/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventInfo;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.DbusEventInternalWritable;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.DbusEventPart;
import com.linkedin.databus.core.DbusEventSerializable;
import com.linkedin.databus.core.DbusEventV2Factory;
import com.linkedin.databus.core.DbusOpcode;
import com.linkedin.databus.core.KeyTypeNotImplementedException;
import com.linkedin.databus.core.util.ByteBufferCRC32;
import com.linkedin.databus.core.util.StringUtils;
import com.linkedin.databus.core.util.TimeUtils;
import com.linkedin.databus.core.util.Utils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

public class DbusEventV1
extends DbusEventSerializable
implements Cloneable {
    public static final String MODULE = DbusEventV1.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private static final int VersionOffset = 0;
    private static final int VersionLength = 1;
    private static final int HeaderCrcOffset = 1;
    private static final int HeaderCrcLength = 4;
    private static final int HeaderCrcDefault = 0;
    private static final int LengthOffset = 5;
    private static final int LengthLength = 4;
    private static final int AttributesOffset = 9;
    private static final int AttributesLength = 2;
    private static final int SequenceOffset = 11;
    private static final int SequenceLength = 8;
    private static final int PhysicalPartitionIdOffset = 19;
    private static final int PhysicalPartitionIdLength = 2;
    private static final int LogicalPartitionIdOffset = 21;
    private static final int LogicalPartitionIdLength = 2;
    private static final int TimestampOffset = 23;
    private static final int TimestampLength = 8;
    private static final int SrcIdOffset = 31;
    private static final int SrcIdLength = 2;
    private static final int SchemaIdOffset = 33;
    private static final int SchemaIdLength = 16;
    private static final int ValueCrcOffset = 49;
    private static final int ValueCrcLength = 4;
    private static final int LongKeyOffset = 53;
    private static final int LongKeyLength = 8;
    private static final int LongKeyValueOffset = 61;
    private static final int StringKeyLengthOffset = 53;
    private static final int StringKeyLengthLength = 4;
    private static final int StringKeyOffset = 57;
    private static int LongKeyHeaderSize = 56;
    private static int StringKeyHeaderSize = 52;
    private static final int UPSERT_MASK = 1;
    private static final int DELETE_MASK = 2;
    private static final int TRACE_FLAG_MASK = 4;
    private static final int KEY_TYPE_MASK = 8;
    private static final int EXT_REPLICATED_EVENT_MASK = 256;
    private static final int MinHeaderSize = 53;
    private static final int MaxHeaderSize = Math.max(61, 57);
    private static final byte[] EmptyAttributesBigEndian = new byte[2];
    private static final byte[] UpsertLongKeyAttributesBigEndian = new byte[2];
    private static final byte[] UpsertStringKeyAttributesBigEndian = new byte[2];
    private static final byte[] DeleteLongKeyAttributesBigEndian = new byte[2];
    private static final byte[] DeleteStringKeyAttributesBigEndian = new byte[2];
    private static final byte[] EmptyAttributesLittleEndian = new byte[2];
    private static final byte[] UpsertLongKeyAttributesLittleEndian = new byte[2];
    private static final byte[] UpsertStringKeyAttributesLittleEndian = new byte[2];
    private static final byte[] DeleteLongKeyAttributesLittleEndian = new byte[2];
    private static final byte[] DeleteStringKeyAttributesLittleEndian = new byte[2];

    public DbusEventV1() {
        this._inited = false;
    }

    public DbusEventV1(ByteBuffer buf, int position) {
        this.resetInternal(buf, position);
    }

    private int serializedKeyLength() {
        if (this.isKeyString()) {
            return 4 + this._buf.getInt(this._position + 53);
        }
        return 8;
    }

    private static int KeyLength(byte[] key) {
        return key.length + 4;
    }

    private static int LongKeyValueOffset() {
        return 61;
    }

    private static int StringValueOffset(int keyLength) {
        return 57 + keyLength;
    }

    public static int getLengthOffset() {
        return 5;
    }

    public static int getLengthLength() {
        return 4;
    }

    public static int serializeEndOfPeriodMarker(ByteBuffer serializationBuffer, DbusEventInfo eventInfo) {
        byte[] attributes = serializationBuffer.order() == ByteOrder.BIG_ENDIAN ? EmptyAttributesBigEndian : EmptyAttributesLittleEndian;
        return DbusEventV1.serializeFullEvent(DbusEventInternalWritable.EOPMarkerKey.getLongKey(), serializationBuffer, eventInfo, attributes);
    }

    public static ByteBuffer serializeEndOfPeriodMarker(long seq, short partN, ByteOrder byteOrder) {
        DbusEventInfo eventInfo = new DbusEventInfo(DbusOpcode.UPSERT, seq, partN, partN, TimeUtils.currentNanoTime(), -2, new byte[16], new byte[0], false, true);
        ByteBuffer buf = ByteBuffer.allocate(MaxHeaderSize).order(byteOrder);
        DbusEventV1.serializeEndOfPeriodMarker(buf, eventInfo);
        return buf;
    }

    public static int serializeEvent(DbusEventKey key, short pPartitionId, short lPartitionId, long timeStampInNanos, short srcId, byte[] schemaId, byte[] value, boolean enableTracing, ByteBuffer serializationBuffer) throws KeyTypeNotImplementedException {
        DbusEventInfo dbusEventInfo = new DbusEventInfo(DbusOpcode.UPSERT, 0L, pPartitionId, lPartitionId, timeStampInNanos, srcId, schemaId, value, enableTracing, false);
        return DbusEventV1.serializeEvent(key, serializationBuffer, dbusEventInfo);
    }

    public static int serializeEvent(DbusEventKey key, ByteBuffer serializationBuffer, DbusEventInfo dbusEventInfo) throws KeyTypeNotImplementedException {
        switch (key.getKeyType()) {
            case LONG: {
                return DbusEventV1.serializeLongKeyEvent(key.getLongKey(), serializationBuffer, dbusEventInfo);
            }
            case STRING: {
                return DbusEventV1.serializeStringKeyEvent(key.getStringKeyInBytes(), serializationBuffer, dbusEventInfo);
            }
        }
        throw new KeyTypeNotImplementedException();
    }

    private static int serializeLongKeyEvent(long key, ByteBuffer serializationBuffer, DbusEventInfo eventInfo) {
        byte[] attributes = null;
        attributes = eventInfo.getOpCode() == DbusOpcode.DELETE ? (serializationBuffer.order() == ByteOrder.BIG_ENDIAN ? (byte[])DeleteLongKeyAttributesBigEndian.clone() : (byte[])DeleteLongKeyAttributesLittleEndian.clone()) : (serializationBuffer.order() == ByteOrder.BIG_ENDIAN ? (byte[])UpsertLongKeyAttributesBigEndian.clone() : (byte[])UpsertLongKeyAttributesLittleEndian.clone());
        if (eventInfo.isEnableTracing()) {
            DbusEventV1.setTraceFlag(attributes, serializationBuffer.order());
        }
        if (eventInfo.isReplicated()) {
            DbusEventV1.setExtReplicationFlag(attributes, serializationBuffer.order());
        }
        return DbusEventV1.serializeFullEvent(key, serializationBuffer, eventInfo, attributes);
    }

    protected static int serializeFullEventWithEmptyAttributes(long key, ByteBuffer buf, DbusEventInfo eventInfo) {
        return DbusEventV1.serializeFullEvent(key, buf, eventInfo, buf.order() == ByteOrder.BIG_ENDIAN ? EmptyAttributesBigEndian : EmptyAttributesLittleEndian);
    }

    private static int serializeFullEvent(long key, ByteBuffer serializationBuffer, DbusEventInfo eventInfo, byte[] attributes) {
        ByteBuffer valueBuffer = eventInfo.getValueByteBuffer();
        int payloadLen = valueBuffer == null ? eventInfo.getValueLength() : valueBuffer.remaining();
        int startPosition = serializationBuffer.position();
        serializationBuffer.put((byte)0).putInt(0).putInt(61 + payloadLen).put(attributes).putLong(eventInfo.getSequenceId()).putShort(eventInfo.getpPartitionId()).putShort(eventInfo.getlPartitionId()).putLong(eventInfo.getTimeStampInNanos()).putShort(eventInfo.getSrcId()).put(eventInfo.getSchemaId(), 0, 16).putInt(0).putLong(key);
        if (valueBuffer != null) {
            serializationBuffer.put(valueBuffer);
        }
        int stopPosition = serializationBuffer.position();
        long valueCrc = ByteBufferCRC32.getChecksum(serializationBuffer, startPosition + 61, payloadLen);
        Utils.putUnsignedInt(serializationBuffer, startPosition + 49, valueCrc);
        if (eventInfo.isAutocommit()) {
            DbusEventV1 e = new DbusEventV1(serializationBuffer, startPosition);
            e.applyCrc();
        }
        serializationBuffer.position(stopPosition);
        return stopPosition - startPosition;
    }

    private static int serializeStringKeyEvent(byte[] key, ByteBuffer serializationBuffer, DbusEventInfo eventInfo) {
        ByteBuffer valueBuffer = eventInfo.getValueByteBuffer();
        int payloadLen = valueBuffer == null ? eventInfo.getValueLength() : valueBuffer.remaining();
        int startPosition = serializationBuffer.position();
        byte[] attributes = null;
        attributes = eventInfo.getOpCode() == DbusOpcode.DELETE ? (serializationBuffer.order() == ByteOrder.BIG_ENDIAN ? (byte[])DeleteStringKeyAttributesBigEndian.clone() : (byte[])DeleteStringKeyAttributesLittleEndian.clone()) : (serializationBuffer.order() == ByteOrder.BIG_ENDIAN ? (byte[])UpsertStringKeyAttributesBigEndian.clone() : (byte[])UpsertStringKeyAttributesLittleEndian.clone());
        if (eventInfo.isEnableTracing()) {
            DbusEventV1.setTraceFlag(attributes, serializationBuffer.order());
        }
        if (eventInfo.isReplicated()) {
            DbusEventV1.setExtReplicationFlag(attributes, serializationBuffer.order());
        }
        serializationBuffer.put((byte)0).putInt(0).putInt(DbusEventV1.StringValueOffset(key.length) + payloadLen).put(attributes).putLong(eventInfo.getSequenceId()).putShort(eventInfo.getpPartitionId()).putShort(eventInfo.getlPartitionId()).putLong(eventInfo.getTimeStampInNanos()).putShort(eventInfo.getSrcId()).put(eventInfo.getSchemaId(), 0, 16).putInt(0).putInt(key.length).put(key);
        if (valueBuffer != null) {
            serializationBuffer.put(valueBuffer);
        }
        int stopPosition = serializationBuffer.position();
        long valueCrc = ByteBufferCRC32.getChecksum(serializationBuffer, startPosition + 57, key.length + payloadLen);
        Utils.putUnsignedInt(serializationBuffer, startPosition + 49, valueCrc);
        if (eventInfo.isAutocommit()) {
            DbusEventV1 e = new DbusEventV1(serializationBuffer, startPosition);
            e.applyCrc();
        }
        serializationBuffer.position(stopPosition);
        return stopPosition - startPosition;
    }

    private static void setAttributeBit(byte[] attribute, int mask, ByteOrder byteOrder) {
        if (mask > 65535) {
            throw new DatabusRuntimeException("attribute mask exceeds max size of attributes");
        }
        byte msByte = (byte)((mask & 0xFF00) >> 8);
        byte lsByte = (byte)(mask & 0xFF);
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            attribute[0] = (byte)(attribute[0] | msByte);
            attribute[1] = (byte)(attribute[1] | lsByte);
        } else {
            attribute[0] = (byte)(attribute[0] | lsByte);
            attribute[1] = (byte)(attribute[1] | msByte);
        }
    }

    private boolean isAttributeBitSet(int mask) {
        return (this._buf.getShort(this._position + 9) & mask) == mask;
    }

    private static void setOpcode(byte[] attribute, DbusOpcode opcode, ByteOrder byteOrder) {
        switch (opcode) {
            case UPSERT: {
                DbusEventV1.setAttributeBit(attribute, 1, byteOrder);
                break;
            }
            case DELETE: {
                DbusEventV1.setAttributeBit(attribute, 2, byteOrder);
                break;
            }
            default: {
                throw new RuntimeException("Unknown DbusOpcode " + opcode.name());
            }
        }
    }

    @Override
    public DbusOpcode getOpcode() {
        if (this.isAttributeBitSet(1)) {
            return DbusOpcode.UPSERT;
        }
        if (this.isAttributeBitSet(2)) {
            return DbusOpcode.DELETE;
        }
        return null;
    }

    private static void setTraceFlag(byte[] attribute, ByteOrder byteOrder) {
        DbusEventV1.setAttributeBit(attribute, 4, byteOrder);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isAttributeBitSet(4);
    }

    private static void setKeyTypeString(byte[] attributes, ByteOrder byteOrder) {
        DbusEventV1.setAttributeBit(attributes, 8, byteOrder);
    }

    @Override
    public boolean isKeyString() {
        return this.isAttributeBitSet(8);
    }

    @Override
    public boolean isKeySchema() {
        return false;
    }

    @Override
    public boolean isKeyNumber() {
        return !this.isAttributeBitSet(8);
    }

    public static void setExtReplicationFlag(byte[] attribute, ByteOrder byteOrder) {
        DbusEventV1.setAttributeBit(attribute, 256, byteOrder);
    }

    @Override
    public boolean isExtReplicatedEvent() {
        return this.isAttributeBitSet(256);
    }

    @Override
    public DbusEventInternalReadable reset(ByteBuffer buf, int position) {
        if (buf.get(position) != 0) {
            this.verifyByteOrderConsistency(buf, "DbusEventV1.reset()");
            return DbusEventV2Factory.createReadOnlyDbusEventFromBufferUnchecked(buf, position);
        }
        this.resetInternal(buf, position);
        return this;
    }

    public static int length(DbusEventKey key, int valueLen) throws KeyTypeNotImplementedException {
        switch (key.getKeyType()) {
            case LONG: {
                return 61 + valueLen;
            }
            case STRING: {
                return 57 + key.getStringKeyInBytes().length + valueLen;
            }
        }
        throw new KeyTypeNotImplementedException();
    }

    @Override
    public void applyCrc() {
        int headerLength = this.headerLength();
        long headerCrc = ByteBufferCRC32.getChecksum(this._buf, this._position + 5, headerLength);
        Utils.putUnsignedInt(this._buf, this._position + 1, headerCrc);
    }

    protected int headerLength() {
        if (!this.isKeyString()) {
            return LongKeyHeaderSize;
        }
        return StringKeyHeaderSize;
    }

    @Override
    public int payloadLength() {
        int overhead = 5;
        return this.size() - this.headerLength() - overhead;
    }

    @Override
    public void setSequence(long sequence) {
        this._buf.putLong(this._position + 11, sequence);
    }

    @Override
    public long sequence() {
        return this._buf.getLong(this._position + 11);
    }

    @Override
    public int keyLength() {
        if (this.isKeyString()) {
            return 4 + this._buf.getInt(this._position + 53);
        }
        return 8;
    }

    @Override
    public int keyBytesLength() {
        assert (this.isKeyString()) : "Key type = " + this._buf.getShort(this._position + 9);
        return this._buf.getInt(this._position + 53);
    }

    @Override
    public int valueLength() {
        return this.size() - (53 + this.keyLength());
    }

    @Override
    protected boolean isPartial() {
        return this.isPartial(true);
    }

    @Override
    protected DbusEventInternalReadable.HeaderScanStatus scanHeader(boolean logErrors) {
        if (this.getVersion() != 0) {
            if (logErrors) {
                LOG.error((Object)("unknown version byte in header: " + this.getVersion()));
            }
            return DbusEventInternalReadable.HeaderScanStatus.ERR;
        }
        if (this.isHeaderPartial(logErrors)) {
            return DbusEventInternalReadable.HeaderScanStatus.PARTIAL;
        }
        int size = this.size();
        if (size < 53) {
            if (logErrors) {
                LOG.error((Object)("Event size too small ; size=" + size + " Header size= " + 53));
            }
            return DbusEventInternalReadable.HeaderScanStatus.ERR;
        }
        int headerLength = this.headerLength();
        long calculatedHeaderCrc = ByteBufferCRC32.getChecksum(this._buf, this._position + 5, headerLength);
        if (calculatedHeaderCrc != this.headerCrc()) {
            if (logErrors) {
                LOG.error((Object)"Header CRC mismatch: ");
                LOG.error((Object)("headerCrc() = " + this.headerCrc()));
                LOG.error((Object)("calculatedCrc = " + calculatedHeaderCrc));
            }
            return DbusEventInternalReadable.HeaderScanStatus.ERR;
        }
        return DbusEventInternalReadable.HeaderScanStatus.OK;
    }

    @Override
    protected DbusEventInternalReadable.EventScanStatus scanEvent(boolean logErrors) {
        long bodyCrc;
        DbusEventInternalReadable.HeaderScanStatus h = this.scanHeader(logErrors);
        if (h != DbusEventInternalReadable.HeaderScanStatus.OK) {
            if (logErrors) {
                LOG.error((Object)("HeaderScan error=" + (Object)((Object)h)));
            }
            return h == DbusEventInternalReadable.HeaderScanStatus.ERR ? DbusEventInternalReadable.EventScanStatus.ERR : DbusEventInternalReadable.EventScanStatus.PARTIAL;
        }
        if (this.isPartial(logErrors)) {
            return DbusEventInternalReadable.EventScanStatus.PARTIAL;
        }
        int payloadLength = this.payloadLength();
        long calculatedValueCrc = this.getCalculatedValueCrc();
        if (calculatedValueCrc != (bodyCrc = this.bodyCrc())) {
            if (logErrors) {
                LOG.error((Object)("_buf.order() = " + this._buf.order() + ", bodyCrc() = " + bodyCrc + ", crc.getValue() = " + calculatedValueCrc + ", crc-ed block size = " + payloadLength + ", event sequence = " + this.sequence() + ", timestamp = " + this.timestampInNanos()));
            }
            return DbusEventInternalReadable.EventScanStatus.ERR;
        }
        return DbusEventInternalReadable.EventScanStatus.OK;
    }

    private boolean isPartial(boolean logErrors) {
        int size = this.size();
        if (size > this._buf.limit() - this._position) {
            if (logErrors) {
                LOG.error((Object)("partial event: size() = " + size + " buf_position=" + this._position + " limit = " + this._buf.limit() + " (_buf.limit()-_position) = " + (this._buf.limit() - this._position)));
            }
            return true;
        }
        return false;
    }

    private boolean isHeaderPartial(boolean logErrors) {
        int limit = this._buf.limit();
        int bufHeaderLen = limit - this._position;
        if (bufHeaderLen < 11) {
            return true;
        }
        int headerLen = this.headerLength() + 5;
        if (bufHeaderLen < headerLen) {
            if (logErrors) {
                LOG.error((Object)("Partial Header: bufHeaderLen=" + bufHeaderLen + " is less then headerLen=" + headerLen));
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (null == this._buf) {
            return "_buf=null";
        }
        boolean valid = true;
        try {
            valid = this.isValid(true);
        }
        catch (Exception ex) {
            LOG.error((Object)"DbusEventV1.toString() : Got Exception while trying to validate the event ", (Throwable)ex);
            valid = false;
        }
        if (!valid) {
            StringBuilder sb = new StringBuilder("Position: ");
            sb.append(this._position);
            sb.append(", _buf: ");
            sb.append(null != this._buf ? this._buf.toString() : "null");
            sb.append(", validity: false; hexDump:");
            if (null != this._buf && this._position >= 0) {
                sb.append(StringUtils.hexdumpByteBufferContents(this._buf, this._position, 100));
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append("Position=").append(this._position).append(";Version=").append(this.getVersion()).append(";isEndOfPeriodMarker=").append(this.isEndOfPeriodMarker()).append(";HeaderCrc=").append(this.headerCrc()).append(";Length=").append(this.size()).append(";Key=");
        if (this.isKeyString()) {
            sb.append(new String(this.keyBytes()));
        } else {
            sb.append(this.key());
        }
        sb.append(";Sequence=").append(this.sequence()).append(";LogicalPartitionId=").append(this.logicalPartitionId()).append(";PhysicalPartitionId=").append(this.physicalPartitionId()).append(";Timestamp=").append(this.timestampInNanos()).append(";SrcId=").append(this.srcId()).append(";SchemaId=").append(Hex.encodeHex((byte[])this.schemaId())).append(";ValueCrc=").append(this.bodyCrc());
        return sb.toString();
    }

    @Override
    public byte getVersion() {
        return this._buf.get(this._position + 0);
    }

    @Override
    public int size() {
        return this._buf.getInt(this._position + 5);
    }

    @Override
    public void setSize(int sz) {
        this._buf.putInt(this._position + 5, sz);
    }

    @Override
    public long headerCrc() {
        return Utils.getUnsignedInt(this._buf, this._position + 1);
    }

    @Override
    public void setHeaderCrc(long crc) {
        Utils.putUnsignedInt(this._buf, this._position + 1, crc);
    }

    @Override
    public long key() {
        assert (this.isKeyNumber());
        return this._buf.getLong(this._position + 53);
    }

    @Override
    public byte[] keyBytes() {
        assert (this.isKeyString());
        int keyLength = this._buf.getInt(this._position + 53);
        byte[] dst = new byte[keyLength];
        for (int i = 0; i < keyLength; ++i) {
            dst[i] = this._buf.get(this._position + 53 + 4 + i);
        }
        return dst;
    }

    @Override
    public short physicalPartitionId() {
        return this._buf.getShort(this._position + 19);
    }

    @Override
    public short logicalPartitionId() {
        return this._buf.getShort(this._position + 21);
    }

    @Override
    public short getPartitionId() {
        return this._buf.getShort(this._position + 19);
    }

    @Override
    public long timestampInNanos() {
        return this._buf.getLong(this._position + 23);
    }

    public void setSchemaVersion(short schemaVersion) {
        this._buf.putShort(this._position + 33, schemaVersion);
    }

    @Override
    public short schemaVersion() {
        return this._buf.getShort(this._position + 33);
    }

    @Override
    public void setSrcId(int srcId) {
        if (srcId > Short.MAX_VALUE) {
            throw new DatabusRuntimeException("Unsupported source Id in DbusEvent V1:" + srcId);
        }
        this._buf.putShort(this._position + 31, (short)srcId);
    }

    @Override
    public short srcId() {
        return this._buf.getShort(this._position + 31);
    }

    @Override
    public int getSourceId() {
        return this.srcId();
    }

    @Override
    public void setSchemaId(byte[] schemaId) {
        for (int i = 0; i < 16; ++i) {
            this._buf.put(this._position + 33 + i, schemaId[i]);
        }
    }

    @Override
    public void recomputeCrcsAfterEspressoRewrite() {
        this.applyCrc();
    }

    @Override
    public byte[] schemaId() {
        byte[] md5 = new byte[16];
        for (int i = 0; i < 16; ++i) {
            md5[i] = this._buf.get(this._position + 33 + i);
        }
        return md5;
    }

    @Override
    public void schemaId(byte[] md5) {
        for (int i = 0; i < 16; ++i) {
            md5[i] = this._buf.get(this._position + 33 + i);
        }
    }

    @Override
    public long getCalculatedValueCrc() {
        long calcValueCrc = ByteBufferCRC32.getChecksum(this._buf, this.isKeyNumber() ? this._position + 61 : this._position + 57, this.payloadLength());
        return calcValueCrc;
    }

    @Override
    public long bodyCrc() {
        return Utils.getUnsignedInt(this._buf, this._position + 49);
    }

    @Override
    public void setValueCrc(long crc) {
        Utils.putUnsignedInt(this._buf, this._position + 49, crc);
    }

    @Override
    public ByteBuffer value() {
        ByteBuffer value = this._buf.asReadOnlyBuffer().order(this._buf.order());
        value.position(this._position + 53 + this.keyLength());
        value = value.slice().order(this._buf.order());
        int valueSize = this.valueLength();
        value.limit(valueSize);
        value.rewind();
        return value;
    }

    @Override
    public void setValue(byte[] bytes) {
        int offset = this._position + 53 + this.serializedKeyLength();
        for (int i = 0; i < bytes.length; ++i) {
            this._buf.put(offset + i, bytes[i]);
        }
    }

    @Override
    public DbusEventPart getPayloadPart() {
        return null;
    }

    @Override
    public DbusEventPart getPayloadMetadataPart() {
        return null;
    }

    @Override
    public DbusEventPart getKeyPart() {
        throw new DatabusRuntimeException("V1 event does not support schema keys");
    }

    @Override
    public DbusEventInternalWritable createCopy() {
        ByteBuffer cloned = ByteBuffer.allocate(this.size()).order(this._buf.order());
        cloned.put(this.getRawBytes());
        DbusEventV1 c = new DbusEventV1(cloned, 0);
        return c;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DbusEventV1) {
            DbusEventV1 objEvent = (DbusEventV1)obj;
            return this.headerCrc() == objEvent.headerCrc() && this.bodyCrc() == objEvent.bodyCrc();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.headerCrc() ^ (int)this.bodyCrc();
    }

    @Override
    public DbusEvent clone(DbusEvent e) {
        DbusEventV1 reuse = (DbusEventV1)e;
        if (null == reuse) {
            reuse = new DbusEventV1(this._buf, this._position);
        } else {
            if (!(e instanceof DbusEventV1)) {
                throw new UnsupportedClassVersionError("Unsupported class:" + e.getClass().getSimpleName());
            }
            reuse.resetInternal(this._buf, this._position);
        }
        return reuse;
    }

    @Override
    public int getMagic() {
        return 0;
    }

    static {
        DbusEventV1.setOpcode(UpsertLongKeyAttributesBigEndian, DbusOpcode.UPSERT, ByteOrder.BIG_ENDIAN);
        DbusEventV1.setOpcode(UpsertStringKeyAttributesBigEndian, DbusOpcode.UPSERT, ByteOrder.BIG_ENDIAN);
        DbusEventV1.setKeyTypeString(UpsertStringKeyAttributesBigEndian, ByteOrder.BIG_ENDIAN);
        DbusEventV1.setOpcode(DeleteLongKeyAttributesBigEndian, DbusOpcode.DELETE, ByteOrder.BIG_ENDIAN);
        DbusEventV1.setOpcode(DeleteStringKeyAttributesBigEndian, DbusOpcode.DELETE, ByteOrder.BIG_ENDIAN);
        DbusEventV1.setKeyTypeString(DeleteStringKeyAttributesBigEndian, ByteOrder.BIG_ENDIAN);
        DbusEventV1.setOpcode(UpsertLongKeyAttributesLittleEndian, DbusOpcode.UPSERT, ByteOrder.LITTLE_ENDIAN);
        DbusEventV1.setOpcode(UpsertStringKeyAttributesLittleEndian, DbusOpcode.UPSERT, ByteOrder.LITTLE_ENDIAN);
        DbusEventV1.setKeyTypeString(UpsertStringKeyAttributesLittleEndian, ByteOrder.LITTLE_ENDIAN);
        DbusEventV1.setOpcode(DeleteLongKeyAttributesLittleEndian, DbusOpcode.DELETE, ByteOrder.LITTLE_ENDIAN);
        DbusEventV1.setOpcode(DeleteStringKeyAttributesLittleEndian, DbusOpcode.DELETE, ByteOrder.LITTLE_ENDIAN);
        DbusEventV1.setKeyTypeString(DeleteStringKeyAttributesLittleEndian, ByteOrder.LITTLE_ENDIAN);
    }
}

