/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.SCNRegressMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;

public class DbusEventUtils {
    public static boolean isControlSrcId(int srcId) {
        return srcId < 0;
    }

    public static Checkpoint getCheckpointFromEvent(DbusEvent event) {
        assert (event.isCheckpointMessage());
        ByteBuffer valueBuffer = event.value();
        byte[] valueBytes = new byte[valueBuffer.limit()];
        valueBuffer.get(valueBytes);
        try {
            Checkpoint newCheckpoint = new Checkpoint(new String(valueBytes));
            return newCheckpoint;
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SCNRegressMessage getSCNRegressFromEvent(DbusEvent event) {
        assert (event.isSCNRegressMessage());
        ByteBuffer valueBuffer = event.value();
        byte[] valueBytes = new byte[valueBuffer.limit()];
        valueBuffer.get(valueBytes);
        SCNRegressMessage newRegressMsg = SCNRegressMessage.getRegressMessage(new String(valueBytes));
        return newRegressMsg;
    }
}

