/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus.core.DbusErrorEvent;
import com.linkedin.databus.core.DbusEventBufferAppendable;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.DbusEventInternalWritable;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.DbusEventPart;
import com.linkedin.databus.core.DbusEventUtils;
import com.linkedin.databus.core.Encoding;
import com.linkedin.databus.core.InvalidEventException;
import com.linkedin.databus.core.KeyTypeNotImplementedException;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus.core.util.Base64;
import com.linkedin.databus.core.util.Utils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public abstract class DbusEventSerializable
extends DbusEventInternalWritable {
    private static final TypeReference<Map<String, Object>> JSON_GENERIC_MAP_TYPEREF = new TypeReference<Map<String, Object>>(){};
    public static final String MODULE = DbusEventSerializable.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    protected ByteBuffer _buf;
    protected int _position;
    protected boolean _inited;

    public static int appendToEventBuffer(BufferedReader jsonStream, DbusEventBufferAppendable eventBuffer, DbusEventsStatisticsCollector statsCollector, boolean startWindow) throws IOException, JsonParseException, InvalidEventException {
        ObjectMapper objectMapper = new ObjectMapper();
        int numEvents = 0;
        boolean endOfPeriod = startWindow;
        try {
            String jsonString;
            boolean success = true;
            while (success && null != (jsonString = jsonStream.readLine())) {
                int appendResult = DbusEventSerializable.appendToEventBuffer(jsonString, eventBuffer, objectMapper, statsCollector, endOfPeriod);
                success = appendResult > 0;
                endOfPeriod = 2 == appendResult;
                ++numEvents;
            }
        }
        catch (KeyTypeNotImplementedException e) {
            LOG.error((Object)("append error: " + e.getMessage()), (Throwable)e);
            numEvents = -1;
        }
        return numEvents;
    }

    public static int appendToEventBuffer(String jsonString, DbusEventBufferAppendable eventBuffer, DbusEventsStatisticsCollector statsCollector, boolean startWindow) throws IOException, JsonParseException, InvalidEventException, KeyTypeNotImplementedException {
        int numEvents = DbusEventSerializable.appendToEventBuffer(jsonString, eventBuffer, null, statsCollector, startWindow);
        return numEvents;
    }

    private static int appendToEventBuffer(String jsonString, DbusEventBufferAppendable eventBuffer, ObjectMapper objectMapper, DbusEventsStatisticsCollector statsCollector, boolean startWindow) throws IOException, JsonParseException, InvalidEventException, KeyTypeNotImplementedException {
        Map jsonObj;
        Object tmpObject;
        if (null == objectMapper) {
            objectMapper = new ObjectMapper();
        }
        if (null == (tmpObject = (jsonObj = (Map)objectMapper.readValue(jsonString, JSON_GENERIC_MAP_TYPEREF)).get("timestampInNanos")) || !(tmpObject instanceof Number)) {
            throw new InvalidEventException("timestampInNanos expected");
        }
        long timestamp = ((Number)tmpObject).longValue();
        tmpObject = jsonObj.get("sequence");
        if (null == tmpObject || !(tmpObject instanceof Number)) {
            throw new InvalidEventException("sequence expected");
        }
        long windowScn = ((Number)tmpObject).longValue();
        boolean endOfPeriod = false;
        boolean result = false;
        tmpObject = jsonObj.get("endOfPeriod");
        if (null != tmpObject) {
            if (!(tmpObject instanceof String) && !(tmpObject instanceof Boolean)) {
                throw new InvalidEventException("invalid endOfPeriod");
            }
            if (tmpObject instanceof Boolean && ((Boolean)tmpObject).booleanValue() || tmpObject instanceof String && Boolean.parseBoolean((String)tmpObject)) {
                eventBuffer.endEvents(windowScn, statsCollector);
                endOfPeriod = true;
                result = true;
            }
        }
        if (!endOfPeriod) {
            byte[] value;
            tmpObject = jsonObj.get("key");
            if (null == tmpObject || !(tmpObject instanceof Number)) {
                throw new InvalidEventException("key expected");
            }
            DbusEventKey key = new DbusEventKey(((Number)tmpObject).longValue());
            tmpObject = jsonObj.get("logicalPartitionId");
            if (null == tmpObject || !(tmpObject instanceof Number)) {
                throw new InvalidEventException("logicalPartitionId expected");
            }
            short lPartitionId = ((Number)tmpObject).shortValue();
            tmpObject = jsonObj.get("physicalPartitionId");
            if (null == tmpObject || !(tmpObject instanceof Number)) {
                throw new InvalidEventException("logicalPartitionId expected");
            }
            short pPartitionId = ((Number)tmpObject).shortValue();
            tmpObject = jsonObj.get("srcId");
            if (null == tmpObject || !(tmpObject instanceof Number)) {
                throw new InvalidEventException("srcId expected");
            }
            short srcId = ((Number)tmpObject).shortValue();
            tmpObject = jsonObj.get("schemaId");
            if (null == tmpObject || !(tmpObject instanceof String)) {
                throw new InvalidEventException("schemaId expected");
            }
            String base64String = (String)tmpObject;
            byte[] schemaId = Base64.decode(base64String);
            tmpObject = jsonObj.get("valueEnc");
            if (null == tmpObject || !(tmpObject instanceof String)) {
                throw new InvalidEventException("valueEnc expected");
            }
            String valueEncString = (String)tmpObject;
            tmpObject = jsonObj.get("value");
            if (null == tmpObject || !(tmpObject instanceof String)) {
                throw new InvalidEventException("value expected");
            }
            base64String = (String)tmpObject;
            if (valueEncString.equals(Encoding.JSON.toString())) {
                value = Base64.decode(base64String);
            } else if (valueEncString.equals(Encoding.JSON_PLAIN_VALUE.toString())) {
                value = base64String.getBytes(Charset.defaultCharset());
            } else {
                throw new InvalidEventException("Unknown value encoding: " + valueEncString);
            }
            if (startWindow) {
                eventBuffer.startEvents();
            }
            boolean traceEnabled = false;
            tmpObject = jsonObj.get("traceEnabled");
            if (null != tmpObject) {
                if (!(tmpObject instanceof Boolean)) {
                    throw new InvalidEventException("traceEnabled must be boolean");
                }
                traceEnabled = (Boolean)tmpObject;
            }
            result = eventBuffer.appendEvent(key, pPartitionId, lPartitionId, timestamp, srcId, schemaId, value, traceEnabled, statsCollector);
        }
        if (result) {
            return endOfPeriod ? 2 : 1;
        }
        return 0;
    }

    public static DbusErrorEvent getErrorEventFromDbusEvent(DbusEventInternalReadable event) {
        if (!event.isErrorEvent()) {
            throw new RuntimeException("Event is expected to be an error event: " + event);
        }
        ByteBuffer valueBuffer = event.value();
        byte[] valueBytes = new byte[valueBuffer.limit()];
        valueBuffer.get(valueBytes);
        try {
            DbusErrorEvent errorEvent = DbusErrorEvent.createDbusErrorEvent(new String(valueBytes));
            return errorEvent;
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isErrorEvent() {
        return this.srcId() > -50 && this.srcId() < -4;
    }

    @Override
    public boolean isCheckpointMessage() {
        return this.srcId() == -3;
    }

    @Override
    public boolean isPrivateControlMessage() {
        return this.srcId() <= -20000;
    }

    @Override
    public boolean isControlMessage() {
        return this.isControlSrcId();
    }

    @Override
    public boolean isControlSrcId() {
        return DbusEventUtils.isControlSrcId(this.getSourceId());
    }

    @Override
    public boolean isEndOfPeriodMarker() {
        return this.srcId() == -2;
    }

    @Override
    public boolean isSCNRegressMessage() {
        return this.srcId() == -51;
    }

    @Override
    public DbusEventInternalReadable.HeaderScanStatus scanHeader() {
        return this.scanHeader(true);
    }

    @Override
    public DbusEventInternalReadable.EventScanStatus scanEvent() {
        return this.scanEvent(true);
    }

    @Override
    public boolean isValid() {
        return this.isValid(true);
    }

    @Override
    public boolean isValid(boolean logErrors) {
        return this._buf != null && this.scanEvent(logErrors) == DbusEventInternalReadable.EventScanStatus.OK;
    }

    @Override
    public ByteBuffer getRawBytes() {
        ByteBuffer buffer = this._buf.asReadOnlyBuffer().order(this._buf.order());
        buffer.position(this._position);
        buffer.limit(this._position + this.size());
        return buffer;
    }

    @Override
    public int writeTo(WritableByteChannel writeChannel, Encoding encoding) {
        int bytesWritten = 0;
        switch (encoding) {
            case BINARY: {
                ByteBuffer writeBuffer = this._buf.duplicate().order(this._buf.order());
                writeBuffer.position(this._position);
                writeBuffer.limit(this._position + this.size());
                try {
                    bytesWritten = writeChannel.write(writeBuffer);
                }
                catch (IOException e) {
                    LOG.error((Object)("binary write error: " + e.getMessage()), (Throwable)e);
                }
                break;
            }
            case JSON_PLAIN_VALUE: 
            case JSON: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                JsonFactory f = new JsonFactory();
                try {
                    JsonGenerator g = f.createJsonGenerator((OutputStream)baos, JsonEncoding.UTF8);
                    g.writeStartObject();
                    byte version = this.getVersion();
                    if (version == 0) {
                        this.writeJSON_V1(g, encoding);
                    } else {
                        this.writeJSON_V2(g, encoding);
                    }
                    g.writeEndObject();
                    g.flush();
                    baos.write("\n".getBytes(Charset.defaultCharset()));
                }
                catch (IOException e) {
                    LOG.error((Object)("JSON write error: " + e.getMessage()), (Throwable)e);
                }
                ByteBuffer writeBuffer = ByteBuffer.wrap(baos.toByteArray()).order(this._buf.order());
                try {
                    bytesWritten = writeChannel.write(writeBuffer);
                }
                catch (IOException e) {
                    LOG.error((Object)("JSON write error: " + e.getMessage()), (Throwable)e);
                }
                break;
            }
        }
        return bytesWritten;
    }

    private void writeJSON_V1(JsonGenerator g, Encoding e) throws IOException {
        if (null != this.getOpcode()) {
            g.writeStringField("opcode", this.getOpcode().toString());
        }
        if (this.isKeyString()) {
            g.writeStringField("keyBytes", Base64.encodeBytes(this.keyBytes()));
        } else {
            g.writeNumberField("key", this.key());
        }
        g.writeNumberField("sequence", this.sequence());
        g.writeNumberField("logicalPartitionId", (int)this.logicalPartitionId());
        g.writeNumberField("physicalPartitionId", (int)this.physicalPartitionId());
        g.writeNumberField("timestampInNanos", this.timestampInNanos());
        g.writeNumberField("srcId", (int)this.srcId());
        g.writeStringField("schemaId", Base64.encodeBytes(this.schemaId()));
        g.writeStringField("valueEnc", e.toString());
        g.writeBooleanField("isReplicated", this.isExtReplicatedEvent());
        if (this.isEndOfPeriodMarker()) {
            g.writeBooleanField("endOfPeriod", true);
        }
        if (this.isTraceEnabled()) {
            g.writeBooleanField("traceEnabled", true);
        }
        if (e.equals((Object)Encoding.JSON)) {
            g.writeStringField("value", Base64.encodeBytes(Utils.byteBufferToBytes(this.value())));
        } else {
            g.writeStringField("value", Utils.byteBufferToString(this.value()));
        }
    }

    private void writeJSON_V2(JsonGenerator g, Encoding e) throws IOException {
        DbusEventPart metadata = this.getPayloadMetadataPart();
        DbusEventPart payload = this.getPayloadPart();
        g.writeNumberField("version", (int)this.getVersion());
        g.writeNumberField("magicByte", this.getMagic());
        g.writeNumberField("headerCrc", this.headerCrc());
        g.writeNumberField("bodyCrc", this.bodyCrc());
        if (this.getOpcode() != null) {
            g.writeStringField("opcode", this.getOpcode().toString());
        } else {
            g.writeNullField("opcode");
        }
        if (this.isKeyNumber()) {
            g.writeStringField("keyType", "Number");
            g.writeNumberField("key", this.key());
        } else if (this.isKeyString()) {
            g.writeStringField("keyType", "String");
            g.writeStringField("keyBytes", Base64.encodeBytes(this.keyBytes()));
        } else if (this.isKeySchema()) {
            g.writeStringField("keyType", "Schema");
            g.writeStringField("key", this.getKeyPart().toString());
        } else {
            throw new UnsupportedOperationException("Key Type Not implemented");
        }
        g.writeStringField("valueEnc", e.toString());
        g.writeBooleanField("isReplicated", this.isExtReplicatedEvent());
        g.writeBooleanField("traceOn", this.isTraceEnabled());
        g.writeBooleanField("hasPayloadMetadata", metadata != null);
        g.writeBooleanField("hasPayload", payload != null);
        g.writeNumberField("timestampInNanos", this.timestampInNanos());
        g.writeNumberField("srcId", this.getSourceId());
        g.writeNumberField("logicalPartitionId", (int)this.getPartitionId());
        g.writeNumberField("physicalPartitionId", (int)this.getPartitionId());
        g.writeNumberField("sequence", this.sequence());
        if (metadata != null) {
            metadata.printString("metadata", g, e);
        }
        if (payload != null) {
            payload.printString("payload", g, e);
        }
    }

    protected void resetInternal(ByteBuffer buf, int position) {
        this.verifyByteOrderConsistency(buf, "DbusEventSerializable.resetInternal()");
        this._inited = true;
        this._buf = buf;
        this._position = position;
    }

    protected void verifyByteOrderConsistency(ByteBuffer buf, String where) {
        if (this._inited && buf.order() != this._buf.order()) {
            throw new DatabusRuntimeException("ByteBuffer byte-order mismatch [" + (where != null ? where : "verifyByteOrderConsistency()") + "]");
        }
    }
}

