/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.Encoding;
import com.linkedin.databus.core.util.Base64;
import com.linkedin.databus.core.util.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;
import org.codehaus.jackson.JsonGenerator;

public class DbusEventPart {
    private static final short SCHEMA_DIGEST_TYPE_MD5 = 0;
    private static final short SCHEMA_DIGEST_TYPE_CRC32 = 1;
    private static final short VERSION_SHIFT = 2;
    private static final short DIGEST_MASK = 3;
    private static final int AttributesOffset = 4;
    private static final int AttributesLen = 2;
    private static final int MAX_DATA_BYTES_PRINTED = 64;
    private final DbusEvent.SchemaDigestType _schemaDigestType;
    private final byte[] _schemaDigest;
    private final short _schemaVersion;
    private ByteBuffer _data = null;

    public DbusEventPart(DbusEvent.SchemaDigestType schemaDigestType, byte[] schemaDigest, short schemaVersion, ByteBuffer data) {
        this._schemaDigestType = schemaDigestType;
        this._schemaDigest = (byte[])schemaDigest.clone();
        this._schemaVersion = schemaVersion;
        this._data = data;
        switch (this._schemaDigestType) {
            case MD5: {
                if (this._schemaDigest.length == 16) break;
                throw new DatabusRuntimeException("Invalid MD5 schema digest length:" + this._schemaDigest.length);
            }
            case CRC32: {
                if (this._schemaDigest.length == 4) break;
                throw new DatabusRuntimeException("Invalid CRC-32 schema digest length:" + this._schemaDigest.length);
            }
            default: {
                throw new UnsupportedOperationException("Unsupported schema digest type:" + (Object)((Object)this._schemaDigestType));
            }
        }
    }

    public DbusEvent.SchemaDigestType getSchemaDigestType() {
        return this._schemaDigestType;
    }

    public byte[] getSchemaDigest() {
        return (byte[])this._schemaDigest.clone();
    }

    public short getSchemaVersion() {
        return this._schemaVersion;
    }

    public ByteBuffer getData() {
        return this._data.asReadOnlyBuffer().slice().order(this._data.order());
    }

    private int getDataLength() {
        return this._data.limit() - this._data.position();
    }

    public void encode(ByteBuffer buf) {
        int curPos = this._data.position();
        buf.putInt(this.getDataLength());
        short attributes = 0;
        switch (this._schemaDigestType) {
            case MD5: {
                attributes = 0;
                break;
            }
            case CRC32: {
                attributes = 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported schema digest type:" + (Object)((Object)this._schemaDigestType));
            }
        }
        attributes = (short)(attributes | this._schemaVersion << 2);
        buf.putShort(attributes);
        buf.put(this._schemaDigest);
        buf.put(this._data);
        this._data.position(curPos);
    }

    private static DbusEvent.SchemaDigestType digestType(short attributes) {
        short digestType = (short)(attributes & 3);
        switch (digestType) {
            case 1: {
                return DbusEvent.SchemaDigestType.CRC32;
            }
            case 0: {
                return DbusEvent.SchemaDigestType.MD5;
            }
        }
        throw new UnsupportedOperationException("Digest type " + digestType + " not supported");
    }

    private static int digestLen(DbusEvent.SchemaDigestType digestType) {
        switch (digestType) {
            case MD5: {
                return 16;
            }
            case CRC32: {
                return 4;
            }
        }
        throw new UnsupportedOperationException("Digest type " + (Object)((Object)digestType) + " not supported");
    }

    public static DbusEventPart decode(ByteBuffer buf) {
        int pos = buf.position();
        int dataLen = buf.getInt(pos);
        if (dataLen < 0) {
            throw new UnsupportedOperationException("Data length " + dataLen + " not supported");
        }
        short attributes = buf.getShort(pos + 4);
        short schemaVersion = (short)(attributes >> 2);
        DbusEvent.SchemaDigestType schemaDigestType = DbusEventPart.digestType(attributes);
        int digestLen = DbusEventPart.digestLen(schemaDigestType);
        byte[] digest = new byte[digestLen];
        for (int i = 0; i < digestLen; ++i) {
            digest[i] = buf.get(pos + 4 + 2 + i);
        }
        ByteBuffer dataBuf = buf.asReadOnlyBuffer();
        dataBuf.position(pos + 4 + 2 + digestLen);
        dataBuf.limit(dataBuf.position() + dataLen);
        return new DbusEventPart(schemaDigestType, digest, schemaVersion, dataBuf);
    }

    public static int computePartLength(DbusEvent.SchemaDigestType digestType, int dataLen) {
        return 6 + dataLen + DbusEventPart.digestLen(digestType);
    }

    public static void replaceSchemaDigest(ByteBuffer buf, int position, byte[] schemaDigest) {
        DbusEvent.SchemaDigestType digestType = DbusEventPart.digestType(buf.getShort(position + 4));
        int digestLen = DbusEventPart.digestLen(digestType);
        if (schemaDigest.length != digestLen) {
            throw new RuntimeException("Expecting length " + digestLen + " for type " + (Object)((Object)digestType) + ", found " + schemaDigest.length);
        }
        for (int i = 0; i < digestLen; ++i) {
            buf.put(position + 4 + 2 + i, schemaDigest[i]);
        }
    }

    public void printString(String prefix, JsonGenerator g, Encoding encoding) throws IOException {
        g.writeNumberField(prefix + "Length", this.getDataLength());
        g.writeNumberField(prefix + "SchemaVersion", (int)this.getSchemaVersion());
        g.writeStringField(prefix + "SchemaId", Base64.encodeBytes(this.getSchemaDigest()));
        if (encoding.equals((Object)Encoding.JSON)) {
            g.writeStringField(prefix + "Value", Base64.encodeBytes(Utils.byteBufferToBytes(this.getData())));
        } else {
            g.writeStringField(prefix + "Value", Utils.byteBufferToString(this.getData()));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Length=").append(this.getDataLength()).append(";SchemaVersion=").append(this.getSchemaVersion()).append(";SchemaId=").append("0x").append(Hex.encodeHexString((byte[])this.getSchemaDigest()));
        ByteBuffer dataBB = this.getData();
        if (dataBB.remaining() > 64) {
            dataBB.limit(64);
        }
        byte[] data = new byte[dataBB.remaining()];
        dataBB.get(data);
        sb.append(";Value=").append("0x").append(Hex.encodeHexString((byte[])data));
        return sb.toString();
    }

    public int computePartLength() {
        return 6 + this._data.remaining() + this._schemaDigest.length;
    }

    public static int partLength(ByteBuffer buf, int position) {
        DbusEvent.SchemaDigestType digestType = DbusEventPart.digestType(buf.getShort(position + 4));
        int digestLen = DbusEventPart.digestLen(digestType);
        return 6 + digestLen + buf.getInt(position);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DbusEventPart other = (DbusEventPart)obj;
        if (this._schemaVersion != other._schemaVersion) {
            return false;
        }
        if (this._schemaDigestType != other._schemaDigestType) {
            return false;
        }
        if (this._schemaDigest == null && other._schemaDigest != null || this._schemaDigest != null && other._schemaDigest == null) {
            return false;
        }
        if (!Arrays.equals(this._schemaDigest, other._schemaDigest)) {
            return false;
        }
        if (this._data == null && other._data != null || this._data != null && other._data == null) {
            return false;
        }
        return this._data.equals(other._data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._schemaDigest == null ? 0 : Arrays.hashCode(this._schemaDigest));
        result = 31 * result + (this._data == null ? 0 : this._data.hashCode());
        return result;
    }
}

