/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DbusEventPart;
import com.linkedin.databus.core.UnsupportedKeyException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.avro.util.Utf8;

public class DbusEventKey {
    private final KeyType _keyType;
    private final Long _longKey;
    private final String _stringKey;
    private final byte[] _stringKeyInBytes;
    private final DbusEventPart _schemaKey;

    public DbusEventKey(long key) {
        this._longKey = key;
        this._stringKey = null;
        this._keyType = KeyType.LONG;
        this._stringKeyInBytes = null;
        this._schemaKey = null;
    }

    @Deprecated
    public DbusEventKey(String key) {
        this._stringKey = key;
        this._longKey = null;
        this._keyType = KeyType.STRING;
        this._stringKeyInBytes = null;
        this._schemaKey = null;
    }

    public DbusEventKey(byte[] key) {
        this._keyType = KeyType.STRING;
        this._longKey = null;
        this._stringKey = null;
        this._stringKeyInBytes = Arrays.copyOf(key, key.length);
        this._schemaKey = null;
    }

    public DbusEventKey(Object key) throws UnsupportedKeyException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        if (key instanceof Long || key instanceof Integer) {
            this._longKey = ((Number)key).longValue();
            this._stringKey = null;
            this._keyType = KeyType.LONG;
            this._stringKeyInBytes = null;
            this._schemaKey = null;
        } else if (key instanceof String) {
            this._longKey = null;
            this._stringKey = (String)key;
            this._keyType = KeyType.STRING;
            this._stringKeyInBytes = null;
            this._schemaKey = null;
        } else if (key instanceof Utf8) {
            this._longKey = null;
            this._stringKey = ((Utf8)key).toString();
            this._keyType = KeyType.STRING;
            this._stringKeyInBytes = null;
            this._schemaKey = null;
        } else if (key instanceof byte[]) {
            this._longKey = null;
            this._stringKey = null;
            this._keyType = KeyType.STRING;
            this._stringKeyInBytes = Arrays.copyOf((byte[])key, ((byte[])key).length);
            this._schemaKey = null;
        } else if (key instanceof DbusEventPart) {
            this._longKey = null;
            this._stringKeyInBytes = null;
            this._stringKey = null;
            this._schemaKey = (DbusEventPart)key;
            this._keyType = KeyType.SCHEMA;
        } else {
            throw new UnsupportedKeyException("Bad key type: " + key.getClass().getName());
        }
    }

    public KeyType getKeyType() {
        return this._keyType;
    }

    public Long getLongKey() {
        return this._longKey;
    }

    public String getStringKey() {
        if (this._stringKey == null) {
            throw new RuntimeException("Invalid method invocation on key type " + (Object)((Object)this._keyType));
        }
        return this._stringKey;
    }

    public byte[] getStringKeyInBytes() {
        if (this._stringKeyInBytes != null) {
            return Arrays.copyOf(this._stringKeyInBytes, this._stringKeyInBytes.length);
        }
        if (this._stringKey != null) {
            return this._stringKey.getBytes(Charset.forName("UTF-8"));
        }
        throw new RuntimeException("Invalid method invocation on key type " + (Object)((Object)this._keyType));
    }

    public DbusEventPart getSchemaKey() {
        if (this._schemaKey == null) {
            throw new RuntimeException("Invalid method invocation on key type " + (Object)((Object)this._keyType));
        }
        return this._schemaKey;
    }

    public String toString() {
        String stringKey;
        StringBuilder builder = new StringBuilder("DbusEventKey [_keyType=");
        builder.append((Object)this._keyType);
        builder.append(", _longKey=");
        builder.append(this._longKey);
        builder.append(", _stringKey=");
        try {
            stringKey = this._stringKey != null ? this._stringKey : (this._stringKeyInBytes == null ? "NULL" : new String(this._stringKeyInBytes, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            stringKey = e.getLocalizedMessage();
        }
        builder.append(stringKey);
        builder.append(", _schemaKey=" + this._schemaKey);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._keyType == null ? 0 : this._keyType.hashCode());
        result = 31 * result + (this._longKey == null ? 0 : this._longKey.hashCode());
        result = 31 * result + (this._stringKey != null ? this._stringKey.hashCode() : (this._stringKeyInBytes == null ? 0 : Arrays.hashCode(this._stringKeyInBytes)));
        result = 31 * result + (this._schemaKey == null ? 0 : this._schemaKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DbusEventKey other = (DbusEventKey)obj;
        if (this._keyType != other._keyType) {
            return false;
        }
        if (this._longKey == null ? other._longKey != null : !this._longKey.equals(other._longKey)) {
            return false;
        }
        if (this._stringKey == null ? other._stringKey != null : !this._stringKey.equals(other._stringKey)) {
            return false;
        }
        if (this._stringKeyInBytes == null ? other._stringKeyInBytes != null : !Arrays.equals(this._stringKeyInBytes, other._stringKeyInBytes)) {
            return false;
        }
        if (this._schemaKey == null) {
            if (other._schemaKey != null) {
                return false;
            }
        } else {
            if (other._schemaKey == null) {
                return false;
            }
            if (!this._schemaKey.equals(other._schemaKey)) {
                return false;
            }
        }
        return true;
    }

    public static enum KeyType {
        LONG,
        STRING,
        SCHEMA;

    }
}

