/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.DbusEventV2;
import com.linkedin.databus.core.KeyTypeNotImplementedException;
import java.nio.charset.Charset;

public abstract class DbusEventInternalWritable
extends DbusEventInternalReadable {
    public static final short EOPMarkerSrcId = -2;
    static final short CHECKPOINT_SRCID = -3;
    public static final short PRIVATE_RANGE_MAX_ERROR_SRCID = -4;
    public static final short BOOTSTRAPTOOOLD_ERROR_SRCID = -5;
    public static final short PULLER_RETRIES_EXPIRED = -6;
    public static final short PRIVATE_RANGE_MIN_ERROR_SRCID = -50;
    public static final short PRIVATE_RANGE_MAX_SRCID = -20000;
    public static final short SCN_REGRESS = -51;
    private static final byte[] emptyValue = "".getBytes(Charset.forName("UTF-8"));
    public static final byte[] emptyMd5 = new byte[16];
    public static final byte[] EOPMarkerValue = emptyValue;
    public static final long ZeroLongKey = 0L;
    public static final DbusEventKey ZeroLongKeyObject;
    public static final DbusEventKey EOPMarkerKey;

    public abstract void setSequence(long var1);

    public abstract void applyCrc();

    public abstract void setSize(int var1);

    public abstract void setHeaderCrc(long var1);

    public abstract void setValue(byte[] var1);

    public abstract void setValueCrc(long var1);

    public abstract DbusEvent clone(DbusEvent var1);

    public abstract void setSrcId(int var1);

    public abstract void setSchemaId(byte[] var1);

    public abstract void recomputeCrcsAfterEspressoRewrite();

    public static DbusEventInternalWritable convertToDifferentVersion(DbusEventInternalWritable event, byte toVer) {
        byte fromVer = event.getVersion();
        if (fromVer == 2 && toVer == 0) {
            try {
                return ((DbusEventV2)event).convertToV1();
            }
            catch (KeyTypeNotImplementedException e) {
                throw new DatabusRuntimeException("failed to convert V2 event to V1, because of unsupported key type:" + e.getLocalizedMessage());
            }
        }
        throw new DatabusRuntimeException("Unsupported Event Version. cannot convert from " + fromVer + " to " + toVer);
    }

    static {
        EOPMarkerKey = ZeroLongKeyObject = new DbusEventKey(0L);
    }
}

