/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventInternalWritable;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.Encoding;
import com.linkedin.databus.core.UnsupportedKeyException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public abstract class DbusEventInternalReadable
extends DbusEvent {
    public abstract byte getVersion();

    public abstract int getMagic();

    public abstract boolean isErrorEvent();

    public abstract DbusEventInternalReadable reset(ByteBuffer var1, int var2);

    public abstract long headerCrc();

    protected abstract EventScanStatus scanEvent(boolean var1);

    public abstract int payloadLength();

    public abstract long bodyCrc();

    public abstract long getCalculatedValueCrc();

    public abstract DbusEventInternalWritable createCopy();

    public abstract int writeTo(WritableByteChannel var1, Encoding var2);

    public abstract short schemaVersion();

    public abstract boolean isValid(boolean var1);

    protected abstract HeaderScanStatus scanHeader(boolean var1);

    protected abstract boolean isPartial();

    public abstract boolean isControlSrcId();

    public abstract int keyBytesLength();

    public abstract HeaderScanStatus scanHeader();

    public abstract EventScanStatus scanEvent();

    public DbusEventKey getDbusEventKey() {
        if (this.isKeyNumber()) {
            return new DbusEventKey(this.key());
        }
        if (this.isKeyString()) {
            return new DbusEventKey(this.keyBytes());
        }
        if (this.isKeySchema()) {
            try {
                return new DbusEventKey(this.getKeyPart());
            }
            catch (UnsupportedKeyException uke) {
                return null;
            }
        }
        return null;
    }

    public static enum EventScanStatus {
        OK,
        ERR,
        PARTIAL;

    }

    public static enum HeaderScanStatus {
        OK,
        ERR,
        PARTIAL;

    }
}

