/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DbusEventPart;
import com.linkedin.databus.core.DbusOpcode;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class DbusEventInfo {
    private DbusOpcode _opCode;
    private long _sequenceId;
    private short _pPartitionId;
    private short _lPartitionId;
    private long _timeStampInNanos;
    private short _srcId;
    private byte[] _payloadSchemaMd5;
    private ByteBuffer _payloadBuffer;
    private boolean _enableTracing;
    private boolean _autocommit;
    private byte _eventSerializationVersion;
    private short _payloadSchemaVersion;
    private boolean _isReplicated;
    private DbusEventPart _metadata;

    public DbusEventInfo(DbusOpcode opCode, long sequenceId, short pPartitionId, short lPartitionId, long timeStampInNanos, short srcId, byte[] payloadSchemaMd5, byte[] payload, boolean enableTracing, boolean autocommit, byte eventSerializationVersion, short payloadSchemaVersion, DbusEventPart metadata) {
        this(opCode, sequenceId, pPartitionId, lPartitionId, timeStampInNanos, srcId, payloadSchemaMd5, payload, enableTracing, autocommit);
        this._eventSerializationVersion = eventSerializationVersion;
        this._payloadSchemaVersion = payloadSchemaVersion;
        this._metadata = metadata;
    }

    public DbusEventInfo(DbusOpcode opCode, long sequenceId, short pPartitionId, short lPartitionId, long timeStampInNanos, short srcId, byte[] payloadSchemaMd5, byte[] payload, boolean enableTracing, boolean autocommit) {
        this._opCode = opCode;
        this._sequenceId = sequenceId;
        this._pPartitionId = pPartitionId;
        this._lPartitionId = lPartitionId;
        this._timeStampInNanos = timeStampInNanos;
        this._srcId = srcId;
        this._payloadSchemaMd5 = payloadSchemaMd5;
        this._enableTracing = enableTracing;
        this._autocommit = autocommit;
        this._eventSerializationVersion = 0;
        this._payloadSchemaVersion = 0;
        this._payloadBuffer = null;
        if (payload != null) {
            this._payloadBuffer = ByteBuffer.wrap(payload);
        }
        this._metadata = null;
    }

    public DbusOpcode getOpCode() {
        return this._opCode;
    }

    public void setOpCode(DbusOpcode opCode) {
        this._opCode = opCode;
    }

    public long getSequenceId() {
        return this._sequenceId;
    }

    public void setSequenceId(long sequenceId) {
        this._sequenceId = sequenceId;
    }

    public short getpPartitionId() {
        return this._pPartitionId;
    }

    public void setpPartitionId(short pPartitionId) {
        this._pPartitionId = pPartitionId;
    }

    public short getlPartitionId() {
        return this._lPartitionId;
    }

    public void setlPartitionId(short lPartitionId) {
        this._lPartitionId = lPartitionId;
    }

    public long getTimeStampInNanos() {
        return this._timeStampInNanos;
    }

    public void setTimeStampInNanos(long timeStampInNanos) {
        this._timeStampInNanos = timeStampInNanos;
    }

    public short getSrcId() {
        return this._srcId;
    }

    public void setSrcId(short srcId) {
        this._srcId = srcId;
    }

    public byte[] getSchemaId() {
        return this._payloadSchemaMd5;
    }

    public void setSchemaId(byte[] schemaId) {
        this._payloadSchemaMd5 = schemaId;
    }

    public byte[] getValueBytes() {
        if (this._payloadBuffer == null) {
            return null;
        }
        if (this._payloadBuffer.isReadOnly() || !this._payloadBuffer.hasArray()) {
            byte[] val = new byte[this._payloadBuffer.remaining()];
            this._payloadBuffer.get(val);
            return val;
        }
        return this._payloadBuffer.array();
    }

    public int getValueLength() {
        if (this._payloadBuffer == null) {
            return 0;
        }
        return this._payloadBuffer.remaining();
    }

    public boolean isEnableTracing() {
        return this._enableTracing;
    }

    public void setEnableTracing(boolean enableTracing) {
        this._enableTracing = enableTracing;
    }

    public boolean isAutocommit() {
        return this._autocommit;
    }

    public void setAutocommit(boolean autocommit) {
        this._autocommit = autocommit;
    }

    public byte getEventSerializationVersion() {
        return this._eventSerializationVersion;
    }

    public void setEventSerializationVersion(byte eventSerializationVersion) {
        this._eventSerializationVersion = eventSerializationVersion;
    }

    public short getPayloadSchemaVersion() {
        return this._payloadSchemaVersion;
    }

    public void setPayloadSchemaVersion(short payloadSchemaVersion) {
        this._payloadSchemaVersion = payloadSchemaVersion;
    }

    public void setValueByteBuffer(ByteBuffer bb) {
        this._payloadBuffer = bb != null ? bb.asReadOnlyBuffer() : null;
    }

    public ByteBuffer getValueByteBuffer() {
        return this._payloadBuffer;
    }

    public boolean isReplicated() {
        return this._isReplicated;
    }

    public void setReplicated(boolean replicated) {
        this._isReplicated = replicated;
    }

    public DbusEventPart getMetadata() {
        return this._metadata;
    }

    public String toString() {
        return "DbusEventInfo{_opCode=" + (Object)((Object)this._opCode) + ", _sequenceId=" + this._sequenceId + ", _pPartitionId=" + this._pPartitionId + ", _lPartitionId=" + this._lPartitionId + ", _timeStampInNanos=" + this._timeStampInNanos + ", _srcId=" + this._srcId + ", _payloadSchemaMd5=" + Arrays.toString(this._payloadSchemaMd5) + ", _payloadBuffer=" + this._payloadBuffer + ", _enableTracing=" + this._enableTracing + ", _autocommit=" + this._autocommit + ", _eventSerializationVersion=" + this._eventSerializationVersion + ", _payloadSchemaVersion=" + this._payloadSchemaVersion + ", _isReplicated=" + this._isReplicated + ", _metadata=" + this._metadata + '}';
    }
}

