/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus.core.DbusErrorEvent;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventInfo;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.DbusEventInternalWritable;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.DbusEventV1;
import com.linkedin.databus.core.DbusEventV2;
import com.linkedin.databus.core.KeyTypeNotImplementedException;
import com.linkedin.databus.core.SCNRegressMessage;
import com.linkedin.databus.core.UnsupportedDbusEventVersionRuntimeException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.log4j.Logger;

public abstract class DbusEventFactory {
    public static final byte DBUS_EVENT_V1 = 0;
    public static final byte DBUS_EVENT_V2 = 2;
    public static final byte DBUS_EVENT_CURLY_BRACE = 123;
    public static final Logger LOG = Logger.getLogger((String)"DbusEventFactory");
    private final ByteOrder _byteOrder;

    protected DbusEventFactory(ByteOrder byteOrder) {
        this._byteOrder = byteOrder;
    }

    public abstract byte getVersion();

    public ByteOrder getByteOrder() {
        return this._byteOrder;
    }

    @Deprecated
    public static void setByteOrder(ByteOrder byteOrderForBackwardCompatiblity) {
        LOG.warn((Object)"This method is deprecated and should not be used. This call has been ignored.");
    }

    public abstract DbusEventInternalWritable createWritableDbusEvent();

    public static int serializeEvent(DbusEventKey key, ByteBuffer serializationBuffer, DbusEventInfo dbusEventInfo) throws KeyTypeNotImplementedException {
        byte version = dbusEventInfo.getEventSerializationVersion();
        if (version == 0) {
            return DbusEventV1.serializeEvent(key, serializationBuffer, dbusEventInfo);
        }
        if (version == 2) {
            return DbusEventV2.serializeEvent(key, serializationBuffer, dbusEventInfo);
        }
        throw new UnsupportedDbusEventVersionRuntimeException(version);
    }

    public DbusEventInternalWritable createWritableDbusEventFromBuffer(ByteBuffer buf, int position) {
        if (buf.order() != this.getByteOrder()) {
            throw new DatabusRuntimeException("ByteBuffer byte-order mismatch [DbusEventFactory.createWritableDbusEventFromBuffer(): buf = " + buf.order() + ", this = " + this.getByteOrder() + "]");
        }
        return DbusEventFactory.createWritableDbusEventFromBufferUnchecked(buf, position);
    }

    private static DbusEventInternalWritable createWritableDbusEventFromBufferUnchecked(ByteBuffer buf, int position) {
        byte version = buf.get(position);
        if (version == 0) {
            return new DbusEventV1(buf, position);
        }
        if (version == 2) {
            return new DbusEventV2(buf, position);
        }
        if (version == 123) {
            try {
                throw new DatabusRuntimeException("apparent remote exception: " + DbusEventFactory.getStringFromBuffer(buf, position));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        throw new UnsupportedDbusEventVersionRuntimeException(version);
    }

    static String getStringFromBuffer(ByteBuffer buf, int position) throws UnsupportedEncodingException {
        byte b;
        int idxLastPrintable;
        int idxFirstPrintable;
        byte[] arr;
        if (buf.hasArray()) {
            arr = buf.array();
            idxFirstPrintable = position + buf.arrayOffset();
        } else {
            ByteBuffer roBuf = buf.asReadOnlyBuffer();
            int length = roBuf.position(position).remaining();
            arr = new byte[length];
            roBuf.get(arr);
            idxFirstPrintable = 0;
        }
        assert (arr[idxFirstPrintable] == 123);
        for (idxLastPrintable = idxFirstPrintable; idxLastPrintable < arr.length && ((b = arr[idxLastPrintable]) >= 32 || b == 9 || b == 10 || b == 13) && b != 127; ++idxLastPrintable) {
        }
        int length = Math.min(idxLastPrintable - idxFirstPrintable, 512);
        return new String(arr, idxFirstPrintable, length, "UTF-8");
    }

    public DbusEventInternalReadable createReadOnlyDbusEventFromBuffer(ByteBuffer buf, int position) {
        return this.createWritableDbusEventFromBuffer(buf, position);
    }

    public static DbusEventInternalReadable createReadOnlyDbusEventFromBufferUnchecked(ByteBuffer buf, int position) {
        return DbusEventFactory.createWritableDbusEventFromBufferUnchecked(buf, position);
    }

    public static int computeEventLength(DbusEventKey key, DbusEventInfo eventInfo) throws KeyTypeNotImplementedException {
        if (eventInfo.getEventSerializationVersion() == 0) {
            return DbusEventV1.length(key, eventInfo.getValueLength());
        }
        if (eventInfo.getEventSerializationVersion() == 2) {
            return DbusEventV2.computeEventLength(key, eventInfo);
        }
        throw new UnsupportedDbusEventVersionRuntimeException(eventInfo.getEventSerializationVersion());
    }

    public abstract int serializeLongKeyEndOfPeriodMarker(ByteBuffer var1, DbusEventInfo var2);

    public abstract DbusEventInternalReadable createLongKeyEOPEvent(long var1, short var3);

    protected abstract DbusEventInternalReadable createLongKeyControlEvent(long var1, short var3, String var4);

    public DbusEventInternalReadable createCheckpointEvent(Checkpoint checkpoint) {
        return this.createLongKeyControlEvent(0L, (short)-3, checkpoint.toString());
    }

    public DbusEventInternalReadable createErrorEvent(DbusErrorEvent dbusErrorEvent) {
        return this.createLongKeyControlEvent(0L, dbusErrorEvent.getErrorId(), dbusErrorEvent.toString());
    }

    public DbusEvent createSCNRegressEvent(SCNRegressMessage scnRegressMessage) {
        return this.createLongKeyControlEvent(scnRegressMessage.getCheckpoint().getWindowScn(), (short)-51, SCNRegressMessage.toJSONString(scnRegressMessage));
    }
}

