/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DbusEventBuffer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DbusEventBufferMetaInfo {
    public static final Logger LOG = Logger.getLogger(DbusEventBufferMetaInfo.class);
    public static final String EVENT_STATE = "eventState";
    public static final String TIMESTAMP_OF_LATEST_DATA_EVENT = "timestampOfLatestDataEvent";
    public static final String TIMESTAMP_OF_FIRST_EVENT = "timestampOfFirstEvent";
    public static final String PREV_SCN = "prevScn";
    public static final String SEEN_END_OF_PERIOD_SCN = "seenEndOfPeriodScn";
    public static final String LAST_WRITTEN_SEQUENCE = "lastWrittenSequence";
    public static final String NUM_EVENTS_IN_WINDOW = "numEventsInWindow";
    public static final String EVENT_START_INDEX = "eventStartIndex";
    public static final String ALLOCATED_SIZE = "allocatedSize";
    public static final String BUFFER_EMPTY = "empty";
    public static final String BUFFER_TAIL = "tail";
    public static final String BUFFER_HEAD = "head";
    public static final String MAX_BUFFER_SIZE = "maxBufferSize";
    public static final String CURRENT_WRITE_POSITION = "currentWritePosition";
    public static final String BYTE_BUFFER_INFO = "ByteBufferInfo";
    public static final String NUM_BYTE_BUFFER = "ByteBufferNum";
    private static final int META_INFO_VERSION = 1;
    private static final char KEY_VALUE_SEP = ' ';
    private final Map<String, String> _info = new HashMap<String, String>(100);
    private boolean _valid = false;
    private final File _file;

    public DbusEventBufferMetaInfo(File metaFile) {
        this._file = metaFile;
    }

    public boolean isValid() {
        return this._valid;
    }

    public String getSessionId() {
        return this.getVal("sessionId");
    }

    public void setSessionId(String sid) {
        this.setVal("sessionId", sid);
    }

    public BufferInfo getReadBufferInfo() throws DbusEventBufferMetaInfoException {
        return new BufferInfo(this.getVal("readBufInfo"));
    }

    public BufferInfo getScnIndexBufferInfo() throws DbusEventBufferMetaInfoException {
        return new BufferInfo(this.getVal("scnIndexBufferInfo"));
    }

    public void setScnIndexBufferInfo(BufferInfo bi) {
        this.setVal("scnIndexBufferInfo", bi.toString());
    }

    public void setReadBufferInfo(BufferInfo bi) {
        this.setVal("readBufInfo", bi.toString());
    }

    public void setVal(String key, String val) {
        this._info.put(key, val);
    }

    String getVal(String key) {
        String val = this._info.get(key);
        return val;
    }

    public long getLong(String key) throws DbusEventBufferMetaInfoException {
        long l;
        try {
            l = Long.parseLong(this.getVal(key));
        }
        catch (NumberFormatException e) {
            throw new DbusEventBufferMetaInfoException(this, "key=" + key + " msg= " + e.getLocalizedMessage());
        }
        return l;
    }

    public int getInt(String key) throws DbusEventBufferMetaInfoException {
        int i;
        try {
            i = Integer.parseInt(this.getVal(key));
        }
        catch (NumberFormatException e) {
            throw new DbusEventBufferMetaInfoException(this, e.getLocalizedMessage());
        }
        return i;
    }

    public boolean getBool(String key) {
        return Boolean.parseBoolean(this.getVal(key));
    }

    public boolean loadMetaInfo() throws DbusEventBufferMetaInfoException {
        BufferedReader br = null;
        this._valid = false;
        boolean debugEnabled = DbusEventBuffer.LOG.isDebugEnabled();
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8");
            br = new BufferedReader(isr);
            DbusEventBuffer.LOG.info((Object)("loading metaInfoFile " + this._file));
            this._info.clear();
            String line = br.readLine();
            while (line != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                int idx = line.indexOf(32);
                if (idx < 0) {
                    DbusEventBuffer.LOG.warn((Object)("illegal line in metaInfoFile. line=" + line));
                    continue;
                }
                String key = line.substring(0, idx);
                String val = line.substring(idx + 1);
                this._info.put(key, val);
                if (debugEnabled) {
                    DbusEventBuffer.LOG.debug((Object)("\tkey=" + key + "; val=" + val));
                }
                line = br.readLine();
                this._valid = true;
            }
        }
        catch (IOException e) {
            throw new DbusEventBufferMetaInfoException(this, "cannot read metaInfoFile:  " + e.getLocalizedMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    DbusEventBuffer.LOG.warn((Object)("faild to close " + this._file));
                }
            }
        }
        int version = this.getInt("version");
        if (version != 1) {
            throw new DbusEventBufferMetaInfoException(this, "metaInfoFile version doesn't match. Please remove the metafile and restart");
        }
        if (this.isMetaFileOlderThenMMappedFiles(this.getSessionId())) {
            // empty if block
        }
        return this._valid;
    }

    private boolean isMetaFileOlderThenMMappedFiles(String sessionId) {
        if (sessionId == null) {
            return false;
        }
        long metaFileModTime = this._file.lastModified();
        LOG.debug((Object)(this._file + " mod time: " + metaFileModTime));
        File sessionDir = new File(this._file.getParent(), sessionId);
        long sessionDirModTime = sessionDir.lastModified();
        if (sessionDirModTime > metaFileModTime) {
            LOG.error((Object)("Session dir " + sessionDir + " seemed to be modified AFTER metaFile " + this._file + " dirModTime=" + sessionDirModTime + "; metaFileModTime=" + metaFileModTime));
            return true;
        }
        String[] mmappedFiles = sessionDir.list();
        if (mmappedFiles == null) {
            LOG.error((Object)("There are no mmaped files in the session directory: " + sessionDir));
            return true;
        }
        for (String fName : mmappedFiles) {
            File f = new File(sessionDir, fName);
            long modTime = f.lastModified();
            LOG.debug((Object)(f + " mod time: " + modTime));
            if (modTime <= metaFileModTime) continue;
            LOG.error((Object)("MMapped file " + f + "(" + modTime + ") seemed to be modified AFTER metaFile " + this._file + "(" + metaFileModTime + ")"));
            return true;
        }
        return false;
    }

    public BufferInfo[] getBuffersInfo() throws DbusEventBufferMetaInfoException {
        int bufNum = 0;
        try {
            bufNum = Integer.parseInt(this._info.get(NUM_BYTE_BUFFER));
        }
        catch (NumberFormatException e) {
            throw new DbusEventBufferMetaInfoException(this, e.getLocalizedMessage());
        }
        String bufInfoAll = this._info.get(BYTE_BUFFER_INFO);
        String[] buffersInfo = bufInfoAll.split(" ");
        if (buffersInfo.length != bufNum) {
            throw new DbusEventBufferMetaInfoException(this, "bufNum " + bufNum + " doesn't match bufInfo size [" + bufInfoAll + "]");
        }
        BufferInfo[] bInfos = new BufferInfo[bufNum];
        for (int i = 0; i < buffersInfo.length; ++i) {
            bInfos[i] = new BufferInfo(buffersInfo[i]);
        }
        return bInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAndClose() throws IOException {
        this.setVal("version", Integer.toString(1));
        if (this._file.exists()) {
            File renameTo = new File(this._file.getAbsoluteFile() + "." + System.currentTimeMillis());
            if (!this._file.renameTo(renameTo)) {
                LOG.warn((Object)("failed to rename " + this._file + " to " + renameTo));
            }
            DbusEventBuffer.LOG.warn((Object)("metaInfoFile " + this._file + " exists. it is renambed to " + renameTo));
        }
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(this._file), "UTF-8");
        BufferedWriter bw = new BufferedWriter(osw);
        try {
            for (Map.Entry<String, String> e : this._info.entrySet()) {
                bw.write(e.getKey() + ' ' + e.getValue());
                bw.newLine();
            }
        }
        finally {
            if (bw != null) {
                bw.close();
            }
        }
    }

    public String toString() {
        return this._file.getAbsolutePath();
    }

    public static class DbusEventBufferMetaInfoException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public DbusEventBufferMetaInfoException(String string) {
            super(string);
        }

        public DbusEventBufferMetaInfoException(DbusEventBufferMetaInfo mi, String string) {
            super("[" + mi.toString() + "]:" + string);
        }
    }

    public static class BufferInfo {
        public static final String DELIMITER = ",";
        public int _pos;
        public int _limit;
        public int _cap;

        BufferInfo(int pos, int limit, int cap) {
            this._pos = pos;
            this._limit = limit;
            this._cap = cap;
        }

        BufferInfo(String fromString) throws DbusEventBufferMetaInfoException {
            String[] info = fromString.split(DELIMITER);
            if (info.length != 3) {
                throw new DbusEventBufferMetaInfoException("parsing BufferInfo failed for " + fromString);
            }
            try {
                this._pos = Integer.parseInt(info[0]);
                this._limit = Integer.parseInt(info[1]);
                this._cap = Integer.parseInt(info[2]);
            }
            catch (NumberFormatException e) {
                throw new DbusEventBufferMetaInfoException("parsing BufferInfo failed for " + fromString + " " + e.getLocalizedMessage());
            }
        }

        public int getLimit() {
            return this._limit;
        }

        public int getPos() {
            return this._pos;
        }

        public int getCapacity() {
            return this._cap;
        }

        public String toString() {
            return this._pos + DELIMITER + this._limit + DELIMITER + this._cap;
        }
    }
}

