/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventBufferAppendable;
import com.linkedin.databus.core.DbusEventBufferMetaInfo;
import com.linkedin.databus.core.DbusEventBufferStreamAppendable;
import com.linkedin.databus.core.DbusEventFactory;
import com.linkedin.databus.core.DbusEventInfo;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.DbusEventInternalWritable;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.DbusEventSerializable;
import com.linkedin.databus.core.DbusEventV1Factory;
import com.linkedin.databus.core.Encoding;
import com.linkedin.databus.core.FileBasedEventTrackingCallback;
import com.linkedin.databus.core.InternalDatabusEventsListener;
import com.linkedin.databus.core.InvalidEventException;
import com.linkedin.databus.core.KeyTypeNotImplementedException;
import com.linkedin.databus.core.OffsetNotFoundException;
import com.linkedin.databus.core.RelayEventTraceOption;
import com.linkedin.databus.core.ScnIndex;
import com.linkedin.databus.core.ScnNotFoundException;
import com.linkedin.databus.core.StreamEventsArgs;
import com.linkedin.databus.core.StreamEventsResult;
import com.linkedin.databus.core.UnsupportedDbusEventVersionRuntimeException;
import com.linkedin.databus.core.data_model.PhysicalPartition;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus.core.util.BufferPosition;
import com.linkedin.databus.core.util.BufferPositionParser;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus.core.util.Range;
import com.linkedin.databus.core.util.RangeBasedReaderWriterLock;
import com.linkedin.databus.core.util.StringUtils;
import com.linkedin.databus2.core.AssertLevel;
import com.linkedin.databus2.core.DatabusException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;

public class DbusEventBuffer
implements Iterable<DbusEventInternalWritable>,
DbusEventBufferAppendable,
DbusEventBufferStreamAppendable {
    public static final String MODULE = DbusEventBuffer.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String MMAP_META_INFO_FILE_NAME = "metaFile";
    public static final String SESSION_PREFIX = "session_";
    public static final String MMAP_META_INFO_SUFFIX = ".info";
    public static final String PERF_MODULE = MODULE + "Perf";
    public static final Logger PERF_LOG = Logger.getLogger((String)PERF_MODULE);
    protected static final AtomicLong ITERATORS_COUNTER = new AtomicLong(0L);
    private final long _bufferRemoveWaitPeriodSec;
    private final double _nanoSecsInMSec = 1000000.0;
    private final DbusEventFactory _eventFactory;
    private byte _eventSerializationVersion = (byte)-1;
    private boolean _scnRegress = false;
    private boolean _dropOldEvents = false;
    public static final int MAX_DEBUG_ON_ERROR_ITERATIONS = 2;
    static final HashMap<String, Integer> TRACE_FILES_COUNT_MAP = new HashMap();
    private static int MIN_INITIAL_ITERATORS = 30;
    private final ReentrantLock _queueLock = new ReentrantLock();
    private final Lock _readBufferLock = new ReentrantLock();
    private final Condition _notFull = this._queueLock.newCondition();
    private final Condition _notEmpty = this._queueLock.newCondition();
    protected final RangeBasedReaderWriterLock _rwLockProvider;
    private final AtomicInteger readLocked = new AtomicInteger(0);
    private final PhysicalPartition _physicalPartition;
    private final BufferPosition _currentWritePosition;
    private final ScnIndex _scnIndex;
    private final ByteBuffer[] _buffers;
    private final int _maxBufferSize;
    private final int _initReadBufferSize;
    private final int _maxEventSize;
    private final BufferPosition _head;
    private final BufferPosition _tail;
    final boolean _bufferPersistenceEnabled;
    private boolean _empty;
    private boolean _isClosed = false;
    private final long _allocatedSize;
    private final HashSet<InternalDatabusEventsListener> _internalListeners = new HashSet<E>();
    private final AllocationPolicy _allocationPolicy;
    private final QueuePolicy _queueingPolicy;
    private File _mmapSessionDirectory;
    private File _mmapDirectory;
    private String _sessionId;
    protected final Set<WeakReference<BaseEventIterator>> _busyIteratorPool = new HashSet<WeakReference<BaseEventIterator>>(DbusEventBuffer.MIN_INITIAL_ITERATORS);
    private final AssertLevel _assertLevel;
    private WindowState _eventState = WindowState.INIT;
    private final BufferPosition _eventStartIndex;
    private int _numEventsInWindow;
    private volatile long _lastWrittenSequence;
    private volatile long _seenEndOfPeriodScn = -1L;
    private volatile long _prevScn;
    private final BufferPositionParser _bufferPositionParser;
    private volatile long _timestampOfFirstEvent;
    private volatile long _minScn;
    private volatile long _timestampOfLatestDataEvent = 0L;
    private static SessionIdGenerator _sessionIdGenerator = new SessionIdGenerator();
    private int _refCount = 0;
    private long _tsRefCounterUpdate = 0x7FFFFFFFFFFFFFFFL;
    final Logger _log;
    private static final double LN_5 = Math.log(5.0);

    public static String getMmapMetaInfoFileNamePrefix() {
        return MMAP_META_INFO_FILE_NAME;
    }

    public static String getSessionPrefix() {
        return SESSION_PREFIX;
    }

    public void setDropOldEvents(boolean val) {
        this._dropOldEvents = val;
    }

    protected boolean isClosed() {
        if (!this._queueLock.isLocked()) {
            throw new RuntimeException("checking if buffer is closed should be done under _queueLock");
        }
        return this._isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClosed() throws DatabusException {
        this.acquireWriteLock();
        try {
            if (this._isClosed) {
                throw new DatabusException("closing already closed buffer");
            }
            this._isClosed = true;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public PhysicalPartition getPhysicalPartition() {
        return this._physicalPartition;
    }

    public synchronized void increaseRefCounter() {
        ++this._refCount;
        this._tsRefCounterUpdate = System.currentTimeMillis();
    }

    public synchronized void decreaseRefCounter() {
        --this._refCount;
        this._tsRefCounterUpdate = System.currentTimeMillis();
    }

    public synchronized boolean shouldBeRemoved(boolean now) {
        if (this._refCount > 0) {
            return false;
        }
        if (now) {
            return true;
        }
        return System.currentTimeMillis() - this._tsRefCounterUpdate > this._bufferRemoveWaitPeriodSec * 1000L;
    }

    public synchronized int getRefCount() {
        return this._refCount;
    }

    public void clear() {
        this.clearAndStart(false, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAndStart(boolean start, long prevScn) {
        this.acquireWriteLock();
        try {
            if (this.isClosed()) {
                LOG.warn((Object)"canceling clearAndStart because the buffer is being closed");
                return;
            }
            this.lockFreeClear();
            this._scnIndex.clear();
            if (start) {
                this.start(prevScn);
            }
            this._empty = true;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void reset(long prevScn) {
        this.clearAndStart(true, prevScn);
    }

    public long getTimestampOfFirstEvent() {
        return this._timestampOfFirstEvent;
    }

    private void lockFreeClear() {
        this._scnIndex.clear();
        this._head.setPosition(0L);
        this._tail.setPosition(0L);
        this._currentWritePosition.setPosition(0L);
        this._prevScn = -1L;
        this._empty = true;
        this._lastWrittenSequence = -1L;
        this._timestampOfFirstEvent = 0L;
        for (ByteBuffer buf : this._buffers) {
            buf.clear();
        }
        this._notFull.signalAll();
    }

    public DbusEventBuffer(Config config) throws InvalidConfigException {
        this(config.build());
    }

    public DbusEventBuffer(StaticConfig config) {
        this(config.getMaxSize(), config.getMaxIndividualBufferSize(), config.getScnIndexSize(), config.getReadBufferSize(), config.getMaxEventSize(), config.getAllocationPolicy(), config.getMmapDirectory(), config.getQueuePolicy(), config.getTrace(), null, config.getAssertLevel(), config.getBufferRemoveWaitPeriod(), config.getRestoreMMappedBuffers(), config.getRestoreMMappedBuffersValidateEvents(), config.isEnableScnIndex(), new DbusEventV1Factory());
    }

    public DbusEventBuffer(StaticConfig config, PhysicalPartition pPartition, DbusEventFactory eventFactory) {
        this(config.getMaxSize(), config.getMaxIndividualBufferSize(), config.getScnIndexSize(), config.getReadBufferSize(), config.getMaxEventSize(), config.getAllocationPolicy(), config.getMmapDirectory(), config.getQueuePolicy(), config.getTrace(), pPartition, config.getAssertLevel(), config.getBufferRemoveWaitPeriod(), config.getRestoreMMappedBuffers(), config.getRestoreMMappedBuffersValidateEvents(), config.isEnableScnIndex(), eventFactory);
    }

    /*
     * Unable to fully structure code
     */
    public DbusEventBuffer(long maxEventBufferSize, int maxIndividualBufferSize, int maxIndexSize, int initReadBufferSize, int maxEventSize, AllocationPolicy allocationPolicy, File mmapDirectory, QueuePolicy queuePolicy, RelayEventTraceOption traceOption, PhysicalPartition physicalPartition, AssertLevel assertLevel, long bufRemovalWaitPeriod, boolean restoreBuffers, boolean validateEventesInRestoredBuffers, boolean enableScnIndex, DbusEventFactory eventFactory) {
        super();
        this._log = null == physicalPartition ? DbusEventBuffer.LOG : Logger.getLogger((String)(DbusEventBuffer.MODULE + "." + physicalPartition.toSimpleString()));
        this._assertLevel = assertLevel;
        DbusEventBuffer.LOG.info((Object)("DbusEventBuffer starting up with eventBufferSize = " + maxEventBufferSize + ", maxIndividualBufferSize = " + maxIndividualBufferSize + ", maxIndexSize = " + maxIndexSize + ", initReadBufferSize = " + initReadBufferSize + ", maxEventSize=" + maxEventSize + ", allocationPolicy = " + allocationPolicy.toString() + ", mmapDirectory = " + mmapDirectory.getAbsolutePath() + ",queuePolicy = " + (Object)queuePolicy + ", eventTraceOption = " + (Object)traceOption.getOption() + ", needFileSuffix = " + traceOption.isNeedFileSuffix() + ", assertLevel=" + (Object)this._assertLevel + ", bufRemovalWaitPeriod=" + bufRemovalWaitPeriod + ", restoreBuffers=" + restoreBuffers));
        this._eventFactory = eventFactory;
        this._eventSerializationVersion = eventFactory.getVersion();
        this._bufferPersistenceEnabled = restoreBuffers;
        this._queueingPolicy = queuePolicy;
        this._allocationPolicy = allocationPolicy;
        buffers = new ArrayList<ByteBuffer>();
        this._maxBufferSize = maxIndividualBufferSize;
        this._empty = true;
        this._lastWrittenSequence = -1L;
        this._prevScn = -1L;
        this._timestampOfFirstEvent = 0L;
        this._timestampOfLatestDataEvent = 0L;
        this._bufferRemoveWaitPeriodSec = bufRemovalWaitPeriod;
        this._physicalPartition = physicalPartition == null ? new PhysicalPartition(0, "default") : physicalPartition;
        mi = null;
        if (allocationPolicy == AllocationPolicy.MMAPPED_MEMORY) {
            this._sessionId = DbusEventBuffer._sessionIdGenerator.generateSessionId();
            metaInfoFile = new File(mmapDirectory, this.metaFileName());
            if (restoreBuffers) {
                if (!metaInfoFile.exists()) {
                    DbusEventBuffer.LOG.warn((Object)("restoreBuffers flag is specified, but the file " + metaInfoFile + " doesn't exist"));
                } else if (System.currentTimeMillis() - metaInfoFile.lastModified() > this._bufferRemoveWaitPeriodSec * 1000L) {
                    DbusEventBuffer.LOG.warn((Object)("restoreBuffers flag is specified, but the file " + metaInfoFile + " is older than " + this._bufferRemoveWaitPeriodSec + " secs"));
                } else {
                    try {
                        mi = new DbusEventBufferMetaInfo(metaInfoFile);
                        mi.loadMetaInfo();
                        if (mi.isValid()) {
                            this._sessionId = mi.getSessionId();
                            DbusEventBuffer.LOG.info((Object)("found file " + mi.toString() + "; will reuse session = " + this._sessionId));
                            this.validateMetaData(maxEventBufferSize, mi);
                        } else {
                            DbusEventBuffer.LOG.warn((Object)("cannot restore from file " + metaInfoFile));
                        }
                    }
                    catch (DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (!mmapDirectory.exists() && !mmapDirectory.mkdirs()) {
                throw new RuntimeException("Could not create directory " + this._mmapDirectory.getAbsolutePath());
            }
            this._mmapSessionDirectory = new File(mmapDirectory, this._sessionId);
            if (!this._mmapSessionDirectory.exists() && !this._mmapSessionDirectory.mkdirs()) {
                throw new RuntimeException("Could not create directory " + this._mmapSessionDirectory.getAbsolutePath());
            }
            DbusEventBuffer.LOG.info((Object)("MMapsessiondir = " + this._mmapSessionDirectory.getAbsolutePath()));
            this._mmapDirectory = mmapDirectory;
            if (!restoreBuffers) {
                DbusEventBuffer.LOG.info((Object)("restoreBuffers is false => will delete mmap session directory " + this._mmapSessionDirectory + " on exit"));
                this._mmapSessionDirectory.deleteOnExit();
            }
        }
        DbusEventBuffer.LOG.debug((Object)("Will allocate a total of " + maxEventBufferSize + " bytes"));
        for (allocatedSize = 0L; allocatedSize < maxEventBufferSize; allocatedSize += (long)nextSize) {
            nextSize = (int)Math.min((long)this._maxBufferSize, maxEventBufferSize - allocatedSize);
            if (DbusEventBuffer.LOG.isDebugEnabled()) {
                DbusEventBuffer.LOG.debug((Object)("Will allocate a buffer of size " + nextSize + " bytes with allocationPolicy = " + allocationPolicy.toString()));
            }
            buffer = DbusEventBuffer.allocateByteBuffer(nextSize, this._eventFactory.getByteOrder(), allocationPolicy, restoreBuffers, this._mmapSessionDirectory, new File(this._mmapSessionDirectory, "writeBuffer_" + buffers.size()));
            buffers.add(buffer);
        }
        DbusEventBuffer.LOG.info((Object)("Allocated a total of " + allocatedSize + " bytes into " + buffers.size() + " buffers"));
        this._allocatedSize = allocatedSize;
        this._buffers = new ByteBuffer[buffers.size()];
        buffers.toArray(this._buffers);
        if (mi != null && mi.isValid()) {
            try {
                this.setAndValidateMMappedBuffers(mi);
            }
            catch (DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException e) {
                throw new RuntimeException(e);
            }
        }
        this._maxEventSize = maxEventSize;
        if (initReadBufferSize <= this.getMaxReadBufferCapacity()) {
            this._initReadBufferSize = initReadBufferSize;
        } else {
            this._initReadBufferSize = this.getMaxReadBufferCapacity();
            this._log.warn((Object)String.format("Initial event staging buffer size %d > than max possible %d event size; resetting to %d ", new Object[]{this._initReadBufferSize, this.getMaxReadBufferCapacity(), this.getMaxReadBufferCapacity()}));
        }
        if (0 >= this._initReadBufferSize) {
            throw new DatabusRuntimeException("invalid initial event staging buffer size: " + this._initReadBufferSize);
        }
        this._bufferPositionParser = new BufferPositionParser((int)Math.min((long)this._maxBufferSize, maxEventBufferSize), buffers.size());
        this._scnIndex = new ScnIndex(maxIndexSize, maxEventBufferSize, this._maxBufferSize, this._bufferPositionParser, allocationPolicy, restoreBuffers, this._mmapSessionDirectory, this._assertLevel, enableScnIndex, this._eventFactory.getByteOrder());
        this._head = new BufferPosition(this._bufferPositionParser, this._buffers);
        this._tail = new BufferPosition(this._bufferPositionParser, this._buffers);
        this._currentWritePosition = new BufferPosition(this._bufferPositionParser, this._buffers);
        this._eventStartIndex = new BufferPosition(this._bufferPositionParser, this._buffers);
        this._rwLockProvider = new RangeBasedReaderWriterLock();
        DbusEventBuffer.LOG.info((Object)("Trace Relay Option : " + (Object)traceOption.getOption() + " physicalPartition:" + this._physicalPartition.getName() + " pSourceName:" + this._physicalPartition));
        if (RelayEventTraceOption.Option.file == traceOption.getOption()) {
            traceListener = this.createEventTraceListener(traceOption, this._physicalPartition.getName() + "_" + this._physicalPartition.getId());
            this._internalListeners.add(traceListener);
        }
        if (mi != null && mi.isValid()) {
            try {
                this.initBuffersWithMetaInfo(mi);
                if (!validateEventesInRestoredBuffers) ** GOTO lbl120
                this.validateEventsInBuffer();
            }
            catch (DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.clear();
            this.resetWindowState();
        }
lbl120:
        // 3 sources

        metaInfo = new File(mmapDirectory, this.metaFileName());
        if (metaInfo.exists()) {
            renameTo = new File(metaInfo.getAbsoluteFile() + "." + System.currentTimeMillis());
            if (metaInfo.renameTo(renameTo)) {
                DbusEventBuffer.LOG.warn((Object)("existing metaInfoFile " + metaInfo + " found. moving it to " + renameTo));
            } else {
                DbusEventBuffer.LOG.error((Object)("failed to move existing metaInfoFile " + metaInfo + " to " + renameTo + ". This may cause buffer to load this file if it gets restarted!"));
            }
        }
        if (enableScnIndex && this._scnIndex.isEmpty()) {
            this._scnIndex.setUpdateOnNext(true);
        }
        this._queueLock.lock();
        this.updateFirstEventMetadata();
        this._queueLock.unlock();
    }

    String metaFileName() {
        return "metaFile." + this._physicalPartition.getName() + "_" + this._physicalPartition.getId();
    }

    private void setAndValidateMMappedBuffers(DbusEventBufferMetaInfo mi) throws DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException {
        DbusEventBufferMetaInfo.BufferInfo[] bufsInfo = null;
        bufsInfo = mi.getBuffersInfo();
        int i = 0;
        for (ByteBuffer buffer : this._buffers) {
            DbusEventBufferMetaInfo.BufferInfo bi = bufsInfo[i];
            buffer.position(bi.getPos());
            buffer.limit(bi.getLimit());
            if (buffer.position() > buffer.limit() || buffer.limit() > buffer.capacity() || buffer.capacity() != bi.getCapacity()) {
                String msg = "ByteBuffers don't match: i=" + i + "; pos=" + buffer.position() + "; limit=" + buffer.limit() + "; capacity=" + buffer.capacity() + "; miCapacity=" + bi.getCapacity();
                throw new DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException(mi, msg);
            }
            ++i;
        }
        this._log.info((Object)("successfully validated all " + i + " mmapped buffers"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateEventsInBuffer() throws DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException {
        DbusEventIterator eventIterator = this.acquireIterator("validateEventsIterator");
        DbusEventInternalWritable e = null;
        int num = 0;
        boolean first = true;
        long firstScn = -1L;
        long start = System.currentTimeMillis();
        try {
            while (eventIterator.hasNext()) {
                e = eventIterator.next();
                ++num;
                if (e.isValid()) {
                    if (!first) continue;
                    firstScn = e.sequence();
                    first = false;
                    continue;
                }
                LOG.error((Object)("event " + e + " is not valid"));
                throw new DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException("Buffer validation failed. There are some invalid events");
            }
            long time = System.currentTimeMillis() - start;
            LOG.info((Object)("scanned " + num + " events in " + time + " msec. event at the end of the buffer: " + e));
            LOG.info((Object)("firstScn = " + firstScn + "; _lastWrittenSequence = " + this._lastWrittenSequence + "; minScn = " + this.getMinScn()));
            if (e != null && this._lastWrittenSequence != e.sequence()) {
                throw new DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException("Buffer validation failed. e.sequence=" + e.sequence() + " and _lastWrittenSeq=" + this._lastWrittenSequence);
            }
        }
        finally {
            this.releaseIterator(eventIterator);
        }
    }

    private void validateMetaData(long maxTotalEventBufferSize, DbusEventBufferMetaInfo mi) throws DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException {
        long miNumBuffs;
        long numBuffs = maxTotalEventBufferSize / (long)this._maxBufferSize;
        if (maxTotalEventBufferSize % (long)this._maxBufferSize > 0L) {
            ++numBuffs;
        }
        if ((miNumBuffs = mi.getLong("ByteBufferNum")) != numBuffs) {
            throw new DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException(mi, "Invalid number of ByteBuffers in meta file:" + miNumBuffs + "(expected =" + numBuffs + ")");
        }
        long miBufSize = mi.getLong("maxBufferSize");
        if (miBufSize != (long)this._maxBufferSize) {
            throw new DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException(mi, "Invalid maxBufferSize in meta file:" + miBufSize + "(expected =" + this._maxBufferSize + ")");
        }
        long allocatedSize = mi.getLong("allocatedSize");
        if (maxTotalEventBufferSize != allocatedSize) {
            throw new DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException(mi, "Invalid maxEventBufferSize in meta file:" + allocatedSize + "(expected =" + maxTotalEventBufferSize + ")");
        }
    }

    public static ByteBuffer allocateByteBuffer(int size, ByteOrder byteOrder, AllocationPolicy allocationPolicy, boolean restoreBuffers, File mmapSessionDir, File mmapFile) {
        ByteBuffer buffer = null;
        switch (allocationPolicy) {
            case HEAP_MEMORY: {
                buffer = ByteBuffer.allocate(size).order(byteOrder);
                break;
            }
            case DIRECT_MEMORY: {
                buffer = ByteBuffer.allocateDirect(size).order(byteOrder);
                break;
            }
            default: {
                if (!mmapSessionDir.exists()) {
                    throw new RuntimeException(mmapSessionDir.getAbsolutePath() + " doesn't exist");
                }
                if (restoreBuffers) {
                    if (!mmapFile.exists()) {
                        LOG.warn((Object)("restoreBuffers is true, but file " + mmapFile + " doesn't exist"));
                    } else {
                        LOG.info((Object)("restoring buffer from " + mmapFile));
                    }
                } else {
                    if (mmapFile.exists()) {
                        LOG.info((Object)("restoreBuffers is false; deleting existing mmap file " + mmapFile));
                        if (!mmapFile.delete()) {
                            throw new RuntimeException("deletion of file failed: " + mmapFile.getAbsolutePath());
                        }
                    }
                    LOG.info((Object)("restoreBuffers is false => will delete new mmap file " + mmapFile + " on exit"));
                    mmapFile.deleteOnExit();
                }
                try {
                    FileChannel rwChannel = new RandomAccessFile(mmapFile, "rw").getChannel();
                    buffer = rwChannel.map(FileChannel.MapMode.READ_WRITE, 0L, size).order(byteOrder);
                    rwChannel.close();
                    break;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("[should never happen!] can't find mmap file/dir " + mmapFile.getAbsolutePath(), e);
                }
                catch (IOException e) {
                    throw new RuntimeException("unable to initialize mmap file " + mmapFile, e);
                }
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private InternalDatabusEventsListener createEventTraceListener(RelayEventTraceOption traceOption, String pSourceName) {
        String fileName = traceOption.getFilename();
        if (traceOption.isNeedFileSuffix()) {
            Class<DbusEventBuffer> clazz = DbusEventBuffer.class;
            // MONITORENTER : com.linkedin.databus.core.DbusEventBuffer.class
            Integer traceNum = TRACE_FILES_COUNT_MAP.get(pSourceName);
            fileName = fileName + "." + pSourceName + (null != traceNum ? "." + traceNum : "");
            if (null == traceNum) {
                TRACE_FILES_COUNT_MAP.put(pSourceName, 1);
            } else {
                TRACE_FILES_COUNT_MAP.put(pSourceName, traceNum + 1);
            }
            // MONITOREXIT : clazz
        }
        LOG.info((Object)("Trace File Name is : " + fileName + "  pSourceName: " + pSourceName));
        FileBasedEventTrackingCallback cbk = new FileBasedEventTrackingCallback(fileName, traceOption.isAppendOnly());
        try {
            cbk.init();
            return cbk;
        }
        catch (IOException e) {
            throw new RuntimeException("unable to initialize FileBasedEventTrackingCallbock: Filename is :" + fileName, e);
        }
    }

    RangeBasedReaderWriterLock getRwLockProvider() {
        return this._rwLockProvider;
    }

    public void setPrevScn(long scn) {
        if (this._log.isDebugEnabled()) {
            this._log.info((Object)("setting prevScn to: " + scn));
        }
        this._prevScn = scn;
    }

    @Override
    public long getPrevScn() {
        return this._prevScn;
    }

    @Override
    public long getMinScn() {
        return this._minScn;
    }

    private void resetWindowState() {
        this._eventState = WindowState.INIT;
        this._numEventsInWindow = 0;
        this._eventStartIndex.setPosition(-1L);
    }

    @Override
    public void start(long startScn) {
        assert (this._eventState == WindowState.INIT || this._eventState == WindowState.ENDED);
        this.startEvents();
        this.endEvents(startScn);
        this.setPrevScn(startScn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startEvents() {
        assert (this._eventState == WindowState.INIT || this._eventState == WindowState.ENDED);
        this.acquireWriteLock();
        try {
            if (this.isClosed()) {
                throw new DatabusRuntimeException("attempting startEvents for a closed buffer");
            }
            this.resetWindowState();
            this._eventState = WindowState.STARTED;
            long tailPosition = this._tail.getPosition();
            this._currentWritePosition.setPosition(tailPosition > 0L ? tailPosition : 0L);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public boolean appendEvent(DbusEventKey key, short pPartitionId, short lPartitionId, long timeStamp, short srcId, byte[] schemaId, byte[] value, boolean enableTracing) {
        return this.appendEvent(key, pPartitionId, lPartitionId, timeStamp, srcId, schemaId, value, enableTracing, null);
    }

    @Override
    @Deprecated
    public boolean appendEvent(DbusEventKey key, long sequenceId, short pPartitionId, short logicalPartitionId, long timeStampInNanos, short srcId, byte[] schemaId, byte[] value, boolean enableTracing, DbusEventsStatisticsCollector statsCollector) {
        throw new RuntimeException("This method is not implemented!!!");
    }

    @Override
    public boolean appendEvent(DbusEventKey key, short pPartitionId, short lPartitionId, long timeStamp, short srcId, byte[] schemaId, byte[] value, boolean enableTracing, DbusEventsStatisticsCollector statsCollector) {
        return this.appendEvent(key, pPartitionId, lPartitionId, timeStamp, srcId, schemaId, value, enableTracing, false, statsCollector);
    }

    @Override
    public boolean appendEvent(DbusEventKey key, short pPartitionId, short lPartitionId, long timeStamp, short srcId, byte[] schemaId, byte[] value, boolean enableTracing, boolean isReplicated, DbusEventsStatisticsCollector statsCollector) {
        DbusEventInfo eventInfo = new DbusEventInfo(null, 0L, pPartitionId, lPartitionId, timeStamp, srcId, schemaId, value, enableTracing, false);
        eventInfo.setEventSerializationVersion((byte)0);
        eventInfo.setReplicated(isReplicated);
        return this.appendEvent(key, eventInfo, statsCollector);
    }

    @Override
    public boolean appendEvent(DbusEventKey key, DbusEventInfo eventInfo, DbusEventsStatisticsCollector statsCollector) {
        boolean isDebugEnabled = LOG.isDebugEnabled();
        this.acquireWriteLock();
        try {
            assert (this._eventState == WindowState.STARTED || this._eventState == WindowState.EVENTS_ADDED);
            try {
                this._scnIndex.assertHeadPosition(this._head.getRealPosition());
                this._bufferPositionParser.assertSpan(this._head.getPosition(), this._currentWritePosition.getPosition(), isDebugEnabled);
            }
            catch (RuntimeException re) {
                LOG.fatal((Object)"Got runtime Exception :", (Throwable)re);
                LOG.fatal((Object)("Event Buffer is :" + this.toString()));
                throw re;
            }
            if (this.isClosed()) {
                throw new DatabusRuntimeException("refusing to append event, because the buffer is closed");
            }
            int expNumBytesWritten = DbusEventFactory.computeEventLength(key, eventInfo);
            this.prepareForAppend(expNumBytesWritten);
            if (this._eventState == WindowState.STARTED) {
                this._eventStartIndex.copy(this._currentWritePosition);
            }
            if (isDebugEnabled) {
                LOG.debug((Object)("serializingEvent at position " + this._currentWritePosition.toString()));
                LOG.debug((Object)("PhysicalPartition passed in=" + eventInfo.getpPartitionId() + "; from the buffer = " + this._physicalPartition.getId().shortValue()));
            }
            eventInfo.setSequenceId(0L);
            eventInfo.setpPartitionId(this._physicalPartition.getId().shortValue());
            eventInfo.setAutocommit(false);
            int bytesWritten = DbusEventFactory.serializeEvent(key, this._buffers[this._currentWritePosition.bufferIndex()], eventInfo);
            if (bytesWritten != expNumBytesWritten) {
                String msg = "Actual Bytes Written was :" + bytesWritten + ", Expected to Write :" + expNumBytesWritten;
                LOG.fatal((Object)msg);
                LOG.fatal((Object)("Event Buffer is :" + this.toString()));
                throw new DatabusRuntimeException(msg);
            }
            long newWritePos = this._bufferPositionParser.incrementOffset(this._currentWritePosition.getPosition(), bytesWritten, this._buffers);
            this.moveCurrentWritePosition(newWritePos);
            this._eventState = WindowState.EVENTS_ADDED;
            ++this._numEventsInWindow;
            this._timestampOfLatestDataEvent = Math.max(this._timestampOfLatestDataEvent, eventInfo.getTimeStampInNanos());
        }
        catch (KeyTypeNotImplementedException ex) {
            if (null != statsCollector) {
                statsCollector.registerEventError(DbusEventInternalReadable.EventScanStatus.ERR);
            }
            throw new DatabusRuntimeException(ex);
        }
        finally {
            this.releaseWriteLock();
            this.finalizeAppend();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareForAppend(int dbusEventSize) throws KeyTypeNotImplementedException {
        boolean isDebugEnabled = LOG.isDebugEnabled();
        this._queueLock.lock();
        try {
            int findBufferIter;
            ByteBuffer buffer = this._buffers[this._currentWritePosition.bufferIndex()];
            int maxFindBufferIter = 3;
            for (findBufferIter = 0; findBufferIter < 3 && buffer.capacity() - 1 - this._currentWritePosition.bufferOffset() < dbusEventSize; ++findBufferIter) {
                if (isDebugEnabled) {
                    this._log.debug((Object)("skipping buffer " + this._currentWritePosition.bufferIndex() + ": " + buffer + ": insufficient capacity " + (buffer.capacity() - this._currentWritePosition.bufferOffset()) + " < " + dbusEventSize));
                }
                long newWritePos = this._bufferPositionParser.incrementIndex(this._currentWritePosition.getPosition(), this._buffers);
                this.ensureFreeSpace(this._currentWritePosition.getPosition(), newWritePos, isDebugEnabled);
                this.moveCurrentWritePosition(newWritePos);
                buffer = this._buffers[this._currentWritePosition.bufferIndex()];
            }
            if (3 == findBufferIter) {
                throw new DatabusRuntimeException("insufficient buffer capacity for event of size:" + dbusEventSize);
            }
            long stopIndex = this._bufferPositionParser.incrementOffset(this._currentWritePosition.getPosition(), dbusEventSize, this._buffers, true);
            this.ensureFreeSpace(this._currentWritePosition.getPosition(), stopIndex, isDebugEnabled);
            buffer.position(this._currentWritePosition.bufferOffset());
        }
        finally {
            this._queueLock.unlock();
        }
    }

    private void finalizeAppend() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackEvents() {
        this.acquireWriteLock();
        try {
            if (this.isClosed()) {
                LOG.warn((Object)"attempt to rollbackEvents for a closed buffer");
                return;
            }
            this.resetWindowState();
            this.rollbackCurrentWritePosition();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void rollbackCurrentWritePosition() {
        int realBufIdx;
        int tailIdx = this._tail.bufferIndex();
        int writePosIdx = this._currentWritePosition.bufferIndex();
        for (int i = 0; !(i >= this._buffers.length || (realBufIdx = (tailIdx + i) % this._buffers.length) == tailIdx && realBufIdx == writePosIdx && this._tail.bufferOffset() <= this._currentWritePosition.bufferOffset() || realBufIdx == writePosIdx && realBufIdx != tailIdx); ++i) {
            this._buffers[realBufIdx].limit(this._buffers[realBufIdx].capacity());
        }
        this._currentWritePosition.setPosition(this._tail.getPosition());
        assert (this.assertBuffersLimits());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endEvents(boolean updateWindowScn, long windowScn, boolean updateIndex, boolean callListener, DbusEventsStatisticsCollector statsCollector) {
        boolean isDebugEnabled = LOG.isDebugEnabled();
        if (windowScn < this._lastWrittenSequence) {
            throw new RuntimeException("Trying to add batch of events at sequence: " + windowScn + " when lastWrittenSequence = " + this._lastWrittenSequence);
        }
        if (WindowState.ENDED == this._eventState && isDebugEnabled) {
            LOG.debug((Object)("Skipping event window as Window is already in ended state" + windowScn));
        }
        this.acquireWriteLock();
        try {
            if (this.isClosed()) {
                throw new DatabusRuntimeException("refusing to endEvents, because the buffer is closed");
            }
            if (WindowState.STARTED == this._eventState && windowScn == this._lastWrittenSequence) {
                if (isDebugEnabled) {
                    LOG.debug((Object)("Skipping event window that did not move forward:" + windowScn));
                }
                this._eventState = WindowState.ENDED;
                return;
            }
            DbusEventInfo eventInfo = new DbusEventInfo(null, windowScn, this._physicalPartition.getId().shortValue(), 0, this._timestampOfLatestDataEvent, -2, DbusEventInternalWritable.emptyMd5, DbusEventInternalWritable.EOPMarkerValue, false, false, this.getEventSerializationVersion(), 0, null);
            int expNumBytesWritten = DbusEventFactory.computeEventLength(DbusEventInternalWritable.EOPMarkerKey, eventInfo);
            this.prepareForAppend(expNumBytesWritten);
            int numBytesWritten = this._eventFactory.serializeLongKeyEndOfPeriodMarker(this._buffers[this._currentWritePosition.bufferIndex()], eventInfo);
            if (numBytesWritten != expNumBytesWritten) {
                String msg = "Actual Bytes Written was :" + numBytesWritten + ", Expected to Write :" + expNumBytesWritten;
                LOG.fatal((Object)msg);
                LOG.fatal((Object)("Event Buffer is :" + this.toString()));
                throw new DatabusRuntimeException(msg);
            }
            long newWritePos = this._bufferPositionParser.incrementOffset(this._currentWritePosition.getPosition(), numBytesWritten, this._buffers);
            this.moveCurrentWritePosition(newWritePos);
            this.finalizeAppend();
            this._currentWritePosition.sanitize();
            boolean updatedIndex = false;
            if (updateWindowScn || updateIndex || callListener) {
                this._eventStartIndex.sanitize();
                InternalEventIterator eventIterator = this.acquireInternalIterator(this._eventStartIndex.getPosition(), this._currentWritePosition.getPosition(), "endEventsIterator");
                try {
                    LOG.debug((Object)"acquired iterator");
                    DbusEventInternalWritable e = null;
                    while (eventIterator.hasNext()) {
                        long eventPosition = eventIterator.getCurrentPosition();
                        e = eventIterator.next();
                        if (updateWindowScn) {
                            e.setSequence(windowScn);
                            e.applyCrc();
                        }
                        if (null != statsCollector) {
                            statsCollector.registerDataEvent(e);
                        }
                        if (updateIndex) {
                            this._scnIndex.onEvent(e, eventPosition, e.size());
                            if (!e.isControlMessage()) {
                                updatedIndex = true;
                            }
                        }
                        if (!this._internalListeners.isEmpty() && callListener) {
                            for (InternalDatabusEventsListener listener : this._internalListeners) {
                                listener.onEvent(e, eventPosition, e.size());
                            }
                        }
                        if (e.isControlMessage()) continue;
                        if (this._timestampOfFirstEvent == 0L) {
                            this._timestampOfFirstEvent = e.timestampInNanos() / 1000000L;
                        }
                        this._timestampOfLatestDataEvent = e.timestampInNanos() / 1000000L;
                    }
                }
                finally {
                    this.releaseIterator(eventIterator);
                }
            }
            if (updatedIndex && QueuePolicy.OVERWRITE_ON_WRITE == this._queueingPolicy) {
                try {
                    this._scnIndex.assertLastWrittenPos(this._eventStartIndex);
                }
                catch (RuntimeException re) {
                    this._log.fatal((Object)"Got runtime Exception: ", (Throwable)re);
                    this._log.fatal((Object)("Event Buffer is: " + this.toString()));
                    this._log.fatal((Object)"SCN Index is: ");
                    this._scnIndex.printVerboseString(LOG, Level.FATAL);
                    throw re;
                }
            }
            this._eventState = WindowState.ENDED;
            this._lastWrittenSequence = windowScn;
            long oldTail = this._tail.getPosition();
            assert (this._currentWritePosition.bufferGenId() - this._head.bufferGenId() <= 1L) : this.toString();
            this._tail.copy(this._currentWritePosition);
            if (this._head.getPosition() < 0L) {
                this._head.setPosition(0L);
            }
            if (QueuePolicy.OVERWRITE_ON_WRITE == this._queueingPolicy) {
                try {
                    this._bufferPositionParser.assertSpan(this._head.getPosition(), this._tail.getPosition(), isDebugEnabled);
                    this._scnIndex.assertHeadPosition(this._head.getRealPosition());
                }
                catch (RuntimeException re) {
                    this._log.fatal((Object)"Got runtime Exception: ", (Throwable)re);
                    this._log.info((Object)("Old Tail was: " + this._bufferPositionParser.toString(oldTail, this._buffers) + ", New Tail is: " + this._tail.toString()));
                    this._log.fatal((Object)("Event Buffer is: " + this.toString()));
                    throw re;
                }
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("DbusEventBuffer: head = " + this._head.toString() + " tail = " + this._tail.toString() + "empty = " + this.empty()));
            }
            if (null != statsCollector) {
                statsCollector.registerBufferMetrics(this.getMinScn(), this._lastWrittenSequence, this.getPrevScn(), this.getBufferFreeSpace());
                statsCollector.registerTimestampOfFirstEvent(this._timestampOfFirstEvent);
            }
            this._empty = false;
            this.updateFirstEventMetadata();
            this._notEmpty.signalAll();
        }
        catch (KeyTypeNotImplementedException ex) {
            if (null != statsCollector) {
                statsCollector.registerEventError(DbusEventInternalReadable.EventScanStatus.ERR);
            }
            throw new RuntimeException(ex);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void endEvents(long sequenceId) {
        this.endEvents(sequenceId, null);
    }

    @Override
    public void endEvents(long eventWindowScn, DbusEventsStatisticsCollector statsCollector) {
        if (this._eventState != WindowState.EVENTS_ADDED) {
            this._eventStartIndex.copy(this._currentWritePosition);
        }
        this.endEvents(true, eventWindowScn, true, true, statsCollector);
    }

    /*
     * Exception decompiling
     */
    public StreamEventsResult streamEvents(Checkpoint checkPoint, WritableByteChannel writeChannel, StreamEventsArgs args) throws ScnNotFoundException, OffsetNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 10[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int batchWrite(Range range, WritableByteChannel writeChannel, Encoding encoding) {
        long startOffset = range.start;
        long endOffset = range.end;
        assert (this._bufferPositionParser.bufferIndex(startOffset) == this._bufferPositionParser.bufferIndex(endOffset));
        ByteBuffer buf = this._buffers[this._bufferPositionParser.bufferIndex(startOffset)];
        int endBufferOffset = this._bufferPositionParser.bufferOffset(endOffset);
        int startBufferOffset = this._bufferPositionParser.bufferOffset(startOffset);
        int bytesWritten = 0;
        switch (encoding) {
            case BINARY: {
                ByteBuffer writeBuf = buf.duplicate().order(this._eventFactory.getByteOrder());
                writeBuf.position(startBufferOffset);
                writeBuf.limit(endBufferOffset);
                try {
                    bytesWritten = writeChannel.write(writeBuf);
                    break;
                }
                catch (IOException e1) {
                    LOG.error((Object)("batchWrite error: " + e1.getMessage()), (Throwable)e1);
                    throw new RuntimeException(e1);
                }
            }
            case JSON: 
            case JSON_PLAIN_VALUE: {
                DbusEventInternalReadable e = this._eventFactory.createReadOnlyDbusEventFromBuffer(buf, startBufferOffset);
                for (int currentBufferOffset = startBufferOffset; currentBufferOffset != endBufferOffset; currentBufferOffset += e.size()) {
                    e = e.reset(buf, currentBufferOffset);
                    e.writeTo(writeChannel, encoding);
                }
                break;
            }
        }
        return bytesWritten;
    }

    @Override
    public boolean empty() {
        return this._empty;
    }

    private void releaseWriteLock() {
        this._queueLock.unlock();
    }

    private void acquireWriteRangeLock(long startOffset, long endOffset) throws InterruptedException, TimeoutException {
        this._rwLockProvider.acquireWriterLock(startOffset, endOffset, this._bufferPositionParser);
    }

    private void releaseWriteRangeLock() {
        this._rwLockProvider.releaseWriterLock(this._bufferPositionParser);
    }

    private void acquireWriteLock() {
        this._queueLock.lock();
    }

    public int getReadStatus() {
        return this.readLocked.get();
    }

    public int readEvents(ReadableByteChannel readChannel, Encoding _encoding) throws InvalidEventException {
        switch (_encoding) {
            case BINARY: {
                return this.readEvents(readChannel);
            }
            case JSON: 
            case JSON_PLAIN_VALUE: {
                BufferedReader in = new BufferedReader(Channels.newReader(readChannel, "UTF-8"));
                try {
                    return DbusEventSerializable.appendToEventBuffer(in, (DbusEventBufferAppendable)this, null, false);
                }
                catch (JsonParseException e) {
                    throw new InvalidEventException(e);
                }
                catch (IOException e) {
                    throw new InvalidEventException(e);
                }
            }
        }
        return -1;
    }

    public int readEvents(ReadableByteChannel readChannel) throws InvalidEventException {
        return this.readEvents(readChannel, this._internalListeners, null);
    }

    public int readEvents(ReadableByteChannel readChannel, DbusEventsStatisticsCollector statsCollector) throws InvalidEventException {
        return this.readEvents(readChannel, this._internalListeners, statsCollector);
    }

    public int readEvents(ReadableByteChannel readChannel, Iterable<InternalDatabusEventsListener> eventListeners) throws InvalidEventException {
        return this.readEvents(readChannel, eventListeners, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readEvents(ReadableByteChannel readChannel, Iterable<InternalDatabusEventsListener> eventListeners, DbusEventsStatisticsCollector statsCollector) throws InvalidEventException {
        try {
            int n = this.readEventsInternal(readChannel, eventListeners, statsCollector);
            return n;
        }
        finally {
            if (this.getMinScn() > 0L && 0L > this.getPrevScn()) {
                long newPrevScn = this.getMinScn() - 1L;
                this.setPrevScn(newPrevScn);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int readEventsInternal(ReadableByteChannel readChannel, Iterable<InternalDatabusEventsListener> eventListeners, DbusEventsStatisticsCollector statsCollector) throws InvalidEventException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 42[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean readEventsFromChannel(ReadableByteChannel readChannel, ByteBuffer readBuffer, boolean logDebugEnabled) {
        if (logDebugEnabled) {
            this._log.debug((Object)("reading events from channel to " + readBuffer));
        }
        boolean success = true;
        long oneread = 1L;
        while (success && oneread > 0L) {
            try {
                oneread = readChannel.read(readBuffer);
                if (!logDebugEnabled) continue;
                this._log.debug((Object)("Read " + oneread + " bytes"));
            }
            catch (IOException e) {
                this._log.error((Object)("readEvents error: " + e.getMessage()), (Throwable)e);
                success = false;
            }
        }
        if (logDebugEnabled) {
            this._log.debug((Object)("read events from channel success=" + success + " to " + readBuffer));
        }
        return success;
    }

    private void compactStgBuffer(ReadEventsReadPosition readPos, boolean logDebugEnabled) {
        ByteBuffer readBuffer = readPos.getReadBuffer();
        readBuffer.clear();
        if (readPos.hasNext()) {
            if (logDebugEnabled) {
                this._log.debug((Object)("Copying " + readPos.bytesRemaining() + " bytes to the start of the readBuffer"));
            }
            for (int i = 0; i < readPos.bytesRemaining(); ++i) {
                readBuffer.put(readBuffer.get(readPos.getPosition() + i));
            }
            readPos.startIteration();
            if (logDebugEnabled) {
                this._log.debug((Object)("readBuffer after compaction: " + readBuffer + "; " + readPos));
            }
        }
    }

    private boolean ensureFreeSpace(long writeStartPos, long writeEndPos, boolean logDebugEnabled) {
        BufferPosition normalizedWriteEndPos = new BufferPosition(writeEndPos, this._bufferPositionParser, this._buffers);
        normalizedWriteEndPos.skipOverFreeSpace();
        boolean interrupted = false;
        if (!this.empty()) {
            if (QueuePolicy.BLOCK_ON_WRITE == this._queueingPolicy) {
                interrupted = this.waitForReadEventsFreeSpace(logDebugEnabled, writeStartPos, normalizedWriteEndPos.getPosition());
            } else {
                this.freeUpSpaceForReadEvents(logDebugEnabled, writeStartPos, normalizedWriteEndPos.getPosition());
            }
        }
        if (logDebugEnabled) {
            this._log.debug((Object)("ensureFreeSpace: writeStart:" + this._bufferPositionParser.toString(writeStartPos, this._buffers) + "; writeEnd:" + this._bufferPositionParser.toString(writeEndPos, this._buffers) + "; normalizedWriteEnd:" + normalizedWriteEndPos + "; head:" + this._head + "; tail:" + this._tail + "; interrupted:" + interrupted));
        }
        assert (interrupted || !this.overwritesHead(writeStartPos, normalizedWriteEndPos.getPosition()));
        return interrupted;
    }

    private boolean waitForReadEventsFreeSpace(boolean logDebugEnabled, long writeStartPosition, long writeEndPosition) {
        assert (this._queueLock.isHeldByCurrentThread());
        boolean interrupted = false;
        while (!interrupted && this.overwritesHead(writeStartPosition, writeEndPosition)) {
            this._log.info((Object)("Waiting for more space to be available. WriteStart: " + this._bufferPositionParser.toString(writeStartPosition, this._buffers) + " to " + this._bufferPositionParser.toString(writeEndPosition, this._buffers) + " head = " + this._head));
            try {
                this._notFull.await();
            }
            catch (InterruptedException ie) {
                this._log.warn((Object)"readEvents interrupted", (Throwable)ie);
                interrupted = true;
            }
            if (logDebugEnabled) {
                this._log.debug((Object)("Coming out of wait for more space. WriteStart: " + this._bufferPositionParser.toString(writeStartPosition, this._buffers) + " to " + this._bufferPositionParser.toString(writeEndPosition, this._buffers) + " head = " + this._head));
            }
            if (!this.isClosed()) continue;
            throw new DatabusRuntimeException("Coming out of wait for more space, but buffer has been closed");
        }
        return interrupted;
    }

    private boolean overwritesHead(long writeStartPosition, long writeEndPosition) {
        return this.empty() ? false : Range.containsReaderPosition(writeStartPosition, writeEndPosition, this._head.getPosition(), this._bufferPositionParser);
    }

    private void freeUpSpaceForReadEvents(boolean logDebugEnabled, long writeStartPosition, long writeEndPosition) {
        if (logDebugEnabled) {
            this._log.debug((Object)("freeUpSpaceForReadEvents: start:" + this._bufferPositionParser.toString(writeStartPosition, this._buffers) + "; end:" + this._bufferPositionParser.toString(writeEndPosition, this._buffers) + "; head:" + this._head));
        }
        if (this.overwritesHead(writeStartPosition, writeEndPosition)) {
            long proposedHead;
            if (logDebugEnabled) {
                this._log.debug((Object)("free space from " + this._bufferPositionParser.toString(writeStartPosition, this._buffers) + " to " + this._bufferPositionParser.toString(writeEndPosition, this._buffers) + " head = " + this._head));
            }
            if ((proposedHead = this._scnIndex.getLargerOffset(writeEndPosition)) < 0L) {
                String error = "track(ScnIndex.head): failed to get larger window offset:nextFreePosition=" + this._bufferPositionParser.toString(writeEndPosition, this._buffers) + " ;Head=" + this._head + "; Tail=" + this._tail + " ;CurrentWritePosition=" + this._currentWritePosition + " ;MinScn=" + this.getMinScn();
                this._log.error((Object)error);
                this._scnIndex.printVerboseString(this._log, Level.ERROR);
                throw new DatabusRuntimeException(error);
            }
            long newScn = -1L;
            long newTs = -1L;
            if (proposedHead < this._tail.getPosition()) {
                DbusEvent e = this.eventAtPosition(proposedHead);
                newScn = e.sequence();
                newTs = e.timestampInNanos();
            }
            this.moveHead(proposedHead, newScn, newTs, logDebugEnabled);
        }
    }

    private void adjustByteBufferLimit(long oldHeadPos) {
        boolean resetLimit;
        int newHeadIdx = this._head.bufferIndex();
        int newHeadOfs = this._head.bufferOffset();
        long newHeadGenid = this._head.bufferGenId();
        int oldHeadIdx = this._bufferPositionParser.bufferIndex(oldHeadPos);
        int oldHeadOfs = this._bufferPositionParser.bufferOffset(oldHeadPos);
        long oldHeadGenid = this._bufferPositionParser.bufferGenId(oldHeadPos);
        assert (oldHeadPos <= this._head.getPosition()) : "oldHeaPos:" + oldHeadPos + " " + this.toString();
        assert (newHeadGenid - oldHeadGenid <= 1L) : "oldHeaPos:" + oldHeadPos + " " + this.toString();
        boolean bl = resetLimit = newHeadIdx != oldHeadIdx || newHeadOfs < oldHeadOfs;
        if (resetLimit) {
            if (this._buffers.length == 1) {
                this._buffers[0].limit(this._buffers[0].capacity());
            } else {
                int bufferNumDiff;
                int n = bufferNumDiff = oldHeadGenid < newHeadGenid ? this._buffers.length + newHeadIdx - oldHeadIdx : newHeadIdx - oldHeadIdx;
                assert (0 <= bufferNumDiff && bufferNumDiff <= this._buffers.length) : "oldHeadPos:" + oldHeadPos + " " + this.toString();
                for (int i = 0; i < bufferNumDiff; ++i) {
                    int bufIdx = (oldHeadIdx + i) % this._buffers.length;
                    this._buffers[bufIdx].limit(this._buffers[bufIdx].capacity());
                }
            }
            assert (this.assertBuffersLimits());
        }
    }

    private void copyReadEventToEventBuffer(ReadEventsReadPosition readPos, ReadEventsWritePosition writePos, Iterable<InternalDatabusEventsListener> eventListeners, DbusEventsStatisticsCollector statsCollector, boolean logDebugEnabled) {
        ByteBuffer readBuffer = readPos.getReadBuffer();
        int numBytesToWrite = readPos.bytesProcessed();
        int writeStartOfs = writePos.getCurOfs();
        ByteBuffer curBuf = writePos.getCurBuf();
        assert (writePos.getNextFree().bufferGenId() - this._head.bufferGenId() <= 1L) : writePos.toString() + " buf:" + this.toString();
        assert (curBuf.limit() >= writePos.getNextFreeOfs()) : "curBuf:" + curBuf + "; " + writePos;
        int oldLimit = readBuffer.limit();
        readBuffer.mark();
        readBuffer.position(readPos.getReadStart());
        readBuffer.limit(readPos.getPosition());
        curBuf.position(writeStartOfs);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("copying from " + readBuffer + " into " + writePos.getCurBuf() + "head:" + this._head + " tail:" + this._tail));
        }
        curBuf.put(readBuffer);
        readBuffer.limit(oldLimit);
        readBuffer.reset();
        if (numBytesToWrite > 0) {
            this.updateNewReadEvent(readPos, writePos, statsCollector, eventListeners, logDebugEnabled);
            if (readPos.getLastSeenStgWin() > this._seenEndOfPeriodScn) {
                this._seenEndOfPeriodScn = readPos.getLastSeenStgWin();
            }
        }
        if (logDebugEnabled) {
            LOG.debug((Object)("Tail is set to :" + this._tail + ", Head is at :" + this._head));
        }
        assert (this._head.bufferIndex() != this._tail.bufferIndex() || this._head.getPosition() < this._tail.getPosition() || this._head.bufferOffset() < writePos.getCurBuf().limit());
    }

    private int updateNewReadEvent(ReadEventsReadPosition readPos, ReadEventsWritePosition writePos, DbusEventsStatisticsCollector statsCollector, Iterable<InternalDatabusEventsListener> eventListeners, boolean logDebugEnabled) {
        int eventsWritten = 0;
        if (writePos.getNextFreePos() > writePos.getCurPos()) {
            if (logDebugEnabled) {
                LOG.debug((Object)("readEvents: acquiring iterator for " + writePos));
            }
            if ((eventsWritten = this.updateScnIndexWithNewReadEvent(readPos, writePos, eventListeners, statsCollector, logDebugEnabled)) > 0) {
                writePos.setNextFreePos(this._currentWritePosition.getPosition());
                this._empty = false;
                this.updateFirstEventMetadata();
                this._notEmpty.signalAll();
                assert (this.assertBuffersLimits());
            } else {
                LOG.error((Object)("Buffer State is :" + this.toString()));
                LOG.error((Object)("readPos:" + readPos));
                LOG.error((Object)("writePos:" + writePos));
                throw new RuntimeException("Unexpected State in EventBuffer");
            }
            if (logDebugEnabled) {
                this._log.debug((Object)("updateNewReadEvents: eventsWritten:" + eventsWritten + "; " + readPos + " " + writePos + "; tail:" + this._tail));
            }
        }
        return eventsWritten;
    }

    private int updateScnIndexWithNewReadEvent(ReadEventsReadPosition readPos, ReadEventsWritePosition writePos, Iterable<InternalDatabusEventsListener> eventListeners, DbusEventsStatisticsCollector statsCollector, boolean logDebugEnabled) {
        int eventsWritten = 0;
        long currentPosition = writePos.getCurPos();
        DbusEventInternalWritable e = writePos.next();
        try {
            assert (e.isValid()) : e.toString();
            if (null != statsCollector) {
                statsCollector.registerDataEvent(e);
            }
            readPos.eventWritten();
            ++eventsWritten;
            this._tail.setPosition(currentPosition + (long)e.size());
            this._currentWritePosition.setPosition(this._tail.getPosition());
            if (!e.isControlMessage()) {
                this._timestampOfLatestDataEvent = e.timestampInNanos() / 1000000L;
                if (this._timestampOfFirstEvent == 0L) {
                    this._timestampOfFirstEvent = this._timestampOfLatestDataEvent;
                }
            }
            this._lastWrittenSequence = e.sequence();
            this._scnIndex.onEvent(e, currentPosition, e.size());
            this.callListeners(e, currentPosition, eventListeners);
            if (eventListeners != this._internalListeners) {
                this.callListeners(e, currentPosition, this._internalListeners);
            }
        }
        catch (RuntimeException ex) {
            this._log.error((Object)("error updating scn index " + this._scnIndex + " for event " + readPos.getCurEvent() + ": " + ex.getMessage()), (Throwable)ex);
        }
        return eventsWritten;
    }

    private void callListeners(DbusEventInternalWritable event, long currentPosition, Iterable<InternalDatabusEventsListener> eventListeners) {
        if (eventListeners != null) {
            for (InternalDatabusEventsListener listener : eventListeners) {
                try {
                    listener.onEvent(event, currentPosition, event.size());
                }
                catch (RuntimeException e) {
                    this._log.warn((Object)("internal listener " + listener + " failed for event " + event));
                }
            }
        }
    }

    private DbusEvent eventAtPosition(long pos) {
        int proposedHeadIdx = this._bufferPositionParser.bufferIndex(pos);
        int proposedHeadOfs = this._bufferPositionParser.bufferOffset(pos);
        DbusEventInternalReadable e = this._eventFactory.createReadOnlyDbusEventFromBuffer(this._buffers[proposedHeadIdx], proposedHeadOfs);
        assert (e.isValid());
        return e;
    }

    private String logSequenceErrorPackets(ReadEventsReadPosition readPos) {
        String k = "UNINITIALIZED";
        if (readPos.getCurEvent().isKeyString()) {
            try {
                k = new String(readPos.getCurEvent().keyBytes(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            k = Long.toString(readPos.getCurEvent().key());
        }
        String errMsg = "" + this._physicalPartition.getName() + " _lastWrittenSequence=" + this._lastWrittenSequence + " _seenEndOfPeriodScn=" + this._seenEndOfPeriodScn + " key=" + k + " _scnRegress=" + this._scnRegress + " " + readPos;
        return errMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveHead(long proposedHead, long newScn, long newHeadTsNs, boolean logDebugEnabled) {
        assert (this._queueLock.isHeldByCurrentThread());
        long oldHeadPos = this._head.getPosition();
        if (logDebugEnabled) {
            this._log.debug((Object)("about to move head to " + this._bufferPositionParser.toString(proposedHead, this._buffers) + "; scn=" + newScn + "; oldhead=" + this._head));
        }
        try {
            this.acquireWriteRangeLock(oldHeadPos, proposedHead);
        }
        catch (InterruptedException e) {
            throw new DatabusRuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new DatabusRuntimeException(e);
        }
        try {
            if (proposedHead > this._tail.getPosition()) {
                throw new DatabusRuntimeException("moveHead assert failure: newHead > tail: newHead:" + proposedHead + " " + this.toString());
            }
            if (this._tail.bufferGenId() - this._bufferPositionParser.bufferGenId(proposedHead) > 1L) {
                throw new DatabusRuntimeException("moveHead assert failure: gen mismatch: newHead:" + proposedHead + " " + this.toString());
            }
            this.setPrevScn(this.getMinScn());
            this._head.setPosition(proposedHead);
            if (this._head.equals(this._tail)) {
                this._empty = true;
                newScn = -1L;
            }
            if (null != this._scnIndex) {
                this._scnIndex.moveHead(this._head.getPosition(), newScn);
            }
            this.updateFirstEventMetadata();
            this.adjustByteBufferLimit(oldHeadPos);
            if (logDebugEnabled) {
                this._log.debug((Object)("moved head to " + this._head.toString() + "; scn=" + newScn));
            }
            this._notFull.signalAll();
        }
        finally {
            this.releaseWriteRangeLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFirstEventMetadata() {
        if (!this._queueLock.isHeldByCurrentThread()) {
            throw new RuntimeException("Queue lock not held when updating minScn");
        }
        boolean found = false;
        BaseEventIterator it = null;
        try {
            it = this.acquireLockFreeInternalIterator(this._head.getPosition(), this._tail.getPosition(), "updateFirstEventMetadata");
            while (it.hasNext()) {
                DbusEventInternalWritable e = it.next();
                if (e.isControlMessage()) continue;
                this._minScn = e.sequence();
                this._timestampOfFirstEvent = e.timestampInNanos() / 1000000L;
                found = true;
                break;
            }
            if (!found) {
                this._minScn = -1L;
                this._timestampOfFirstEvent = 0L;
            }
        }
        finally {
            if (null != it) {
                it.close();
            }
        }
    }

    protected void moveCurrentWritePosition(long newWritePos) {
        boolean resetLimit;
        if (this._currentWritePosition.getPosition() >= newWritePos) {
            throw new DatabusRuntimeException("moveCurrentWritePosition: assert regression:  _currentWritePosition:" + this._currentWritePosition + "; newWritePos:" + this._bufferPositionParser.toString(newWritePos, this._buffers));
        }
        if (this.overwritesHead(this._currentWritePosition.getPosition(), newWritePos)) {
            throw new DatabusRuntimeException("moveCurrentWritePosition: overwritesHead assert:" + this);
        }
        int curWriteIdx = this._currentWritePosition.bufferIndex();
        int curWriteOfs = this._currentWritePosition.bufferOffset();
        long curWriteGenid = this._currentWritePosition.bufferGenId();
        int newWriteIdx = this._bufferPositionParser.bufferIndex(newWritePos);
        int newWriteOfs = this._bufferPositionParser.bufferOffset(newWritePos);
        long newWriteGenid = this._bufferPositionParser.bufferGenId(newWritePos);
        if (newWriteIdx != curWriteIdx && (curWriteIdx + 1) % this._buffers.length != newWriteIdx) {
            throw new DatabusRuntimeException("buffer skip: _currentWritePosition:" + this._currentWritePosition + "; newWritePos:" + this._bufferPositionParser.toString(newWritePos, this._buffers));
        }
        if (newWriteGenid - curWriteGenid > 1L) {
            throw new DatabusRuntimeException("generation skip: _currentWritePosition:" + this._currentWritePosition + "; newWritePos:" + this._bufferPositionParser.toString(newWritePos, this._buffers) + "; this=" + this);
        }
        if (newWriteGenid - this._head.bufferGenId() > 1L) {
            throw new DatabusRuntimeException("new write position too far ahead: " + this._bufferPositionParser.toString(newWritePos, this._buffers) + "; this=" + this);
        }
        boolean bl = resetLimit = newWriteIdx != curWriteIdx || newWriteOfs < curWriteOfs;
        if (resetLimit) {
            this._buffers[curWriteIdx].limit(curWriteOfs);
        }
        this._currentWritePosition.setPosition(newWritePos);
        assert (this.assertBuffersLimits());
    }

    boolean assertBuffersLimits() {
        boolean success;
        boolean bl = success = this._tail.getPosition() <= this._currentWritePosition.getPosition();
        if (!success) {
            this._log.error((Object)("tail:" + this._tail + "> _currentWritePosition:" + this._currentWritePosition));
            return false;
        }
        int headIdx = this._head.bufferIndex();
        int writeIdx = this._currentWritePosition.bufferIndex();
        int zone = this._head.getPosition() == this._currentWritePosition.getPosition() ? 2 : 1;
        for (int i = 0; i < this._buffers.length; ++i) {
            int bufIdx = (headIdx + i) % this._buffers.length;
            if (1 == zone && bufIdx == writeIdx && (bufIdx != headIdx || this._head.bufferOffset() < this._currentWritePosition.bufferOffset())) {
                zone = 2;
            }
            if (2 != zone || this._buffers[bufIdx].limit() == this._buffers[bufIdx].capacity() || this._head.bufferOffset() == this._buffers[bufIdx].limit()) continue;
            success = false;
            this._log.error((Object)("assertBuffersLimits failure: buf[" + bufIdx + "]=" + this._buffers[bufIdx] + "; head:" + this._head + "; _currentWritePosition:" + this._currentWritePosition + "; _tail:" + this._tail));
        }
        return success;
    }

    public String toString() {
        return "DbusEventBuffer [,_rwLockProvider=" + this._rwLockProvider + ", readLocked=" + this.readLocked + ",_scnIndex=" + this._scnIndex + ", _buffers=" + Arrays.toString(this._buffers) + ",_maxBufferSize=" + this._maxBufferSize + "," + this.bufPositionInfo() + ",_allocatedSize=" + this._allocatedSize + ", _internalListeners=" + this._internalListeners + ",_allocationPolicy=" + (Object)((Object)this._allocationPolicy) + ", _queueingPolicy=" + (Object)((Object)this._queueingPolicy) + ",_mmapSessionDirectory=" + this._mmapSessionDirectory + ",_busyIteratorPool.size=" + this._busyIteratorPool.size() + ", _eventState=" + (Object)((Object)this._eventState) + ",_eventStartIndex=" + this._eventStartIndex + ", _numEventsInWindow=" + this._numEventsInWindow + ",_lastWrittenSequence=" + this._lastWrittenSequence + ", _prevScn=" + this._prevScn + ",_bufferPositionParser=" + this._bufferPositionParser + "]";
    }

    public String bufPositionInfo() {
        return "_head=" + this._head + ",_tail=" + this._tail + ",_empty=" + this._empty + ",_currentWritePosition=" + this._currentWritePosition;
    }

    public String toShortString() {
        StringBuffer sb = new StringBuffer();
        sb.append("h=" + this._head);
        sb.append(";t=" + this._tail);
        sb.append(";cwp=" + this._currentWritePosition);
        return sb.toString();
    }

    public void waitForFreeSpaceUninterruptibly(long freeSpaceThreshold) {
        try {
            this.waitForFreeSpace(freeSpaceThreshold, false);
        }
        catch (InterruptedException ie) {
            LOG.error((Object)"This should not be seen");
        }
    }

    public void waitForFreeSpace(long freeSpaceThreshold) throws InterruptedException {
        this.waitForFreeSpace(freeSpaceThreshold, true);
    }

    private void waitForFreeSpace(long freeSpaceThreshold, boolean interruptCaller) throws InterruptedException {
        this._queueLock.lock();
        int blocked = 0;
        try {
            do {
                int freeReadSpace;
                if ((long)(freeReadSpace = this.getBufferFreeReadSpace()) >= freeSpaceThreshold) {
                    if (blocked > 1) {
                        LOG.info((Object)("we have enough space in the buffer in waitForFreeSpace(). freeSpace=" + freeReadSpace + ",threshold=" + freeSpaceThreshold + ",bl=" + blocked + ",bufPosInfo=" + this.bufPositionInfo()));
                    }
                    return;
                }
                if (blocked > 0) {
                    LOG.warn((Object)("waiting for free space in the buffer in waitForFreeSpace(). freeSpace=" + freeReadSpace + ",threshold=" + freeSpaceThreshold + ",bl=" + blocked + ",bufPosInfo=" + this.bufPositionInfo()));
                }
                ++blocked;
                try {
                    this._notFull.await(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ie) {
                    if (!interruptCaller) continue;
                    throw ie;
                }
            } while (!this.isClosed());
            throw new DatabusRuntimeException("Coming out of wait, and the buffer is closed");
        }
        finally {
            this._queueLock.unlock();
        }
    }

    public long getBufferFreeSpace() {
        long remaining = this.remaining();
        return remaining;
    }

    public int getBufferFreeReadSpace() {
        assert (this._eventState != WindowState.IN_READ);
        long remaining = this.remaining();
        return (int)Math.min(remaining, (long)this.getMaxReadBufferCapacity());
    }

    public int getMaxReadBufferCapacity() {
        return this._maxEventSize;
    }

    private long remaining() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Remaining query : head = " + this._head.toString() + " tail =" + this._tail.toString()));
        }
        if (this.empty()) {
            long space = 0L;
            for (ByteBuffer buf : this._buffers) {
                space += (long)buf.capacity();
            }
            return space;
        }
        if (this._head.getRealPosition() < this._tail.getRealPosition()) {
            int i;
            long space = 0L;
            for (i = 0; i < this._head.bufferIndex(); ++i) {
                space += (long)this._buffers[i].capacity();
            }
            space += (long)this._head.bufferOffset();
            space += (long)(this._buffers[this._tail.bufferIndex()].capacity() - this._tail.bufferOffset());
            for (i = this._tail.bufferIndex() + 1; i < this._buffers.length; ++i) {
                space += (long)this._buffers[i].capacity();
            }
            return space;
        }
        if (this._head.getRealPosition() > this._tail.getRealPosition()) {
            if (this._head.bufferIndex() == this._tail.bufferIndex()) {
                return this._head.getRealPosition() - this._tail.getRealPosition();
            }
            long space = this._buffers[this._tail.bufferIndex()].capacity() - this._tail.bufferOffset();
            space += (long)this._head.bufferOffset();
            for (int i = this._tail.bufferIndex() + 1; i < this._head.bufferIndex(); ++i) {
                space += (long)this._buffers[i].capacity();
            }
            return space;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackIterator(BaseEventIterator eventIterator) {
        Set<WeakReference<BaseEventIterator>> set = this._busyIteratorPool;
        synchronized (set) {
            this._busyIteratorPool.add(new WeakReference<BaseEventIterator>(eventIterator));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void untrackIterator(BaseEventIterator eventIterator) {
        Set<WeakReference<BaseEventIterator>> set = this._busyIteratorPool;
        synchronized (set) {
            Iterator<WeakReference<BaseEventIterator>> refIter = this._busyIteratorPool.iterator();
            while (refIter.hasNext()) {
                WeakReference<BaseEventIterator> curRef = refIter.next();
                BaseEventIterator iter = (BaseEventIterator)curRef.get();
                if (null == iter) {
                    refIter.remove();
                    continue;
                }
                if (!iter.equals(eventIterator)) continue;
                refIter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbusEventIterator acquireIterator(String iteratorName) {
        this._queueLock.lock();
        try {
            DbusEventIterator eventIterator;
            DbusEventIterator dbusEventIterator = eventIterator = new DbusEventIterator(this._head.getPosition(), this._tail.getPosition(), iteratorName);
            return dbusEventIterator;
        }
        finally {
            this._queueLock.unlock();
        }
    }

    protected InternalEventIterator acquireInternalIterator(long head, long tail, String iteratorName) {
        InternalEventIterator eventIterator = new InternalEventIterator(head, tail, iteratorName);
        return eventIterator;
    }

    protected BaseEventIterator acquireLockFreeInternalIterator(long head, long tail, String iteratorName) {
        BaseEventIterator eventIterator = new BaseEventIterator(head, tail, iteratorName);
        return eventIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DbusEventInternalWritable> iterator() {
        this._queueLock.lock();
        try {
            ManagedEventIterator eventIterator;
            ManagedEventIterator managedEventIterator = eventIterator = new ManagedEventIterator(this._head.getPosition(), this._tail.getPosition());
            return managedEventIterator;
        }
        finally {
            this._queueLock.unlock();
        }
    }

    public void releaseIterator(BaseEventIterator e) {
        e.close();
    }

    public void addInternalListener(InternalDatabusEventsListener listener) {
        if (!this._internalListeners.contains(listener)) {
            this._internalListeners.add(listener);
        }
    }

    public boolean removeInternalListener(InternalDatabusEventsListener listener) {
        return this._internalListeners.remove(listener);
    }

    long getHead() {
        return this._head.getPosition();
    }

    long getTail() {
        return this._tail.getPosition();
    }

    ByteBuffer[] getBuffer() {
        return this._buffers;
    }

    ScnIndex getScnIndex() {
        return this._scnIndex;
    }

    public BufferPositionParser getBufferPositionParser() {
        return this._bufferPositionParser;
    }

    void setHead(long offset) {
        this._head.setPosition(offset);
        this._scnIndex.moveHead(offset);
    }

    void setTail(long offset) {
        this._tail.setPosition(offset);
        this._currentWritePosition.setPosition(offset);
    }

    long deleteFirstWindow() {
        long proposedHead = this._scnIndex.getLargerOffset(this._head.getPosition());
        if (proposedHead > 0L) {
            this._head.setPosition(proposedHead);
            this._scnIndex.moveHead(proposedHead);
        }
        return proposedHead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recreateIndex() {
        DbusEventIterator itr = null;
        try {
            this._scnIndex.acquireWriteLock();
            this._scnIndex.clear();
            itr = this.acquireIterator("scnIndexRecreate");
            while (itr.hasNext()) {
                long eventPosition = itr.getCurrentPosition();
                DbusEventInternalWritable e = itr.next();
                this._scnIndex.onEvent(e, eventPosition, e.size());
            }
        }
        finally {
            this._scnIndex.releaseWriteLock();
            if (itr != null) {
                this.releaseIterator(itr);
            }
        }
    }

    public long getAllocatedSize() {
        return this._allocatedSize;
    }

    @Override
    public long lastWrittenScn() {
        return this._lastWrittenSequence;
    }

    @Override
    public void setStartSCN(long sinceSCN) {
        this.setPrevScn(sinceSCN);
    }

    void setEmpty(boolean val) {
        this._empty = val;
    }

    public long getTimestampOfLatestDataEvent() {
        return this._timestampOfLatestDataEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeBuffer(boolean persistBuffer) {
        this.acquireWriteLock();
        try {
            if (this._eventState != WindowState.ENDED && this._eventState != WindowState.INIT) {
                this.rollbackEvents();
            }
            this.setClosed();
        }
        catch (DatabusException e) {
            this._log.warn((Object)("for buffer " + this.toString()), (Throwable)e);
            return;
        }
        finally {
            this.releaseWriteLock();
        }
        if (this._internalListeners != null) {
            for (InternalDatabusEventsListener l : this._internalListeners) {
                try {
                    l.close();
                }
                catch (IOException ioe) {
                    this._log.warn((Object)("Couldn't close channel/file for listener=" + l), (Throwable)ioe);
                }
                catch (RuntimeException re) {
                    this._log.warn((Object)("Couldn't close channel/file for listener=" + l), (Throwable)re);
                }
            }
        }
        if (persistBuffer) {
            try {
                this.saveBufferMetaInfo(false);
            }
            catch (IOException e) {
                this._log.error((Object)("error saving meta info for buffer for partition: " + this.getPhysicalPartition() + ": " + e.getMessage()), (Throwable)e);
            }
            catch (RuntimeException e) {
                this._log.error((Object)("error saving meta info for buffer for partition: " + this.getPhysicalPartition() + ": " + e.getMessage()), (Throwable)e);
            }
        } else {
            this.cleanUpPersistedBuffers();
        }
    }

    public void removeMMapFiles() {
        if (this._allocationPolicy != AllocationPolicy.MMAPPED_MEMORY) {
            this._log.warn((Object)("Skipping removal of MMap files because allocation policy is " + (Object)((Object)this._allocationPolicy)));
            return;
        }
        File f = new File(this._mmapDirectory, this.metaFileName());
        if (f.exists()) {
            f.deleteOnExit();
        }
        if (this._mmapSessionDirectory != null && this._mmapSessionDirectory.exists()) {
            this._mmapSessionDirectory.deleteOnExit();
        }
    }

    private void flushMMappedBuffers() {
        this._log.info((Object)("flushing buffers to disk for partition: " + this._physicalPartition + "; allocation_policy=" + (Object)((Object)this._allocationPolicy)));
        if (this._allocationPolicy == AllocationPolicy.MMAPPED_MEMORY) {
            for (ByteBuffer buf : this._buffers) {
                if (!(buf instanceof MappedByteBuffer)) continue;
                ((MappedByteBuffer)buf).force();
            }
            this._scnIndex.flushMMappedBuffers();
            this._log.info((Object)("done flushing buffers to disk for partition: " + this._physicalPartition));
        }
    }

    public void cleanUpPersistedBuffers() {
        File metaFile;
        if (this._allocationPolicy != AllocationPolicy.MMAPPED_MEMORY) {
            this._log.info((Object)("Not cleaning up buffer mmap directory because allocation policy is " + (Object)((Object)this._allocationPolicy) + "; bufferPersistenceEnabled:" + this._bufferPersistenceEnabled));
            return;
        }
        this._log.warn((Object)("Removing mmap directory for buffer(" + this._physicalPartition + "): " + this._mmapSessionDirectory));
        if (!this._mmapSessionDirectory.exists() || !this._mmapSessionDirectory.isDirectory()) {
            this._log.warn((Object)("cannot cleanup _mmap=" + this._mmapSessionDirectory + " directory because it doesn't exist or is not a directory"));
            return;
        }
        try {
            FileUtils.cleanDirectory((File)this._mmapSessionDirectory);
        }
        catch (IOException e) {
            this._log.error((Object)("failed to cleanup buffer session directory " + this._mmapSessionDirectory));
        }
        if (!this._mmapSessionDirectory.delete()) {
            this._log.error((Object)("failed to delete buffer session directory " + this._mmapSessionDirectory));
        }
        if ((metaFile = new File(this._mmapDirectory, this.metaFileName())).exists()) {
            this._log.warn((Object)("Removing meta file " + metaFile));
            if (!metaFile.delete()) {
                this._log.error((Object)("failed to delete metafile " + metaFile));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBufferMetaInfo(boolean infoOnly) throws IOException {
        this.acquireWriteLock();
        try {
            this.flushMMappedBuffers();
            this._scnIndex.saveBufferMetaInfo();
            this.saveDataBufferMetaInfo(infoOnly);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void saveDataBufferMetaInfo(boolean infoOnly) throws IOException {
        if (this._allocationPolicy != AllocationPolicy.MMAPPED_MEMORY || !this._bufferPersistenceEnabled) {
            this._log.info((Object)("Not saving state metaInfoFile, because allocation policy is " + (Object)((Object)this._allocationPolicy) + "; bufferPersistenceEnabled:" + this._bufferPersistenceEnabled));
            return;
        }
        String fileName = this.metaFileName() + (infoOnly ? MMAP_META_INFO_SUFFIX : "");
        DbusEventBufferMetaInfo mi = new DbusEventBufferMetaInfo(new File(this._mmapDirectory, fileName));
        this._log.info((Object)("about to save DbusEventBuffer for PP " + this._physicalPartition + " state into " + mi.toString()));
        mi.setSessionId(this._sessionId);
        mi.setVal("ByteBufferNum", Integer.toString(this._buffers.length));
        StringBuilder bufferInfo = new StringBuilder("");
        for (ByteBuffer b : this._buffers) {
            DbusEventBufferMetaInfo.BufferInfo bi = new DbusEventBufferMetaInfo.BufferInfo(b.position(), b.limit(), b.capacity());
            bufferInfo.append(bi.toString());
            bufferInfo.append(" ");
        }
        mi.setVal("ByteBufferInfo", bufferInfo.toString());
        String currentWritePosition = Long.toString(this._currentWritePosition.getPosition());
        mi.setVal("currentWritePosition", currentWritePosition);
        mi.setVal("maxBufferSize", Integer.toString(this._maxBufferSize));
        String head = Long.toString(this._head.getPosition());
        mi.setVal("head", head);
        String tail = Long.toString(this._tail.getPosition());
        mi.setVal("tail", tail);
        String empty = Boolean.toString(this._empty);
        mi.setVal("empty", empty);
        mi.setVal("allocatedSize", Long.toString(this._allocatedSize));
        mi.setVal("eventStartIndex", Long.toString(this._eventStartIndex.getPosition()));
        mi.setVal("numEventsInWindow", Integer.toString(this._numEventsInWindow));
        mi.setVal("lastWrittenSequence", Long.toString(this._lastWrittenSequence));
        mi.setVal("seenEndOfPeriodScn", Long.toString(this._seenEndOfPeriodScn));
        mi.setVal("prevScn", Long.toString(this._prevScn));
        mi.setVal("timestampOfFirstEvent", Long.toString(this._timestampOfFirstEvent));
        mi.setVal("timestampOfLatestDataEvent", Long.toString(this._timestampOfLatestDataEvent));
        mi.setVal("eventState", this._eventState.toString());
        mi.saveAndClose();
    }

    public void initBuffersWithMetaInfo(DbusEventBufferMetaInfo mi) throws DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException {
        if (mi.isValid()) {
            this._head.setPosition(mi.getLong("head"));
            this._tail.setPosition(mi.getLong("tail"));
            this._currentWritePosition.setPosition(mi.getLong("currentWritePosition"));
            this._empty = mi.getBool("empty");
            this._eventStartIndex.setPosition(mi.getLong("eventStartIndex"));
            this._numEventsInWindow = mi.getInt("numEventsInWindow");
            this._eventState = WindowState.valueOf(mi.getVal("eventState"));
            this._lastWrittenSequence = mi.getLong("lastWrittenSequence");
            this._seenEndOfPeriodScn = mi.getLong("seenEndOfPeriodScn");
            this._prevScn = mi.getLong("prevScn");
            this._timestampOfFirstEvent = mi.getLong("timestampOfFirstEvent");
            this._timestampOfLatestDataEvent = mi.getLong("timestampOfLatestDataEvent");
        }
    }

    public long getSeenEndOfPeriodScn() {
        return this._seenEndOfPeriodScn;
    }

    public boolean isSCNRegress() {
        return this._scnRegress;
    }

    public Logger getLog() {
        return this._log;
    }

    public String hexdumpByteBufferContents(long pos, int length) {
        try {
            if (length < 0) {
                return "! invalid length: " + length;
            }
            int bufIdx = this._bufferPositionParser.bufferIndex(pos);
            if (bufIdx >= this._buffers.length) {
                return "! invalid buffer position: " + pos;
            }
            int bufOfs = this._bufferPositionParser.bufferOffset(pos);
            return StringUtils.hexdumpByteBufferContents(this._buffers[bufIdx], bufOfs, length);
        }
        catch (RuntimeException e) {
            return "! unable to generate dump for position " + pos + ": " + e;
        }
    }

    public boolean injectEvent(DbusEventInternalReadable event) throws InvalidEventException {
        ByteBuffer eventBuf = event.getRawBytes();
        byte[] cpEventBytes = null;
        if (eventBuf.hasArray()) {
            cpEventBytes = eventBuf.array();
        } else {
            cpEventBytes = new byte[event.getRawBytes().limit()];
            eventBuf.get(cpEventBytes);
        }
        ByteArrayInputStream cpIs = new ByteArrayInputStream(cpEventBytes);
        ReadableByteChannel cpRbc = Channels.newChannel(cpIs);
        int ecnt = this.readEvents(cpRbc);
        return ecnt > 0;
    }

    public synchronized byte getEventSerializationVersion() {
        return this._eventSerializationVersion;
    }

    protected synchronized void setEventSerializationVersion(byte eventSerializationVersion) {
        this._eventSerializationVersion = eventSerializationVersion;
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        public static final int DEFAULT_MAX_EVENT_SIZE = -1;
        public static final double DEFAULT_DEFAULT_MEMUSAGE = 0.75;
        public static final double DEFAULT_EVENT_BUFFER_MAX_SIZE_QUOTA = 0.8;
        public static final double DEFAULT_EVENT_BUFFER_READ_BUFFER_QUOTA = 0.1;
        public static final QueuePolicy DEFAULT_QUEUE_POLICY = QueuePolicy.OVERWRITE_ON_WRITE;
        private static int FIVE_HUNDRED_MEGABYTES_IN_BYTES;
        public static final int DEFAULT_INDIVIDUAL_BUFFER_SIZE;
        public static final String DEFAULT_MMAP_DIRECTORY = "mmappedBuffer";
        private static final long BUFFER_REMOVE_WAIT_PERIOD = 86400L;
        private static final int DEFAULT_AVERAGE_EVENT_SIZE = 20480;
        protected long _maxSize;
        protected int _maxIndividualBufferSize;
        protected int _readBufferSize;
        private int _maxEventSize;
        private int _averageEventSize = 20480;
        protected int _scnIndexSize;
        protected String _allocationPolicy;
        protected String _mmapDirectory;
        protected double _defaultMemUsage;
        protected String _queuePolicy;
        protected DbusEventBuffer _existingBuffer;
        private RelayEventTraceOption.RelayEventTraceOptionBuilder _trace;
        private String _assertLevel = AssertLevel.NONE.toString();
        private long _bufferRemoveWaitPeriodSec;
        private boolean _restoreMMappedBuffers = false;
        private boolean _restoreMMappedBuffersValidateEvents = false;
        private boolean _enableScnIndex = true;

        public Config() {
            this._defaultMemUsage = 0.75;
            this.deriveSizesFromMemPct();
            this._allocationPolicy = this.getMaxSize() > 10000L ? "DIRECT_MEMORY" : "HEAP_MEMORY";
            this._mmapDirectory = DEFAULT_MMAP_DIRECTORY;
            this._queuePolicy = DEFAULT_QUEUE_POLICY.toString();
            this._trace = new RelayEventTraceOption.RelayEventTraceOptionBuilder();
            this._bufferRemoveWaitPeriodSec = 86400L;
            this._restoreMMappedBuffers = false;
            this._enableScnIndex = true;
            this._maxEventSize = -1;
        }

        public Config(Config other) {
            this._maxSize = other._maxSize;
            this._maxIndividualBufferSize = other._maxIndividualBufferSize;
            this._readBufferSize = other._readBufferSize;
            this._maxEventSize = other._maxEventSize;
            this._averageEventSize = other._averageEventSize;
            this._scnIndexSize = other._scnIndexSize;
            this._allocationPolicy = other._allocationPolicy;
            this._mmapDirectory = other._mmapDirectory;
            this._defaultMemUsage = other._defaultMemUsage;
            this._queuePolicy = other._queuePolicy;
            this._existingBuffer = other._existingBuffer;
            this._trace = new RelayEventTraceOption.RelayEventTraceOptionBuilder(other._trace);
            this._bufferRemoveWaitPeriodSec = other._bufferRemoveWaitPeriodSec;
            this._restoreMMappedBuffers = other._restoreMMappedBuffers;
            this._enableScnIndex = other._enableScnIndex;
        }

        private void deriveSizesFromMemPct() {
            long maxMem = Runtime.getRuntime().maxMemory();
            long memForEventBuffer = Math.min((long)(this._defaultMemUsage * (double)maxMem), 0xA00000L);
            this._maxSize = (long)(0.8 * (double)memForEventBuffer);
            this._maxIndividualBufferSize = DEFAULT_INDIVIDUAL_BUFFER_SIZE;
            this._readBufferSize = (int)(0.1 * (double)memForEventBuffer);
            this._scnIndexSize = (int)(Math.abs(0.09999999999999995) * (double)memForEventBuffer);
        }

        public boolean isEnableScnIndex() {
            return this._enableScnIndex;
        }

        public void setEnableScnIndex(boolean enableScnIndex) {
            this._enableScnIndex = enableScnIndex;
        }

        public void setRestoreMMappedBuffersValidateEvents(boolean restoreMMappedBuffersValidateEventsValidateEvents) {
            this._restoreMMappedBuffersValidateEvents = restoreMMappedBuffersValidateEventsValidateEvents;
        }

        public boolean getRestoreMMappedBuffersValidateEvents() {
            return this._restoreMMappedBuffersValidateEvents;
        }

        public void setRestoreMMappedBuffers(boolean restoreMMappedBuffers) {
            this._restoreMMappedBuffers = restoreMMappedBuffers;
        }

        public boolean getRestoreMMappedBuffers() {
            return this._restoreMMappedBuffers;
        }

        public void setBufferRemoveWaitPeriodSec(long waitPeriod) {
            this._bufferRemoveWaitPeriodSec = waitPeriod;
        }

        public long getBufferRemoveWaitPeriodSec() {
            return this._bufferRemoveWaitPeriodSec;
        }

        public void setMaxSize(long eventBufferMaxSize) {
            this._maxSize = eventBufferMaxSize;
        }

        public void setMaxIndividualBufferSize(int individualBufferMaxSize) {
            this._maxIndividualBufferSize = individualBufferMaxSize;
        }

        @Deprecated
        public void setReadBufferSize(int eventBufferReadBufferSize) {
            LOG.warn((Object)("Unable to set readBufferSize to " + eventBufferReadBufferSize + " as this has been deprecated! Use averageEventSize instead!"));
        }

        public void setAverageEventSize(int averageEventSize) {
            this._averageEventSize = averageEventSize;
        }

        public void setScnIndexSize(int eventBufferScnIndexSize) {
            LOG.info((Object)("setting scn index size to " + eventBufferScnIndexSize));
            this._scnIndexSize = eventBufferScnIndexSize;
        }

        public void setDefaultMemUsage(double eventBufferDefaultMemUsage) {
            this._defaultMemUsage = eventBufferDefaultMemUsage;
            this.deriveSizesFromMemPct();
        }

        public void setAllocationPolicy(String allocationPolicy) {
            LOG.info((Object)("Setting allocation policy to " + allocationPolicy));
            this._allocationPolicy = allocationPolicy;
        }

        public String getMmapDirectory() {
            return this._mmapDirectory;
        }

        public void setMmapDirectory(String mmapDirectory) {
            this._mmapDirectory = mmapDirectory;
        }

        public void setQueuePolicy(String queuePolicy) {
            this._queuePolicy = queuePolicy;
        }

        public void setExistingBuffer(DbusEventBuffer existingBuffer) {
            this._existingBuffer = existingBuffer;
        }

        public long getMaxSize() {
            return this._maxSize;
        }

        public int getMaxIndividualBufferSize() {
            return this._maxIndividualBufferSize;
        }

        public int getReadBufferSize() {
            return this._readBufferSize;
        }

        public int getScnIndexSize() {
            return this._scnIndexSize;
        }

        public String getAllocationPolicy() {
            return this._allocationPolicy;
        }

        public double getDefaultMemUsage() {
            return this._defaultMemUsage;
        }

        public String getQueuePolicy() {
            return this._queuePolicy;
        }

        public DbusEventBufferAppendable getExistingBuffer() {
            return this._existingBuffer;
        }

        @Override
        public StaticConfig build() throws InvalidConfigException {
            AllocationPolicy allocPolicy;
            LOG.info((Object)("Event buffer max size: " + this._maxSize));
            if (this._readBufferSize > this._averageEventSize) {
                LOG.warn((Object)("Ignoring staging event buffer size because it is deprecated: req size= " + this._readBufferSize + " " + "is larger than " + this._averageEventSize));
            }
            this._readBufferSize = this._averageEventSize;
            LOG.info((Object)("Staging event buffer size: " + this._readBufferSize));
            if (this._enableScnIndex) {
                LOG.info((Object)("Event buffer scn index size: " + this._scnIndexSize));
            }
            LOG.info((Object)("Event buffer allocation policy: " + this._allocationPolicy.toString()));
            LOG.info((Object)("Using queue policy: " + this._queuePolicy.toString()));
            try {
                allocPolicy = AllocationPolicy.valueOf(this._allocationPolicy);
            }
            catch (Exception e) {
                throw new InvalidConfigException("Invalid Config Value for allocationPolicy: " + this._allocationPolicy);
            }
            File mmapDirectory = new File(this._mmapDirectory);
            if (allocPolicy.equals((Object)AllocationPolicy.MMAPPED_MEMORY) && !mmapDirectory.exists()) {
                if (!mmapDirectory.mkdirs()) {
                    throw new InvalidConfigException("Invalid Config Value: Cannot create mmapDirectory: " + this._mmapDirectory);
                }
                if (mmapDirectory.exists() && !mmapDirectory.canWrite()) {
                    throw new InvalidConfigException("Invalid Config Value: Cannot write to mmapDirectory: " + this._mmapDirectory);
                }
            }
            QueuePolicy queuePolicy = null;
            try {
                queuePolicy = QueuePolicy.valueOf(this._queuePolicy);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigException("Invalid queueing policy:" + this._queuePolicy);
            }
            AssertLevel assertLevel = null;
            try {
                assertLevel = AssertLevel.valueOf(this._assertLevel);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigException("Invalid assert level:" + this._assertLevel);
            }
            int maxMaxEventSize = this.maxMaxEventSize();
            int realMaxEventsSize = -1 == this._maxEventSize ? maxMaxEventSize : Math.min(this._maxEventSize, maxMaxEventSize);
            int initReadBufferSize = Math.min(this._readBufferSize, realMaxEventsSize);
            LOG.info((Object)("Initial staging event buffer size: " + initReadBufferSize));
            return new StaticConfig(this._maxSize, this._maxIndividualBufferSize, initReadBufferSize, realMaxEventsSize, this._scnIndexSize, allocPolicy, mmapDirectory, this._defaultMemUsage, queuePolicy, this._existingBuffer, this._trace.build(), assertLevel, this._bufferRemoveWaitPeriodSec, this._restoreMMappedBuffers, this._restoreMMappedBuffersValidateEvents, this._enableScnIndex);
        }

        public RelayEventTraceOption.RelayEventTraceOptionBuilder getTrace() {
            return this._trace;
        }

        public void setTrace(RelayEventTraceOption.RelayEventTraceOptionBuilder trace) {
            this._trace = trace;
        }

        public String getAssertLevel() {
            return this._assertLevel;
        }

        public void setAssertLevel(String assertLevel) {
            this._assertLevel = assertLevel;
        }

        public int getMaxEventSize() {
            return this._maxEventSize;
        }

        public void setMaxEventSize(int maxEventSize) {
            this._maxEventSize = maxEventSize > 0 ? maxEventSize : -1;
        }

        public int getAverageEventSize() {
            return this._averageEventSize;
        }

        public int maxMaxEventSize() {
            int maxMaxEventSize = (int)Math.min(this._maxSize, (long)this._maxIndividualBufferSize);
            return maxMaxEventSize - 1;
        }

        static {
            DEFAULT_INDIVIDUAL_BUFFER_SIZE = FIVE_HUNDRED_MEGABYTES_IN_BYTES = 512000000;
        }
    }

    public static class StaticConfig {
        private final long _maxSize;
        private final int _maxIndividualBufferSize;
        private final int _readBufferSize;
        private final int _maxEventSize;
        private final int _scnIndexSize;
        private final AllocationPolicy _allocationPolicy;
        private final File _mmapDirectory;
        private final double _defaultMemUsage;
        private final QueuePolicy _queuePolicy;
        private final DbusEventBuffer _existingBuffer;
        private final RelayEventTraceOption _trace;
        private final AssertLevel _assertLevel;
        private final long _bufferRemoveWaitPeriod;
        private final boolean _restoreMMappedBuffers;
        private final boolean _restoreMMappedBuffersValidateEvents;
        private final boolean _enableScnIndex;

        public StaticConfig(long maxSize, int maxIndividualBufferSize, int readBufferSize, int maxEventSize, int scnIndexSize, AllocationPolicy allocationPolicy, File mmapDirectory, double defaultMemUsage, QueuePolicy queuePolicy, DbusEventBuffer existingBuffer, RelayEventTraceOption trace, AssertLevel assertLevel, long bufferRemoveWaitPeriod, boolean restoreMMappedBuffers, boolean restoreMMappedBuffersValidateEvents, boolean enableScnIndex) {
            this._maxSize = maxSize;
            this._maxIndividualBufferSize = maxIndividualBufferSize;
            this._readBufferSize = readBufferSize;
            this._maxEventSize = maxEventSize;
            this._scnIndexSize = scnIndexSize;
            this._allocationPolicy = allocationPolicy;
            this._mmapDirectory = mmapDirectory;
            this._defaultMemUsage = defaultMemUsage;
            this._queuePolicy = queuePolicy;
            this._existingBuffer = existingBuffer;
            this._trace = trace;
            this._assertLevel = assertLevel;
            this._bufferRemoveWaitPeriod = bufferRemoveWaitPeriod;
            this._restoreMMappedBuffers = restoreMMappedBuffers;
            this._restoreMMappedBuffersValidateEvents = restoreMMappedBuffersValidateEvents;
            this._enableScnIndex = enableScnIndex;
        }

        public boolean isEnableScnIndex() {
            return this._enableScnIndex;
        }

        public boolean getRestoreMMappedBuffersValidateEvents() {
            return this._restoreMMappedBuffersValidateEvents;
        }

        public boolean getRestoreMMappedBuffers() {
            return this._restoreMMappedBuffers;
        }

        public long getBufferRemoveWaitPeriod() {
            return this._bufferRemoveWaitPeriod;
        }

        public long getMaxSize() {
            return this._maxSize;
        }

        public int getMaxIndividualBufferSize() {
            return this._maxIndividualBufferSize;
        }

        public int getReadBufferSize() {
            return this._readBufferSize;
        }

        public int getScnIndexSize() {
            return this._scnIndexSize;
        }

        public AllocationPolicy getAllocationPolicy() {
            return this._allocationPolicy;
        }

        public File getMmapDirectory() {
            return this._mmapDirectory;
        }

        public double getDefaultMemUsage() {
            return this._defaultMemUsage;
        }

        public QueuePolicy getQueuePolicy() {
            return this._queuePolicy;
        }

        public DbusEventBuffer getExistingBuffer() {
            return this._existingBuffer;
        }

        public RelayEventTraceOption getTrace() {
            return this._trace;
        }

        public DbusEventBuffer getOrCreateEventBuffer(DbusEventFactory eventFactory) {
            DbusEventBuffer result = this.getExistingBuffer();
            if (null == result) {
                result = new DbusEventBuffer(this, null, eventFactory);
            }
            return result;
        }

        public DbusEventBuffer getOrCreateEventBufferWithPhyPartition(PhysicalPartition pp, DbusEventFactory eventFactory) {
            DbusEventBuffer result = this.getExistingBuffer();
            if (null == result) {
                result = new DbusEventBuffer(this, pp, eventFactory);
            }
            return result;
        }

        public AssertLevel getAssertLevel() {
            return this._assertLevel;
        }

        public int getMaxEventSize() {
            return this._maxEventSize;
        }
    }

    class ReadEventsWritePosition {
        int _numBytesWritten;
        BaseEventIterator _writeIter;
        DbusEventInternalWritable _lastEvent;
        ByteBuffer _curBuf;

        public ReadEventsWritePosition() {
            this._writeIter = DbusEventBuffer.this.acquireLockFreeInternalIterator(DbusEventBuffer.this._tail.getPosition(), DbusEventBuffer.this._tail.getPosition(), "ReadEventsWritePosition");
        }

        public DbusEventInternalWritable next() {
            if (null != this._lastEvent) {
                this._numBytesWritten += this._lastEvent.size();
            }
            this._lastEvent = this._writeIter.next();
            return this._lastEvent;
        }

        public long getCurPos() {
            return this._writeIter.getCurrentPosition();
        }

        public void startNewIteration() {
            this._lastEvent = null;
            int writeBufIndex = DbusEventBuffer.this._bufferPositionParser.bufferIndex(this.getCurPos());
            this._curBuf = DbusEventBuffer.this._buffers[writeBufIndex];
            this._numBytesWritten = 0;
            this.assertPositions();
        }

        public int getNumBytesWritten() {
            return this._numBytesWritten;
        }

        public void determineWriteEnd(ReadEventsReadPosition readPos) {
            int increment = readPos.bytesProcessed();
            this.setNextFreePos(DbusEventBuffer.this._bufferPositionParser.incrementOffset(this.getCurPos(), increment, DbusEventBuffer.this._buffers));
            if (DbusEventBuffer.this._log.isDebugEnabled()) {
                DbusEventBuffer.this._log.debug((Object)("readEvents: _empty :" + DbusEventBuffer.this._empty + ", " + this + ", Head:" + DbusEventBuffer.this._head + ", Tail:" + DbusEventBuffer.this._tail));
            }
            this.assertPositions();
        }

        public String toString() {
            return "writePos:{iter:" + this._writeIter + ", numBytesWritten:" + this._numBytesWritten + "}";
        }

        private void assertPositions() {
            int posIdx = DbusEventBuffer.this._bufferPositionParser.bufferIndex(this.getCurPos());
            int nextFreeIdx = DbusEventBuffer.this._bufferPositionParser.bufferIndex(this.getNextFreePos());
            assert (posIdx == nextFreeIdx && this.getCurOfs() <= this.getNextFreeOfs() || (posIdx + 1) % DbusEventBuffer.this._buffers.length == nextFreeIdx && this.getNextFreeOfs() == 0) : this.toString();
        }

        private void setNextFreePos(long nextFreePos) {
            if (nextFreePos > DbusEventBuffer.this._currentWritePosition.getPosition()) {
                DbusEventBuffer.this.moveCurrentWritePosition(nextFreePos);
            }
            this._writeIter.reset(this._writeIter.getCurrentPosition(), nextFreePos, this._writeIter.getIdentifier());
        }

        public long getNextFreePos() {
            return this._writeIter._iteratorTail.getPosition();
        }

        public BufferPosition getNextFree() {
            return this._writeIter._iteratorTail;
        }

        public int getCurOfs() {
            return DbusEventBuffer.this._bufferPositionParser.bufferOffset(this.getCurPos());
        }

        public int getNextFreeOfs() {
            return DbusEventBuffer.this._bufferPositionParser.bufferOffset(this.getNextFreePos());
        }

        public void moveToNextBuffer() {
            long nextWritePos = DbusEventBuffer.this._bufferPositionParser.incrementIndex(DbusEventBuffer.this._currentWritePosition.getPosition(), DbusEventBuffer.this._buffers);
            this.setNextFreePos(nextWritePos);
            assert (0 == this.getNextFreeOfs()) : this.toString();
        }

        public ByteBuffer getCurBuf() {
            return this._curBuf;
        }

        public void close() {
            DbusEventBuffer.this.releaseIterator(this._writeIter);
        }
    }

    class ReadEventsReadPosition {
        int _start;
        int _pos;
        int _nextPos;
        int _end;
        int _skippedEvents;
        int _readEvents;
        long _lastProcessedSeq;
        ReadEventsScanStatus _scanStatus;
        DbusEventInternalWritable _curEvent;
        long _lastSeenStgWin;
        boolean _resetScnRegress;
        private ByteBuffer _readBuffer;

        public ReadEventsReadPosition() {
            this._lastSeenStgWin = DbusEventBuffer.this._seenEndOfPeriodScn;
            this._readBuffer = ByteBuffer.allocate(DbusEventBuffer.this._initReadBufferSize).order(DbusEventBuffer.this._eventFactory.getByteOrder());
        }

        public void startIteration() {
            this._start = 0;
            this._pos = 0;
            this._skippedEvents = 0;
            this._end = this._readBuffer.position();
            this._lastProcessedSeq = DbusEventBuffer.this._lastWrittenSequence;
            this._curEvent = this._curEvent == null ? DbusEventBuffer.this._eventFactory.createWritableDbusEventFromBuffer(this._readBuffer, this._pos) : (DbusEventInternalWritable)this._curEvent.reset(this._readBuffer, this._pos);
        }

        public int getReadStart() {
            return this._start;
        }

        public int getPosition() {
            return this._pos;
        }

        public int getEnd() {
            return this._end;
        }

        public long getSeq() {
            assert (null != this._curEvent);
            assert (this.isValidEvent()) : null != this._scanStatus ? this._scanStatus.toString() : "null";
            return this._curEvent.sequence();
        }

        private boolean isValidEvent() {
            return this._scanStatus == ReadEventsScanStatus.OK || this._scanStatus == ReadEventsScanStatus.MISSING_EOP || this._scanStatus == ReadEventsScanStatus.SCN_REGRESSION;
        }

        public long getLastProcessedSeq() {
            return this._lastProcessedSeq;
        }

        public int getNumReadEvents() {
            return this._readEvents;
        }

        public int getSkippedEvents() {
            return this._skippedEvents;
        }

        public ReadEventsScanStatus getEventScanStatus() {
            return this._scanStatus;
        }

        public boolean hasNext() {
            return this._pos < this._end;
        }

        public boolean hasEventWithOldScn() {
            long seq = this.getSeq();
            boolean res = seq > 0L && this._lastProcessedSeq > 0L && (seq < this._lastProcessedSeq || seq == this._lastSeenStgWin);
            return res;
        }

        public boolean hasMissingEOP() {
            long seq = this.getSeq();
            boolean missingEopMarker = this._lastProcessedSeq > 0L && seq > this._lastProcessedSeq && this._lastSeenStgWin < this._lastProcessedSeq;
            return missingEopMarker;
        }

        public int bytesProcessed() {
            return this._pos - this._start;
        }

        public int bytesRemaining() {
            return this._end - this._pos;
        }

        public String toString() {
            return "readPos: {start:" + this._start + ", end:" + this._end + ", pos:" + this._pos + ", read:" + this._readEvents + ", skipped:" + this._skippedEvents + ", lastSeenStgWin:" + this._lastSeenStgWin + ", seq:" + (null == this._curEvent || this.bytesProcessed() == 0 ? -1L : this.getSeq()) + ", lastProcessedSeq: " + this._lastProcessedSeq + "}";
        }

        private void checkForReadEventsScnRegress() {
            if (this._curEvent.isSCNRegressMessage()) {
                DbusEventBuffer.this._log.info((Object)("Seeing SCNRegress Message :" + this._curEvent));
                DbusEventBuffer.this._scnRegress = true;
            } else if (DbusEventBuffer.this._scnRegress && this._curEvent.isEndOfPeriodMarker()) {
                DbusEventBuffer.this._log.info((Object)("Resetting SCNRegress as EOP is seen : EOP :" + this._curEvent));
                this._resetScnRegress = true;
            }
        }

        public ReadEventsScanStatus startEventProcessing() {
            this._start = this._pos;
            this._resetScnRegress = false;
            try {
                this._curEvent = (DbusEventInternalWritable)this._curEvent.reset(this._readBuffer, this._pos);
                DbusEventInternalReadable.EventScanStatus eventScanStatus = this._curEvent.scanEvent(false);
                switch (eventScanStatus) {
                    case PARTIAL: {
                        this._scanStatus = ReadEventsScanStatus.PARTIAL_EVENT;
                        break;
                    }
                    case ERR: {
                        this._scanStatus = ReadEventsScanStatus.INVALID_EVENT;
                        break;
                    }
                    case OK: {
                        this._nextPos = this._pos + this._curEvent.size();
                        this.checkForReadEventsScnRegress();
                        if (DbusEventBuffer.this._log.isDebugEnabled()) {
                            long eventSrcId = this._curEvent.getSourceId();
                            LOG.debug((Object)("scan event:position:" + this.getPosition() + ";size:" + this._curEvent.size() + ";seq:" + this._curEvent.sequence() + ";evSrcId:" + eventSrcId));
                        }
                        this._scanStatus = ReadEventsScanStatus.OK;
                        if (DbusEventBuffer.this._dropOldEvents && !DbusEventBuffer.this._scnRegress && this.hasEventWithOldScn()) {
                            this._scanStatus = ReadEventsScanStatus.SCN_REGRESSION;
                            break;
                        }
                        if (DbusEventBuffer.this._dropOldEvents && !DbusEventBuffer.this._scnRegress && this.hasMissingEOP()) {
                            this._scanStatus = ReadEventsScanStatus.MISSING_EOP;
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown event scan status: " + (Object)((Object)eventScanStatus));
                    }
                }
            }
            catch (UnsupportedDbusEventVersionRuntimeException e) {
                DbusEventBuffer.this._log.fatal((Object)"Unknown dbus event version:", (Throwable)e);
                this._scanStatus = ReadEventsScanStatus.INVALID_EVENT;
            }
            return this._scanStatus;
        }

        public void eventAccepted() {
            if (!this.isValidEvent()) {
                return;
            }
            if (this._resetScnRegress) {
                DbusEventBuffer.this._scnRegress = false;
            }
            this._pos = this._nextPos;
            long seq = this.getSeq();
            if (seq > this._lastProcessedSeq) {
                this._lastProcessedSeq = seq;
            }
            if (this._curEvent.isEndOfPeriodMarker() && this._lastProcessedSeq > this._lastSeenStgWin) {
                this._lastSeenStgWin = this._lastProcessedSeq;
            }
            if (DbusEventBuffer.this._log.isDebugEnabled()) {
                DbusEventBuffer.this._log.debug((Object)("stg events scanned: " + this));
            }
        }

        public void eventWritten() {
            this._start += this._curEvent.size();
            ++this._readEvents;
        }

        public void eventSkipped() {
            if (DbusEventBuffer.this._log.isDebugEnabled()) {
                LOG.debug((Object)("skipping event " + this.getSkippedEvents() + " event.seq:" + this.getSeq() + " _lastWrittenSequence:" + DbusEventBuffer.this._lastWrittenSequence + this.toString()));
            }
            this._pos = this._nextPos;
            ++this._skippedEvents;
            ++this._readEvents;
        }

        public DbusEvent getCurEvent() {
            return this._curEvent;
        }

        public long getLastSeenStgWin() {
            return this._lastSeenStgWin;
        }

        public ByteBuffer getReadBuffer() {
            return this._readBuffer;
        }

        public ByteBuffer growReadBuffer(int newSize) {
            assert (0 == this._readBuffer.position()) : "readBuffer position not 0; data before it will be lost!";
            if (newSize <= this._readBuffer.capacity()) {
                throw new DatabusRuntimeException("invalid new event staging buffer size: " + newSize + "; current buffer: " + this._readBuffer);
            }
            if (DbusEventBuffer.this._log.isDebugEnabled()) {
                DbusEventBuffer.this._log.debug((Object)("growing event staging buffer from " + this._readBuffer.capacity() + " to " + newSize));
            }
            ByteBuffer newBuf = ByteBuffer.allocate(newSize).order(DbusEventBuffer.this._eventFactory.getByteOrder());
            newBuf.put(this._readBuffer);
            this._curEvent = null;
            this._readBuffer = newBuf;
            return newBuf;
        }
    }

    static enum ReadEventsScanStatus {
        OK,
        PARTIAL_EVENT,
        INVALID_EVENT,
        SCN_REGRESSION,
        MISSING_EOP;

    }

    static enum StreamingMode {
        WINDOW_AT_TIME,
        CONTINUOUS;

    }

    private static enum WindowState {
        INIT,
        STARTED,
        EVENTS_ADDED,
        IN_READ,
        ENDED;

    }

    public class DbusEventIterator
    extends InternalEventIterator {
        protected DbusEventIterator(long head, long tail) {
            this(head, tail, "DbusEventIterator" + ITERATORS_COUNTER.getAndIncrement());
        }

        protected DbusEventIterator(long head, long tail, String iteratorName) {
            super(head, tail, iteratorName);
        }

        public DbusEventIterator copy(DbusEventIterator destinationIterator, String iteratorName) {
            if (null == destinationIterator) {
                destinationIterator = new DbusEventIterator(this._currentPosition.getPosition(), this._iteratorTail.getPosition(), iteratorName);
            } else {
                super.copy(destinationIterator, iteratorName);
            }
            return destinationIterator;
        }

        public void trim() {
            this._iteratorTail.copy(this._currentPosition);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyBufferEndpoints() throws InterruptedException, TimeoutException {
            boolean debugEnabled = DbusEventBuffer.this._log.isDebugEnabled();
            DbusEventBuffer.this._queueLock.lock();
            try {
                long oldPos = this._currentPosition.getPosition();
                long oldTail = this._iteratorTail.getPosition();
                try {
                    this._iteratorTail.copy(DbusEventBuffer.this._tail);
                    if (DbusEventBuffer.this._head.getPosition() < 0L) {
                        this._currentPosition.setPosition(-1L);
                    } else if (this._currentPosition.getPosition() < 0L) {
                        this._currentPosition.copy(DbusEventBuffer.this._head);
                    }
                    if (DbusEventBuffer.this.empty() || this._currentPosition.getPosition() < DbusEventBuffer.this._head.getPosition()) {
                        this._currentPosition.copy(DbusEventBuffer.this._head);
                    }
                }
                finally {
                    if (oldPos != this._currentPosition.getPosition() || oldTail != this._iteratorTail.getPosition()) {
                        if (debugEnabled) {
                            DbusEventBuffer.this._log.debug((Object)("refreshing iterator: " + this));
                        }
                        this.reacquireReadLock();
                        if (debugEnabled) {
                            DbusEventBuffer.this._log.debug((Object)("done refreshing iterator: " + this));
                        }
                    }
                }
            }
            finally {
                DbusEventBuffer.this._queueLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean await(long time, TimeUnit unit) {
            boolean isDebug = LOG.isDebugEnabled();
            DbusEventBuffer.this._queueLock.lock();
            try {
                this.copyBufferEndpoints();
                boolean available = this.hasNext();
                if (!available) {
                    if (isDebug) {
                        LOG.debug((Object)(this.toString() + ": waiting for notEmpty" + this));
                    }
                    available = DbusEventBuffer.this._notEmpty.await(time, unit);
                    if (isDebug) {
                        LOG.debug((Object)("_notEmpty coming out of await: " + available));
                    }
                    if (available) {
                        this.copyBufferEndpoints();
                    }
                }
                boolean bl = available;
                return bl;
            }
            catch (InterruptedException e) {
                LOG.warn((Object)(this.toString() + ": await/refresh interrupted"));
                boolean bl = false;
                return bl;
            }
            catch (TimeoutException e) {
                DbusEventBuffer.this._log.error((Object)(this.toString() + ": timeout waiting for a lock"), (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                DbusEventBuffer.this._queueLock.unlock();
            }
        }

        public void awaitUninterruptibly() {
            try {
                this.await(true);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void await() throws InterruptedException {
            this.await(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await(boolean absorbInterrupt) throws InterruptedException {
            boolean debugEnabled = DbusEventBuffer.this._log.isDebugEnabled();
            DbusEventBuffer.this._queueLock.lock();
            try {
                try {
                    this.copyBufferEndpoints();
                    while (!this.hasNext()) {
                        if (debugEnabled) {
                            DbusEventBuffer.this._log.debug((Object)(this._identifier + ": waiting for notEmpty" + this));
                        }
                        DbusEventBuffer.this._notEmpty.await();
                        this.copyBufferEndpoints();
                        if (!debugEnabled) continue;
                        DbusEventBuffer.this._log.debug((Object)("Iterator " + this + " coming out of await"));
                    }
                }
                catch (InterruptedException e) {
                    DbusEventBuffer.this._log.warn((Object)(this.toString() + ": await/refresh interrupted"), (Throwable)e);
                    if (!absorbInterrupt) {
                        throw e;
                    }
                }
                catch (TimeoutException e) {
                    throw new DatabusRuntimeException(this.toString() + ": refresh timed out", e);
                }
            }
            finally {
                DbusEventBuffer.this._queueLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void awaitInterruptibly() {
            boolean debugEnabled = DbusEventBuffer.this._log.isDebugEnabled();
            DbusEventBuffer.this._queueLock.lock();
            try {
                try {
                    this.copyBufferEndpoints();
                    boolean wait = true;
                    while (!this.hasNext()) {
                        if (debugEnabled) {
                            DbusEventBuffer.this._log.debug((Object)(this._identifier + ": waiting for notEmpty" + this));
                        }
                        DbusEventBuffer.this._notEmpty.await();
                        this.copyBufferEndpoints();
                        if (!debugEnabled) continue;
                        DbusEventBuffer.this._log.debug((Object)("Iterator " + this + " coming out of await"));
                    }
                }
                catch (InterruptedException e) {
                    DbusEventBuffer.this._log.warn((Object)(this.toString() + ": lock wait/refresh interrupted"), (Throwable)e);
                }
                catch (TimeoutException e) {
                    DbusEventBuffer.this._log.error((Object)(this.toString() + ": refresh timed out"), (Throwable)e);
                }
            }
            finally {
                DbusEventBuffer.this._queueLock.unlock();
            }
        }

        @Override
        public boolean hasNext() {
            boolean result = super.hasNext();
            if (!result) {
                try {
                    this.copyBufferEndpoints();
                }
                catch (InterruptedException e) {
                    DbusEventBuffer.this._log.warn((Object)(this.toString() + ": refresh interrupted"));
                    return false;
                }
                catch (TimeoutException e) {
                    DbusEventBuffer.this._log.error((Object)(this.toString() + ": refresh timed out"));
                    return false;
                }
                result = super.hasNext();
            }
            return result;
        }

        @Override
        public void remove() {
            boolean debugEnabled = LOG.isDebugEnabled();
            if (debugEnabled) {
                LOG.debug((Object)("Iterator " + this._identifier + " hasNext = " + this.hasNext() + " being asked to remove stuff" + this));
            }
            DbusEventBuffer.this._rwLockProvider.shiftReaderLockStart(this._lockToken, this._currentPosition.getPosition(), DbusEventBuffer.this._bufferPositionParser);
            DbusEventBuffer.this.acquireWriteLock();
            try {
                if (DbusEventBuffer.this.isClosed()) {
                    LOG.warn((Object)("canceling remove operation on iterator because the buffer is closed. it=" + this));
                    throw new DatabusRuntimeException(this.toString() + " remove canceled.");
                }
                this.copyBufferEndpoints();
                long newHead = this._currentPosition.getPosition();
                long newScn = -1L;
                long newTs = -1L;
                if (0L <= newHead && newHead < DbusEventBuffer.this._tail.getPosition()) {
                    DbusEventInternalWritable e = this.currentEvent();
                    assert (e.isValid());
                    newScn = e.sequence();
                    newTs = e.timestampInNanos();
                }
                DbusEventBuffer.this.moveHead(newHead, newScn, newTs, debugEnabled);
            }
            catch (InterruptedException e) {
                DbusEventBuffer.this._log.error((Object)("buffer locks: " + DbusEventBuffer.this._rwLockProvider));
                throw new DatabusRuntimeException(this.toString() + ": refresh interrupted", e);
            }
            catch (TimeoutException e) {
                DbusEventBuffer.this._log.error((Object)("remove timeout for iterator " + this + " in buffer " + DbusEventBuffer.this), (Throwable)e);
                throw new DatabusRuntimeException(this.toString() + ": refresh timed out", e);
            }
            catch (RuntimeException e) {
                DbusEventBuffer.this._log.error((Object)("error removing events for iterator " + this + ":" + e.getMessage()));
                DbusEventBuffer.this._log.error((Object)("buffer:" + DbusEventBuffer.this));
                throw e;
            }
            catch (AssertionError e) {
                DbusEventBuffer.this._log.error((Object)("error removing events for iterator " + this + ":" + ((Throwable)((Object)e)).getMessage()));
                DbusEventBuffer.this._log.error((Object)("buffer:" + DbusEventBuffer.this));
                DbusEventBuffer.this._log.error((Object)DbusEventBuffer.this.hexdumpByteBufferContents(this._currentPosition.getPosition(), 200));
                throw e;
            }
            finally {
                DbusEventBuffer.this.releaseWriteLock();
            }
        }

        public boolean equivalent(DbusEventIterator lastSuccessfulIterator) {
            return lastSuccessfulIterator != null && lastSuccessfulIterator._currentPosition.equals(this._currentPosition);
        }
    }

    protected class ManagedEventIterator
    extends InternalEventIterator {
        public ManagedEventIterator(long head, long tail, String iteratorName) {
            super(head, tail, iteratorName);
        }

        public ManagedEventIterator(long head, long tail) {
            this(head, tail, "ManagedEventIterator" + ITERATORS_COUNTER.getAndIncrement());
        }

        @Override
        public boolean hasNext() {
            boolean hasMore = super.hasNext();
            if (!hasMore) {
                this.close();
            }
            return hasMore;
        }
    }

    protected class InternalEventIterator
    extends BaseEventIterator {
        protected RangeBasedReaderWriterLock.LockToken _lockToken;

        public InternalEventIterator(long head, long tail, String iteratorName) {
            super(head, tail, iteratorName);
        }

        public InternalEventIterator(long head, long tail) {
            this(head, tail, null);
        }

        @Override
        public void close() {
            this.releaseReadLock();
            super.close();
        }

        public InternalEventIterator copy(InternalEventIterator destinationIterator, String iteratorName) {
            if (null == destinationIterator) {
                destinationIterator = DbusEventBuffer.this.acquireInternalIterator(this._currentPosition.getPosition(), this._iteratorTail.getPosition(), iteratorName);
            } else {
                destinationIterator.reset(this._currentPosition.getPosition(), this._iteratorTail.getPosition(), destinationIterator._identifier);
            }
            return destinationIterator;
        }

        @Override
        protected void reset(long head, long tail, String iteratorName) {
            super.reset(head, tail, iteratorName);
            try {
                this.reacquireReadLock();
            }
            catch (InterruptedException e) {
                throw new DatabusRuntimeException(e);
            }
            catch (TimeoutException e) {
                throw new DatabusRuntimeException(e);
            }
        }

        @Override
        protected StringBuilder printInternalState(StringBuilder builder) {
            builder = super.printInternalState(builder);
            if (null != this._lockToken) {
                builder.append(", lockToken=");
                builder.append(this._lockToken);
            }
            return builder;
        }

        protected synchronized void reacquireReadLock() throws InterruptedException, TimeoutException {
            if (this._lockToken != null) {
                DbusEventBuffer.this._rwLockProvider.releaseReaderLock(this._lockToken);
                this._lockToken = null;
            }
            if (this._currentPosition.getPosition() >= 0L) {
                this._lockToken = DbusEventBuffer.this._rwLockProvider.acquireReaderLock(this._currentPosition.getPosition(), this._iteratorTail.getPosition(), DbusEventBuffer.this._bufferPositionParser, this.getIdentifier() + "-" + System.identityHashCode(this));
            }
        }

        protected synchronized void releaseReadLock() {
            if (this._lockToken != null) {
                DbusEventBuffer.this._rwLockProvider.releaseReaderLock(this._lockToken);
                this._lockToken = null;
            }
        }

        @Override
        protected void assertPointers() {
            super.assertPointers();
            assert (null == this._lockToken || this._lockToken.getRange().start <= this._currentPosition.getPosition()) : this.printExtendedStateInfo();
            assert (null == this._lockToken || this._lockToken.getRange().end >= this._iteratorTail.getPosition()) : this.printExtendedStateInfo();
        }
    }

    protected class BaseEventIterator
    implements Iterator<DbusEventInternalWritable> {
        protected final BufferPosition _currentPosition;
        protected final BufferPosition _iteratorTail;
        protected DbusEventInternalWritable _iteratingEvent;
        protected String _identifier;

        public BaseEventIterator(long head, long tail, String iteratorName) {
            this._currentPosition = new BufferPosition(DbusEventBuffer.this._bufferPositionParser, DbusEventBuffer.this._buffers);
            this._currentPosition.setPosition(head);
            this._iteratorTail = new BufferPosition(DbusEventBuffer.this._bufferPositionParser, DbusEventBuffer.this._buffers);
            this._iteratorTail.setPosition(tail);
            this._iteratingEvent = DbusEventBuffer.this._eventFactory.createWritableDbusEvent();
            this.reset(head, tail, iteratorName);
            DbusEventBuffer.this.trackIterator(this);
        }

        public BaseEventIterator(long head, long tail) {
            this(head, tail, null);
        }

        @Override
        public boolean hasNext() {
            boolean result = false;
            if (this._currentPosition.init()) {
                result = false;
            } else {
                try {
                    this._currentPosition.sanitize();
                    this._iteratorTail.sanitize();
                    if (this._currentPosition.getPosition() > this._iteratorTail.getPosition()) {
                        LOG.error((Object)("unexpected iterator state: this:" + this + " \nbuf: " + DbusEventBuffer.this));
                        throw new DatabusRuntimeException("unexpected iterator state: " + this);
                    }
                    boolean bl = result = this._currentPosition.getPosition() != this._iteratorTail.getPosition();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(" - hasNext = " + result + " currentPosition = " + this._currentPosition + " iteratorTail = " + this._iteratorTail + "limit = " + DbusEventBuffer.this._buffers[0].limit() + "tail = " + DbusEventBuffer.this._tail));
                    }
                }
                catch (DatabusRuntimeException e) {
                    DbusEventBuffer.this._log.error((Object)("error in hasNext for iterator: " + this));
                    DbusEventBuffer.this._log.error((Object)("buffer: " + DbusEventBuffer.this));
                    throw e;
                }
            }
            return result;
        }

        @Override
        public DbusEventInternalWritable next() {
            try {
                return this.next(false);
            }
            catch (InvalidEventException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append(": {");
            this.printInternalState(builder);
            builder.append("}");
            return builder.toString();
        }

        @Override
        public void remove() {
            throw new DatabusRuntimeException("not supported");
        }

        public void close() {
            DbusEventBuffer.this.untrackIterator(this);
        }

        public BaseEventIterator copy(BaseEventIterator destinationIterator, String iteratorName) {
            if (null == destinationIterator) {
                destinationIterator = DbusEventBuffer.this.acquireLockFreeInternalIterator(this._currentPosition.getPosition(), this._iteratorTail.getPosition(), iteratorName);
            }
            destinationIterator.reset(this._currentPosition.getPosition(), this._iteratorTail.getPosition(), destinationIterator._identifier);
            return destinationIterator;
        }

        public String printExtendedStateInfo() {
            String baseState = this.toString();
            return baseState + "; buffer.head: " + DbusEventBuffer.this._head + "; buffer.tail: " + DbusEventBuffer.this._tail + "; buffer.currentWritePosition: " + DbusEventBuffer.this._currentWritePosition;
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }

        protected void reset(long head, long tail, String iteratorName) {
            assert (head >= 0L) : "name:" + iteratorName;
            assert (head <= tail) : "head:" + head + "; tail: " + tail + "; name:" + iteratorName;
            this._identifier = null != iteratorName ? iteratorName : this.getClass().getSimpleName() + ITERATORS_COUNTER.getAndIncrement();
            this._currentPosition.setPosition(head);
            this._iteratorTail.setPosition(tail);
            this.assertPointers();
            assert (this._iteratingEvent != null);
        }

        protected DbusEventInternalWritable next(boolean validateEvent) throws InvalidEventException {
            long oldPos = this._currentPosition.getPosition();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            DbusEventInternalWritable nextEvent = this.currentEvent();
            if (validateEvent && !nextEvent.isValid()) {
                DbusEventBuffer.this._log.error((Object)("invalid event in iterator detected:" + this));
                int dumpLen = Math.min(100, Math.max(nextEvent.size(), 100));
                DbusEventBuffer.this._log.error((Object)("current event bytes:" + DbusEventBuffer.this.hexdumpByteBufferContents(this._currentPosition.getPosition(), dumpLen)));
                if (oldPos >= 0L) {
                    DbusEventBuffer.this._log.error((Object)("previous event bytes @ " + DbusEventBuffer.this._bufferPositionParser.toString(oldPos, DbusEventBuffer.this._buffers) + ": " + DbusEventBuffer.this.hexdumpByteBufferContents(oldPos, 100)));
                }
                throw new InvalidEventException();
            }
            try {
                this._currentPosition.incrementOffset(nextEvent.size());
            }
            catch (DatabusRuntimeException e) {
                if (oldPos >= 0L) {
                    DbusEventBuffer.this._log.error((Object)("previous event bytes @ " + DbusEventBuffer.this._bufferPositionParser.toString(oldPos, DbusEventBuffer.this._buffers) + ": " + DbusEventBuffer.this.hexdumpByteBufferContents(oldPos, 100)));
                }
                DbusEventBuffer.this._scnIndex.printVerboseString(LOG, Level.ERROR);
                throw new InvalidEventException("error in incrementOffset: " + e.getMessage(), e);
            }
            return nextEvent;
        }

        protected DbusEventInternalWritable currentEvent() {
            this._currentPosition.sanitize();
            assert (this._iteratingEvent != null);
            this._iteratingEvent = (DbusEventInternalWritable)this._iteratingEvent.reset(DbusEventBuffer.this._buffers[this._currentPosition.bufferIndex()], this._currentPosition.bufferOffset());
            return this._iteratingEvent;
        }

        protected long getCurrentPosition() {
            this._currentPosition.sanitize();
            return this._currentPosition.getPosition();
        }

        protected StringBuilder printInternalState(StringBuilder builder) {
            if (null == builder) {
                builder = new StringBuilder();
            }
            builder.append("identifier: ");
            builder.append(this._identifier);
            builder.append('-');
            builder.append(System.identityHashCode(this));
            builder.append(", currentPosition: ");
            builder.append(this._currentPosition);
            builder.append(", iteratorTail: ");
            builder.append(this._iteratorTail);
            assert (this._iteratingEvent != null);
            if (this.hasNext() && this._iteratingEvent.isValid()) {
                builder.append(", iteratingEvent: ");
                builder.append(this._iteratingEvent);
            }
            return builder;
        }

        protected void assertPointers() {
            assert (this._currentPosition.getPosition() >= DbusEventBuffer.this._head.getPosition()) : this.printExtendedStateInfo();
            assert (this._iteratorTail.getPosition() <= DbusEventBuffer.this._currentWritePosition.getPosition()) : this.printExtendedStateInfo();
        }

        public String getIdentifier() {
            return this._identifier;
        }

        public DbusEventBuffer getEventBuffer() {
            return DbusEventBuffer.this;
        }
    }

    protected static class SessionIdGenerator {
        private long _lastSessionIdGenerated = -1L;

        protected SessionIdGenerator() {
        }

        synchronized String generateSessionId() {
            long sessionId;
            while ((sessionId = System.currentTimeMillis()) <= this._lastSessionIdGenerated) {
            }
            this._lastSessionIdGenerated = sessionId;
            return DbusEventBuffer.SESSION_PREFIX + this._lastSessionIdGenerated;
        }
    }

    public static enum AllocationPolicy {
        HEAP_MEMORY,
        DIRECT_MEMORY,
        MMAPPED_MEMORY;

    }

    public static enum QueuePolicy {
        BLOCK_ON_WRITE,
        OVERWRITE_ON_WRITE;

    }
}

