/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.PullerRetriesExhaustedException;
import com.linkedin.databus.core.ScnNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class DbusErrorEvent {
    public static final String MODULE = DbusErrorEvent.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private Throwable _error;
    private short _errorId;
    private static ObjectMapper _mapper = new ObjectMapper();

    public DbusErrorEvent() {
    }

    public DbusErrorEvent(Throwable error, short errorId) {
        this._error = error;
        this._errorId = errorId;
    }

    public static DbusErrorEvent createDbusErrorEvent(String serilizedErrorEvent) throws JsonParseException, JsonMappingException, IOException {
        return (DbusErrorEvent)_mapper.readValue((InputStream)new ByteArrayInputStream(serilizedErrorEvent.getBytes(Charset.defaultCharset())), DbusErrorEvent.class);
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
            _mapper.writeValue((OutputStream)byteArrayStream, (Object)this);
            return ((Object)byteArrayStream).toString();
        }
        catch (Exception e) {
            LOG.error((Object)("JSON error: " + e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setError(Throwable error) {
        this._error = error;
    }

    public Throwable getError() {
        return this._error;
    }

    public void setErrorId(short errorId) {
        this._errorId = errorId;
    }

    public short getErrorId() {
        return this._errorId;
    }

    public Throwable returnActualException() {
        Exception error = null;
        switch (this._errorId) {
            case -5: {
                error = new ScnNotFoundException(this._error);
                break;
            }
            case -6: {
                error = new PullerRetriesExhaustedException(this._error);
                break;
            }
            default: {
                LOG.error((Object)("Invalid error id: " + this._errorId));
            }
        }
        return error;
    }
}

