/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

public final class DbusConstants {
    public static final long NUM_NSECS_IN_MSEC = 1000000L;
    public static final long NUM_NSECS_IN_SEC = 1000000000L;
    public static final long NUM_NSECS_IN_MIN = 60000000000L;
    public static final long NUM_MSECS_IN_SEC = 1000L;
    public static final String SERVER_INFO_HOSTPORT_HEADER_PARAM = "X-DBUS2-BS-HOSTPORT";
    public static final String HOSTPORT_DELIMITER = ":";
    public static final String APP_NAME = "com.linkedin.app.name";
    public static final String INSTANCE_NAME = "com.linkedin.app.instance";
    public static final String ENV_NAME = "com.linkedin.app.env";
    public static final String MACHINE_NAME = "com.linkedin.app.machine";
    public static final String CONTAINER_NAME = "com.linkedin.app.container";
    public static final String COMPOUND_KEY_DELIMITER = "\t";
    public static final String COMPOUND_KEY_SEPARATOR = ",";
    public static final String UNKNOWN_ENV = "UNKNOWN";
    public static final String UNKNOWN_APP_NAME = "UNKNOWN";
    public static final String UNKNOWN_INSTANCE = "UNKNOWN";
    public static final String UNKNOWN_SERVICE_ID = "UNKNOWN";
    public static final String UNKNOWN_HOST = "UNKNOWN";
    public static final String DEFAULT_VAL = "UNKNOWN";
    private static final String UNKNOWN_FULL_SERVICE_ID = DbusConstants.getServiceIdentifier("UNKNOWN", "UNKNOWN", "UNKNOWN");
    public static final String GG_REPLICATION_BIT_SETTER_FIELD_NAME = "GG_STATUS";
    public static final String GG_REPLICATION_BIT_SETTER_VALUE = "g";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String XML_VERSION = "1.0";
    public static final int DONT_USE_METADATA_SCHEMA = 0;
    public static final int USE_LATEST_METADATA_SCHEMA = -1;

    public static String getAppName() {
        return System.getProperty(APP_NAME, "UNKNOWN");
    }

    public static void setAppName(String appName) {
        System.setProperty(APP_NAME, appName);
    }

    public static String getInstanceName() {
        return System.getProperty(INSTANCE_NAME, "UNKNOWN");
    }

    public static void setInstanceName(String instanceName) {
        System.setProperty(INSTANCE_NAME, instanceName);
    }

    public static String getEnvName() {
        return System.getProperty(ENV_NAME, "UNKNOWN");
    }

    public static void setEnvName(String envName) {
        System.setProperty(ENV_NAME, envName);
    }

    public static String getMachineName() {
        return System.getProperty(MACHINE_NAME, "UNKNOWN");
    }

    public static void setMachineName(String machineName) {
        System.setProperty(MACHINE_NAME, machineName);
    }

    public static String getContainerName() {
        return System.getProperty(CONTAINER_NAME, "UNKNOWN");
    }

    public static void setContainerName(String containerName) {
        System.setProperty(CONTAINER_NAME, containerName);
    }

    public static String getServiceIdentifier(String environment, String appName, String instance) {
        return environment + "/" + appName + "/" + instance;
    }

    public static String getServiceIdentifier() {
        String svcId = DbusConstants.getServiceIdentifier(DbusConstants.getEnvName(), DbusConstants.getAppName(), DbusConstants.getInstanceName());
        if (svcId.equals(UNKNOWN_FULL_SERVICE_ID)) {
            svcId = "UNKNOWN";
        }
        return svcId;
    }
}

