/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus2.core.DatabusException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class DatabusThreadBase
extends Thread {
    protected final Logger _log;
    protected Lock _controlLock = new ReentrantLock(true);
    protected Condition _shutdownCondition = this._controlLock.newCondition();
    protected Condition _pauseCondition = this._controlLock.newCondition();
    protected Condition _resumeCondition = this._controlLock.newCondition();
    protected Condition _resumeRequestCondition = this._controlLock.newCondition();
    protected boolean _shutdownRequested = false;
    protected boolean _shutdown = false;
    protected boolean _pauseRequested = false;
    protected boolean _paused = false;
    protected boolean _resumeRequested = false;
    public static final String MODULE = DatabusThreadBase.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);

    public DatabusThreadBase(String name) {
        super(name);
        this.setDaemon(true);
        this._log = Logger.getLogger((String)(this.getClass().getName() + "." + name));
    }

    @Override
    public void run() {
        try {
            this.beforeRun();
            boolean done = false;
            while (!done && !this.isShutdownRequested()) {
                while (this.isPauseRequested()) {
                    LOG.info((Object)"Pausing !!");
                    this.signalPause();
                    try {
                        this.awaitUnPauseRequest();
                        LOG.info((Object)"Resuming !!");
                    }
                    catch (InterruptedException interruptedException) {}
                }
                done = !this.runOnce();
            }
            LOG.info((Object)"Shutting down !!");
            this.doShutdownNotify();
            this.afterRun();
        }
        catch (DatabusException ex) {
            LOG.error((Object)"Got error. Stopping !! ", (Throwable)ex);
        }
    }

    public boolean runOnce() throws DatabusException {
        return false;
    }

    public void beforeRun() throws DatabusException {
    }

    public void afterRun() throws DatabusException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAsynchronously() {
        this._log.info((Object)"Pause requested");
        this._controlLock.lock();
        try {
            this._pauseRequested = true;
        }
        finally {
            this._controlLock.unlock();
        }
    }

    public void pause() throws InterruptedException {
        this.pauseAsynchronously();
        this.awaitPause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpauseAsynchronously() {
        this._log.info((Object)"Resume requested");
        this._controlLock.lock();
        try {
            this._resumeRequested = true;
            this._resumeRequestCondition.signal();
        }
        finally {
            this._controlLock.unlock();
        }
    }

    public void unpause() throws InterruptedException {
        this.unpauseAsynchronously();
        this.awaitUnPause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalPause() {
        this._controlLock.lock();
        try {
            this._paused = true;
            this._pauseCondition.signal();
        }
        finally {
            this._controlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signalResumed() {
        this._controlLock.lock();
        try {
            this._paused = false;
            this._resumeRequested = true;
            this._resumeCondition.signal();
        }
        finally {
            this._controlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAsynchronously() {
        this._log.info((Object)"Shutdown requested");
        this._controlLock.lock();
        try {
            this._shutdownRequested = true;
        }
        finally {
            this._controlLock.unlock();
        }
    }

    public void shutdown() {
        this.shutdownAsynchronously();
        this.awaitShutdownUniteruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPauseRequested() {
        this._controlLock.lock();
        try {
            boolean bl = this._pauseRequested;
            return bl;
        }
        finally {
            this._controlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        this._controlLock.lock();
        try {
            boolean bl = this._paused;
            return bl;
        }
        finally {
            this._controlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnPauseRequested() {
        this._controlLock.lock();
        try {
            boolean bl = this._resumeRequested;
            return bl;
        }
        finally {
            this._controlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnPaused() {
        this._controlLock.lock();
        try {
            boolean bl = !this._paused;
            return bl;
        }
        finally {
            this._controlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdownRequested() {
        this._controlLock.lock();
        try {
            boolean bl = this._shutdownRequested;
            return bl;
        }
        finally {
            this._controlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        this._controlLock.lock();
        try {
            boolean bl = this._shutdownRequested;
            return bl;
        }
        finally {
            this._controlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitPause() throws InterruptedException {
        this._log.info((Object)"Waiting to be paused");
        this._controlLock.lock();
        try {
            while (!this._paused) {
                this._pauseCondition.await();
            }
            this._pauseRequested = false;
        }
        finally {
            this._controlLock.unlock();
        }
        this._log.info((Object)"Paused: true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitUnPause() throws InterruptedException {
        this._log.info((Object)"Waiting for resumption");
        this._controlLock.lock();
        try {
            while (this._paused) {
                this._resumeCondition.await();
            }
            this._resumeRequested = false;
        }
        finally {
            this._controlLock.unlock();
        }
        this._log.info((Object)"Resumed: true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awaitUnPauseRequest() throws InterruptedException {
        this._log.info((Object)"Waiting to be requested for resume");
        this._controlLock.lock();
        try {
            while (!this._resumeRequested) {
                this._resumeRequestCondition.await();
            }
        }
        finally {
            this._controlLock.unlock();
        }
        this._log.info((Object)"Resume Requested: true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitPause(long timeout, TimeUnit timeUnit) throws InterruptedException {
        boolean success;
        this._log.info((Object)"Waiting for pause with timeout");
        this._controlLock.lock();
        try {
            while (!this._paused) {
                boolean successfulWait = this._pauseCondition.await(timeout, timeUnit);
                if (!this._log.isDebugEnabled()) continue;
                this._log.debug((Object)("Await Condition returned :" + successfulWait));
            }
            success = this._paused;
        }
        finally {
            this._controlLock.unlock();
        }
        this._log.info((Object)("Paused: " + success));
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitUnPause(long timeout, TimeUnit timeUnit) throws InterruptedException {
        boolean success;
        this._log.info((Object)"Waiting for resume with timeout");
        this._controlLock.lock();
        try {
            while (this._paused) {
                boolean successfulWait = this._resumeCondition.await(timeout, timeUnit);
                if (!this._log.isDebugEnabled()) continue;
                this._log.debug((Object)("Await Condition returned :" + successfulWait));
            }
            success = !this._paused;
        }
        finally {
            this._controlLock.unlock();
        }
        this._log.info((Object)("UnPaused: " + success));
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitShutdown() throws InterruptedException {
        this._log.info((Object)"Waiting for shutdown");
        this._controlLock.lock();
        try {
            while (!this._shutdown) {
                this._shutdownCondition.await();
            }
        }
        finally {
            this._controlLock.unlock();
        }
        this._log.info((Object)"Shutdown: true");
    }

    public void awaitShutdownUniteruptibly() {
        this._log.info((Object)"Waiting for shutdown uninteruptibly");
        boolean keepOnWaiting = true;
        while (keepOnWaiting) {
            try {
                this.awaitShutdown();
                keepOnWaiting = false;
            }
            catch (InterruptedException interruptedException) {}
        }
        this._log.info((Object)"Shutdown: true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitShutdownUninteruptibly(long timeout, TimeUnit timeUnit) {
        boolean success;
        this._log.info((Object)"Waiting for shutdown uninteruptibly with timeout");
        this._controlLock.lock();
        try {
            long startTime = System.nanoTime();
            long timeoutNanos = timeUnit.toNanos(timeout);
            while (!this._shutdown) {
                try {
                    long elapsed = System.nanoTime() - startTime;
                    if (elapsed >= timeoutNanos) break;
                    success = this._shutdownCondition.await(timeoutNanos - elapsed, timeUnit);
                }
                catch (InterruptedException ie) {}
            }
            success = this._shutdown;
        }
        finally {
            this._controlLock.unlock();
        }
        this._log.info((Object)("Shutdown: " + success));
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doShutdownNotify() {
        this._controlLock.lock();
        try {
            this._log.info((Object)"Signalling shutdown !!");
            this._shutdown = true;
            this._shutdownCondition.signalAll();
        }
        finally {
            this._controlLock.unlock();
        }
    }
}

