/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus2.core.BackoffTimer;
import com.linkedin.databus2.core.BackoffTimerStaticConfig;
import org.apache.log4j.Logger;

public class DatabusComponentStatus {
    public static final String INITIALIZING_MESSAGE = "The databus component is initializing...";
    public static final String RUNNING_MESSAGE = "The databus component is running normally.";
    public static final String PAUSED_MESSAGE = "The databus component is paused by the administrator.";
    public static final String SHUTDOWN_MESSAGE = "The databus component is being shutdown by the administrator...";
    protected final Logger _log;
    private final String _componentName;
    private BackoffTimer _retriesCounter;
    private Status _status;
    private String _message;
    private volatile long _lastStartTime;

    public DatabusComponentStatus(String componentName, Status status, String detailedMessage, BackoffTimer errorRetriesCounter) {
        this._log = Logger.getLogger((String)(DatabusComponentStatus.class.getName() + "_" + componentName));
        this._componentName = componentName;
        this._status = status;
        this._message = detailedMessage;
        this._retriesCounter = errorRetriesCounter;
        this._lastStartTime = -1L;
    }

    public DatabusComponentStatus(String componentName, Status status, String detailedMessage, BackoffTimerStaticConfig errorRetriesConf) {
        this(componentName, status, detailedMessage, new BackoffTimer(componentName + ".errorRetries", errorRetriesConf));
    }

    public DatabusComponentStatus(String componentName, Status status, String detailedMessage) {
        this(componentName, status, detailedMessage, BackoffTimerStaticConfig.UNLIMITED_RETRIES);
    }

    public DatabusComponentStatus(String componentName) {
        this(componentName, Status.INITIALIZING, INITIALIZING_MESSAGE);
    }

    public DatabusComponentStatus(String componentName, BackoffTimerStaticConfig errorRetriesConf) {
        this(componentName, Status.INITIALIZING, INITIALIZING_MESSAGE, errorRetriesConf);
    }

    public synchronized Status getStatus() {
        return this._status;
    }

    public synchronized String getMessage() {
        return this._message;
    }

    public synchronized DatabusComponentStatus getStatusSnapshot() {
        return new DatabusComponentStatus(this._componentName, this._status, this._message, this._retriesCounter);
    }

    public synchronized boolean isRunningStatus() {
        return Status.RUNNING == this._status;
    }

    public synchronized boolean isPausedStatus() {
        return Status.PAUSED == this._status || Status.SUSPENDED_ON_ERROR == this._status;
    }

    public synchronized int getRetriesNum() {
        return this._retriesCounter.getRetriesNum();
    }

    public synchronized int getRetriesLeft() {
        return this._retriesCounter.getRemainingRetriesNum();
    }

    public synchronized long getLastRetrySleepMs() {
        return this._retriesCounter.getCurrentSleepMs();
    }

    public synchronized void waitForResume() {
        while (this.isPausedStatus()) {
            try {
                this._log.info((Object)("Entering into waiting state..." + (Object)((Object)this._status)));
                this.wait();
                this._log.info((Object)("Existing waiting state with new state..." + (Object)((Object)this._status)));
            }
            catch (InterruptedException e) {
                this._log.info((Object)"Interruptd while being suspended!");
            }
        }
    }

    protected synchronized void setStatus(Status status, String statusDetail) {
        if (Status.SHUTDOWN != this._status) {
            Status oldStatus = this._status;
            this._status = status;
            if (Status.PAUSED == oldStatus || Status.SUSPENDED_ON_ERROR == oldStatus) {
                this.notifyAll();
            }
            String newMessage = statusDetail;
            this._lastStartTime = -1L;
            switch (this._status) {
                case RUNNING: {
                    this._retriesCounter.reset();
                    this._lastStartTime = System.currentTimeMillis();
                    break;
                }
                case ERROR_RETRY: {
                    this._retriesCounter.backoff();
                    if (Status.SUSPENDED_ON_ERROR != oldStatus && Status.ERROR_RETRY != oldStatus) break;
                    newMessage = this._message + ";" + statusDetail;
                    break;
                }
                case SUSPENDED_ON_ERROR: {
                    if (Status.SUSPENDED_ON_ERROR != oldStatus && Status.ERROR_RETRY != oldStatus) break;
                    newMessage = this._message + ";" + statusDetail;
                    break;
                }
                case INITIALIZING: {
                    break;
                }
                case PAUSED: {
                    break;
                }
            }
            this._message = newMessage;
        }
        this._log.debug((Object)(status.toString() + ": " + this.getMessage()));
    }

    public void start() {
        this.setStatus(Status.RUNNING, RUNNING_MESSAGE);
    }

    public void shutdown() {
        this.setStatus(Status.SHUTDOWN, SHUTDOWN_MESSAGE);
    }

    public void pause() {
        this.setStatus(Status.PAUSED, PAUSED_MESSAGE);
    }

    public void resume() {
        this.setStatus(Status.RUNNING, RUNNING_MESSAGE);
    }

    public boolean retryOnError(String message) {
        this.setStatus(Status.ERROR_RETRY, message);
        return this._retriesCounter.backoffAndSleep();
    }

    public boolean retryOnLastError() {
        return this._retriesCounter.backoffAndSleep();
    }

    public void suspendOnError(Throwable error) {
        this.setStatus(Status.SUSPENDED_ON_ERROR, null != error ? error.toString() : "unknown error");
    }

    public BackoffTimer getRetriesCounter() {
        return this._retriesCounter;
    }

    public void setRetriesCounter(BackoffTimer retriesCounter) {
        this._retriesCounter = retriesCounter;
    }

    public long getUptimeMs() {
        long lastStart = this._lastStartTime;
        return 0L < lastStart ? System.currentTimeMillis() - lastStart : 0L;
    }

    public String getComponentName() {
        return this._componentName;
    }

    public String toString() {
        return "DatabusComponentStatus [_componentName=" + this._componentName + ", _retriesCounter=" + this._retriesCounter + ", _status=" + (Object)((Object)this._status) + ", _message=" + this._message + ", _lastStartTime=" + this._lastStartTime + "]";
    }

    public static enum Status {
        INITIALIZING(0),
        RUNNING(100),
        PAUSED(200),
        ERROR_RETRY(300),
        SUSPENDED_ON_ERROR(400),
        SHUTDOWN(1000);

        private final int _code;

        private Status(int code) {
            this._code = code;
        }

        public int getCode() {
            return this._code;
        }
    }
}

