/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DatabusComponentStatus;
import com.linkedin.databus2.core.BackoffTimer;
import com.linkedin.databus2.core.BackoffTimerStaticConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompoundDatabusComponentStatus
extends DatabusComponentStatus {
    private static final long STATUS_EXPIRY_MS = 5L;
    private long _lastStatusCheckMs = 0L;
    private final Map<String, DatabusComponentStatus> _children = new HashMap<String, DatabusComponentStatus>();
    private final Map<String, DatabusComponentStatus> _readOnlyChildren = Collections.unmodifiableMap(this._children);
    protected final List<String> _initializing = new ArrayList<String>();
    private final List<String> _initializingRO = Collections.unmodifiableList(this._initializing);
    protected final List<String> _retryingOnError = new ArrayList<String>();
    private final List<String> _retryingOnErrorRO = Collections.unmodifiableList(this._retryingOnError);
    protected final List<String> _suspended = new ArrayList<String>();
    private final List<String> _suspendedRO = Collections.unmodifiableList(this._suspended);
    protected final List<String> _paused = new ArrayList<String>();
    private final List<String> _pausedRO = Collections.unmodifiableList(this._paused);
    protected final List<String> _shutdown = new ArrayList<String>();
    private final List<String> _shutdownRO = Collections.unmodifiableList(this._shutdown);

    public CompoundDatabusComponentStatus(String componentName, BackoffTimerStaticConfig errorRetriesConf, Collection<DatabusComponentStatus> children) {
        super(componentName, errorRetriesConf);
        this.addChildren(children);
    }

    public CompoundDatabusComponentStatus(String componentName, DatabusComponentStatus.Status status, String detailedMessage, BackoffTimer errorRetriesCounter, Collection<DatabusComponentStatus> children) {
        super(componentName, status, detailedMessage, errorRetriesCounter);
        this.addChildren(children);
    }

    public CompoundDatabusComponentStatus(String componentName, DatabusComponentStatus.Status status, String detailedMessage, BackoffTimerStaticConfig errorRetriesConf, Collection<DatabusComponentStatus> children) {
        super(componentName, status, detailedMessage, errorRetriesConf);
        this.addChildren(children);
    }

    public CompoundDatabusComponentStatus(String componentName, DatabusComponentStatus.Status status, String detailedMessage, Collection<DatabusComponentStatus> children) {
        super(componentName, status, detailedMessage);
        this.addChildren(children);
    }

    public CompoundDatabusComponentStatus(String componentName, Collection<DatabusComponentStatus> children) {
        super(componentName);
        this.addChildren(children);
    }

    private void processChildStatus(DatabusComponentStatus child) {
        switch (child.getStatus()) {
            case INITIALIZING: {
                this._initializing.add(child.getComponentName());
                break;
            }
            case RUNNING: {
                break;
            }
            case ERROR_RETRY: {
                this._retryingOnError.add(child.getComponentName());
                break;
            }
            case SUSPENDED_ON_ERROR: {
                this._suspended.add(child.getComponentName());
                break;
            }
            case PAUSED: {
                this._paused.add(child.getComponentName());
                break;
            }
            case SHUTDOWN: {
                this._shutdown.add(child.getComponentName());
            }
        }
    }

    private void resetStatusLists() {
        this._initializing.clear();
        this._retryingOnError.clear();
        this._suspended.clear();
        this._paused.clear();
        this._shutdown.clear();
    }

    public void addChildren(Collection<DatabusComponentStatus> children) {
        if (null == children) {
            return;
        }
        for (DatabusComponentStatus child : children) {
            this.addChild(child);
        }
    }

    public void addChild(DatabusComponentStatus child) {
        this._children.put(child.getComponentName(), child);
        this.processChildStatus(child);
    }

    public Map<String, DatabusComponentStatus> getChildren() {
        return this._readOnlyChildren;
    }

    public List<String> getInitializing() {
        return this._initializingRO;
    }

    public List<String> getSuspended() {
        return this._suspendedRO;
    }

    public List<String> getPaused() {
        return this._pausedRO;
    }

    public List<String> getShutdown() {
        return this._shutdownRO;
    }

    public List<String> getRetryingOnError() {
        return this._retryingOnErrorRO;
    }

    @Override
    public DatabusComponentStatus.Status getStatus() {
        this.refreshStatus();
        return super.getStatus();
    }

    @Override
    public String getMessage() {
        this.refreshStatus();
        return super.getMessage();
    }

    @Override
    public DatabusComponentStatus getStatusSnapshot() {
        this.refreshStatus();
        return super.getStatusSnapshot();
    }

    @Override
    public boolean isRunningStatus() {
        this.refreshStatus();
        return super.isRunningStatus();
    }

    @Override
    public boolean isPausedStatus() {
        this.refreshStatus();
        return super.isPausedStatus();
    }

    @Override
    public synchronized void start() {
        for (Map.Entry<String, DatabusComponentStatus> entry : this._children.entrySet()) {
            try {
                entry.getValue().start();
            }
            catch (RuntimeException e) {
                entry.getValue().suspendOnError(e);
            }
        }
        super.start();
        this.refreshStatus();
    }

    @Override
    public void shutdown() {
        for (Map.Entry<String, DatabusComponentStatus> entry : this._children.entrySet()) {
            try {
                entry.getValue().shutdown();
            }
            catch (RuntimeException e) {
                entry.getValue().suspendOnError(e);
            }
        }
        super.shutdown();
        this.refreshStatus();
    }

    @Override
    public void pause() {
        for (Map.Entry<String, DatabusComponentStatus> entry : this._children.entrySet()) {
            try {
                entry.getValue().pause();
            }
            catch (RuntimeException e) {
                entry.getValue().suspendOnError(e);
            }
        }
        super.pause();
        this.refreshStatus();
    }

    @Override
    public void resume() {
        for (Map.Entry<String, DatabusComponentStatus> entry : this._children.entrySet()) {
            try {
                entry.getValue().resume();
            }
            catch (RuntimeException e) {
                entry.getValue().suspendOnError(e);
            }
        }
        super.resume();
        this.refreshStatus();
    }

    @Override
    public void suspendOnError(Throwable error) {
        super.suspendOnError(error);
        this.refreshStatus();
    }

    public synchronized void refreshStatus() {
        long now = System.currentTimeMillis();
        if (now - this._lastStatusCheckMs < 5L) {
            return;
        }
        this._lastStatusCheckMs = now;
        this.resetStatusLists();
        for (Map.Entry<String, DatabusComponentStatus> entry : this._children.entrySet()) {
            this.processChildStatus(entry.getValue());
        }
    }
}

