/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus.core.DbusEventBufferMult;
import com.linkedin.databus.core.data_model.PhysicalPartition;
import com.linkedin.databus.core.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class CheckpointMult {
    public static final String MODULE = DbusEventBufferMult.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final Map<PhysicalPartition, Checkpoint> _pPart2Checkpoint = new HashMap<PhysicalPartition, Checkpoint>();
    private static final ObjectMapper _mapper = new ObjectMapper();
    private static final String CURSOR_PARTITION_KEY = "cursorPartition";
    private PhysicalPartition _cursorPartition = null;
    private PhysicalPartition _partialWindowPartition = null;

    public PhysicalPartition getPartialWindowPartition() {
        return this._partialWindowPartition;
    }

    public CheckpointMult() {
    }

    public CheckpointMult(String checkpointString) throws JsonParseException, JsonMappingException, InvalidParameterSpecException, IOException {
        if (null != checkpointString) {
            Map map = (Map)_mapper.readValue((InputStream)new ByteArrayInputStream(checkpointString.getBytes(Charset.defaultCharset())), Map.class);
            boolean debugEnabled = LOG.isDebugEnabled();
            for (Map.Entry m : map.entrySet()) {
                if (((String)m.getKey()).equals(CURSOR_PARTITION_KEY)) {
                    this._cursorPartition = PhysicalPartition.createFromJsonString((String)m.getValue());
                    continue;
                }
                if (!((String)m.getKey()).startsWith("{")) {
                    if (!debugEnabled) continue;
                    LOG.debug((Object)("Ignoring checkpoint mult key" + (String)m.getKey()));
                    continue;
                }
                PhysicalPartition pPart = PhysicalPartition.createFromJsonString((String)m.getKey());
                String cpString = (String)m.getValue();
                Checkpoint cp = new Checkpoint(cpString);
                if (debugEnabled) {
                    LOG.debug((Object)("CPMULT constructor: pPart=" + pPart + ";cp=" + cp));
                }
                this._pPart2Checkpoint.put(pPart, cp);
                if (!cp.isPartialWindow()) continue;
                if (this._partialWindowPartition != null) {
                    throw new InvalidParameterSpecException("Multiple partitions with partial window:" + this._partialWindowPartition.toSimpleString() + " and " + pPart.toSimpleString());
                }
                this._partialWindowPartition = pPart;
            }
        }
    }

    public Checkpoint getCheckpoint(PhysicalPartition pPart) {
        return this._pPart2Checkpoint.get(pPart);
    }

    public void addCheckpoint(PhysicalPartition pPart, Checkpoint cp) {
        if (cp.isPartialWindow()) {
            if (this._partialWindowPartition != null && !this._partialWindowPartition.equals(pPart)) {
                throw new DatabusRuntimeException("Existing partition with partial window:" + this._partialWindowPartition.toSimpleString() + ",cannot allow partition " + pPart.toSimpleString());
            }
            this._partialWindowPartition = pPart;
        } else if (this._partialWindowPartition != null && pPart.equals(this._partialWindowPartition)) {
            this._partialWindowPartition = null;
        }
        this._pPart2Checkpoint.put(pPart, cp);
    }

    void serialize(OutputStream outStream) throws JsonGenerationException, JsonMappingException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HashMap<String, String> map = new HashMap<String, String>();
        boolean debugEnabled = LOG.isDebugEnabled();
        for (Map.Entry<PhysicalPartition, Checkpoint> e : this._pPart2Checkpoint.entrySet()) {
            baos.reset();
            Checkpoint cp = e.getValue();
            cp.serialize(baos);
            String pPartJson = e.getKey().toJsonString();
            String cpStr = StringUtils.bytesToString(baos.toByteArray());
            map.put(pPartJson, cpStr);
            if (!debugEnabled) continue;
            LOG.debug((Object)("phSourId=" + e.getKey() + ";cp =" + cpStr));
        }
        _mapper.writeValue(outStream, map);
    }

    public String toString() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            this.serialize(bs);
        }
        catch (IOException e) {
            LOG.warn((Object)"toString failed", (Throwable)e);
        }
        try {
            return bs.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "InvalidSerialization";
        }
    }

    public int getNumCheckponts() {
        return this._pPart2Checkpoint.size();
    }

    public PhysicalPartition getCursorPartition() {
        return this._cursorPartition;
    }

    public void setCursorPartition(PhysicalPartition cursorPartition) {
        this._cursorPartition = cursorPartition;
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof CheckpointMult)) {
            return false;
        }
        CheckpointMult otherCp = (CheckpointMult)other;
        boolean success = ((Object)this._pPart2Checkpoint).equals(otherCp._pPart2Checkpoint);
        return success;
    }

    public int hashCode() {
        return ((Object)this._pPart2Checkpoint).hashCode();
    }
}

