/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DbusClientMode;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.InternalDatabusEventsListenerAbstract;
import com.linkedin.databus.core.InvalidCheckpointException;
import com.linkedin.databus.core.util.Fnv1aHashImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class Checkpoint
extends InternalDatabusEventsListenerAbstract
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String MODULE = Checkpoint.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final long UNSET_BOOTSTRAP_START_NSECS = -1L;
    public static final long UNSET_TS_NSECS = -1L;
    public static final long UNSET_BOOTSTRAP_START_SCN = -1L;
    public static final long UNSET_BOOTSTRAP_SINCE_SCN = -1L;
    public static final long UNSET_BOOTSTRAP_TARGET_SCN = -1L;
    public static final int UNSET_BOOTSTRAP_INDEX = 0;
    public static final long UNSET_ONLINE_PREVSCN = -1L;
    public static final long WINDOW_SCN_FOR_PURE_TIMEBASED_CKPT = 0L;
    public static final String NO_SOURCE_NAME = "";
    public static final Long FULLY_CONSUMED_WINDOW_OFFSET = -1L;
    public static final Long DEFAULT_SNAPSHOT_FILE_RECORD_OFFSET = -1L;
    private static final String TS_NSECS = "tsNsecs";
    private static final String WINDOW_SCN = "windowScn";
    private static final String WINDOW_OFFSET = "windowOffset";
    private static final String PREV_SCN = "prevScn";
    private static final String CONSUMPTION_MODE = "consumption_mode";
    private static final String BOOTSTRAP_START_SCN = "bootstrap_start_scn";
    private static final String SNAPSHOT_SOURCE = "snapshot_source";
    private static final String SNAPSHOT_OFFSET = "snapshot_offset";
    private static final String CATCHUP_SOURCE = "catchup_source";
    private static final String BOOTSTRAP_TARGET_SCN = "bootstrap_target_scn";
    private static final String BOOTSTRAP_SINCE_SCN = "bootstrap_since_scn";
    private static final String BOOTSTRAP_SNAPSHOT_SOURCE_INDEX = "bootstrap_snapshot_source_index";
    private static final String BOOTSTRAP_CATCHUP_SOURCE_INDEX = "bootstrap_catchup_source_index";
    public static final String BOOTSTRAP_SERVER_INFO = "bootstrap_server_info";
    public static final String SNAPSHOT_FILE_RECORD_OFFSET = "bootstrap_snapshot_file_record_offset";
    public static final String STORAGE_CLUSTER_NAME = "storage_cluster_name";
    public static final String BOOTSTRAP_START_TSNSECS = "bootstrap_start_tsnsecs";
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Map<String, Object> internalData = new HashMap<String, Object>();
    private long currentWindowScn;
    private long prevWindowScn;
    private long currentWindowOffset;
    private long snapShotOffset;

    public Checkpoint(String serializedCheckpoint) throws JsonParseException, JsonMappingException, IOException {
        this();
        this.internalData.putAll((Map)mapper.readValue((InputStream)new ByteArrayInputStream(serializedCheckpoint.getBytes(Charset.defaultCharset())), Map.class));
        this.mapToInternalState();
    }

    private void mapToInternalState() {
        this.currentWindowScn = this.internalData.get(WINDOW_SCN) != null ? ((Number)this.internalData.get(WINDOW_SCN)).longValue() : -1L;
        this.prevWindowScn = this.internalData.get(PREV_SCN) != null ? ((Number)this.internalData.get(PREV_SCN)).longValue() : -1L;
        this.currentWindowOffset = this.internalData.get(WINDOW_OFFSET) != null ? ((Number)this.internalData.get(WINDOW_OFFSET)).longValue() : FULLY_CONSUMED_WINDOW_OFFSET.longValue();
        this.snapShotOffset = this.internalData.get(SNAPSHOT_OFFSET) != null ? ((Number)this.internalData.get(SNAPSHOT_OFFSET)).longValue() : -1L;
    }

    private void internalStateToMap() {
        this.internalData.put(WINDOW_SCN, this.currentWindowScn);
        this.internalData.put(PREV_SCN, this.prevWindowScn);
        this.internalData.put(WINDOW_OFFSET, this.currentWindowOffset);
        this.internalData.put(SNAPSHOT_OFFSET, this.snapShotOffset);
    }

    public Checkpoint() {
        this.init();
    }

    public void init() {
        this.currentWindowScn = -1L;
        this.prevWindowScn = -1L;
        this.currentWindowOffset = FULLY_CONSUMED_WINDOW_OFFSET;
        this.snapShotOffset = -1L;
        this.internalData.clear();
        this.setConsumptionMode(DbusClientMode.INIT);
    }

    public void setTsNsecs(long nsecs) {
        this.internalData.put(TS_NSECS, nsecs);
    }

    public long getTsNsecs() {
        return Checkpoint.number2Long((Number)this.internalData.get(TS_NSECS), -1L);
    }

    public void setBootstrapStartNsecs(long nsecs) {
        this.internalData.put(BOOTSTRAP_START_TSNSECS, nsecs);
    }

    public long getBootstrapStartNsecs() {
        return Checkpoint.number2Long((Number)this.internalData.get(BOOTSTRAP_START_TSNSECS), -1L);
    }

    public void setBootstrapSnapshotSourceIndex(int index) {
        this.internalData.put(BOOTSTRAP_SNAPSHOT_SOURCE_INDEX, index);
    }

    public void setBootstrapCatchupSourceIndex(int index) {
        this.internalData.put(BOOTSTRAP_CATCHUP_SOURCE_INDEX, index);
    }

    int nextBootstrapSnapshotSourceIndex() {
        int index = this.getBootstrapSnapshotSourceIndex();
        return index + 1;
    }

    int nextBootstrapCatchupSourceIndex() {
        int index = this.getBootstrapCatchupSourceIndex();
        return index + 1;
    }

    public void setBootstrapServerInfo(String serverInfoStr) {
        this.internalData.put(BOOTSTRAP_SERVER_INFO, serverInfoStr);
    }

    public String getBootstrapServerInfo() {
        Object obj = this.internalData.get(BOOTSTRAP_SERVER_INFO);
        if (null == obj) {
            return null;
        }
        return (String)obj;
    }

    public void setWindowScn(Long windowScn) {
        if (DbusClientMode.BOOTSTRAP_CATCHUP == this.getConsumptionMode() && !this.isBootstrapTargetScnSet()) {
            throw new InvalidCheckpointException("target SCN must be set for catchup to proceed", this);
        }
        this.currentWindowScn = windowScn;
    }

    public void setPrevScn(Long windowScn) {
        this.prevWindowScn = windowScn;
    }

    public long getPrevScn() {
        return this.prevWindowScn;
    }

    public void setWindowOffset(long windowOffset) {
        if (DbusClientMode.BOOTSTRAP_CATCHUP == this.getConsumptionMode() && !this.isBootstrapTargetScnSet()) {
            throw new InvalidCheckpointException("target SCN must be set for catchup to proceed", this);
        }
        this.currentWindowOffset = windowOffset;
    }

    @Deprecated
    public void setWindowOffset(Integer windowOffset) {
        this.currentWindowOffset = windowOffset.longValue();
    }

    public void setConsumptionMode(DbusClientMode mode) {
        this.internalData.put(CONSUMPTION_MODE, mode.toString());
    }

    public void setBootstrapStartScn(Long bootstrapStartScn) {
        if (this.isBootstrapStartScnSet() && bootstrapStartScn != -1L) {
            throw new InvalidCheckpointException("bootstrap_start_scn is already set", this);
        }
        if (bootstrapStartScn != -1L && DbusClientMode.BOOTSTRAP_SNAPSHOT != this.getConsumptionMode()) {
            throw new InvalidCheckpointException("not in bootstrap snapshot mode", this);
        }
        if (bootstrapStartScn != -1L && bootstrapStartScn < 0L) {
            throw new InvalidCheckpointException("invalid bootstra_start_scn value:" + bootstrapStartScn, this);
        }
        this.internalData.put(BOOTSTRAP_START_SCN, bootstrapStartScn);
    }

    public void setSnapshotSource(int sourceIndex, String sourceName) {
        this.internalData.put(SNAPSHOT_SOURCE, sourceName);
        this.setBootstrapSnapshotSourceIndex(sourceIndex);
    }

    public void setSnapshotOffset(long snapshotOffset) {
        if (snapshotOffset != 0L && !this.isBootstrapStartScnSet()) {
            throw new InvalidCheckpointException("cannot snapshot without bootstrap_start_scn", this);
        }
        this.internalData.put(SNAPSHOT_OFFSET, snapshotOffset);
        this.snapShotOffset = snapshotOffset;
    }

    protected void clearSnapshotOffset() {
        this.internalData.put(SNAPSHOT_OFFSET, FULLY_CONSUMED_WINDOW_OFFSET);
        this.snapShotOffset = FULLY_CONSUMED_WINDOW_OFFSET;
    }

    @Deprecated
    public void setSnapshotOffset(Integer snapshotOffset) {
        this.internalData.put(SNAPSHOT_OFFSET, snapshotOffset);
    }

    protected void setCatchupSource(int sourceIndex, String sourceName) {
        this.setBootstrapCatchupSourceIndex(sourceIndex);
        this.internalData.put(CATCHUP_SOURCE, sourceName);
    }

    public void setCatchupOffset(Integer catchupOffset) {
        this.setWindowOffset(catchupOffset.longValue());
        this.internalData.put(WINDOW_OFFSET, catchupOffset);
    }

    public void setBootstrapTargetScn(Long targetScn) {
        if (-1L != targetScn) {
            if (targetScn < this.getBootstrapStartScn()) {
                throw new InvalidCheckpointException("bootstrap_target_scn cannot be smaller than bootstrap_start_scn", this);
            }
            if (!this.isSnapShotSourceCompleted()) {
                throw new InvalidCheckpointException("snapshot should be complete before setting bootstrap_target_scn", this);
            }
        }
        this.internalData.put(BOOTSTRAP_TARGET_SCN, targetScn);
    }

    public void setBootstrapSinceScn(Long sinceScn) {
        this.internalData.put(BOOTSTRAP_SINCE_SCN, sinceScn);
    }

    public long getWindowScn() {
        return this.currentWindowScn;
    }

    public Long getWindowOffset() {
        return this.currentWindowOffset;
    }

    public DbusClientMode getConsumptionMode() {
        return DbusClientMode.valueOf((String)this.internalData.get(CONSUMPTION_MODE));
    }

    public String getSnapshotSource() {
        return (String)this.internalData.get(SNAPSHOT_SOURCE);
    }

    public long getSnapshotFileRecordOffset() {
        return Checkpoint.number2Long((Number)this.internalData.get(SNAPSHOT_FILE_RECORD_OFFSET), DEFAULT_SNAPSHOT_FILE_RECORD_OFFSET);
    }

    public void setSnapshotFileRecordOffset(long snapshotFileRecordOffset) {
        this.internalData.put(SNAPSHOT_FILE_RECORD_OFFSET, snapshotFileRecordOffset);
    }

    public String getStorageClusterName() {
        return (String)this.internalData.get(STORAGE_CLUSTER_NAME);
    }

    public void setStorageClusterName(String storageClusterName) {
        this.internalData.put(STORAGE_CLUSTER_NAME, storageClusterName);
    }

    private static Long number2Long(Number n, Long nullValue) {
        return null == n ? nullValue : (n instanceof Long ? ((Long)n).longValue() : n.longValue());
    }

    private static Integer number2Integer(Number n, Integer nullValue) {
        return null == n ? nullValue : (n instanceof Integer ? ((Integer)n).intValue() : n.intValue());
    }

    public Long getSnapshotOffset() {
        return Checkpoint.number2Long((Number)this.internalData.get(SNAPSHOT_OFFSET), FULLY_CONSUMED_WINDOW_OFFSET);
    }

    public String getCatchupSource() {
        return (String)this.internalData.get(CATCHUP_SOURCE);
    }

    public Long getBootstrapStartScn() {
        Number n = (Number)this.internalData.get(BOOTSTRAP_START_SCN);
        return Checkpoint.number2Long(n, -1L);
    }

    public Long getBootstrapTargetScn() {
        Number n = (Number)this.internalData.get(BOOTSTRAP_TARGET_SCN);
        return Checkpoint.number2Long(n, -1L);
    }

    public Integer getBootstrapSnapshotSourceIndex() {
        Number n = (Number)this.internalData.get(BOOTSTRAP_SNAPSHOT_SOURCE_INDEX);
        return Checkpoint.number2Integer(n, 0);
    }

    public Integer getBootstrapCatchupSourceIndex() {
        Number n = (Number)this.internalData.get(BOOTSTRAP_CATCHUP_SOURCE_INDEX);
        return Checkpoint.number2Integer(n, 0);
    }

    public Long getBootstrapSinceScn() {
        Number n = (Number)this.internalData.get(BOOTSTRAP_SINCE_SCN);
        return Checkpoint.number2Long(n, -1L);
    }

    public void serialize(OutputStream outStream) throws JsonGenerationException, JsonMappingException, IOException {
        this.internalStateToMap();
        mapper.writeValue(outStream, this.internalData);
    }

    public String toString() {
        this.internalStateToMap();
        try {
            return mapper.writeValueAsString(this.internalData);
        }
        catch (JsonGenerationException e) {
            LOG.error((Object)("JSON generation error: " + e.getMessage()), (Throwable)e);
            return "JsonGenerationException while printing Checkpoint.";
        }
        catch (JsonMappingException e) {
            LOG.error((Object)("JSON mapping error: " + e.getMessage()), (Throwable)e);
            return "JsonMappingException while printing Checkpoint.";
        }
        catch (IOException e) {
            LOG.error((Object)("JSON IO error: " + e.getMessage()), (Throwable)e);
            return "IOException while printing Checkpoint.";
        }
    }

    public void startEvent() {
    }

    @Override
    public void onEvent(DbusEvent e, long offset, int size) {
        this.onEvent(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void onEvent(DbusEvent e) {
        if (e.isEndOfPeriodMarker()) {
            this.prevWindowScn = e.sequence();
            this.endEvents(e.sequence(), e.timestampInNanos());
        } else if (e.isCheckpointMessage()) {
            ckpt = null;
            try {
                tmpBuffer = e.value();
                valueBytes = new byte[tmpBuffer.limit()];
                tmpBuffer.get(valueBytes);
                ckpt = new Checkpoint(new String(valueBytes, "UTF-8"));
                switch (1.$SwitchMap$com$linkedin$databus$core$DbusClientMode[this.getConsumptionMode().ordinal()]) {
                    case 1: {
                        this.copyBootstrapSnapshotCheckpoint(ckpt);
                        ** break;
lbl17:
                        // 1 sources

                    }
                    case 2: {
                        this.copyBootstrapCatchupCheckpoint(ckpt);
                        ** break;
lbl21:
                        // 1 sources

                    }
                    case 3: {
                        this.copyOnlineCheckpoint(ckpt);
                        ** break;
lbl25:
                        // 1 sources

                    }
                    default: {
                        throw new RuntimeException("Invalid checkpoint message received: " + this);
                    }
                }
            }
            catch (Exception exception) {
                Checkpoint.LOG.error((Object)"Exception encountered while reading checkpiont from bootstrap service", (Throwable)exception);
            }
            finally {
                if (null != ckpt) {
                    ckpt.close();
                }
            }
        } else if (this.currentWindowScn == e.sequence()) {
            ++this.currentWindowOffset;
        } else {
            this.currentWindowScn = e.sequence();
            this.currentWindowOffset = 1L;
        }
        if (Checkpoint.LOG.isDebugEnabled()) {
            Checkpoint.LOG.info((Object)("CurrentWindowSCN : " + this.currentWindowScn + ", currentWindowOffset :" + this.currentWindowOffset + ", PrevSCN :" + this.prevWindowScn));
        }
    }

    protected void copyBootstrapCatchupCheckpoint(Checkpoint ckpt) {
        this.setWindowScn(ckpt.getWindowScn());
        this.setWindowOffset(ckpt.getWindowOffset());
        this.setSnapshotFileRecordOffset(ckpt.getSnapshotFileRecordOffset());
    }

    protected void copyBootstrapSnapshotCheckpoint(Checkpoint ckpt) {
        this.setSnapshotOffset(ckpt.getSnapshotOffset());
        this.setSnapshotSource(ckpt.getBootstrapSnapshotSourceIndex(), ckpt.getSnapshotSource());
        this.setSnapshotFileRecordOffset(ckpt.getSnapshotFileRecordOffset());
    }

    private void copyOnlineCheckpoint(Checkpoint fromCkpt) {
        this.setWindowScn(fromCkpt.getWindowScn());
        this.setWindowOffset(fromCkpt.getWindowOffset());
    }

    private void endEvents(long endWindowScn, long nsecs) {
        this.setFullyConsumed(endWindowScn);
        this.setTsNsecs(nsecs);
    }

    private void setFullyConsumed(long endWindowScn) {
        this.currentWindowOffset = FULLY_CONSUMED_WINDOW_OFFSET;
        this.clearWindowOffset();
        this.setWindowScn(endWindowScn);
    }

    public void onSnapshotEvent(long snapshotOffset) {
        this.snapShotOffset = snapshotOffset;
    }

    public void onCatchupEvent(long eventWindowScn, long catchupOffset) {
        this.currentWindowScn = eventWindowScn;
        this.currentWindowOffset = catchupOffset;
    }

    public void startSnapShotSource() {
        this.setSnapshotOffset(0L);
    }

    public void endSnapShotSource() {
        this.setSnapshotOffset(-1L);
    }

    public boolean isSnapShotSourceCompleted() {
        return this.getSnapshotOffset() == -1L;
    }

    public void startCatchupSource() {
        this.setWindowOffset(0L);
        this.setWindowScn(this.getBootstrapStartScn());
    }

    public void endCatchupSource() {
        this.setFullyConsumed(this.currentWindowScn);
        this.setWindowOffset(FULLY_CONSUMED_WINDOW_OFFSET);
    }

    public boolean isCatchupSourceCompleted() {
        return this.getWindowOffset() == FULLY_CONSUMED_WINDOW_OFFSET;
    }

    public void bootstrapCheckPoint() {
        if (this.getConsumptionMode() == DbusClientMode.BOOTSTRAP_CATCHUP) {
            this.setWindowOffset(this.currentWindowOffset);
            this.setWindowScn(this.currentWindowScn);
        } else if (this.getConsumptionMode() == DbusClientMode.BOOTSTRAP_SNAPSHOT) {
            this.setSnapshotOffset(this.snapShotOffset);
        }
    }

    private void clearWindowOffset() {
        this.internalData.remove(WINDOW_OFFSET);
    }

    public void checkPoint() {
        if (this.currentWindowScn >= 0L) {
            this.setWindowScn(this.currentWindowScn);
        }
        if (this.currentWindowOffset >= 0L) {
            this.setWindowOffset(this.currentWindowOffset);
        }
    }

    public boolean isPartialWindow() {
        return this.currentWindowOffset >= 0L;
    }

    @Deprecated
    public void setInit() {
        this.setConsumptionMode(DbusClientMode.INIT);
    }

    public boolean getInit() {
        return this.getConsumptionMode() == DbusClientMode.INIT;
    }

    public void setFlexible() {
        this.setConsumptionMode(DbusClientMode.ONLINE_CONSUMPTION);
        this.setWindowScn(-1L);
        this.setTsNsecs(-1L);
    }

    public boolean getFlexible() {
        return this.getConsumptionMode() == DbusClientMode.ONLINE_CONSUMPTION && this.getWindowScn() < 0L && this.getTsNsecs() == -1L;
    }

    public void clearBootstrapStartTsNsecs() {
        this.setBootstrapStartNsecs(-1L);
    }

    public void clearBootstrapSinceScn() {
        this.setBootstrapSinceScn(-1L);
    }

    public void clearBootstrapStartScn() {
        this.setBootstrapStartScn(-1L);
    }

    public void clearBootstrapTargetScn() {
        this.setBootstrapTargetScn(-1L);
    }

    public boolean isBootstrapStartScnSet() {
        return null != this.getBootstrapStartScn() && -1L != this.getBootstrapStartScn();
    }

    public boolean isBootstrapTargetScnSet() {
        return null != this.getBootstrapTargetScn() && -1L != this.getBootstrapTargetScn();
    }

    public boolean isBootstrapSinceScnSet() {
        return null != this.getBootstrapSinceScn() && -1L != this.getBootstrapSinceScn();
    }

    public void resetBootstrap() {
        this.clearBootstrapSinceScn();
        this.clearSnapshotOffset();
        this.setWindowOffset(FULLY_CONSUMED_WINDOW_OFFSET);
        this.clearBootstrapStartScn();
        this.clearBootstrapTargetScn();
        this.setBootstrapSnapshotSourceIndex(0);
        this.setBootstrapCatchupSourceIndex(0);
        this.setBootstrapServerInfo(null);
        this.setSnapshotFileRecordOffset(DEFAULT_SNAPSHOT_FILE_RECORD_OFFSET);
        this.setStorageClusterName(NO_SOURCE_NAME);
        this.clearBootstrapStartTsNsecs();
    }

    protected void resetForServerChange() {
        this.setConsumptionMode(DbusClientMode.BOOTSTRAP_SNAPSHOT);
        this.setSnapshotOffset(0L);
        this.setWindowOffset(FULLY_CONSUMED_WINDOW_OFFSET);
        this.setWindowScn(this.getBootstrapSinceScn());
        this.clearBootstrapStartScn();
        this.clearBootstrapTargetScn();
        this.setBootstrapSnapshotSourceIndex(0);
        this.setBootstrapCatchupSourceIndex(0);
        this.setBootstrapServerInfo(null);
        this.setSnapshotFileRecordOffset(DEFAULT_SNAPSHOT_FILE_RECORD_OFFSET);
        this.setStorageClusterName(NO_SOURCE_NAME);
    }

    @Override
    public void close() {
    }

    public Checkpoint clone() {
        Checkpoint ckpt = new Checkpoint();
        ckpt.currentWindowOffset = this.currentWindowOffset;
        ckpt.currentWindowScn = this.currentWindowScn;
        ckpt.prevWindowScn = this.prevWindowScn;
        ckpt.snapShotOffset = this.snapShotOffset;
        for (Map.Entry<String, Object> srcEntry : this.internalData.entrySet()) {
            ckpt.internalData.put(srcEntry.getKey(), srcEntry.getValue());
        }
        return ckpt;
    }

    public static Checkpoint createFlexibleCheckpoint() {
        Checkpoint cp = new Checkpoint();
        cp.setFlexible();
        return cp;
    }

    public static Checkpoint createOnlineConsumptionCheckpoint(long lastConsumedScn) {
        if (lastConsumedScn < 0L) {
            throw new InvalidCheckpointException("scn must be non-negative: " + lastConsumedScn, null);
        }
        Checkpoint cp = new Checkpoint();
        cp.setConsumptionMode(DbusClientMode.ONLINE_CONSUMPTION);
        cp.setWindowScn(lastConsumedScn);
        cp.setPrevScn(lastConsumedScn);
        cp.setWindowOffset(FULLY_CONSUMED_WINDOW_OFFSET);
        return cp;
    }

    public static Checkpoint createOnlineConsumptionCheckpoint(long lastConsumedScn, long tsNanos) {
        Checkpoint cp = Checkpoint.createOnlineConsumptionCheckpoint(lastConsumedScn);
        cp.setTsNsecs(tsNanos);
        return cp;
    }

    public boolean equals(Object other) {
        boolean success;
        if (null == other) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof Checkpoint)) {
            return false;
        }
        Checkpoint otherCp = (Checkpoint)other;
        boolean bl = success = this.currentWindowScn == otherCp.currentWindowScn && this.prevWindowScn == otherCp.prevWindowScn && this.currentWindowOffset == otherCp.currentWindowOffset && this.snapShotOffset == otherCp.getSnapshotOffset();
        if (success) {
            for (Map.Entry<String, Object> e : this.internalData.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                Object otherV = otherCp.internalData.get(k);
                success = v instanceof Number ? otherV instanceof Number && ((Number)v).longValue() == ((Number)otherV).longValue() : v.equals(otherV);
                if (success) continue;
                break;
            }
        }
        return success;
    }

    public int hashCode() {
        long lhash = Fnv1aHashImpl.init32();
        DbusClientMode mode = this.getConsumptionMode();
        lhash = Fnv1aHashImpl.addInt32(lhash, mode.ordinal());
        lhash = Fnv1aHashImpl.addLong32(lhash, this.currentWindowScn);
        lhash = Fnv1aHashImpl.addLong32(lhash, this.prevWindowScn);
        lhash = Fnv1aHashImpl.addLong32(lhash, this.currentWindowOffset);
        lhash = Fnv1aHashImpl.addLong32(lhash, this.getTsNsecs());
        if (DbusClientMode.BOOTSTRAP_CATCHUP == mode || DbusClientMode.BOOTSTRAP_SNAPSHOT == mode) {
            lhash = Fnv1aHashImpl.addLong32(lhash, this.snapShotOffset);
            lhash = Fnv1aHashImpl.addLong32(lhash, this.getBootstrapSinceScn());
            lhash = Fnv1aHashImpl.addLong32(lhash, this.getBootstrapStartScn());
            lhash = Fnv1aHashImpl.addLong32(lhash, this.getBootstrapTargetScn());
            lhash = Fnv1aHashImpl.addLong32(lhash, this.getBootstrapCatchupSourceIndex().intValue());
            lhash = Fnv1aHashImpl.addLong32(lhash, this.getBootstrapSnapshotSourceIndex().intValue());
            lhash = Fnv1aHashImpl.addLong32(lhash, this.getSnapshotFileRecordOffset());
            lhash = Fnv1aHashImpl.addLong32(lhash, this.getBootstrapStartNsecs());
        }
        return Fnv1aHashImpl.getHash32(lhash);
    }

    public boolean assertCheckpoint() {
        switch (this.getConsumptionMode()) {
            case INIT: {
                return true;
            }
            case ONLINE_CONSUMPTION: {
                return this.assertOnlineCheckpoint();
            }
            case BOOTSTRAP_SNAPSHOT: {
                return this.assertSnapshotCheckpoint();
            }
            case BOOTSTRAP_CATCHUP: {
                return this.assertCatchupCheckpoint();
            }
        }
        throw new InvalidCheckpointException("unknown checkpoint type", this);
    }

    private boolean assertCatchupCheckpoint() {
        this.assertCatchupSourceIndex();
        if (!this.isBootstrapSinceScnSet()) {
            throw new InvalidCheckpointException("bootstrap_since_scn must be set", this);
        }
        if (!this.isBootstrapStartScnSet()) {
            throw new InvalidCheckpointException("bootstrap_start_scn must be set", this);
        }
        if (!this.isBootstrapTargetScnSet()) {
            throw new InvalidCheckpointException("bootstrap_target_scn must be set", this);
        }
        if (!this.isSnapShotSourceCompleted()) {
            throw new InvalidCheckpointException("bootstrap_snapshot_offset must be -1 for CATCHUP checkpoints", this);
        }
        if (this.getBootstrapTargetScn() < this.getBootstrapStartScn()) {
            throw new InvalidCheckpointException("bootstrap_target_scn < getbootstrap_start_scn", this);
        }
        if (this.getSnapshotFileRecordOffset() != DEFAULT_SNAPSHOT_FILE_RECORD_OFFSET.longValue() && this.getStorageClusterName().isEmpty()) {
            throw new InvalidCheckpointException("snapshot file record offset cannot be set when storage cluster name is empty", this);
        }
        return true;
    }

    private boolean assertSnapshotCheckpoint() {
        if (0 != this.getBootstrapCatchupSourceIndex()) {
            throw new InvalidCheckpointException("bootstrap_catchup_source_index must be 0", this);
        }
        if (!this.isBootstrapSinceScnSet()) {
            throw new InvalidCheckpointException("bootstrap_since_scn must be set", this);
        }
        if (!this.isBootstrapStartScnSet()) {
            if (0 != this.getBootstrapSnapshotSourceIndex()) {
                throw new InvalidCheckpointException("bootstrap_snapshot_source_index must be 0 when bootstrap_start_scn is not set", this);
            }
            if (0L != this.getSnapshotOffset()) {
                throw new InvalidCheckpointException("snapshot_offset must be 0 when bootstrap_start_scn is not set", this);
            }
            if (this.isBootstrapTargetScnSet()) {
                throw new InvalidCheckpointException("bootstrap_target_scn cannot be set when bootstrap_start_scn is not set", this);
            }
        }
        if (this.getSnapshotFileRecordOffset() != DEFAULT_SNAPSHOT_FILE_RECORD_OFFSET.longValue() && this.getStorageClusterName().isEmpty()) {
            throw new InvalidCheckpointException("snapshot file record offset cannot be set when storage cluster name is empty", this);
        }
        return true;
    }

    private boolean assertOnlineCheckpoint() {
        if (this.getFlexible()) {
            long tsNsecs = this.getTsNsecs();
            if (tsNsecs != -1L) {
                throw new InvalidCheckpointException("unexpected tsNsecs:" + tsNsecs, this);
            }
            return true;
        }
        if (this.getWindowScn() < 0L) {
            throw new InvalidCheckpointException("unexpected windowScn: " + this.getWindowScn(), this);
        }
        long ofs = this.getWindowOffset();
        if (ofs < 0L && FULLY_CONSUMED_WINDOW_OFFSET != ofs) {
            throw new InvalidCheckpointException("unexpected windowOfs: " + this.getWindowOffset(), this);
        }
        if (FULLY_CONSUMED_WINDOW_OFFSET == ofs && -1L != this.getPrevScn() && this.getPrevScn() != this.getWindowScn()) {
            throw new InvalidCheckpointException("prevScn != windowScn for a fully consumed window ", this);
        }
        if (this.getPrevScn() > this.getWindowScn()) {
            throw new InvalidCheckpointException("prevScn > windowScn", this);
        }
        return true;
    }

    private void assertCatchupSourceIndex() {
        int catchupSourceIndex = this.getBootstrapCatchupSourceIndex();
        int snapshotSourceIndex = this.getBootstrapSnapshotSourceIndex();
        if (0 > catchupSourceIndex || catchupSourceIndex > snapshotSourceIndex) {
            throw new InvalidCheckpointException("invalid catchup source index for using sources ", this);
        }
    }
}

