/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus.core.DbusClientMode;
import com.linkedin.databus.core.InvalidCheckpointException;
import java.util.Arrays;
import java.util.List;

public class BootstrapCheckpointHandler {
    private String[] _sourceNames;

    public BootstrapCheckpointHandler(List<String> sourceNames) {
        assert (null != sourceNames);
        assert (sourceNames.size() > 0);
        this._sourceNames = sourceNames.toArray(new String[sourceNames.size()]);
    }

    public BootstrapCheckpointHandler(String ... sourceNames) {
        assert (null != sourceNames);
        assert (sourceNames.length > 0);
        this._sourceNames = Arrays.copyOf(sourceNames, sourceNames.length);
    }

    public void setSourceNames(List<String> sourceNames) {
        this._sourceNames = sourceNames.toArray(new String[sourceNames.size()]);
    }

    public boolean needsMoreCatchup(Checkpoint ckpt) {
        int snapshotSourceIndex = ckpt.getBootstrapSnapshotSourceIndex();
        int catchupSourceIndex = ckpt.getBootstrapCatchupSourceIndex();
        return catchupSourceIndex < snapshotSourceIndex;
    }

    public boolean needsMoreSnapshot(Checkpoint ckpt) {
        int snapshotSourceIndex = ckpt.getBootstrapSnapshotSourceIndex();
        return snapshotSourceIndex < this._sourceNames.length;
    }

    public Checkpoint createInitialBootstrapCheckpoint(Checkpoint ckpt, Long sinceScn) {
        if (sinceScn < 0L) {
            throw new DatabusRuntimeException("sinceScn must be non-negative:" + sinceScn);
        }
        if (null == ckpt) {
            ckpt = new Checkpoint();
        }
        ckpt.resetBootstrap();
        ckpt.setConsumptionMode(DbusClientMode.BOOTSTRAP_SNAPSHOT);
        ckpt.setBootstrapSinceScn(sinceScn);
        this.setSnapshotSource(ckpt, 0);
        this.setCatchupSource(ckpt, 0);
        ckpt.startSnapShotSource();
        return ckpt;
    }

    public boolean needsMoreCowbell(Checkpoint ckpt) {
        return true;
    }

    public void finalizeSnapshotPhase(Checkpoint ckpt) {
        this.assertBootstrapCheckpoint(ckpt);
        ckpt.endSnapShotSource();
    }

    public void finalizeCatchupPhase(Checkpoint ckpt) {
        this.assertBootstrapCheckpoint(ckpt);
        ckpt.endCatchupSource();
    }

    public void advanceAfterSnapshotPhase(Checkpoint ckpt) {
        this.assertBootstrapCheckpoint(ckpt);
        if (!this.needsMoreSnapshot(ckpt)) {
            throw new InvalidCheckpointException("unexpected endSnapshotSource", ckpt);
        }
        int snapshotSourceIndex = ckpt.nextBootstrapSnapshotSourceIndex();
        this.setSnapshotSource(ckpt, snapshotSourceIndex);
        this.setCatchupSource(ckpt, 0);
    }

    public void advanceAfterCatchupPhase(Checkpoint ckpt) {
        this.assertBootstrapCheckpoint(ckpt);
        if (!this.needsMoreCatchup(ckpt)) {
            throw new InvalidCheckpointException("unexpected endCatchupSource", ckpt);
        }
        int catchupSourceIndex = ckpt.nextBootstrapCatchupSourceIndex();
        this.setCatchupSource(ckpt, catchupSourceIndex);
        if (this.needsMoreCatchup(ckpt)) {
            this.startCatchupSource(ckpt);
        } else if (this.needsMoreSnapshot(ckpt)) {
            this.startNextSnapshotSource(ckpt);
        }
    }

    public void advanceAfterTargetScn(Checkpoint ckpt) {
        this.assertBootstrapCheckpoint(ckpt);
        if (!ckpt.isBootstrapTargetScnSet()) {
            throw new InvalidCheckpointException("bootstrap_target_scn must be set", ckpt);
        }
        if (0 != ckpt.getBootstrapCatchupSourceIndex()) {
            throw new InvalidCheckpointException("bootstrap_catchup_source_index must be 0", ckpt);
        }
        this.startCatchupSource(ckpt);
    }

    public boolean assertBootstrapCheckpoint(Checkpoint ckpt) {
        assert (null != ckpt);
        if (!ckpt.assertCheckpoint()) {
            return false;
        }
        switch (ckpt.getConsumptionMode()) {
            case BOOTSTRAP_SNAPSHOT: {
                return this.assertSnapshotCheckpoint(ckpt);
            }
            case BOOTSTRAP_CATCHUP: {
                return this.assertCatchupCheckpoint(ckpt);
            }
        }
        throw new InvalidCheckpointException("not a bootstrap checkpoint", ckpt);
    }

    public void resetForServerChange(Checkpoint ckpt) {
        ckpt.resetForServerChange();
        int snapshotSourceIndex = ckpt.getBootstrapSnapshotSourceIndex();
        int catchupSourceIndex = ckpt.getBootstrapCatchupSourceIndex();
        this.setSnapshotSource(ckpt, snapshotSourceIndex);
        this.setCatchupSource(ckpt, catchupSourceIndex);
    }

    private void startCatchupSource(Checkpoint ckpt) {
        if (!ckpt.isBootstrapStartScnSet()) {
            throw new InvalidCheckpointException("startScn not set for catchup", ckpt);
        }
        String source = this._sourceNames[ckpt.getBootstrapCatchupSourceIndex()];
        if (null == source) {
            throw new InvalidCheckpointException("no sources available for catchup", ckpt);
        }
        ckpt.setConsumptionMode(DbusClientMode.BOOTSTRAP_CATCHUP);
        ckpt.startCatchupSource();
    }

    private void startNextSnapshotSource(Checkpoint ckpt) {
        String source = this._sourceNames[ckpt.getBootstrapSnapshotSourceIndex()];
        if (null == source) {
            throw new RuntimeException("no sources available for snapshot");
        }
        ckpt.setConsumptionMode(DbusClientMode.BOOTSTRAP_SNAPSHOT);
        ckpt.startSnapShotSource();
        this.setCatchupSource(ckpt, 0);
    }

    private boolean assertSnapshotCheckpoint(Checkpoint ckpt) {
        this.assertSnapshotSourceIndex(ckpt);
        return true;
    }

    private void validateSnapshotSourceIndex(int snapshotSourceIndex, Checkpoint ckpt) {
        if (0 > snapshotSourceIndex || snapshotSourceIndex > this._sourceNames.length) {
            throw new InvalidCheckpointException("invalid snapshot source index " + snapshotSourceIndex + " for source names " + Arrays.toString(this._sourceNames), ckpt);
        }
    }

    private void assertSnapshotSourceIndex(Checkpoint ckpt) {
        int snapshotSourceIndex = ckpt.getBootstrapSnapshotSourceIndex();
        this.validateSnapshotSourceIndex(snapshotSourceIndex, ckpt);
        if (this._sourceNames.length > snapshotSourceIndex && !this._sourceNames[snapshotSourceIndex].equals(ckpt.getSnapshotSource())) {
            throw new InvalidCheckpointException("snapshot index/source name mismatch for source names " + Arrays.toString(this._sourceNames), ckpt);
        }
    }

    private boolean assertCatchupCheckpoint(Checkpoint ckpt) {
        this.assertSnapshotSourceIndex(ckpt);
        this.assertCatchupSourceIndex(ckpt);
        return true;
    }

    private void assertCatchupSourceIndex(Checkpoint ckpt) {
        int catchupSourceIndex = ckpt.getBootstrapCatchupSourceIndex();
        if (this._sourceNames.length > catchupSourceIndex && !this._sourceNames[catchupSourceIndex].equals(ckpt.getCatchupSource())) {
            throw new InvalidCheckpointException("catchup index/source name mismatch for source names " + Arrays.toString(this._sourceNames), ckpt);
        }
    }

    private void setCatchupSource(Checkpoint ckpt, int catchupSourceIndex) {
        if (catchupSourceIndex < this.getSourcesNamesListLength()) {
            ckpt.setCatchupSource(catchupSourceIndex, this._sourceNames[catchupSourceIndex]);
        } else if (catchupSourceIndex == this.getSourcesNamesListLength()) {
            ckpt.setCatchupSource(catchupSourceIndex, "");
        } else {
            throw new InvalidCheckpointException("invalid catchup source index " + catchupSourceIndex, ckpt);
        }
    }

    private void setSnapshotSource(Checkpoint ckpt, int snapshotSourceIndex) {
        if (snapshotSourceIndex < this.getSourcesNamesListLength()) {
            ckpt.setSnapshotSource(snapshotSourceIndex, this._sourceNames[snapshotSourceIndex]);
        } else if (snapshotSourceIndex == this.getSourcesNamesListLength()) {
            ckpt.setSnapshotSource(snapshotSourceIndex, "");
        } else {
            throw new InvalidCheckpointException("invalid snapshot source index " + snapshotSourceIndex, ckpt);
        }
    }

    private int getSourcesNamesListLength() {
        return this._sourceNames.length;
    }

    public void setStartScnAfterServerChange(Checkpoint ckpt, Long startScn) {
        ckpt.setBootstrapStartScn(startScn);
    }
}

