/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;

public class BaseCli {
    protected static final Level[] VERBOSITIES = new Level[]{Level.OFF, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.ALL};
    protected static final String CMD_LINE_PROPS_OPT_LONG_NAME = "cmdline_props";
    protected static final char CMD_LINE_PROPS_OPT_CHAR = 'c';
    protected static final String HELP_OPT_LONG_NAME = "help";
    protected static final char HELP_OPT_CHAR = 'h';
    protected static final String LOG4J_PROPS_OPT_LONG_NAME = "log_props";
    protected static final char LOG4J_PROPS_OPT_CHAR = 'l';
    protected static final String PROPS_FILE_OPT_LONG_NAME = "props_file";
    protected static final char PROPS_FILE_OPT_CHAR = 'p';
    protected static final String QUIET_OPT_LONG_NAME = "quiet";
    protected static final char QUIET_OPT_CHAR = 'q';
    protected static final String VERBOSE1_OPT_LONG_NAME = "v";
    protected static final String VERBOSE2_OPT_LONG_NAME = "vv";
    protected static final String VERBOSE3_OPT_LONG_NAME = "vvv";
    private final CliHelp _help;
    protected final Options _cliOptions;
    protected final HelpFormatter _helpFormatter;
    protected final Logger _log;
    protected CommandLine _cmd;
    protected int _defaultLogLevelIdx = 3;
    protected final Properties _configProps = new Properties(System.getProperties());

    public BaseCli(String usage, Logger log) {
        this(new CliHelpBuilder().usage(usage).build(), log);
    }

    public BaseCli(CliHelp help, Logger log) {
        this._log = null == log ? Logger.getLogger(this.getClass()) : log;
        this._help = help;
        this._cliOptions = new Options();
        this._helpFormatter = new HelpFormatter();
        this._helpFormatter.setWidth(150);
    }

    public static String createDefaultUsageString(String className) {
        return "java " + className + " [options]";
    }

    public static String createDefaultUsageString(Class<?> clazz) {
        return BaseCli.createDefaultUsageString(clazz.getName());
    }

    public Properties getConfigProps() {
        return this._configProps;
    }

    protected String getProgramName() {
        return this._help.getClassName();
    }

    protected void printError(String message, boolean printHelp) {
        System.err.println(this.getProgramName() + ": " + message);
        if (printHelp) {
            System.out.println();
            this.printCliHelp();
        }
    }

    private void updatePropsFromCmdLine(String cmdLinePropString) {
        String[] cmdLinePropSplit;
        for (String s : cmdLinePropSplit = cmdLinePropString.split(";")) {
            String[] onePropSplit = s.split("=");
            if (onePropSplit.length != 2) {
                this._log.error((Object)("CMD line property setting " + s + "is not valid!"));
                continue;
            }
            this._log.info((Object)("CMD line Property overwride: " + s));
            this._configProps.put(onePropSplit[0], onePropSplit[1]);
        }
    }

    protected void constructCommandLineOptions() {
        OptionBuilder.withLongOpt((String)HELP_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Prints command-line options info");
        this._cliOptions.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)CMD_LINE_PROPS_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Command-line override for config properties; a semicolon-separated list of key=vale.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"Semicolon_separated_properties");
        this._cliOptions.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)LOG4J_PROPS_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Log4j properties to use");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"property_file");
        this._cliOptions.addOption(OptionBuilder.create((char)'l'));
        OptionBuilder.withLongOpt((String)PROPS_FILE_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"Config properties file to use");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"property_file");
        this._cliOptions.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)QUIET_OPT_LONG_NAME);
        OptionBuilder.withDescription((String)"quiet (no logging)");
        this._cliOptions.addOption(OptionBuilder.create((char)'q'));
        OptionBuilder.withDescription((String)"verbose");
        this._cliOptions.addOption(OptionBuilder.create((String)VERBOSE1_OPT_LONG_NAME));
        OptionBuilder.withDescription((String)"more verbose");
        this._cliOptions.addOption(OptionBuilder.create((String)VERBOSE2_OPT_LONG_NAME));
        OptionBuilder.withDescription((String)"most verbose");
        this._cliOptions.addOption(OptionBuilder.create((String)VERBOSE3_OPT_LONG_NAME));
    }

    public boolean processCommandLineArgs(String[] cliArgs) {
        this.constructCommandLineOptions();
        GnuParser cliParser = new GnuParser();
        this._cmd = null;
        try {
            this._cmd = cliParser.parse(this._cliOptions, cliArgs);
        }
        catch (ParseException pe) {
            this.printError("failed to parse command-line options: " + pe.toString(), true);
            return false;
        }
        if (this._cmd.hasOption('h')) {
            this.printCliHelp();
            return false;
        }
        int verbosityInc = 0;
        if (this._cmd.hasOption(VERBOSE3_OPT_LONG_NAME)) {
            verbosityInc = VERBOSITIES.length;
        } else if (this._cmd.hasOption(VERBOSE2_OPT_LONG_NAME)) {
            verbosityInc = 2;
        } else if (this._cmd.hasOption(VERBOSE1_OPT_LONG_NAME)) {
            verbosityInc = 1;
        }
        Level effectiveLevel = VERBOSITIES[Math.min(this._defaultLogLevelIdx + verbosityInc, VERBOSITIES.length - 1)];
        if (this._cmd.hasOption('q')) {
            effectiveLevel = Level.OFF;
        }
        Logger.getRootLogger().setLevel(effectiveLevel);
        if (this._cmd.hasOption('l')) {
            String log4jPropFile = this._cmd.getOptionValue('l');
            PropertyConfigurator.configure((String)log4jPropFile);
            this._log.debug((Object)("Using custom logging settings from file " + log4jPropFile));
        } else {
            PatternLayout defaultLayout = new PatternLayout("%d{ISO8601} +%r [%t] (%p) {%c{1}} %m%n");
            ConsoleAppender defaultAppender = new ConsoleAppender((Layout)defaultLayout);
            Logger.getRootLogger().removeAllAppenders();
            Logger.getRootLogger().addAppender((Appender)defaultAppender);
            this._log.debug((Object)"Using default logging settings");
        }
        this.processProperties();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processProperties() {
        if (this._cmd.hasOption('p')) {
            for (String propFile : this._cmd.getOptionValues('p')) {
                this._log.info((Object)("Loading container config from properties file " + propFile));
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(propFile);
                    this._configProps.load(fis);
                }
                catch (Exception e) {
                    this._log.error((Object)("error processing properties; ignoring:" + e.getMessage()));
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        } else {
            this._log.info((Object)"Using system properties for container config");
        }
        if (this._cmd.hasOption('c')) {
            String cmdLinePropString = this._cmd.getOptionValue('c');
            this.updatePropsFromCmdLine(cmdLinePropString);
        }
    }

    public void printCliHelp() {
        this._helpFormatter.printHelp(this._help.getUsage(), this._help.getHeader(), this._cliOptions, this._help.getFooter());
    }

    public String getUsage() {
        return this._help.getUsage();
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        BaseCli cli = new BaseCli(new CliHelpBuilder().className(BaseCli.class).startHeader().addSection("Description").addLine("Description Line 1").addLine("Description Line 2").addSection("Options").finish().startFooter().addSection("Examples").addLine("* Example Line 1").addLine("\u007f\t Example Line 2").addSection("Notes").addLine("Be careful").finish().build(), null);
        cli.processCommandLineArgs(args);
    }

    public static class CliHelpBuilder {
        private String _usage;
        private HeaderFooterBuilder _header;
        private HeaderFooterBuilder _footer;
        private String _className = "<class>";

        public CliHelpBuilder className(String className) {
            this._className = className;
            this._header = new StdHeaderFooterBuilder(this);
            this._footer = new StdHeaderFooterBuilder(this);
            return this;
        }

        public CliHelpBuilder className(Class<?> clazz) {
            return this.className(clazz.getName());
        }

        public String className() {
            return this._className;
        }

        public HeaderFooterBuilder startHeader() {
            return this._header;
        }

        public CliHelpBuilder headerBuilder(HeaderFooterBuilder builder) {
            this._header = builder;
            return this;
        }

        public HeaderFooterBuilder startFooter() {
            return this._footer;
        }

        public CliHelpBuilder footerBuilder(HeaderFooterBuilder builder) {
            this._footer = builder;
            return this;
        }

        public String header() {
            return ((Object)this._header).toString();
        }

        public String footer() {
            return ((Object)this._footer).toString();
        }

        public CliHelpBuilder usage(String usage) {
            this._usage = usage;
            return this;
        }

        public String usage() {
            return this._usage;
        }

        public CliHelp build() {
            if (null == this._usage) {
                this._usage = "java " + this._className + " [options]";
            }
            return new CliHelp(this._className, this._usage, null != this._header ? ((Object)this._header).toString() : "", null != this._footer ? ((Object)this._footer).toString() : "");
        }
    }

    public static class StdHeaderFooterBuilder
    implements HeaderFooterBuilder {
        protected final StringBuilder _s = new StringBuilder();
        protected final CliHelpBuilder _parent;

        public StdHeaderFooterBuilder(CliHelpBuilder parent) {
            this._parent = parent;
        }

        @Override
        public HeaderFooterBuilder addLine(String ln) {
            this._s.append(ln);
            this._s.append("\n");
            return this;
        }

        @Override
        public HeaderFooterBuilder addSection(String sectionName) {
            this.addLine();
            this.addLine(sectionName.toUpperCase());
            for (int i = 0; i < sectionName.length(); ++i) {
                this.add("-");
            }
            this.addLine();
            return this;
        }

        @Override
        public String toString() {
            return this._s.toString();
        }

        @Override
        public HeaderFooterBuilder add(String s) {
            this._s.append(s);
            return this;
        }

        @Override
        public CliHelpBuilder finish() {
            return this._parent;
        }

        @Override
        public HeaderFooterBuilder addLine() {
            return this.addLine("\u007f");
        }
    }

    public static interface HeaderFooterBuilder {
        public HeaderFooterBuilder add(String var1);

        public HeaderFooterBuilder addLine();

        public HeaderFooterBuilder addLine(String var1);

        public HeaderFooterBuilder addSection(String var1);

        public CliHelpBuilder finish();

        public String toString();
    }

    public static class CliHelp {
        private final String _className;
        private final String _usage;
        private final String _header;
        private final String _footer;

        public CliHelp(String className, String usage, String header, String footer) {
            this._usage = usage;
            this._header = header;
            this._footer = footer;
            this._className = className;
        }

        public String getUsage() {
            return this._usage;
        }

        public String getHeader() {
            return this._header;
        }

        public String getFooter() {
            return this._footer;
        }

        public String getClassName() {
            return this._className;
        }
    }
}

