/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.test.container;

import java.net.SocketAddress;
import java.nio.ByteOrder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.DirectChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.local.DefaultLocalClientChannelFactory;
import org.jboss.netty.channel.local.LocalAddress;

public class SimpleTestClientConnection {
    private Channel _channel;
    private Thread _thread;
    private final ClientBootstrap _clientBootstrap;
    private final Lock _lock = new ReentrantLock(true);
    private boolean _connected;
    private boolean _shutdownRequested;
    private boolean _shutdown;
    private final Condition _connectedCondition = this._lock.newCondition();
    private final Condition _shutdownReqCondition = this._lock.newCondition();
    private final Condition _shutdownCondition = this._lock.newCondition();

    public SimpleTestClientConnection(ByteOrder bufferByteOrder) {
        this._clientBootstrap = new ClientBootstrap((ChannelFactory)new DefaultLocalClientChannelFactory());
        this._clientBootstrap.setOption("bufferFactory", (Object)DirectChannelBufferFactory.getInstance((ByteOrder)bufferByteOrder));
    }

    public void setPipelineFactory(ChannelPipelineFactory pipelineFactory) {
        this._clientBootstrap.setPipelineFactory(pipelineFactory);
    }

    public void start(final int serverAddr) {
        this._shutdownRequested = false;
        this._shutdown = false;
        this._connected = false;
        this._thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ChannelFuture connectFuture = SimpleTestClientConnection.this._clientBootstrap.connect((SocketAddress)new LocalAddress(serverAddr));
                connectFuture.awaitUninterruptibly();
                SimpleTestClientConnection.this._channel = connectFuture.getChannel();
                SimpleTestClientConnection.this._lock.lock();
                try {
                    SimpleTestClientConnection.this._connected = connectFuture.isSuccess();
                    SimpleTestClientConnection.this._connectedCondition.signalAll();
                    while (!SimpleTestClientConnection.this._shutdownRequested) {
                        try {
                            SimpleTestClientConnection.this._shutdownReqCondition.await();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    SimpleTestClientConnection.this._shutdown = true;
                    SimpleTestClientConnection.this._shutdownCondition.signalAll();
                }
                finally {
                    SimpleTestClientConnection.this._lock.unlock();
                }
            }
        });
        this._thread.setDaemon(true);
        this._thread.start();
    }

    public boolean startSynchronously(int serverAddr, long timeoutMillis) {
        this.start(serverAddr);
        try {
            this.awaitConnected(timeoutMillis);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        return this.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitConnected(long timeoutMillis) throws InterruptedException {
        this._lock.lock();
        try {
            if (!this._connected) {
                this._connectedCondition.await(timeoutMillis, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        this._lock.lock();
        try {
            boolean bl = this._connected;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this._lock.lock();
        try {
            this._shutdownRequested = true;
            this._shutdownReqCondition.signalAll();
            while (!this._shutdown) {
                try {
                    this._shutdownCondition.await();
                }
                catch (InterruptedException ie) {}
            }
        }
        finally {
            this._lock.unlock();
        }
        ChannelFuture closeFuture = this._channel.close();
        closeFuture.awaitUninterruptibly();
        this._clientBootstrap.releaseExternalResources();
    }

    public Channel getChannel() {
        return this._channel;
    }
}

