/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.test.container;

import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class SimpleObjectCaptureHandler
extends SimpleChannelUpstreamHandler {
    private final List<Object> _messages;
    private final Lock _msgLock = new ReentrantLock();
    private final Condition _newMsgCondition = this._msgLock.newCondition();

    public SimpleObjectCaptureHandler() {
        this._messages = new Vector<Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this._msgLock.lock();
        try {
            this._messages.clear();
        }
        finally {
            this._messages.clear();
        }
    }

    public List<Object> getMessages() {
        return this._messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForMessage(long timeoutMs, int size) {
        this._msgLock.lock();
        try {
            boolean interrupted = false;
            while (!interrupted && size >= this._messages.size()) {
                try {
                    if (timeoutMs > 0L) {
                        this._newMsgCondition.await(timeoutMs, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    this._newMsgCondition.await();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            boolean bl = size < this._messages.size();
            return bl;
        }
        finally {
            this._msgLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this._msgLock.lock();
        try {
            this._messages.add(e.getMessage());
            this._newMsgCondition.signalAll();
        }
        finally {
            this._msgLock.unlock();
        }
        super.messageReceived(ctx, e);
    }
}

