/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.test.container;

import com.linkedin.databus2.test.TestUtil;
import java.nio.channels.ClosedChannelException;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.timeout.WriteTimeoutException;

public class MockServerChannelHandler
extends SimpleChannelHandler {
    public static Logger LOG = Logger.getLogger(MockServerChannelHandler.class);
    private boolean _throwWTOException = false;
    private boolean _saveTheFuture = false;
    private boolean _disableWriteComplete = false;
    private boolean _delayWriteComplete = false;
    private ChannelFuture _future = null;

    public void enableThrowWTOException(boolean enable) {
        this._throwWTOException = enable;
    }

    public void enableSaveTheFuture(boolean enable) {
        this._saveTheFuture = enable;
    }

    public void disableWriteComplete(boolean disable) {
        this._disableWriteComplete = disable;
    }

    public void delayWriteComplete(boolean delay) {
        this._delayWriteComplete = delay;
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        Thread t = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("=>=>=>=WRite complete start" + e));
        }
        if (this._disableWriteComplete) {
            LOG.info((Object)"Injecting exceptions into writeComplete");
            this._future.setFailure((Throwable)new WriteTimeoutException("Mocked WriteTimeout"));
            this._future.setFailure((Throwable)new ClosedChannelException());
            TestUtil.sleep(16000L);
        } else if (this._delayWriteComplete) {
            LOG.info((Object)"Injecting delay into writeComplete");
            t = this.startExceptionThread(ctx);
            LOG.info((Object)"waiting for timeout");
            TestUtil.sleep(10L);
        }
        super.writeComplete(ctx, e);
        LOG.debug((Object)"=>=>=> Write complete end");
        if (t != null) {
            t.interrupt();
        }
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<=<=<=<=WRite requested" + e.getMessage()));
            this.printMessage("<=<=<=<=", e);
        }
        MessageEvent newMessage = e;
        if (this._saveTheFuture && this._future == null) {
            this._future = e.getFuture();
            ChannelFuture newFuture = Channels.future((Channel)ctx.getChannel());
            newMessage = new DownstreamMessageEvent(ctx.getChannel(), newFuture, e.getMessage(), e.getRemoteAddress());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Saving the future:" + this._future));
            }
        }
        super.writeRequested(ctx, newMessage);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (LOG.isDebugEnabled()) {
            this.printMessage("msgReceived=>=>=>=>", e);
        }
        if (this._throwWTOException) {
            this._throwWTOException = false;
            this.startExceptionThread(ctx);
        }
        super.messageReceived(ctx, e);
    }

    private Thread startExceptionThread(final ChannelHandlerContext ctx) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                LOG.info((Object)"***** ABOUT TO FIRE time out exception");
                Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new WriteTimeoutException("MOCK write timeout exception2"));
                LOG.info((Object)"**** Exception in the hole ");
                try {
                    Thread.sleep(100000L);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"sleep interrupted");
                }
                ctx.getChannel().close();
            }
        }, "Write Timeout thread");
        t.setDaemon(true);
        t.start();
        return t;
    }

    private void printMessage(String prefix, MessageEvent e) {
        String resp;
        Object msgO = e.getMessage();
        if (msgO instanceof HttpRequest) {
            HttpRequest msgReq = (HttpRequest)msgO;
            resp = msgReq.getUri();
        } else if (msgO instanceof HttpResponse) {
            HttpResponse msgReq = (HttpResponse)msgO;
            resp = msgReq.toString();
        } else if (msgO instanceof HttpChunk) {
            HttpChunk msgReq = (HttpChunk)msgO;
            resp = msgReq.toString();
        } else {
            ChannelBuffer msg = (ChannelBuffer)msgO;
            byte[] bytes = new byte[msg.capacity()];
            msg.readBytes(bytes);
            msg.setIndex(0, bytes.length);
            StringBuilder out = new StringBuilder("MSG: ").append(e.getChannel().getRemoteAddress());
            out.append("\nMESSAGE length=").append(bytes.length).append("\n").append(new String(bytes));
            resp = out.toString();
        }
        LOG.debug((Object)(prefix + resp));
    }
}

