/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.test;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class ClassIntrospectionUtils {
    public static final Logger LOG = Logger.getLogger((String)ClassIntrospectionUtils.class.getName());
    Object _classInstance;
    Class<?> _classType;

    public ClassIntrospectionUtils(Object classInstance) {
        this._classInstance = classInstance;
        this._classType = classInstance.getClass();
    }

    public <T> T getFieldValue(String fieldName, Class<T> fieldClassType) throws NoSuchFieldException, IllegalAccessException {
        Field field = this.getField(fieldName);
        Object value = field.get(this._classInstance);
        return fieldClassType.cast(value);
    }

    public void setFieldValue(String fieldName, Object fieldValue) throws NoSuchFieldException, IllegalAccessException {
        this.getField(fieldName).set(this._classInstance, fieldValue);
    }

    public Object invokeMethod(String methodName, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.getMethod(methodName);
        return method.invoke(this._classInstance, args);
    }

    public Method getMethod(String methodName) throws NoSuchMethodException {
        return this.methodUnwinder(methodName, this._classType);
    }

    public Field getField(String fieldName) throws NoSuchFieldException {
        return ClassIntrospectionUtils.fieldUnwinder(fieldName, this._classType);
    }

    private static <T> Field fieldUnwinder(String fieldName, Class<T> classType) throws NoSuchFieldException {
        Field field = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Peeking into classInstance: " + classType));
        }
        try {
            field = classType.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<T> superClass = classType.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return ClassIntrospectionUtils.fieldUnwinder(fieldName, superClass);
        }
        field.setAccessible(true);
        return field;
    }

    private <T> Method methodUnwinder(String fieldName, Class<T> classType) throws NoSuchMethodException {
        Method method = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Peeking into classInstance: " + classType));
        }
        try {
            method = classType.getDeclaredMethod(fieldName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Class<T> superClass = classType.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return this.methodUnwinder(fieldName, superClass);
        }
        method.setAccessible(true);
        return method;
    }
}

