/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import com.linkedin.databus2.core.container.request.UnknownCommandException;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class UnknownCommandProcessor
implements RequestProcessor {
    private static final ExecutorService UNKNOWN_COMMAND_PROCESSOR_EXECUTOR = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.DAYS, new LinkedBlockingDeque<Runnable>());

    UnknownCommandProcessor() {
    }

    @Override
    public ExecutorService getExecutorService() {
        return UNKNOWN_COMMAND_PROCESSOR_EXECUTOR;
    }

    @Override
    public DatabusRequest process(DatabusRequest request) throws IOException {
        request.setError(new UnknownCommandException(request.getName()));
        return request;
    }
}

