/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus2.core.DatabusException;
import java.util.List;

public class SourcesTooOldException
extends DatabusException {
    private static final long serialVersionUID = 1L;
    public static final String MESSAGE_PREFIX = "sources to old: ";
    private final List<Short> _srcIds;

    public SourcesTooOldException(List<Short> srcIds) {
        super(SourcesTooOldException.generateMessage(srcIds));
        this._srcIds = srcIds;
    }

    public SourcesTooOldException(int serverId) {
        super("sources to old: server " + serverId);
        this._srcIds = null;
    }

    public List<Short> getSrcIds() {
        return this._srcIds;
    }

    public static String generateMessage(List<Short> srcIds) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(MESSAGE_PREFIX);
        boolean first = true;
        for (Short srcId : srcIds) {
            if (!first) {
                sb.append(',');
            }
            first = false;
            sb.append(srcId);
        }
        return sb.toString();
    }
}

