/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.InvalidRequestParamValueException;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class SleepRequestProcessor
implements RequestProcessor {
    public static final String MODULE = SleepRequestProcessor.class.getName();
    public static Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "sleep";
    public static final String MIN_SLEEP_TIME_PARAM = "sleepMin";
    public static final String MAX_SLEEP_TIME_PARAM = "sleepMax";
    public static final String MIN_RESP_SIZE_PARAM = "responseSizeMin";
    public static final String MAX_RESP_SIZE_PARAM = "responseSizeMax";
    public static final int DEFAULT_MIN_SLEEP_TIME_MS = 0;
    public static final int DEFAULT_MAX_SLEEP_TIME_MS = 100;
    public static final int DEFAULT_MIN_RESP_SIZE = 1000;
    public static final int DEFAULT_MAX_RESP_SIZE = 10000;
    private static final int DEFAULT_RESPONSE_CHUNK_SIZE = 32000;
    private static final String BODY_PATTERN = "DeAdBeEf";
    private final ExecutorService _executorService;

    public SleepRequestProcessor(ExecutorService executorService) {
        this._executorService = executorService;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    @Override
    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        long endNanos;
        long elapsedMillis;
        int sleepTime;
        int maxRespSize;
        int maxTime;
        long startNanos = System.nanoTime();
        int minTime = request.getOptionalIntParam(MIN_SLEEP_TIME_PARAM, 0);
        if (minTime > (maxTime = request.getOptionalIntParam(MAX_SLEEP_TIME_PARAM, 100))) {
            throw new InvalidRequestParamValueException(request.getName(), MIN_SLEEP_TIME_PARAM, "minTime > maxTime");
        }
        int minRespSize = request.getOptionalIntParam(MIN_RESP_SIZE_PARAM, 1000);
        if (minRespSize > (maxRespSize = request.getOptionalIntParam(MAX_RESP_SIZE_PARAM, 10000))) {
            throw new InvalidRequestParamValueException(request.getName(), MIN_SLEEP_TIME_PARAM, "responseSizeMin > responseSizeMax");
        }
        Random rng = new Random();
        int respSize = minRespSize + rng.nextInt(maxRespSize - minRespSize);
        ByteBuffer bb = ByteBuffer.allocate(32000).order(ByteOrder.nativeOrder());
        int patternSize = BODY_PATTERN.getBytes(Charset.defaultCharset()).length;
        for (int i = 0; i < respSize / 32000; ++i) {
            bb.clear();
            for (int j = 0; j < 32000 / patternSize; ++j) {
                bb.put(BODY_PATTERN.getBytes(Charset.defaultCharset()));
            }
            bb.rewind();
            request.getResponseContent().write(bb);
        }
        if (respSize % 32000 > 0) {
            bb.clear();
            for (int j = 0; j <= respSize % 32000 / patternSize; ++j) {
                bb.put(BODY_PATTERN.getBytes(Charset.defaultCharset()));
            }
            bb.flip();
            request.getResponseContent().write(bb);
        }
        if ((long)(sleepTime = maxTime > minTime ? minTime + rng.nextInt(maxTime - minTime) : 0) > (elapsedMillis = (long)((int)(((endNanos = System.nanoTime()) - startNanos + 1L) / 1000000L)))) {
            try {
                Thread.sleep((long)sleepTime - elapsedMillis);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        return request;
    }
}

