/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus.core.util.JsonUtils;
import com.linkedin.databus2.core.container.request.IDatabusResponse;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DownstreamMessageEvent;

public abstract class SimpleDatabusResponse
implements IDatabusResponse {
    protected final byte _protocolVersion;

    public SimpleDatabusResponse(byte protocolVersion) {
        this._protocolVersion = protocolVersion;
    }

    public abstract ChannelBuffer serializeToBinary();

    @Override
    public void writeToChannelAsBinary(ChannelHandlerContext ctx, ChannelFuture future) {
        ChannelFuture realFuture = null != future ? future : Channels.future((Channel)ctx.getChannel());
        ChannelBuffer serializedResponse = this.serializeToBinary();
        DownstreamMessageEvent e = new DownstreamMessageEvent(ctx.getChannel(), realFuture, (Object)serializedResponse, ctx.getChannel().getRemoteAddress());
        ctx.sendDownstream((ChannelEvent)e);
    }

    public byte getProtocolVersion() {
        return this._protocolVersion;
    }

    @Override
    public String toJsonString(boolean pretty) {
        return JsonUtils.toJsonStringSilent((Object)this, (boolean)pretty);
    }

    public String toString() {
        return this.toJsonString(false);
    }
}

