/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus.core.util.JsonUtils;
import com.linkedin.databus2.core.container.request.IDatabusRequest;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.DownstreamMessageEvent;

public abstract class SimpleDatabusRequest
implements IDatabusRequest {
    protected final byte _protocolVersion;

    public SimpleDatabusRequest(byte protocolVersion) {
        this._protocolVersion = protocolVersion;
    }

    public abstract ChannelBuffer toBinaryChannelBuffer();

    @Override
    public byte getProtocolVersion() {
        return this._protocolVersion;
    }

    @Override
    public void sendDownstreamAsBinary(ChannelHandlerContext ctx, ChannelFuture future) {
        ChannelBuffer buffer = this.toBinaryChannelBuffer();
        ctx.sendDownstream((ChannelEvent)new DownstreamMessageEvent(ctx.getChannel(), future, (Object)buffer, ctx.getChannel().getRemoteAddress()));
    }

    @Override
    public ChannelFuture writeToChannelAsBinary(Channel channel) {
        ChannelBuffer buffer = this.toBinaryChannelBuffer();
        return channel.write((Object)buffer);
    }

    public String toJsonString(boolean pretty) {
        return JsonUtils.toJsonStringSilent((Object)this, (boolean)pretty);
    }

    public String toString() {
        return this.toJsonString(false);
    }
}

