/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.ExtendedReadTimeoutHandler;
import com.linkedin.databus2.core.container.request.BinaryCommandParser;
import com.linkedin.databus2.core.container.request.CommandsRegistry;
import com.linkedin.databus2.core.container.request.ErrorResponse;
import com.linkedin.databus2.core.container.request.UnsupportedProtocolVersionException;
import java.nio.ByteOrder;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class SimpleBinaryDatabusRequestDecoder
extends FrameDecoder {
    public static final String MODULE = SimpleBinaryDatabusRequestDecoder.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String REQUEST_EXEC_HANDLER_NAME = "request execute hander";
    private final CommandsRegistry _commandsRegistry;
    private final ExtendedReadTimeoutHandler _readTimeoutHandler;
    private final ByteOrder _byteOrder;
    private State _state = State.EXPECT_COMMAND;
    private int _curOpcode = -1;
    private BinaryCommandParser _currentParser;

    public SimpleBinaryDatabusRequestDecoder(CommandsRegistry commandsRegistry, ExtendedReadTimeoutHandler readTimeoutHandler, ByteOrder byteOrder) {
        this._commandsRegistry = commandsRegistry;
        this._readTimeoutHandler = readTimeoutHandler;
        this._byteOrder = byteOrder;
    }

    private void returnError(Channel responseChannel, ErrorResponse errResponse, ChannelBuffer buf, State newState, boolean logError, boolean logBuffer) {
        SimpleBinaryDatabusRequestDecoder.returnError(responseChannel, errResponse, buf, logError, logBuffer);
        this._state = newState;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("new state after error: " + (Object)((Object)this._state)));
        }
    }

    public static void returnError(Channel responseChannel, ErrorResponse errResponse, ChannelBuffer buf, boolean logError, boolean logBuffer) {
        if (logError || LOG.isDebugEnabled()) {
            if (errResponse.isExpected()) {
                LOG.info((Object)("Returning expected error response:" + errResponse.getErrorCode()));
            } else {
                LOG.error((Object)("error " + errResponse.getErrorCode()), errResponse.getCause());
                if (null != buf && logBuffer) {
                    buf.readerIndex(0);
                    LOG.error((Object)("buffer contents:" + ChannelBuffers.hexDump((ChannelBuffer)buf)));
                }
            }
        }
        responseChannel.write((Object)errResponse);
        if (null != buf) {
            buf.readerIndex(buf.readerIndex() + buf.readableBytes());
        }
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        int resetIndex = buffer.readerIndex();
        Object result = null;
        block14: while (State.INCOMPLETE_DATA != this._state && null == result && buffer.readable()) {
            switch (this._state) {
                case EXPECT_COMMAND: {
                    byte opcode = buffer.readByte();
                    if (opcode != this._curOpcode || -1 == this._curOpcode) {
                        this._currentParser = this._commandsRegistry.createParser(opcode, ctx.getChannel(), this._byteOrder);
                        if (null == this._currentParser) {
                            this._curOpcode = -1;
                            this.returnError(ctx.getChannel(), ErrorResponse.createUnknownCommandResponse(opcode), buffer, State.EXPECT_COMMAND, true, true);
                            continue block14;
                        }
                        this._curOpcode = opcode;
                        this._state = State.EXPECT_MORE_DATA;
                        ChannelPipeline pipe = ctx.getPipeline();
                        pipe.replace(REQUEST_EXEC_HANDLER_NAME, REQUEST_EXEC_HANDLER_NAME, (ChannelHandler)this._commandsRegistry.createExecHandler(opcode, ctx.getChannel()));
                        this._currentParser.startNew();
                        resetIndex = buffer.readerIndex();
                        continue block14;
                    }
                    this._state = State.EXPECT_MORE_DATA;
                    this._currentParser.startNew();
                    resetIndex = buffer.readerIndex();
                    continue block14;
                }
                case EXPECT_MORE_DATA: {
                    if (null == this._currentParser) {
                        this.returnError(ctx.getChannel(), ErrorResponse.createInternalServerErrorResponse((Throwable)new DatabusException("expecting more data but no parser")), buffer, State.EXPECT_COMMAND, true, true);
                        continue block14;
                    }
                    try {
                        BinaryCommandParser.ParseResult parseResult = this._currentParser.parseBinary(buffer);
                        switch (parseResult) {
                            case DISCARD: {
                                continue block14;
                            }
                            case INCOMPLETE_DATA: {
                                this._state = State.INCOMPLETE_DATA;
                                continue block14;
                            }
                            case EXPECT_MORE: {
                                this._state = State.EXPECT_MORE_DATA;
                                continue block14;
                            }
                            case PASS_THROUGH: {
                                result = buffer;
                                continue block14;
                            }
                            case DONE: {
                                if (null == this._currentParser.getError()) {
                                    result = this._currentParser.getCommand();
                                    this._state = State.EXPECT_COMMAND;
                                    continue block14;
                                }
                                this.returnError(ctx.getChannel(), this._currentParser.getError(), buffer, State.EXPECT_COMMAND, true, true);
                                continue block14;
                            }
                        }
                        this.returnError(ctx.getChannel(), ErrorResponse.createInternalServerErrorResponse((Throwable)new DatabusException("unknown parser return code" + (Object)((Object)parseResult))), buffer, State.EXPECT_COMMAND, true, true);
                    }
                    catch (UnsupportedProtocolVersionException upve) {
                        this.returnError(ctx.getChannel(), ErrorResponse.createUnsupportedProtocolVersionResponse(upve.getProtocolVerson()), buffer, State.EXPECT_COMMAND, true, true);
                    }
                    catch (Exception ex) {
                        this.returnError(ctx.getChannel(), ErrorResponse.createInternalServerErrorResponse(ex), buffer, State.EXPECT_COMMAND, true, true);
                    }
                    continue block14;
                }
            }
            this.returnError(ctx.getChannel(), ErrorResponse.createInternalServerErrorResponse((Throwable)new DatabusException("unknown state: " + (Object)((Object)this._state))), buffer, State.EXPECT_COMMAND, true, true);
        }
        if (State.INCOMPLETE_DATA == this._state) {
            buffer.readerIndex(resetIndex);
            result = null;
            this._state = State.EXPECT_MORE_DATA;
        }
        if (State.EXPECT_COMMAND == this._state) {
            if (null != this._readTimeoutHandler && this._readTimeoutHandler.isStarted()) {
                this._readTimeoutHandler.stop();
            }
        } else if (null != this._readTimeoutHandler && !this._readTimeoutHandler.isStarted()) {
            this._readTimeoutHandler.start(ctx);
        }
        return result;
    }

    private static enum State {
        EXPECT_COMMAND,
        INCOMPLETE_DATA,
        EXPECT_MORE_DATA;

    }
}

