/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.ProcessorRegistrationConflictException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import com.linkedin.databus2.core.container.request.UnknownCommandProcessor;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class RequestProcessorRegistry {
    private static final RequestProcessor UNKOWN_COMMAND_PROCESSOR = new UnknownCommandProcessor();
    private final HashMap<String, RequestProcessor> _processors = new HashMap();

    public void register(String commandName, RequestProcessor processor) throws ProcessorRegistrationConflictException {
        if (this._processors.containsKey(commandName)) {
            throw new ProcessorRegistrationConflictException(commandName);
        }
        this._processors.put(commandName, processor);
    }

    public void reregister(String commandName, RequestProcessor processor) throws ProcessorRegistrationConflictException {
        if (this._processors.containsKey(commandName)) {
            this.unregister(commandName);
        }
        this._processors.put(commandName, processor);
    }

    public void unregister(String commandName) {
        this._processors.remove(commandName);
    }

    public Future<DatabusRequest> run(DatabusRequest request) {
        RequestProcessor processor = this._processors.get(request.getName());
        if (null == processor) {
            processor = UNKOWN_COMMAND_PROCESSOR;
        }
        request.setProcessor(processor);
        ExecutorService procExecutor = processor.getExecutorService();
        if (null != procExecutor) {
            return procExecutor.submit(request);
        }
        request.call();
        return request;
    }
}

