/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus.core.util.Base64;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RegisterResponseMetadataEntry {
    public static final String METADATA_SCHEMAS_KEY = "metadataSchemas";
    public static final String MODULE = RegisterResponseMetadataEntry.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private String _schema;
    private short _version;
    private byte[] _crc32;

    public RegisterResponseMetadataEntry(short version, String schema, byte[] crc32) {
        this._version = version;
        this._schema = schema;
        this._crc32 = crc32;
    }

    public RegisterResponseMetadataEntry() {
        this(0, "n/a", new byte[4]);
    }

    public short getVersion() {
        return this._version;
    }

    public byte[] getCrc32() {
        return (byte[])this._crc32.clone();
    }

    public void setVersion(short version) {
        this._version = version;
    }

    public String getSchema() {
        return this._schema;
    }

    public static List<RegisterResponseMetadataEntry> createFromResponse(Map<String, List<Object>> responseMap, String hashKey, boolean optional) {
        List<Object> metadataObjectsList = responseMap.get(METADATA_SCHEMAS_KEY);
        List<RegisterResponseMetadataEntry> metadataSchemasList = null;
        if (metadataObjectsList == null) {
            LOG.info((Object)"/register response v4 has no 'metadataSchemas' entry");
        } else {
            metadataSchemasList = RegisterResponseMetadataEntry.reconstructMetadataSchemasList(metadataObjectsList);
        }
        return metadataSchemasList;
    }

    private static List<RegisterResponseMetadataEntry> reconstructMetadataSchemasList(List<Object> objectsList) {
        ArrayList<RegisterResponseMetadataEntry> schemasList = new ArrayList<RegisterResponseMetadataEntry>();
        for (Object obj : objectsList) {
            Map map;
            boolean ok = false;
            if (obj instanceof Map && (map = (Map)obj).containsKey("version") && map.containsKey("schema") && map.containsKey("crc32")) {
                byte[] crc32Digest = Base64.decode((String)((String)map.get("crc32")));
                schemasList.add(new RegisterResponseMetadataEntry(((Integer)map.get("version")).shortValue(), (String)map.get("schema"), crc32Digest));
                ok = true;
            }
            if (ok) continue;
            throw new RuntimeException("/register response v4 metadata schemas deserialization error: object type = " + obj.getClass().getName());
        }
        return schemasList;
    }

    public void setSchema(String schema) {
        this._schema = schema;
    }
}

