/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RegisterResponseEntry {
    public static final String SOURCE_SCHEMAS_KEY = "sourceSchemas";
    public static final String KEY_SCHEMAS_KEY = "keySchemas";
    public static final String MODULE = RegisterResponseEntry.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private long _id;
    private String _schema;
    private short _version;

    public RegisterResponseEntry(long id, short version, String schema) {
        this._id = id;
        this._version = version;
        this._schema = schema;
    }

    public RegisterResponseEntry() {
        this(0L, 0, "N/A");
    }

    public long getId() {
        return this._id;
    }

    public void setId(long id) {
        this._id = id;
    }

    public short getVersion() {
        return this._version;
    }

    public void setVersion(short version) {
        this._version = version;
    }

    public String getSchema() {
        return this._schema;
    }

    public void setSchema(String schema) {
        this._schema = schema;
    }

    public static Map<Long, List<RegisterResponseEntry>> createFromResponse(Map<String, List<Object>> responseMap, String hashKey, boolean optional) {
        List<Object> schemasList = responseMap.get(hashKey);
        if (optional) {
            if (schemasList == null) {
                LOG.info((Object)("/register response v4 has no '" + hashKey + "' entry"));
            }
            return null;
        }
        if (schemasList == null || schemasList.size() <= 0) {
            throw new RuntimeException("/register response v4 has no '" + hashKey + "' entry (or entry is empty)");
        }
        List<RegisterResponseEntry> sourcesSchemasList = RegisterResponseEntry.reconstructSchemasList(schemasList);
        Map<Long, List<RegisterResponseEntry>> schemasMap = RegisterResponseEntry.convertSchemaListToMap(sourcesSchemasList);
        return schemasMap;
    }

    private static List<RegisterResponseEntry> reconstructSchemasList(List<Object> objectsList) {
        ArrayList<RegisterResponseEntry> schemasList = new ArrayList<RegisterResponseEntry>();
        for (Object obj : objectsList) {
            Map map;
            boolean ok = false;
            if (obj instanceof Map && (map = (Map)obj).containsKey("id") && map.containsKey("version") && map.containsKey("schema")) {
                schemasList.add(new RegisterResponseEntry(((Integer)map.get("id")).intValue(), ((Integer)map.get("version")).shortValue(), (String)map.get("schema")));
                ok = true;
            }
            if (ok) continue;
            throw new RuntimeException("/register response v4 schemas deserialization error: object type = " + obj.getClass().getName());
        }
        return schemasList;
    }

    public static Map<Long, List<RegisterResponseEntry>> convertSchemaListToMap(List<RegisterResponseEntry> schemasList) {
        HashMap<Long, List<RegisterResponseEntry>> schemasMap = new HashMap<Long, List<RegisterResponseEntry>>(schemasList.size() * 2);
        for (RegisterResponseEntry entry : schemasList) {
            List<RegisterResponseEntry> val = schemasMap.get(entry.getId());
            if (null == val) {
                val = new ArrayList<RegisterResponseEntry>();
                val.add(entry);
                schemasMap.put(entry.getId(), val);
                continue;
            }
            val.add(entry);
        }
        return schemasMap;
    }
}

