/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus.core.data_model.PhysicalPartition;
import com.linkedin.databus.core.data_model.UnknownPartitionException;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.request.BinaryProtocol;
import com.linkedin.databus2.core.container.request.InvalidRequestParamValueException;
import com.linkedin.databus2.core.container.request.SimpleDatabusResponse;
import com.linkedin.databus2.core.container.request.SourcesTooOldException;
import com.linkedin.databus2.core.container.request.UnexpectedCommand;
import com.linkedin.databus2.core.container.request.UnknownCommandException;
import com.linkedin.databus2.core.container.request.UnsupportedProtocolVersionException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class ErrorResponse
extends SimpleDatabusResponse {
    private final byte _errorCode;
    private final Throwable _cause;
    private final String _causeClassName;
    private final String _causeMessage;
    private boolean _isExpected = false;

    public ErrorResponse(byte errorCode, Throwable cause) {
        super((byte)1);
        this._errorCode = errorCode;
        this._cause = cause;
        this._causeClassName = this._cause.getClass().getName();
        this._causeMessage = this._cause.getMessage();
    }

    public ErrorResponse(byte errorCode, String causeClassName, String causeMessage) {
        super((byte)1);
        this._errorCode = errorCode;
        this._cause = null;
        this._causeClassName = causeClassName;
        this._causeMessage = causeMessage;
    }

    public boolean isExpected() {
        return this._isExpected;
    }

    public void setExpected(boolean expected) {
        this._isExpected = expected;
    }

    public static ErrorResponse decodeFromChannelBuffer(ChannelBuffer buffer) {
        byte[] errorMessageBytes;
        if (buffer.readableBytes() < 9) {
            return null;
        }
        byte opcode = buffer.readByte();
        int responseLen = buffer.readInt();
        if (responseLen <= 0) {
            throw new IllegalArgumentException("responseLen=" + responseLen);
        }
        if (buffer.readableBytes() < responseLen) {
            return null;
        }
        short errorClassLen = buffer.readShort();
        if (errorClassLen <= 0) {
            throw new IllegalArgumentException("errorClassLen=" + errorClassLen);
        }
        byte[] classNameBytes = new byte[errorClassLen];
        buffer.readBytes(classNameBytes);
        short errorMessageLen = buffer.readShort();
        if (errorMessageLen < 0) {
            throw new IllegalArgumentException("errorMessageLen=" + errorMessageLen);
        }
        byte[] byArray = errorMessageBytes = errorMessageLen > 0 ? new byte[errorMessageLen] : null;
        if (errorMessageLen > 0) {
            buffer.readBytes(errorMessageBytes);
        }
        ErrorResponse result = new ErrorResponse(opcode, new String(classNameBytes), null != errorMessageBytes ? new String(errorMessageBytes) : null);
        return result;
    }

    public byte getErrorCode() {
        return this._errorCode;
    }

    public Throwable getCause() {
        return this._cause;
    }

    public String getCauseClassName() {
        return this._causeClassName;
    }

    public String getCauseMessage() {
        return this._causeMessage;
    }

    public static ErrorResponse createUnknownCommandResponse(int opcode) {
        return new ErrorResponse(-65, new UnknownCommandException(Integer.toHexString(opcode & 0xFF)));
    }

    public static ErrorResponse createMismatchingMetadata(String cmd, String param, String value) {
        return new ErrorResponse(-72, new InvalidRequestParamValueException(cmd, param, value));
    }

    public static ErrorResponse createUnexpectedControlEventErrorResponse(String msg) {
        return new ErrorResponse(-69, (Throwable)new DatabusException(msg));
    }

    public static ErrorResponse createInternalServerErrorResponse(Throwable cause) {
        return new ErrorResponse(-1, cause);
    }

    public static ErrorResponse createUnsupportedProtocolVersionResponse(byte version) {
        return new ErrorResponse(-66, (Throwable)((Object)new UnsupportedProtocolVersionException(version)));
    }

    public static ErrorResponse createSourcesTooOldResponse(List<Short> srcIds) {
        return new ErrorResponse(-2, (Throwable)((Object)new SourcesTooOldException(srcIds)));
    }

    public static ErrorResponse createSourcesTooOldResponse(int serverId) {
        return new ErrorResponse(-2, (Throwable)((Object)new SourcesTooOldException(serverId)));
    }

    public static ErrorResponse createUnexpectedCommandResponse(String commandName) {
        return new ErrorResponse(-67, (Throwable)((Object)new UnexpectedCommand(commandName)));
    }

    public static ErrorResponse createUnexpectedCommandResponse(byte opcode) {
        return new ErrorResponse(-67, (Throwable)((Object)new UnexpectedCommand(opcode)));
    }

    public static ErrorResponse createInvalidRequestParam(String cmdName, String paramName, String paramValue) {
        return new ErrorResponse(-68, new InvalidRequestParamValueException(cmdName, paramName, paramValue));
    }

    public static ErrorResponse createUnknownPartition(PhysicalPartition ppart) {
        return new ErrorResponse(-3, (Throwable)new UnknownPartitionException(ppart));
    }

    public static ErrorResponse createInvalidEvent(String errMsg) {
        return new ErrorResponse(-70, (Throwable)new DatabusException(errMsg));
    }

    public static ErrorResponse createUnsupportedDbusEventVersion(String errMsg) {
        return new ErrorResponse(-71, (Throwable)new DatabusException(errMsg));
    }

    @Override
    public ChannelBuffer serializeToBinary() {
        int resultSize = 9;
        int classLen = 0;
        byte[] causeClass = null;
        int messageLen = 0;
        byte[] causeMessage = null;
        if (null != this._cause) {
            causeClass = this._causeClassName.getBytes(Charset.defaultCharset());
            classLen = Math.min(causeClass.length, 100);
            resultSize += classLen;
            if (null != this._causeMessage) {
                causeMessage = this._causeMessage.getBytes(Charset.defaultCharset());
                messageLen = Math.min(causeMessage.length, 1000);
                resultSize += causeMessage.length;
            }
        }
        ChannelBuffer result = ChannelBuffers.buffer((ByteOrder)BinaryProtocol.BYTE_ORDER, (int)resultSize);
        result.writeByte((int)this._errorCode);
        result.writeInt(resultSize - 1 - 4);
        result.writeShort(classLen);
        result.writeBytes(causeClass, 0, classLen);
        result.writeShort(messageLen);
        if (messageLen > 0) {
            result.writeBytes(causeMessage, 0, messageLen);
        }
        return result;
    }
}

