/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;

public class EchoRequestProcessor
implements RequestProcessor {
    public static final String COMMAND_NAME = "echo";
    public static final String REPEAT_PARAM = "repeat";
    private final ExecutorService _executorService;

    public EchoRequestProcessor(ExecutorService executorService) {
        this._executorService = executorService;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    @Override
    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        byte[] echoBytes = request.toString().getBytes(Charset.defaultCharset());
        int repeat = request.getOptionalIntParam(REPEAT_PARAM, 1);
        byte[] responseBytes = new byte[repeat * (echoBytes.length + 2)];
        for (int i = 0; i < repeat; ++i) {
            int destIdx = i * (echoBytes.length + 2);
            System.arraycopy(echoBytes, 0, responseBytes, destIdx, echoBytes.length);
            responseBytes[destIdx += echoBytes.length] = 13;
            responseBytes[destIdx + 1] = 10;
        }
        request.getResponseContent().write(ByteBuffer.wrap(responseBytes));
        return request;
    }
}

