/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus.core.DbusPrettyLogUtils;
import com.linkedin.databus.core.data_model.PhysicalPartition;
import com.linkedin.databus2.core.container.ChunkedWritableByteChannel;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.core.container.request.InvalidRequestParamValueException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class DatabusRequest
implements Callable<DatabusRequest>,
Future<DatabusRequest> {
    public static final String MODULE = DatabusRequest.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String DATA_PARAM_NAME = "reqdata";
    public static final String PATH_PARAM_NAME = "reqpath";
    private static final String ERROR_MESSAGE_PREFIX = "";
    private static final byte[] FALLBACK_ERROR_MESSAGE_BYTES = "{\"class\":\"unknown\"}".getBytes(Charset.defaultCharset());
    private static final String ERROR_MESSAGE_SUFFIX = "\r\n";
    private final long _id;
    private final String _name;
    private final HttpMethod _requestType;
    private final Properties _params;
    private final ServerContainer.RuntimeConfig _config;
    private final long _createTimestampMs;
    private final SocketAddress _remoteAddress;
    private PhysicalPartition _cursorPartition = null;
    private ChunkedWritableByteChannel _responseContent = null;
    private Throwable _responseThrowable = null;
    private RequestProcessor _processor = null;
    private static AtomicLong IdCounter = new AtomicLong(1L);

    public DatabusRequest(String name, HttpMethod requestType, SocketAddress remoteAddress, Properties params, ServerContainer.RuntimeConfig config) {
        this._name = name;
        this._params = params;
        this._requestType = requestType;
        this._config = config;
        this._id = IdCounter.getAndIncrement();
        this._createTimestampMs = System.currentTimeMillis();
        this._remoteAddress = remoteAddress;
    }

    public DatabusRequest(String name, HttpMethod requestType, SocketAddress remoteAddress, ServerContainer.RuntimeConfig config) {
        this(name, requestType, remoteAddress, new Properties(), config);
    }

    public String getName() {
        return this._name;
    }

    public Properties getParams() {
        return this._params;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("{\"name\":\"");
        res.append(this._name);
        res.append("\", \"method\":\"");
        res.append(this._requestType);
        res.append("\" ");
        for (Object key : this._params.keySet()) {
            Object value = this._params.get(key);
            res.append(", \"");
            res.append(key.toString());
            res.append("\":\"");
            res.append(null != value ? value.toString() : "null");
            res.append("\"");
        }
        res.append("}");
        return res.toString();
    }

    public ChunkedWritableByteChannel getResponseContent() {
        return this._responseContent;
    }

    public Throwable getResponseThrowable() {
        return this._responseThrowable;
    }

    @Override
    public DatabusRequest call() {
        if (null != this._processor) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this._name + ": start processing"));
                }
                this._processor.process(this);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this._name + ": end processing"));
                }
            }
            catch (Exception e) {
                DbusPrettyLogUtils.logExceptionAtInfo((String)this.getName(), (Throwable)e, (Logger)LOG);
                this.setError(e);
            }
        }
        return this;
    }

    public RequestProcessor getProcessor() {
        return this._processor;
    }

    public void setProcessor(RequestProcessor processor) {
        this._processor = processor;
    }

    public void setError(Throwable throwable) {
        this._responseThrowable = throwable;
        if (null != this._responseThrowable) {
            byte[] dataBytes;
            this._responseContent.addMetadata("x-dbus-error", this._responseThrowable.getClass().getName());
            if (this._responseThrowable.getMessage() != null) {
                this._responseContent.addMetadata("x-dbus-error-message", this._responseThrowable.getMessage());
            } else {
                this._responseContent.addMetadata("x-dbus-error-message", "No message provided");
            }
            Throwable cause = this._responseThrowable.getCause();
            if (null != cause) {
                this._responseContent.addMetadata("x-dbus-error-cause", cause.getClass().getName());
                if (cause.getMessage() != null) {
                    this._responseContent.addMetadata("x-dbus-error-cause-message", cause.getMessage());
                } else {
                    this._responseContent.addMetadata("x-dbus-error-cause-message", "No message provided");
                }
            }
            this._responseContent.setResponseCode(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            HashMap<String, String> exceptionInfo = new HashMap<String, String>();
            exceptionInfo.put("error", this._responseThrowable.getClass().getName());
            exceptionInfo.put("message", this._responseThrowable.getMessage());
            ObjectMapper mapper = new ObjectMapper();
            mapper.getJsonFactory().configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
            StringWriter out = new StringWriter(10240);
            out.write(ERROR_MESSAGE_PREFIX);
            try {
                mapper.writeValue((Writer)out, exceptionInfo);
                out.write(ERROR_MESSAGE_SUFFIX);
                out.close();
                dataBytes = out.toString().getBytes(Charset.defaultCharset());
            }
            catch (IOException e) {
                dataBytes = FALLBACK_ERROR_MESSAGE_BYTES;
            }
            try {
                this._responseContent.write(ByteBuffer.wrap(dataBytes));
            }
            catch (IOException ioe) {
                LOG.error((Object)("Can't serialize exception " + ioe.toString()));
            }
        }
    }

    public PhysicalPartition getCursorPartition() {
        return this._cursorPartition;
    }

    public void setCursorPartition(PhysicalPartition cursorPartition) {
        this._cursorPartition = cursorPartition;
    }

    public HttpMethod getRequestType() {
        return this._requestType;
    }

    public ServerContainer.RuntimeConfig getConfig() {
        return this._config;
    }

    public int getRequiredIntParam(String paramName) throws InvalidRequestParamValueException {
        String paramStr = this.getParams().getProperty(paramName);
        if (null == paramStr) {
            throw new InvalidRequestParamValueException(this.getName(), paramName, "null");
        }
        try {
            return Integer.parseInt(paramStr);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidRequestParamValueException(this.getName(), paramName, paramStr);
        }
    }

    public int getOptionalIntParam(String paramName, int defaultValue) throws InvalidRequestParamValueException {
        String paramStr = this.getParams().getProperty(paramName);
        if (null == paramStr) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(paramStr);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidRequestParamValueException(this.getName(), paramName, paramStr);
        }
    }

    public long getRequiredLongParam(String paramName) throws InvalidRequestParamValueException {
        String paramStr = this.getParams().getProperty(paramName);
        if (null == paramStr) {
            throw new InvalidRequestParamValueException(this.getName(), paramName, "null");
        }
        try {
            return Long.parseLong(paramStr);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidRequestParamValueException(this.getName(), paramName, paramStr);
        }
    }

    public long getOptionalLongParam(String paramName, long defaultValue) throws InvalidRequestParamValueException {
        String paramStr = this.getParams().getProperty(paramName);
        if (null == paramStr) {
            return defaultValue;
        }
        try {
            return Long.parseLong(paramStr);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidRequestParamValueException(this.getName(), paramName, paramStr);
        }
    }

    public String getRequiredStringParam(String paramName) throws InvalidRequestParamValueException {
        String paramValue = this.getParams().getProperty(paramName);
        if (null == paramValue) {
            throw new InvalidRequestParamValueException(this.getName(), paramName, "null");
        }
        return paramValue;
    }

    @Override
    public boolean cancel(boolean arg0) {
        return false;
    }

    @Override
    public DatabusRequest get() throws InterruptedException, ExecutionException {
        return this;
    }

    @Override
    public DatabusRequest get(long arg0, TimeUnit arg1) throws InterruptedException, ExecutionException, TimeoutException {
        return this;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    public void setResponseContent(ChunkedWritableByteChannel responseContent) {
        this._responseContent = responseContent;
    }

    public long getId() {
        return this._id;
    }

    public long getCreateTimestampMs() {
        return this._createTimestampMs;
    }

    public SocketAddress getRemoteAddress() {
        return this._remoteAddress;
    }
}

