/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsTotalStats;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectors;
import com.linkedin.databus2.core.container.monitoring.mbean.ContainerStatisticsCollector;
import com.linkedin.databus2.core.container.monitoring.mbean.ContainerStats;
import com.linkedin.databus2.core.container.monitoring.mbean.ContainerTrafficTotalStats;
import com.linkedin.databus2.core.container.monitoring.mbean.ContainerTrafficTotalStatsMBean;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.core.container.request.AbstractStatsRequestProcessor;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.InvalidRequestParamValueException;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.avro.io.JsonEncoder;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class ContainerStatsRequestProcessor
extends AbstractStatsRequestProcessor {
    public static final String MODULE = ContainerStatsRequestProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "containerStats";
    private static final String OUTBOUND_EVENTS_TOTAL_KEY = "outbound/events/total";
    private static final String OUTBOUND_EVENTS_SOURCES_KEY = "outbound/events/sources";
    private static final String OUTBOUND_EVENTS_SOURCE_PREFIX = "outbound/events/source/";
    private static final String OUTBOUND_EVENTS_PSOURCES_KEY = "outbound/events/psources";
    protected static final String OUTBOUND_EVENTS_PSOURCE_PREFIX = "outbound/events/psource/";
    private static final String OUTBOUND_EVENTS_CLIENTS_KEY = "outbound/events/clients";
    private static final String OUTBOUND_EVENTS_CLIENT_PREFIX = "outbound/events/client/";
    private static final String INBOUND_EVENTS_TOTAL_KEY = "inbound/events/total";
    private static final String INBOUND_EVENTS_SOURCES_KEY = "inbound/events/sources";
    private static final String INBOUND_EVENTS_SOURCE_PREFIX = "inbound/events/source/";
    private static final String INBOUND_EVENTS_PSOURCES_KEY = "inbound/events/psources";
    protected static final String INBOUND_EVENTS_PSOURCE_PREFIX = "inbound/events/psource/";
    private final ServerContainer _container;
    private final ContainerStatisticsCollector _containerStatsCollector;

    public ContainerStatsRequestProcessor(ExecutorService executorService, ServerContainer container) {
        super(COMMAND_NAME, executorService);
        this._container = container;
        this._containerStatsCollector = this._container.getContainerStatsCollector();
    }

    @Override
    public boolean doProcess(String category, DatabusRequest request) throws IOException, RequestProcessingException {
        boolean success = true;
        if (category.equals(OUTBOUND_EVENTS_TOTAL_KEY)) {
            this.processEventsTotalStats(this._container.getOutboundEventStatisticsCollector(), request);
        } else if (category.equals(OUTBOUND_EVENTS_SOURCES_KEY)) {
            this.processEventsSourcesList(this._container.getOutboundEventStatisticsCollector(), request);
        } else if (category.equals(OUTBOUND_EVENTS_PSOURCES_KEY)) {
            this.processEventsPhysicalSourcesList(this._container.getOutBoundStatsCollectors(), request);
        } else if (category.startsWith(OUTBOUND_EVENTS_SOURCE_PREFIX)) {
            this.processEventsSourceStats(this._container.getOutboundEventStatisticsCollector(), OUTBOUND_EVENTS_SOURCE_PREFIX, request);
        } else if (category.startsWith(OUTBOUND_EVENTS_PSOURCE_PREFIX)) {
            this.processPhysicalPartitionStats(this._container.getOutBoundStatsCollectors(), OUTBOUND_EVENTS_PSOURCE_PREFIX, request);
        } else if (category.equals(OUTBOUND_EVENTS_CLIENTS_KEY)) {
            this.processEventsPeersList(this._container.getOutboundEventStatisticsCollector(), request);
        } else if (category.startsWith(OUTBOUND_EVENTS_CLIENT_PREFIX)) {
            this.processEventsPeerStats(this._container.getOutboundEventStatisticsCollector(), OUTBOUND_EVENTS_CLIENT_PREFIX, request);
        } else if (category.equals(INBOUND_EVENTS_TOTAL_KEY)) {
            this.processEventsTotalStats(this._container.getInboundEventStatisticsCollector(), request);
        } else if (category.equals(INBOUND_EVENTS_SOURCES_KEY)) {
            this.processEventsSourcesList(this._container.getInboundEventStatisticsCollector(), request);
        } else if (category.equals(INBOUND_EVENTS_PSOURCES_KEY)) {
            this.processEventsPhysicalSourcesList(this._container.getInBoundStatsCollectors(), request);
        } else if (category.startsWith(INBOUND_EVENTS_SOURCE_PREFIX)) {
            this.processEventsSourceStats(this._container.getInboundEventStatisticsCollector(), INBOUND_EVENTS_SOURCE_PREFIX, request);
        } else if (category.startsWith(INBOUND_EVENTS_PSOURCE_PREFIX)) {
            this.processPhysicalPartitionStats(this._container.getInBoundStatsCollectors(), INBOUND_EVENTS_PSOURCE_PREFIX, request);
        } else if (category.equals("container")) {
            this.processContainerStats(request);
        } else if (category.equals("netty")) {
            this.processNettyStats(request);
        } else if (category.equals("outbound/total")) {
            this.processOutboundTrafficTotalStats(request);
        } else if (category.equals("outbound/clients")) {
            this.processOutboundTrafficClientsList(request);
        } else if (category.startsWith("outbound/client/")) {
            this.processOutboundTrafficClientStats(request);
        } else if (category.equals("inbound/total")) {
            this.processInboundTrafficTotalStats(request);
        } else {
            success = false;
        }
        return success;
    }

    private void processNettyStats(DatabusRequest request) throws IOException {
    }

    private void processContainerStats(DatabusRequest request) throws IOException {
        ContainerStats containerStats = this._containerStatsCollector.getContainerStats();
        if (null == containerStats) {
            return;
        }
        this.writeJsonObjectToResponse(containerStats, request);
    }

    private void processOutboundTrafficTotalStats(DatabusRequest request) throws IOException {
        ContainerTrafficTotalStatsMBean outboundTrafficTotalStatsMBean = this._containerStatsCollector.getOutboundTrafficTotalStats();
        if (null == outboundTrafficTotalStatsMBean) {
            return;
        }
        JsonEncoder jsonEncoder = outboundTrafficTotalStatsMBean.createJsonEncoder(Channels.newOutputStream(request.getResponseContent()));
        outboundTrafficTotalStatsMBean.toJson(jsonEncoder, null);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean(outboundTrafficTotalStatsMBean, request);
        }
    }

    private void processOutboundTrafficClientsList(DatabusRequest request) throws IOException {
        List<String> clientsList = this._containerStatsCollector.getOutboundClients();
        this.writeJsonObjectToResponse(clientsList, request);
    }

    private void processOutboundTrafficClientStats(DatabusRequest request) throws IOException, RequestProcessingException {
        String prefix;
        String category = request.getParams().getProperty("reqpath");
        String client = category.substring((prefix = "outbound/client/").length());
        ContainerTrafficTotalStats clientStats = this._containerStatsCollector.getOutboundClientStats(client);
        if (null == clientStats) {
            throw new InvalidRequestParamValueException(request.getName(), prefix, client);
        }
        JsonEncoder jsonEncoder = clientStats.createJsonEncoder(Channels.newOutputStream(request.getResponseContent()));
        clientStats.toJson(jsonEncoder, null);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean(clientStats, request);
        }
    }

    private void processInboundTrafficTotalStats(DatabusRequest request) throws IOException {
        ContainerTrafficTotalStatsMBean inboundTrafficTotalStatsMBean = this._containerStatsCollector.getInboundTrafficTotalStats();
        if (null == inboundTrafficTotalStatsMBean) {
            return;
        }
        JsonEncoder jsonEncoder = inboundTrafficTotalStatsMBean.createJsonEncoder(Channels.newOutputStream(request.getResponseContent()));
        inboundTrafficTotalStatsMBean.toJson(jsonEncoder, null);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean(inboundTrafficTotalStatsMBean, request);
        }
    }

    private void processEventsTotalStats(DbusEventsStatisticsCollector statsCollector, DatabusRequest request) throws IOException {
        if (null == statsCollector) {
            return;
        }
        DbusEventsTotalStats totalStatsMBean = statsCollector.getTotalStats();
        if (null == totalStatsMBean) {
            return;
        }
        this.writeJsonObjectToResponse(totalStatsMBean, request);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean(totalStatsMBean, request);
        }
    }

    private void processEventsSourcesList(DbusEventsStatisticsCollector statsCollector, DatabusRequest request) throws IOException {
        if (null == statsCollector) {
            return;
        }
        List sourcesList = statsCollector.getSources();
        this.writeJsonObjectToResponse(sourcesList, request);
    }

    private void processEventsPhysicalSourcesList(StatsCollectors<DbusEventsStatisticsCollector> statsCollector, DatabusRequest request) throws IOException {
        if (null == statsCollector) {
            return;
        }
        ArrayList sourcesList = statsCollector.getStatsCollectorKeys();
        this.writeJsonObjectToResponse(sourcesList, request);
    }

    private void processEventsSourceStats(DbusEventsStatisticsCollector statsCollector, String prefix, DatabusRequest request) throws IOException, RequestProcessingException {
        if (null == statsCollector) {
            return;
        }
        String category = request.getParams().getProperty("reqpath");
        String sourceIdStr = category.substring(prefix.length());
        int sourceId = -1;
        try {
            sourceId = Integer.valueOf(sourceIdStr);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidRequestParamValueException("bad srcId:" + request.getName(), prefix, sourceIdStr);
        }
        DbusEventsTotalStats sourceStats = null;
        sourceStats = statsCollector.getSourceStats(sourceId);
        if (null == sourceStats) {
            LOG.warn((Object)("no stats for this srcId: " + request.getName() + "prefix=" + prefix + "source ids " + sourceIdStr));
            sourceStats = new DbusEventsTotalStats(0, sourceIdStr, false, false, null);
        }
        this.writeJsonObjectToResponse(sourceStats, request);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean(sourceStats, request);
        }
    }

    private void processPhysicalPartitionStats(StatsCollectors<DbusEventsStatisticsCollector> statsCollectors, String prefix, DatabusRequest request) throws IOException, RequestProcessingException {
        DbusEventsTotalStats sourceStats;
        if (null == statsCollectors) {
            return;
        }
        String category = request.getParams().getProperty("reqpath");
        String sourceIdStr = category.substring(prefix.length());
        DbusEventsStatisticsCollector s = (DbusEventsStatisticsCollector)statsCollectors.getStatsCollector(sourceIdStr = sourceIdStr.replace('/', ':'));
        DbusEventsTotalStats dbusEventsTotalStats = sourceStats = s == null ? null : s.getTotalStats();
        if (null == sourceStats) {
            LOG.warn((Object)("no stats for this srcId: " + request.getName() + "prefix=" + prefix + "source ids " + sourceIdStr));
            sourceStats = new DbusEventsTotalStats(0, sourceIdStr, false, false, null);
        }
        this.writeJsonObjectToResponse(sourceStats, request);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean(sourceStats, request);
        }
    }

    private void processEventsPeersList(DbusEventsStatisticsCollector statsCollector, DatabusRequest request) throws IOException {
        if (null == statsCollector) {
            return;
        }
        List clientsList = statsCollector.getPeers();
        this.writeJsonObjectToResponse(clientsList, request);
    }

    private void processEventsPeerStats(DbusEventsStatisticsCollector statsCollector, String prefix, DatabusRequest request) throws IOException, RequestProcessingException {
        if (null == statsCollector) {
            return;
        }
        String category = request.getParams().getProperty("reqpath");
        String client = category.substring(prefix.length());
        DbusEventsTotalStats clientStats = statsCollector.getPeerStats(client);
        if (null == clientStats) {
            throw new InvalidRequestParamValueException(request.getName(), prefix, client);
        }
        this.writeJsonObjectToResponse(clientStats, request);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean(clientStats, request);
        }
    }
}

