/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus.core.util.Utils;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.InvalidRequestParamValueException;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class ContainerOperationProcessor
implements RequestProcessor {
    public static final String MODULE = ContainerOperationProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "operation";
    private final ExecutorService _executorService;
    private final ServerContainer _serverContainer;

    public ContainerOperationProcessor(ExecutorService executorService, ServerContainer serverContainer) {
        this._executorService = executorService;
        this._serverContainer = serverContainer;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    @Override
    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        String action = request.getParams().getProperty("reqpath", "");
        if (action.equals("shutdown")) {
            String pid = Utils.getPid();
            String response = "{\"Container\":\"set-shutdown\",\"pid\":\"" + pid + "\"}";
            request.getResponseContent().write(ByteBuffer.wrap(response.getBytes(Charset.defaultCharset())));
            Thread runThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ContainerOperationProcessor.this._serverContainer.shutdown();
                }
            });
            runThread.start();
        } else if (action.equals("pause")) {
            this._serverContainer.pause();
            request.getResponseContent().write(ByteBuffer.wrap("{\"Container\":\"set-pause\"}".getBytes(Charset.defaultCharset())));
        } else if (action.equals("resume")) {
            this._serverContainer.resume();
            request.getResponseContent().write(ByteBuffer.wrap("{\"Container\":\"set-resume\"}".getBytes(Charset.defaultCharset())));
        } else if (action.equals("getpid")) {
            String pid = Utils.getPid();
            String response = "{\"pid\":\"" + pid + "\"}";
            request.getResponseContent().write(ByteBuffer.wrap(response.getBytes(Charset.defaultCharset())));
        } else {
            throw new InvalidRequestParamValueException(COMMAND_NAME, "request path", action);
        }
        return request;
    }
}

