/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus.core.DatabusComponentStatus;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.concurrent.ExecutorService;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class ContainerAdminRequestProcessor
implements RequestProcessor {
    private final ExecutorService _executorService;
    private final DatabusComponentStatus _status;
    private final String _normalizedPath;
    private final String _statusPath;

    public ContainerAdminRequestProcessor(ExecutorService executorService, DatabusComponentStatus status, String healthcheckPath) {
        this._executorService = executorService;
        int slashIdx = healthcheckPath.indexOf(47);
        this._normalizedPath = -1 == slashIdx ? "" : ContainerAdminRequestProcessor.normalizePath(healthcheckPath.substring(slashIdx));
        this._statusPath = 0 == this._normalizedPath.length() ? "status" : this._normalizedPath + "/status";
        this._status = status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        String path = request.getParams().getProperty("reqpath");
        String normPath = ContainerAdminRequestProcessor.normalizePath(path);
        if (null == normPath) {
            if (0 != this._normalizedPath.length()) throw new RequestProcessingException("expected admin sub-command");
            this.returnPlainStatus(request);
            return null;
        } else if (this._normalizedPath.equals(normPath)) {
            this.returnPlainStatus(request);
            return null;
        } else {
            if (!this._statusPath.equals(normPath)) throw new RequestProcessingException("unknown admin sub-command:" + normPath);
            this.returnComponentStatus(request);
        }
        return null;
    }

    public static String extractCommandRoot(String path) {
        int slashIndex = path.indexOf(47);
        return -1 == slashIndex ? path : path.substring(0, slashIndex);
    }

    private static String normalizePath(String path) {
        int endIdx;
        int startIdx;
        if (null == path) {
            return null;
        }
        for (startIdx = 0; startIdx < path.length() && path.charAt(startIdx) == '/'; ++startIdx) {
        }
        for (endIdx = path.length() - 1; endIdx >= 0 && path.charAt(endIdx) == '/'; --endIdx) {
        }
        return path.substring(startIdx, endIdx + 1);
    }

    private void returnComponentStatus(DatabusRequest request) throws IOException {
        Formatter fmt = new Formatter();
        fmt.format("{\"status\":\"%s\",\"message\":\"%s\"}\n", this._status.getStatus().toString(), this._status.getMessage());
        fmt.flush();
        request.getResponseContent().write(ByteBuffer.wrap(fmt.toString().getBytes(Charset.defaultCharset())));
    }

    @Override
    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    private void returnPlainStatus(DatabusRequest request) throws IOException {
        HttpResponseStatus statusCode;
        String statusString;
        if (null != this._status && this._status.getStatus() != DatabusComponentStatus.Status.RUNNING) {
            statusString = "BAD\n";
            statusCode = HttpResponseStatus.SERVICE_UNAVAILABLE;
        } else {
            statusString = "GOOD\n";
            statusCode = HttpResponseStatus.OK;
        }
        request.getResponseContent().setResponseCode(statusCode);
        request.getResponseContent().write(ByteBuffer.wrap(statusString.getBytes(Charset.defaultCharset())));
    }
}

