/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.InvalidRequestType;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class ConfigRequestProcessor
implements RequestProcessor {
    public static final String MODULE = ConfigRequestProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "config";
    private final ExecutorService _executorService;
    private final ServerContainer _serverContainer;

    public ConfigRequestProcessor(ExecutorService executorService, ServerContainer serverContainer) {
        this._executorService = executorService;
        this._serverContainer = serverContainer;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    @Override
    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        LOG.debug((Object)("Method=" + request.getRequestType()));
        if (request.getRequestType() == HttpMethod.GET) {
            this.doGetConfig(request);
        } else if (request.getRequestType() == HttpMethod.POST || request.getRequestType() == HttpMethod.PUT) {
            this.doPutConfig(request);
        } else {
            throw new InvalidRequestType(request.getRequestType(), request.getName());
        }
        return request;
    }

    private void serializeConfig(ServerContainer.RuntimeConfig config, WritableByteChannel destChannel) throws IOException {
        StringWriter out = new StringWriter(10240);
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((Writer)out, (Object)config);
        out.close();
        byte[] dataBytes = out.toString().getBytes(Charset.defaultCharset());
        destChannel.write(ByteBuffer.wrap(dataBytes));
    }

    private void doGetConfig(DatabusRequest request) throws IOException, RequestProcessingException {
        ServerContainer.RuntimeConfig config = request.getConfig();
        this.serializeConfig(config, request.getResponseContent());
    }

    private void doPutConfig(DatabusRequest request) throws IOException, RequestProcessingException {
        Properties cmdParams = request.getParams();
        try {
            this._serverContainer.getContainerRuntimeConfigMgr().loadConfig((Map)cmdParams);
        }
        catch (InvalidConfigException ice) {
            throw new RequestProcessingException("config load failed", ice);
        }
        ServerContainer.RuntimeConfig newConfig = (ServerContainer.RuntimeConfig)this._serverContainer.getContainerRuntimeConfigMgr().getReadOnlyConfig();
        this.serializeConfig(newConfig, request.getResponseContent());
    }
}

