/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus2.core.container.request.BinaryCommandParser;
import com.linkedin.databus2.core.container.request.BinaryCommandParserFactory;
import com.linkedin.databus2.core.container.request.ProcessorRegistrationConflictException;
import com.linkedin.databus2.core.container.request.RequestExecutionHandlerFactory;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.SimpleChannelHandler;

public class CommandsRegistry {
    private final Map<Byte, BinaryCommandParserFactory> _binaryParsers = new HashMap<Byte, BinaryCommandParserFactory>();
    private final Map<Byte, RequestExecutionHandlerFactory> _tcpExecHandlers = new HashMap<Byte, RequestExecutionHandlerFactory>();
    private final Map<String, RequestExecutionHandlerFactory> _httpExecHandlers = new HashMap<String, RequestExecutionHandlerFactory>();

    public void registerCommand(String name, Byte opcode, BinaryCommandParserFactory binaryParserFactory, RequestExecutionHandlerFactory execHandlerFactory) throws ProcessorRegistrationConflictException {
        if (null != opcode) {
            if (this._binaryParsers.containsKey(opcode)) {
                throw new ProcessorRegistrationConflictException(name);
            }
            this._binaryParsers.put(opcode, binaryParserFactory);
            this._tcpExecHandlers.put(opcode, execHandlerFactory);
        }
        if (null != name) {
            this._httpExecHandlers.put(name, execHandlerFactory);
        }
    }

    public BinaryCommandParser createParser(byte opcode, Channel channel, ByteOrder byteOrder) {
        BinaryCommandParserFactory factory = this._binaryParsers.get(opcode);
        return null != factory ? factory.createParser(channel, byteOrder) : null;
    }

    public SimpleChannelHandler createExecHandler(byte opcode, Channel channel) {
        RequestExecutionHandlerFactory factory = this._tcpExecHandlers.get(opcode);
        return null != factory ? factory.createHandler(channel) : null;
    }

    public SimpleChannelHandler createExecHandler(String name, Channel channel) {
        RequestExecutionHandlerFactory factory = this._httpExecHandlers.get(name);
        return null != factory ? factory.createHandler(channel) : null;
    }
}

