/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import java.nio.ByteOrder;

public class BinaryProtocol {
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static final byte RECOVERABLE_ERROR_THRESHOLD = 0;
    public static final byte UNRECOVERABLE_ERROR_THRESHOLD = -64;
    public static final int MAX_ERROR_CLASS_LEN = 100;
    public static final int MAX_ERROR_MESSAGE_LEN = 1000;
    public static final byte RESULT_OK = 0;
    public static final byte RESULT_ERR_INTERNAL_SERVER_ERROR = -1;
    public static final byte RESULT_ERR_SOURCES_TOO_OLD = -2;
    public static final byte RESULT_ERR_UNKNOWN_PARTITION = -3;
    public static final byte RESULT_ERR_UNKNOWN_COMMAND = -65;
    public static final byte RESULT_ERR_UNSUPPORTED_PROTOCOL_VERSION = -66;
    public static final byte RESULT_ERR_UNEXPECTED_COMMAND = -67;
    public static final byte RESULT_ERR_INVALID_REQ_PARAM = -68;
    public static final byte RESULT_ERR_UNEXPECTED_CONTROL_EVENT = -69;
    public static final byte RESULT_ERR_INVALID_EVENT = -70;
    public static final byte RESULT_ERR_UNSUPPORTED_DBUS_EVENT_VERSION = -71;
    public static final byte RESULT_ERR_INVALID_METADATA = -72;

    public static ErrorType getErrorType(byte code) {
        if (code == 0) {
            return ErrorType.NONE;
        }
        if (code < -64) {
            return ErrorType.UNRECOVERABLE;
        }
        return ErrorType.RECOVERABLE;
    }

    public static enum ErrorType {
        NONE,
        RECOVERABLE,
        UNRECOVERABLE;

    }
}

