/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.request;

import com.linkedin.databus.core.monitoring.mbean.DatabusMonitoringMBean;
import com.linkedin.databus2.core.container.request.AbstractRequestProcesser;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.InvalidRequestParamValueException;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public abstract class AbstractStatsRequestProcessor
extends AbstractRequestProcesser {
    public static final String MODULE = AbstractStatsRequestProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String RESET_PARAM = "reset";
    public static final String ENABLED_PARAM = "enabled";
    private final ExecutorService _executorService;
    private final String _commandName;

    public AbstractStatsRequestProcessor(String commandName, ExecutorService executorService) {
        this._executorService = executorService;
        this._commandName = commandName;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    @Override
    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        String category = request.getParams().getProperty("reqpath");
        if (null == category) {
            throw new InvalidRequestParamValueException(this._commandName, "category", "null");
        }
        if (!this.doProcess(category, request)) {
            throw new InvalidRequestParamValueException(this._commandName, "category", category);
        }
        return request;
    }

    protected abstract boolean doProcess(String var1, DatabusRequest var2) throws IOException, RequestProcessingException;

    protected <T> void enableOrResetStatsMBean(DatabusMonitoringMBean<T> bean, DatabusRequest request) {
        String resetStr;
        String enabledStr = request.getParams().getProperty(ENABLED_PARAM);
        if (null != enabledStr) {
            boolean newEnabled = Boolean.parseBoolean(enabledStr);
            bean.setEnabled(newEnabled);
        }
        if (null != (resetStr = request.getParams().getProperty(RESET_PARAM))) {
            bean.reset();
        }
    }
}

