/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.netty;

import com.linkedin.databus2.core.container.ExtendedReadTimeoutHandler;
import com.linkedin.databus2.core.container.ExtendedWriteTimeoutHandler;
import com.linkedin.databus2.core.container.netty.ConnectionChannelRegistrationHandler;
import com.linkedin.databus2.core.container.netty.OutboundContainerStatisticsCollectingHandler;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.core.container.request.SimpleBinaryDatabusRequestDecoder;
import com.linkedin.databus2.core.container.request.SimpleBinaryDatabusResponseEncoder;
import java.nio.ByteOrder;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.logging.LoggingHandler;
import org.jboss.netty.logging.InternalLogLevel;

public class TcpServerPipelineFactory
implements ChannelPipelineFactory {
    private final ServerContainer _serverContainer;
    private final ByteOrder _byteOrder;

    public TcpServerPipelineFactory(ServerContainer serverContainer, ByteOrder byteOrder) {
        this._serverContainer = serverContainer;
        this._byteOrder = byteOrder;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("auto group register ", (ChannelHandler)new ConnectionChannelRegistrationHandler(this._serverContainer.getTcpChannelGroup()));
        if (Logger.getRootLogger().isTraceEnabled()) {
            pipeline.addLast("netty server traffic", (ChannelHandler)new LoggingHandler("netty server traffic", InternalLogLevel.DEBUG, true));
        }
        pipeline.addLast("outbound statistics collector", (ChannelHandler)new OutboundContainerStatisticsCollectingHandler(this._serverContainer.getContainerStatsCollector()));
        ExtendedWriteTimeoutHandler writeTimeoutHandler = new ExtendedWriteTimeoutHandler("server container " + this._serverContainer.getContainerStaticConfig().getId(), this._serverContainer.getNetworkTimeoutTimer(), this._serverContainer.getContainerStaticConfig().getWriteTimeoutMs(), true);
        ExtendedReadTimeoutHandler readTimeoutHandler = new ExtendedReadTimeoutHandler("server container " + this._serverContainer.getContainerStaticConfig().getId(), this._serverContainer.getNetworkTimeoutTimer(), this._serverContainer.getContainerStaticConfig().getReadTimeoutMs(), true);
        pipeline.addLast("read timeout", (ChannelHandler)readTimeoutHandler);
        pipeline.addLast("server container write timeout handler", (ChannelHandler)writeTimeoutHandler);
        pipeline.addLast("decoder", (ChannelHandler)new SimpleBinaryDatabusRequestDecoder(this._serverContainer.getCommandsRegistry(), readTimeoutHandler, this._byteOrder));
        pipeline.addLast("encoder", (ChannelHandler)new SimpleBinaryDatabusResponseEncoder());
        pipeline.addLast("request execute hander", (ChannelHandler)new LoggingHandler("netty server traffic", InternalLogLevel.DEBUG, true));
        return pipeline;
    }
}

