/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.netty;

import com.linkedin.databus.core.DatabusComponentStatus;
import com.linkedin.databus.core.monitoring.mbean.AggregatedDbusEventsStatisticsCollector;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectorMergeable;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectors;
import com.linkedin.databus.core.util.ConfigApplier;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigManager;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus.core.util.JsonUtils;
import com.linkedin.databus.core.util.NamedThreadFactory;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.JmxStaticConfig;
import com.linkedin.databus2.core.container.JmxStaticConfigBuilder;
import com.linkedin.databus2.core.container.monitoring.mbean.ContainerStatisticsCollector;
import com.linkedin.databus2.core.container.monitoring.mbean.DatabusComponentAdmin;
import com.linkedin.databus2.core.container.netty.HttpServerPipelineFactory;
import com.linkedin.databus2.core.container.netty.JmxShutdownThread;
import com.linkedin.databus2.core.container.netty.TcpServerPipelineFactory;
import com.linkedin.databus2.core.container.request.CommandsRegistry;
import com.linkedin.databus2.core.container.request.ContainerAdminRequestProcessor;
import com.linkedin.databus2.core.container.request.ContainerStatsRequestProcessor;
import com.linkedin.databus2.core.container.request.JavaStatsRequestProcessor;
import com.linkedin.databus2.core.container.request.RequestProcessorRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.NameAlreadyBoundException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.DirectChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Log4JLoggerFactory;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.Timer;

public abstract class ServerContainer {
    public static final String MODULE = ServerContainer.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final int GLOBAL_STATS_MERGE_INTERVAL_MS = 10000;
    private static final int SHUTDOWN_TIMEOUT_MS = 30000;
    private Timer _networkTimeoutTimer = null;
    protected final StaticConfig _containerStaticConfig;
    private final MBeanServer _mbeanServer;
    private final ThreadPoolExecutor _defaultExecutorService;
    private final ExecutorService _ioExecutorService;
    private final ExecutorService _bossExecutorService;
    private final ExecutionHandler _nettyExecHandler;
    private final ConfigManager<RuntimeConfig> _containerRuntimeConfigMgr;
    private final ContainerStatisticsCollector _containerStatsCollector;
    private final ReentrantLock _controlLock = new ReentrantLock(true);
    private final Condition _shutdownCondition = this._controlLock.newCondition();
    private final Condition _shutdownFinishedCondition = this._controlLock.newCondition();
    protected final StatsCollectors<DbusEventsStatisticsCollector> _inBoundStatsCollectors;
    protected final StatsCollectors<DbusEventsStatisticsCollector> _outBoundStatsCollectors;
    private final DatabusComponentAdmin _componentAdmin;
    private final DatabusComponentStatus _componentStatus;
    protected final GlobalStatsCalc _globalStatsMerger;
    private final Thread _globalStatsThread;
    protected final RequestProcessorRegistry _processorRegistry;
    protected final CommandsRegistry _commandsRegistry;
    private JMXConnectorServer _jmxConnServer;
    private JmxShutdownThread _jmxShutdownThread;
    private NettyShutdownThread _nettyShutdownThread;
    private Thread _containerShutdownHook;
    private volatile boolean _shutdown = false;
    private boolean _shutdownRequest = false;
    private boolean _started = false;
    private String _baseDir = ".";
    private final ByteOrder _dbusEventByteOrder;
    protected ServerBootstrap _httpBootstrap;
    protected ServerBootstrap _tcpBootstrap;
    protected Channel _httpServerChannel;
    protected Channel _tcpServerChannel;
    protected int _containerPort = -1;
    private static Cli _staticCliToBeDeprecated = new Cli();
    protected ChannelGroup _tcpChannelGroup;
    protected ChannelGroup _httpChannelGroup;
    public static final String JMX_DOMAIN = "com.linkedin.databus2";

    @Deprecated
    public static Properties processCommandLineArgs(String[] cliArgs) throws IOException, DatabusException {
        _staticCliToBeDeprecated.processCommandLineArgs(cliArgs);
        return _staticCliToBeDeprecated.getConfigProps();
    }

    public RequestProcessorRegistry getProcessorRegistry() {
        return this._processorRegistry;
    }

    public ByteOrder getDbusEventByteOrder() {
        return this._dbusEventByteOrder;
    }

    public ServerContainer(StaticConfig config, ByteOrder byteOrder) throws IOException, InvalidConfigException, DatabusException {
        this._containerStaticConfig = config;
        this._baseDir = config.getContainerBaseDir();
        this._networkTimeoutTimer = new HashedWheelTimer(5L, TimeUnit.MILLISECONDS);
        this._processorRegistry = new RequestProcessorRegistry();
        this._commandsRegistry = new CommandsRegistry();
        this._mbeanServer = this._containerStaticConfig.getOrCreateMBeanServer();
        this._containerStaticConfig.getRuntime().setManagedInstance(this);
        this._dbusEventByteOrder = byteOrder;
        RuntimeConfigBuilder runtimeConfig = this._containerStaticConfig.getRuntime();
        this._ioExecutorService = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("io" + this._containerStaticConfig.getId()));
        this._bossExecutorService = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("boss" + this._containerStaticConfig.getId()));
        this._defaultExecutorService = new OrderedMemoryAwareThreadPoolExecutor(runtimeConfig.getDefaultExecutor().getMaxThreadsNum(), 0L, 0L, (long)runtimeConfig.getDefaultExecutor().getKeepAliveMs(), TimeUnit.MILLISECONDS, (ThreadFactory)new NamedThreadFactory("worker" + this._containerStaticConfig.getId()));
        this._containerStatsCollector = this._containerStaticConfig.getOrCreateContainerStatsCollector();
        AggregatedDbusEventsStatisticsCollector inboundEventStatisticsCollector = new AggregatedDbusEventsStatisticsCollector(this.getContainerStaticConfig().getId(), "eventsInbound", true, true, this.getMbeanServer());
        AggregatedDbusEventsStatisticsCollector outboundEventStatisticsCollector = new AggregatedDbusEventsStatisticsCollector(this.getContainerStaticConfig().getId(), "eventsOutbound", true, true, this.getMbeanServer());
        this._inBoundStatsCollectors = new StatsCollectors((StatsCollectorMergeable)inboundEventStatisticsCollector);
        this._outBoundStatsCollectors = new StatsCollectors((StatsCollectorMergeable)outboundEventStatisticsCollector);
        this._containerRuntimeConfigMgr = new ConfigManager(this._containerStaticConfig.getRuntimeConfigPropertyPrefix(), (ConfigBuilder)this._containerStaticConfig.getRuntime());
        this._nettyExecHandler = new ExecutionHandler((Executor)this._defaultExecutorService);
        this._componentStatus = this.createComponentStatus();
        this._componentAdmin = this.createComponentAdmin();
        this._componentAdmin.registerAsMBean();
        this._globalStatsMerger = new GlobalStatsCalc(10000);
        this._globalStatsThread = new Thread((Runnable)this._globalStatsMerger, "GlobalStatsThread");
        this._globalStatsThread.setDaemon(true);
        this.initializeContainerNetworking(byteOrder);
        this.initializeContainerJmx();
        this.initializeContainerCommandProcessors();
        this.initializeStatsMerger();
    }

    private void initializeStatsMerger() {
        this._globalStatsMerger.registerStatsCollector(this._inBoundStatsCollectors);
        this._globalStatsMerger.registerStatsCollector(this._outBoundStatsCollectors);
    }

    protected void initializeContainerCommandProcessors() throws DatabusException {
        this._processorRegistry.register("containerStats", new ContainerStatsRequestProcessor(null, this));
        this._processorRegistry.register("javaStats", new JavaStatsRequestProcessor(null));
        String healthcheckPrefix = ContainerAdminRequestProcessor.extractCommandRoot(this._containerStaticConfig.getHealthcheckPath());
        LOG.info((Object)("healthcheck command root: " + healthcheckPrefix));
        this._processorRegistry.register(healthcheckPrefix, new ContainerAdminRequestProcessor(null, this._componentStatus, this._containerStaticConfig.getHealthcheckPath()));
    }

    protected abstract DatabusComponentAdmin createComponentAdmin();

    protected DatabusComponentStatus createComponentStatus() {
        return new DatabusComponentStatus("Relay", DatabusComponentStatus.Status.INITIALIZING, "The databus component is initializing...");
    }

    protected void initializeContainerNetworking(ByteOrder byteOrder) throws IOException, DatabusException {
        ThreadRenamingRunnable.setThreadNameDeterminer((ThreadNameDeterminer)ThreadNameDeterminer.CURRENT);
        this._httpBootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)this._bossExecutorService, (Executor)this._ioExecutorService));
        this._httpBootstrap.setPipelineFactory((ChannelPipelineFactory)new HttpServerPipelineFactory(this));
        this._httpBootstrap.setOption("bufferFactory", (Object)DirectChannelBufferFactory.getInstance((ByteOrder)byteOrder));
        this._httpBootstrap.setOption("child.bufferFactory", (Object)DirectChannelBufferFactory.getInstance((ByteOrder)byteOrder));
        if (this._containerStaticConfig.getTcp().isEnabled()) {
            this._tcpBootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)this._bossExecutorService, (Executor)this._ioExecutorService));
            this._tcpBootstrap.setPipelineFactory((ChannelPipelineFactory)new TcpServerPipelineFactory(this, byteOrder));
            this._tcpBootstrap.setOption("bufferFactory", (Object)DirectChannelBufferFactory.getInstance((ByteOrder)byteOrder));
            this._tcpBootstrap.setOption("child.bufferFactory", (Object)DirectChannelBufferFactory.getInstance((ByteOrder)byteOrder));
        }
    }

    protected void initializeContainerJmx() {
        if (this._containerStaticConfig.getJmx().isRmiEnabled()) {
            try {
                JMXServiceURL jmxServiceUrl = new JMXServiceURL("service:jmx:rmi://" + this._containerStaticConfig.getJmx().getJmxServiceHost() + ":" + this._containerStaticConfig.getJmx().getJmxServicePort() + "/jndi/rmi://" + this._containerStaticConfig.getJmx().getRmiRegistryHost() + ":" + this._containerStaticConfig.getJmx().getRmiRegistryPort() + "/jmxrmi" + this._containerStaticConfig.getJmx().getJmxServicePort());
                this._jmxConnServer = JMXConnectorServerFactory.newJMXConnectorServer(jmxServiceUrl, null, this.getMbeanServer());
            }
            catch (Exception e) {
                LOG.warn((Object)"Unable to instantiate JMX server", (Throwable)e);
            }
        }
    }

    public void startAndBlock() {
        this.start();
        this.awaitShutdown();
    }

    public synchronized void start() {
        if (!this._started) {
            this.doStart();
            this._componentStatus.start();
            this._started = true;
            LOG.info((Object)"Databus service started!");
        } else {
            LOG.info((Object)"Databus service has already been started. Skipping this request !!");
        }
    }

    public void startAsynchronously() {
        Thread runThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ServerContainer.this.startAndBlock();
            }
        }, "ServerContainerStartAsync");
        runThread.start();
    }

    protected void doStart() {
        this._controlLock.lock();
        try {
            int portNum = this.getContainerStaticConfig().getHttpPort();
            this._tcpChannelGroup = new DefaultChannelGroup();
            this._httpChannelGroup = new DefaultChannelGroup();
            this._httpServerChannel = this._httpBootstrap.bind((SocketAddress)new InetSocketAddress(portNum));
            InetSocketAddress actualAddress = (InetSocketAddress)this._httpServerChannel.getLocalAddress();
            this._containerPort = actualAddress.getPort();
            File portNumFile = new File(this.getHttpPortFileName());
            portNumFile.deleteOnExit();
            try {
                FileWriter portNumFileW = new FileWriter(portNumFile);
                portNumFileW.write(Integer.toString(this._containerPort));
                portNumFileW.close();
                LOG.info((Object)("Saving port number in " + portNumFile.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this._httpChannelGroup.add((Object)this._httpServerChannel);
            LOG.info((Object)("Serving container " + this.getContainerStaticConfig().getId() + " HTTP listener on port " + this._containerPort));
            if (this._containerStaticConfig.getTcp().isEnabled()) {
                int tcpPortNum = this._containerStaticConfig.getTcp().getPort();
                this._tcpServerChannel = this._tcpBootstrap.bind((SocketAddress)new InetSocketAddress(tcpPortNum));
                this._tcpChannelGroup.add((Object)this._tcpServerChannel);
                LOG.info((Object)("Serving container " + this.getContainerStaticConfig().getId() + " TCP listener on port " + tcpPortNum));
            }
            this._nettyShutdownThread = new NettyShutdownThread();
            Runtime.getRuntime().addShutdownHook(this._nettyShutdownThread);
            if (null != this._jmxConnServer && this._containerStaticConfig.getJmx().isRmiEnabled()) {
                try {
                    this._jmxShutdownThread = new JmxShutdownThread(this._jmxConnServer);
                    Runtime.getRuntime().addShutdownHook(this._jmxShutdownThread);
                    this._jmxConnServer.start();
                    LOG.info((Object)("JMX server listening on port " + this._containerStaticConfig.getJmx().getJmxServicePort()));
                }
                catch (IOException ioe) {
                    if (ioe.getCause() != null && ioe.getCause() instanceof NameAlreadyBoundException) {
                        LOG.warn((Object)"Unable to bind JMX server connector. Likely cause is that the previous instance was not cleanly shutdown: killed in Eclipse?");
                        if (this._jmxConnServer.isActive()) {
                            LOG.warn((Object)"JMX server connector seems to be running anyway. ");
                        } else {
                            LOG.warn((Object)"Unable to determine if JMX server connector is running");
                        }
                    }
                    LOG.error((Object)"Unable to start JMX server connector", (Throwable)ioe);
                }
            }
            this._globalStatsThread.start();
        }
        catch (RuntimeException ex) {
            LOG.error((Object)("Got runtime exception :" + ex), (Throwable)ex);
            throw ex;
        }
        finally {
            this._controlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitShutdown() {
        this._controlLock.lock();
        try {
            while (!this._shutdownRequest) {
                LOG.info((Object)("waiting for shutdown request for container id: " + this._containerStaticConfig.getId()));
                this._shutdownCondition.awaitUninterruptibly();
            }
        }
        finally {
            this._controlLock.unlock();
        }
        this._controlLock.lock();
        try {
            while (!this._shutdown) {
                LOG.info((Object)("Waiting for shutdown complete for serving container: " + this._containerStaticConfig.getId()));
                this._shutdownFinishedCondition.awaitUninterruptibly();
            }
        }
        finally {
            this._controlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitShutdown(long timeoutMs) throws TimeoutException, InterruptedException {
        long waitTime;
        long startTs = System.currentTimeMillis();
        long endTs = startTs + timeoutMs;
        this._controlLock.lock();
        try {
            while (!this._shutdownRequest && (waitTime = endTs - System.currentTimeMillis()) > 0L) {
                LOG.info((Object)("waiting for shutdown request for container id: " + this._containerStaticConfig.getId()));
                if (this._shutdownCondition.await(waitTime, TimeUnit.MILLISECONDS)) continue;
                break;
            }
        }
        finally {
            this._controlLock.unlock();
        }
        if (!this._shutdownRequest) {
            LOG.error((Object)"timeout waiting for a shutdown request");
            throw new TimeoutException("timeout waiting for shutdown request");
        }
        this._controlLock.lock();
        try {
            while (!this._shutdown && (waitTime = endTs - System.currentTimeMillis()) > 0L) {
                LOG.info((Object)("Waiting for shutdown complete for serving container: " + this._containerStaticConfig.getId()));
                if (this._shutdownFinishedCondition.await(waitTime, TimeUnit.MILLISECONDS)) continue;
                break;
            }
        }
        finally {
            this._controlLock.unlock();
        }
        if (!this._shutdown) {
            LOG.error((Object)"timeout waiting for shutdown");
            throw new TimeoutException("timeout waiting for shutdown to complete");
        }
    }

    protected void doShutdown() {
        this.unregisterShutdownHook();
        LOG.info((Object)("Initializing shutdown for serving container: " + this._containerStaticConfig.getId()));
        if (null != this._jmxShutdownThread && Thread.State.NEW == this._jmxShutdownThread.getState()) {
            try {
                Runtime.getRuntime().removeShutdownHook(this._jmxShutdownThread);
                this._jmxShutdownThread.start();
            }
            catch (IllegalStateException ise) {
                LOG.error((Object)"Error removing shutdown hook", (Throwable)ise);
            }
        }
        if (null != this._nettyShutdownThread && Thread.State.NEW == this._nettyShutdownThread.getState()) {
            try {
                Runtime.getRuntime().removeShutdownHook(this._nettyShutdownThread);
                this._nettyShutdownThread.start();
            }
            catch (IllegalStateException ise) {
                LOG.error((Object)"Error removing shutdown hook", (Throwable)ise);
            }
        }
        if (this._globalStatsMerger != null && !this._globalStatsMerger.isHalted()) {
            this._globalStatsMerger.halt();
            this._globalStatsThread.interrupt();
        }
        this.getContainerStatsCollector().unregisterMBeans();
        this.getInboundEventStatisticsCollector().unregisterMBeans();
        this.getOutboundEventStatisticsCollector().unregisterMBeans();
        for (DbusEventsStatisticsCollector coll : this._inBoundStatsCollectors.getStatsCollectors()) {
            coll.unregisterMBeans();
        }
        for (DbusEventsStatisticsCollector coll : this._outBoundStatsCollectors.getStatsCollectors()) {
            coll.unregisterMBeans();
        }
        this._componentAdmin.unregisterAsMBeans();
        LOG.info((Object)"joining shutdown threads");
        long startTime = System.currentTimeMillis();
        long timeRemaining = 30000L;
        while (null != this._jmxShutdownThread && this._jmxShutdownThread.isAlive() && timeRemaining > 0L) {
            try {
                this._jmxShutdownThread.join(timeRemaining);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            timeRemaining = 30000L - (System.currentTimeMillis() - startTime);
        }
        LOG.info((Object)("JMX shutdown for container " + this._containerStaticConfig.getId() + ":" + (null != this._jmxShutdownThread ? !this._jmxShutdownThread.isAlive() : true) + "; ms remaining: " + timeRemaining));
        while (null != this._nettyShutdownThread && this._nettyShutdownThread.isAlive() && timeRemaining > 0L) {
            try {
                this._nettyShutdownThread.join(timeRemaining);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            timeRemaining = 30000L - (System.currentTimeMillis() - startTime);
        }
        LOG.info((Object)("Netty shutdown for container " + this._containerStaticConfig.getId() + ":" + (null != this._nettyShutdownThread ? !this._nettyShutdownThread.isAlive() : true) + "; ms remaining: " + timeRemaining));
        LOG.info((Object)("Done with shutdown for serving container: " + this._containerStaticConfig.getId()));
    }

    public void shutdown() {
        this.shutdownAsynchronously();
        try {
            this.awaitShutdown(30000L);
        }
        catch (TimeoutException e) {
            LOG.error((Object)"shutdown timed out");
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"shutdown cancelled because of interruption");
        }
    }

    public void shutdownUninteruptibly() {
        this.shutdownAsynchronously();
        this.awaitShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAsynchronously() {
        LOG.info((Object)("Initiating asynchronous shutdown for serving container: " + this._containerStaticConfig.getId()));
        this._controlLock.lock();
        try {
            if (this._shutdown) {
                return;
            }
            if (!this._shutdownRequest) {
                this._shutdownRequest = true;
                this._shutdownCondition.signalAll();
                Thread shutdownThread = new Thread((Runnable)new ShutdownRunnable(), "shutdown thread for container: " + this._containerStaticConfig.getId());
                shutdownThread.setDaemon(true);
                shutdownThread.start();
            }
        }
        finally {
            this._controlLock.unlock();
        }
    }

    public DatabusComponentStatus.Status getStatus() {
        return this._componentStatus.getStatus();
    }

    public String getStatusMessage() {
        return this._componentStatus.getMessage();
    }

    public boolean isRunningStatus() {
        return this._componentStatus.isRunningStatus();
    }

    public MBeanServer getMbeanServer() {
        return this._mbeanServer;
    }

    public StaticConfig getContainerStaticConfig() {
        return this._containerStaticConfig;
    }

    public ExecutionHandler getNettyExecHandler() {
        return this._nettyExecHandler;
    }

    public ConfigManager<RuntimeConfig> getContainerRuntimeConfigMgr() {
        return this._containerRuntimeConfigMgr;
    }

    public ThreadPoolExecutor getDefaultExecutorService() {
        return this._defaultExecutorService;
    }

    public ContainerStatisticsCollector getContainerStatsCollector() {
        return this._containerStatsCollector;
    }

    public GlobalStatsCalc getGlobalStatsMerger() {
        return this._globalStatsMerger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerShutdownHook() {
        this._controlLock.lock();
        try {
            if (null != this._containerShutdownHook) {
                return;
            }
            this._containerShutdownHook = new Thread(new Runnable(){

                @Override
                public void run() {
                    ServerContainer.this.shutdown();
                }
            }, "shutdownHook-" + this._containerStaticConfig.getId());
            Runtime.getRuntime().addShutdownHook(this._containerShutdownHook);
        }
        finally {
            this._controlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregisterShutdownHook() {
        this._controlLock.lock();
        try {
            if (null != this._containerShutdownHook) {
                Runtime.getRuntime().removeShutdownHook(this._containerShutdownHook);
                this._containerShutdownHook = null;
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            this._controlLock.unlock();
        }
    }

    public StatsCollectors<DbusEventsStatisticsCollector> getInBoundStatsCollectors() {
        return this._inBoundStatsCollectors;
    }

    public StatsCollectors<DbusEventsStatisticsCollector> getOutBoundStatsCollectors() {
        return this._outBoundStatsCollectors;
    }

    public DbusEventsStatisticsCollector getInboundEventStatisticsCollector() {
        return (DbusEventsStatisticsCollector)this._inBoundStatsCollectors.getStatsCollector();
    }

    public DbusEventsStatisticsCollector getOutboundEventStatisticsCollector() {
        return (DbusEventsStatisticsCollector)this._outBoundStatsCollectors.getStatsCollector();
    }

    public abstract void pause();

    public abstract void resume();

    public abstract void suspendOnError(Throwable var1);

    public DatabusComponentAdmin getComponentAdmin() {
        return this._componentAdmin;
    }

    public DatabusComponentStatus getComponentStatus() {
        return this._componentStatus;
    }

    public ExecutorService getIoExecutorService() {
        return this._ioExecutorService;
    }

    protected ChannelGroup getTcpChannelGroup() {
        return this._tcpChannelGroup;
    }

    protected ChannelGroup getHttpChannelGroup() {
        return this._httpChannelGroup;
    }

    public Timer getNetworkTimeoutTimer() {
        return this._networkTimeoutTimer;
    }

    public CommandsRegistry getCommandsRegistry() {
        return this._commandsRegistry;
    }

    public boolean hasClientStarted() {
        return this._started;
    }

    protected void setStarted(boolean started) {
        this._started = started;
    }

    public ExecutorService getBossExecutorService() {
        return this._bossExecutorService;
    }

    public int getHttpPort() {
        return this._containerPort;
    }

    public String getBaseDir() {
        return this._baseDir;
    }

    public String getHttpPortFileName() {
        return new File(this._baseDir, "containerPortNum_" + this._containerStaticConfig.getId()).getAbsolutePath();
    }

    private class ShutdownRunnable
    implements Runnable {
        private ShutdownRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerContainer.this._controlLock.lock();
            try {
                try {
                    ServerContainer.this.doShutdown();
                }
                catch (Exception e) {
                    LOG.error((Object)"shutdown error", (Throwable)e);
                }
                ServerContainer.this._shutdown = true;
                ServerContainer.this._shutdownFinishedCondition.signalAll();
            }
            finally {
                ServerContainer.this._controlLock.unlock();
            }
        }
    }

    class NettyShutdownThread
    extends Thread {
        public NettyShutdownThread() {
            super("Databus2 Netty Shutdown Thread");
        }

        @Override
        public void run() {
            LOG.info((Object)"Starting shutdown procedure for Netty ...");
            if (null != ServerContainer.this._httpServerChannel) {
                LOG.info((Object)"closing http server channel ...");
                ServerContainer.this._httpServerChannel.close().awaitUninterruptibly();
                ServerContainer.this._httpChannelGroup.remove((Object)ServerContainer.this._httpServerChannel);
            }
            if (null != ServerContainer.this._tcpServerChannel) {
                LOG.info((Object)"closing tcp server channel ...");
                ServerContainer.this._tcpServerChannel.close().awaitUninterruptibly();
                ServerContainer.this._tcpChannelGroup.remove((Object)ServerContainer.this._tcpServerChannel);
            }
            if (null != ServerContainer.this._tcpChannelGroup) {
                LOG.info((Object)("closing tcp channel group with " + ServerContainer.this._tcpChannelGroup.size() + " channels ..."));
                ServerContainer.this._tcpChannelGroup.close().awaitUninterruptibly();
            }
            if (null != ServerContainer.this._httpChannelGroup) {
                LOG.info((Object)("closing http channel group with " + ServerContainer.this._httpChannelGroup.size() + " channels ..."));
                ServerContainer.this._httpChannelGroup.close().awaitUninterruptibly();
            }
            if (null != ServerContainer.this._httpBootstrap) {
                LOG.info((Object)"releasing netty http resources ...");
                ServerContainer.this._httpBootstrap.releaseExternalResources();
            }
            if (null != ServerContainer.this._tcpBootstrap) {
                LOG.info((Object)"releasing netty tcp resources ...");
                ServerContainer.this._tcpBootstrap.releaseExternalResources();
            }
            LOG.info((Object)"stopping network timeout timer");
            ServerContainer.this._networkTimeoutTimer.stop();
            LOG.info((Object)"Done shutting down Netty.");
        }
    }

    public static class GlobalStatsCalc
    implements Runnable {
        private boolean _stopRequested = false;
        private boolean _stopped = false;
        private final int _sleepInMs;
        private final List<StatsCollectors<? extends StatsCollectorMergeable<?>>> _stats;

        public GlobalStatsCalc(int sleepInMs) {
            this._sleepInMs = sleepInMs;
            this._stats = new ArrayList(5);
        }

        public synchronized void registerStatsCollector(StatsCollectors<? extends StatsCollectorMergeable<?>> coll) {
            this._stats.add(coll);
        }

        public synchronized void deregisterStatsCollector(StatsCollectors<? extends StatsCollectorMergeable<?>> coll) {
            this._stats.remove(coll);
        }

        public void halt() {
            this._stopRequested = true;
        }

        public boolean isHalted() {
            return this._stopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this._stopped = false;
                while (!this._stopRequested) {
                    GlobalStatsCalc globalStatsCalc = this;
                    synchronized (globalStatsCalc) {
                        try {
                            for (StatsCollectors<? extends StatsCollectorMergeable<?>> statsCollectors : this._stats) {
                                statsCollectors.mergeStatsCollectors();
                            }
                        }
                        catch (RuntimeException r) {
                            LOG.error((Object)"Error during merging of stats ", (Throwable)r);
                        }
                    }
                    if (this._stopRequested) continue;
                    Thread.sleep(this._sleepInMs);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._stopped = true;
        }
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        private int _id = -1;
        private int _httpPort = 9000;
        private JmxStaticConfigBuilder _jmx = new JmxStaticConfigBuilder();
        private MBeanServer _existingMbeanServer = null;
        private String _runtimeConfigPropertyPrefix = "databus.container.runtime";
        private RuntimeConfigBuilder _runtime = new RuntimeConfigBuilder();
        private int _defaultId;
        private String _healthcheckPath = "admin";
        private long _readTimeoutMs = 15000L;
        private long _bstReadTimeoutMs = 15000L;
        private boolean _bstReadTimeoutSet = false;
        private long _writeTimeoutMs = 15000L;
        private final TcpStaticConfigBuilder _tcp = new TcpStaticConfigBuilder();
        private boolean _enableHttpCompression = false;
        private String _containerBaseDir = ".";

        public String getContainerBaseDir() {
            return this._containerBaseDir;
        }

        public void setContainerBaseDir(String dir) {
            this._containerBaseDir = dir;
        }

        public int getHttpPort() {
            return this._httpPort;
        }

        public void setHttpPort(int httpPort) {
            this._httpPort = httpPort;
        }

        public JmxStaticConfigBuilder getJmx() {
            return this._jmx;
        }

        public void setJmx(JmxStaticConfigBuilder jmx) {
            this._jmx = jmx;
        }

        public MBeanServer getExistingMbeanServer() {
            return this._existingMbeanServer;
        }

        public void setExistingMbeanServer(MBeanServer existingMbeanServer) {
            this._existingMbeanServer = existingMbeanServer;
        }

        public StaticConfig build() throws InvalidConfigException {
            this._defaultId = -1;
            try {
                int hostHash = InetAddress.getLocalHost().hashCode();
                this._defaultId = hostHash == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(hostHash);
                this._defaultId %= 0x7FFF0000;
            }
            catch (UnknownHostException uhe) {
                LOG.error((Object)"Error getting localhost info", (Throwable)uhe);
            }
            if (this._id == -1) {
                UUID uuid = UUID.randomUUID();
                this._id = Math.abs(this._defaultId + uuid.hashCode());
                LOG.info((Object)("Using container id: " + this._id + "(from defaultId = " + this._defaultId + ";hash=" + uuid.hashCode() + ")"));
            }
            String realHealthcheckPath = this._healthcheckPath.startsWith("/") ? this._healthcheckPath.substring(1) : this._healthcheckPath;
            LOG.info((Object)("Using http port:" + this._httpPort));
            LOG.info((Object)("Using containerBasedir: " + this._containerBaseDir));
            LOG.info((Object)("Using healthcheck path: " + realHealthcheckPath));
            return new StaticConfig(this._id, this._jmx.build(), this._httpPort, this._existingMbeanServer, this._runtimeConfigPropertyPrefix, this._runtime, realHealthcheckPath, this._readTimeoutMs, this._bstReadTimeoutSet ? this._bstReadTimeoutMs : this._readTimeoutMs, this._writeTimeoutMs, this._tcp.build(), this._enableHttpCompression, this._containerBaseDir);
        }

        public String getRuntimeConfigPropertyPrefix() {
            return this._runtimeConfigPropertyPrefix;
        }

        public void setRuntimeConfigPropertyPrefix(String runtimeConfigPropertyPrefix) {
            this._runtimeConfigPropertyPrefix = runtimeConfigPropertyPrefix;
        }

        public RuntimeConfigBuilder getRuntime() {
            return this._runtime;
        }

        public void setRuntime(RuntimeConfigBuilder runtime) {
            this._runtime = runtime;
        }

        public int getId() {
            return this._id;
        }

        public void setId(int id) {
            this._id = id;
        }

        public void setIdFromName(String name) {
            int id = name.hashCode();
            if (id < 0) {
                id = id == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(id);
            }
            this.setId(id);
        }

        public String getHealthcheckPath() {
            return this._healthcheckPath;
        }

        public void setHealthcheckPath(String healthcheckPath) {
            this._healthcheckPath = healthcheckPath;
        }

        public long getBstReadTimeoutMs() {
            if (this._bstReadTimeoutSet) {
                return this._bstReadTimeoutMs;
            }
            return this._readTimeoutMs;
        }

        public long getReadTimeoutMs() {
            return this._readTimeoutMs;
        }

        public void setReadTimeoutMs(long readTimeoutMs) {
            this._readTimeoutMs = readTimeoutMs;
        }

        public void setBstReadTimeoutMs(long bstReadTimeoutMs) {
            this._bstReadTimeoutMs = bstReadTimeoutMs;
            this._bstReadTimeoutSet = true;
        }

        public long getWriteTimeoutMs() {
            return this._writeTimeoutMs;
        }

        public void setWriteTimeoutMs(long writeTimeoutMs) {
            this._writeTimeoutMs = writeTimeoutMs;
        }

        public TcpStaticConfigBuilder getTcp() {
            return this._tcp;
        }

        public boolean getEnableHttpCompression() {
            return this._enableHttpCompression;
        }

        public void setEnableHttpCompression(boolean enableHttpCompression) {
            this._enableHttpCompression = enableHttpCompression;
        }
    }

    public static class StaticConfig {
        private final int _id;
        private final JmxStaticConfig _jmxConfig;
        private final int _httpPort;
        private final MBeanServer _existingMbeanServer;
        private final String _runtimeConfigPropertyPrefix;
        private final RuntimeConfigBuilder _runtimeConfigBuilder;
        private final String _healthcheckPath;
        private final long _readTimeoutMs;
        private final long _bstReadTimeoutMs;
        private final long _writeTimeoutMs;
        private final TcpStaticConfig _tcp;
        private final boolean _enableHttpCompression;
        private final String _containerBaseDir;

        public StaticConfig(int id, JmxStaticConfig jmxConfig, int httpPort, MBeanServer existingMbeanServer, String runtimeConfigPropertyPrefix, RuntimeConfigBuilder runtimeConfigBuilder, String healthcheckPath, long readTimeoutMs, long bstReadTimeoutMs, long writeTimeoutMs, TcpStaticConfig tcp, boolean enableHttpCompression, String containerBaseDir) {
            this._id = id;
            this._jmxConfig = jmxConfig;
            this._httpPort = httpPort;
            this._existingMbeanServer = existingMbeanServer;
            this._runtimeConfigPropertyPrefix = runtimeConfigPropertyPrefix;
            this._runtimeConfigBuilder = runtimeConfigBuilder;
            this._healthcheckPath = healthcheckPath;
            this._readTimeoutMs = readTimeoutMs;
            this._bstReadTimeoutMs = bstReadTimeoutMs;
            this._writeTimeoutMs = writeTimeoutMs;
            this._tcp = tcp;
            this._enableHttpCompression = enableHttpCompression;
            this._containerBaseDir = containerBaseDir;
        }

        public String getContainerBaseDir() {
            return this._containerBaseDir;
        }

        public int getHttpPort() {
            return this._httpPort;
        }

        public JmxStaticConfig getJmx() {
            return this._jmxConfig;
        }

        public MBeanServer getExistingMbeanServer() {
            return this._existingMbeanServer;
        }

        public String getRuntimeConfigPropertyPrefix() {
            return this._runtimeConfigPropertyPrefix;
        }

        public RuntimeConfigBuilder getRuntime() {
            return this._runtimeConfigBuilder;
        }

        public int getId() {
            return this._id;
        }

        public MBeanServer getOrCreateMBeanServer() {
            return null != this.getExistingMbeanServer() ? this.getExistingMbeanServer() : ManagementFactory.getPlatformMBeanServer();
        }

        public ContainerStatisticsCollector getOrCreateContainerStatsCollector() {
            ContainerStatisticsCollector result = new ContainerStatisticsCollector(this.getRuntime().getManagedInstance(), "containerStats", true, true, this.getOrCreateMBeanServer());
            return result;
        }

        public String getHealthcheckPath() {
            return this._healthcheckPath;
        }

        public long getReadTimeoutMs() {
            return this._readTimeoutMs;
        }

        public long getBstReadTimeoutMs() {
            return this._bstReadTimeoutMs;
        }

        public long getWriteTimeoutMs() {
            return this._writeTimeoutMs;
        }

        public TcpStaticConfig getTcp() {
            return this._tcp;
        }

        public boolean getEnableHttpCompression() {
            return this._enableHttpCompression;
        }

        public String toString() {
            return "StaticConfig [_id=" + this._id + ", _jmxConfig=" + this._jmxConfig + ", _httpPort=" + this._httpPort + ", _existingMbeanServer=" + this._existingMbeanServer + ", _runtimeConfigPropertyPrefix=" + this._runtimeConfigPropertyPrefix + ", _runtimeConfigBuilder=" + this._runtimeConfigBuilder + ", _statsCollector=" + this._healthcheckPath + ", _readTimeoutMs=" + this._readTimeoutMs + ", _writeTimeoutMs=" + this._writeTimeoutMs + ", _tcp=" + this._tcp + ", _enableHttpCompression=" + this._enableHttpCompression + "]";
        }
    }

    public static class RuntimeConfigBuilder
    implements ConfigBuilder<RuntimeConfig> {
        private int _requestProcessingBudgetMs = 100;
        private ExecutorConfigBuilder _defaultExecutor = new ExecutorConfigBuilder();
        private ExecutorConfigBuilder _ioExecutor = new ExecutorConfigBuilder();
        private ServerContainer _managedInstance = null;

        public RuntimeConfigBuilder() {
            this._ioExecutor.setCoreThreadsNum(5);
            this._ioExecutor.setMaxThreadsNum(2 * Runtime.getRuntime().availableProcessors());
        }

        public int getRequestProcessingBudgetMs() {
            return this._requestProcessingBudgetMs;
        }

        public void setRequestProcessingBudgetMs(int requestProcessingBudgetMs) {
            this._requestProcessingBudgetMs = requestProcessingBudgetMs;
        }

        public ExecutorConfigBuilder getDefaultExecutor() {
            return this._defaultExecutor;
        }

        public void setDefaultExecutor(ExecutorConfigBuilder defaultExecutor) {
            this._defaultExecutor = defaultExecutor;
        }

        public RuntimeConfig build() throws InvalidConfigException {
            if (null != this._managedInstance) {
                return new RuntimeConfig(this._requestProcessingBudgetMs, this._defaultExecutor.build(), this._ioExecutor.build());
            }
            throw new InvalidConfigException("Server container instance not set");
        }

        public ServerContainer getManagedInstance() {
            return this._managedInstance;
        }

        public void setManagedInstance(ServerContainer managedInstance) {
            if (null != managedInstance) {
                this._managedInstance = managedInstance;
                this._defaultExecutor.setManagedInstance(managedInstance);
                this._ioExecutor.setManagedInstance(managedInstance);
            }
        }

        public ExecutorConfigBuilder getIoExecutor() {
            return this._ioExecutor;
        }

        public void setIoExecutor(ExecutorConfigBuilder ioExecutor) {
            this._ioExecutor = ioExecutor;
        }
    }

    public static class RuntimeConfig
    implements ConfigApplier<RuntimeConfig> {
        private final int _requestProcessingBudgetMs;
        private final ExecutorConfig _defaultExecutorConfig;
        private final ExecutorConfig _ioExecutorConfig;

        public RuntimeConfig(int requestProcessingBudgetMs, ExecutorConfig defaultExecutorConfig, ExecutorConfig ioExecutorConfig) throws InvalidConfigException {
            this._requestProcessingBudgetMs = requestProcessingBudgetMs;
            this._defaultExecutorConfig = defaultExecutorConfig;
            this._ioExecutorConfig = ioExecutorConfig;
        }

        public int getRequestProcessingBudgetMs() {
            return this._requestProcessingBudgetMs;
        }

        public ExecutorConfig getDefaultExecutor() {
            return this._defaultExecutorConfig;
        }

        public void applyNewConfig(RuntimeConfig oldConfig) {
            LOG.info((Object)"Changing container config");
            if (null == oldConfig || !this.getDefaultExecutor().equals(oldConfig.getDefaultExecutor())) {
                this.getDefaultExecutor().applyNewConfig(null != oldConfig ? oldConfig.getDefaultExecutor() : null);
            }
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof RuntimeConfig)) {
                return false;
            }
            if (this == other) {
                return true;
            }
            return this.equalsConfig((RuntimeConfig)other);
        }

        public boolean equalsConfig(RuntimeConfig otherConfig) {
            if (otherConfig == null) {
                return false;
            }
            return this.getRequestProcessingBudgetMs() == otherConfig.getRequestProcessingBudgetMs() && this.getDefaultExecutor().equals(otherConfig.getDefaultExecutor());
        }

        public int hashCode() {
            return this._requestProcessingBudgetMs ^ this._defaultExecutorConfig.hashCode();
        }

        public ExecutorConfig getIoExecutorConfig() {
            return this._ioExecutorConfig;
        }
    }

    public static class ExecutorConfigBuilder
    implements ConfigBuilder<ExecutorConfig> {
        public static final Integer DEFAULT_MAX_THREADS_NUM = 100;
        public static final Integer DEFAULT_CORE_THREADS_NUM = 50;
        public static final Integer DEFAULT_KEEPALIVE_MS = 60000;
        public static final Boolean DEFAULT_TRACKER_ENABLED = true;
        public static final Integer DEFAULT_MAX_QUEUE_SIZE = 1000;
        private int _maxThreadsNum = DEFAULT_MAX_THREADS_NUM;
        private int _coreThreadsNum = DEFAULT_CORE_THREADS_NUM;
        private int _keepAliveMs = DEFAULT_KEEPALIVE_MS;
        private boolean _trackerEnabled = DEFAULT_TRACKER_ENABLED;
        private int _maxQueueSize = DEFAULT_MAX_QUEUE_SIZE;
        private ServerContainer _managedInstance = null;

        public int getMaxThreadsNum() {
            return this._maxThreadsNum;
        }

        public void setMaxThreadsNum(int maxThreadsNum) {
            this._maxThreadsNum = maxThreadsNum;
        }

        public int getCoreThreadsNum() {
            return this._coreThreadsNum;
        }

        public void setCoreThreadsNum(int coreThreadsNum) {
            this._coreThreadsNum = coreThreadsNum;
        }

        public int getKeepAliveMs() {
            return this._keepAliveMs;
        }

        public void setKeepAliveMs(int keepAliveMs) {
            this._keepAliveMs = keepAliveMs;
        }

        public boolean isTrackerEnabled() {
            return this._trackerEnabled;
        }

        public void setTrackerEnabled(boolean trackerEnabled) {
            this._trackerEnabled = trackerEnabled;
        }

        public ExecutorConfig build() throws InvalidConfigException {
            if (null == this._managedInstance) {
                throw new InvalidConfigException("Missing server container");
            }
            return new ExecutorConfig(this._maxThreadsNum, this._coreThreadsNum, this._keepAliveMs, this._trackerEnabled, this._maxQueueSize);
        }

        ServerContainer getManagedInstance() {
            return this._managedInstance;
        }

        void setManagedInstance(ServerContainer managedInstance) {
            this._managedInstance = managedInstance;
        }

        public int getMaxQueueSize() {
            return this._maxQueueSize;
        }

        public void setMaxQueueSize(int maxQueueSize) {
            this._maxQueueSize = maxQueueSize;
        }
    }

    public static class ExecutorConfig
    implements ConfigApplier<ExecutorConfig> {
        private final int _maxThreadsNum;
        private final int _coreThreadsNum;
        private final int _keepAliveMs;
        private final boolean _trackerEnabled;
        private final int _maxQueueSize;

        public ExecutorConfig(int maxThreadsNum, int coreThreadsNum, int keepAliveMs, boolean trackerEnabled, int maxQueueSize) throws InvalidConfigException {
            this._maxThreadsNum = maxThreadsNum;
            this._coreThreadsNum = coreThreadsNum;
            this._keepAliveMs = keepAliveMs;
            this._trackerEnabled = trackerEnabled;
            this._maxQueueSize = maxQueueSize;
        }

        public int getMaxThreadsNum() {
            return this._maxThreadsNum;
        }

        public int getCoreThreadsNum() {
            return this._coreThreadsNum;
        }

        public int getKeepAliveMs() {
            return this._keepAliveMs;
        }

        public boolean isTrackerEnabled() {
            return this._trackerEnabled;
        }

        public void applyNewConfig(ExecutorConfig oldConfig) {
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof ExecutorConfig)) {
                return false;
            }
            if (this == other) {
                return true;
            }
            return this.equalsConfig((ExecutorConfig)other);
        }

        public boolean equalsConfig(ExecutorConfig otherConfig) {
            if (otherConfig == null) {
                return false;
            }
            return this.getMaxThreadsNum() == otherConfig.getMaxThreadsNum() && this.getCoreThreadsNum() == otherConfig.getCoreThreadsNum() && this.getKeepAliveMs() == otherConfig.getKeepAliveMs() && this.isTrackerEnabled() == otherConfig.isTrackerEnabled();
        }

        public int hashCode() {
            return this._maxThreadsNum ^ this._coreThreadsNum ^ this._keepAliveMs ^ (this._trackerEnabled ? -1 : 0);
        }

        public int getMaxQueueSize() {
            return this._maxQueueSize;
        }
    }

    public static class TcpStaticConfigBuilder
    implements ConfigBuilder<TcpStaticConfig> {
        private boolean _enabled = false;
        private int _port = 8180;

        public boolean isEnabled() {
            return this._enabled;
        }

        public int getPort() {
            return this._port;
        }

        public void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        public void setPort(int port) {
            this._port = port;
        }

        public TcpStaticConfig build() throws InvalidConfigException {
            if (this._enabled && 0 >= this._port) {
                throw new InvalidConfigException("invalid TCP port: " + this._port);
            }
            TcpStaticConfig newConfig = new TcpStaticConfig(this._enabled, this._port);
            LOG.info((Object)("TCP command interface configuration:" + newConfig));
            return newConfig;
        }
    }

    public static class TcpStaticConfig {
        private final boolean _enabled;
        private final int _port;

        public TcpStaticConfig(boolean enabled, int port) {
            this._enabled = enabled;
            this._port = port;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public int getPort() {
            return this._port;
        }

        public String toString() {
            return this.toJsonString(false);
        }

        public String toJsonString(boolean pretty) {
            return JsonUtils.toJsonStringSilent((Object)this, (boolean)pretty);
        }
    }

    public static class Cli {
        public static final String HELP_OPT_LONG_NAME = "help";
        public static final char HELP_OPT_CHAR = 'h';
        public static final String LOG4J_PROPS_OPT_LONG_NAME = "log_props";
        public static final char LOG4J_PROPS_OPT_CHAR = 'l';
        public static final String CONTAINER_PROPS_OPT_LONG_NAME = "container_props";
        public static final char CONTAINER_PROPS_OPT_CHAR = 'p';
        public static final String CMD_LINE_PROPS_OPT_LONG_NAME = "cmdline_props";
        public static final char CMD_LINE_PROPS_OPT_CHAR = 'c';
        public static final String DEBUG_OPT_LONG_NAME = "debug";
        public static final char DEBUG_OPT_CHAR = 'd';
        private final String _usage;
        protected Options _cliOptions;
        protected CommandLine _cmd;
        protected Properties _configProps;
        HelpFormatter _helpFormatter;
        protected Level _defaultLogLevel = Level.INFO;

        public Cli() {
            this("java <class> [options]");
        }

        public Cli(String usage) {
            this._usage = usage;
            this._cliOptions = new Options();
            this._helpFormatter = new HelpFormatter();
            this._helpFormatter.setWidth(150);
        }

        public void printCliHelp() {
            this._helpFormatter.printHelp(this.getUsage(), this._cliOptions);
        }

        public String getUsage() {
            return this._usage;
        }

        public Options getCliOptions() {
            return this._cliOptions;
        }

        public CommandLine getCmdLine() {
            return this._cmd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processCommandLineArgs(String[] cliArgs) throws IOException, DatabusException {
            this.constructCommandLineOptions();
            GnuParser cliParser = new GnuParser();
            this._cmd = null;
            try {
                this._cmd = cliParser.parse(this._cliOptions, cliArgs);
            }
            catch (ParseException pe) {
                System.err.println("HttpServer: failed to parse command-line options: " + pe.toString());
                this.printCliHelp();
                System.exit(1);
            }
            if (this._cmd.hasOption('h')) {
                this.printCliHelp();
                System.exit(0);
            }
            if (this._cmd.hasOption('d')) {
                Logger.getRootLogger().setLevel(Level.DEBUG);
            } else {
                Logger.getRootLogger().setLevel(this._defaultLogLevel);
            }
            if (this._cmd.hasOption('l')) {
                String log4jPropFile = this._cmd.getOptionValue('l');
                PropertyConfigurator.configure((String)log4jPropFile);
                LOG.info((Object)("Using custom logging settings from file " + log4jPropFile));
            } else {
                PatternLayout defaultLayout = new PatternLayout("%d{ISO8601} +%r [%t] (%p) {%c{1}} %m%n");
                ConsoleAppender defaultAppender = new ConsoleAppender((Layout)defaultLayout);
                Logger.getRootLogger().removeAllAppenders();
                Logger.getRootLogger().addAppender((Appender)defaultAppender);
                LOG.info((Object)"Using default logging settings");
            }
            this._configProps = new Properties(System.getProperties());
            if (this._cmd.hasOption('p')) {
                for (String propFile : this._cmd.getOptionValues('p')) {
                    LOG.info((Object)("Loading container config from properties file " + propFile));
                    FileInputStream fis = new FileInputStream(propFile);
                    try {
                        this._configProps.load(fis);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("error processing properties; ignoring:" + e.getMessage()), (Throwable)e);
                    }
                    finally {
                        fis.close();
                    }
                }
            } else {
                LOG.info((Object)"Using system properties for container config");
            }
            if (this._cmd.hasOption('c')) {
                String cmdLinePropString = this._cmd.getOptionValue('c');
                this.updatePropsFromCmdLine(cmdLinePropString);
            }
            if (Logger.getRootLogger().isTraceEnabled()) {
                InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Log4JLoggerFactory());
            }
        }

        private void updatePropsFromCmdLine(String cmdLinePropString) {
            String[] cmdLinePropSplit;
            for (String s : cmdLinePropSplit = cmdLinePropString.split(";")) {
                String[] onePropSplit = s.split("=");
                if (onePropSplit.length != 2) {
                    LOG.error((Object)("CMD line property setting " + s + "is not valid!"));
                    continue;
                }
                LOG.info((Object)("CMD line Property overwride: " + s));
                this._configProps.put(onePropSplit[0], onePropSplit[1]);
            }
        }

        protected void constructCommandLineOptions() {
            OptionBuilder.withLongOpt((String)HELP_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Prints command-line options info");
            Option helpOption = OptionBuilder.create((char)'h');
            OptionBuilder.withLongOpt((String)LOG4J_PROPS_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Log4j properties to use");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"property_file");
            Option log4jPropsOption = OptionBuilder.create((char)'l');
            OptionBuilder.withLongOpt((String)DEBUG_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Turns on debugging info");
            Option debugPropsOption = OptionBuilder.create((char)'d');
            OptionBuilder.withLongOpt((String)CONTAINER_PROPS_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Container config properties to use");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"property_file");
            Option containerPropsOption = OptionBuilder.create((char)'p');
            OptionBuilder.withLongOpt((String)CMD_LINE_PROPS_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Cmd line override of config properties. Semicolon separated.");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"Semicolon_separated_properties");
            Option cmdLinePropsOption = OptionBuilder.create((char)'c');
            this._cliOptions.addOption(helpOption);
            this._cliOptions.addOption(log4jPropsOption);
            this._cliOptions.addOption(debugPropsOption);
            this._cliOptions.addOption(containerPropsOption);
            this._cliOptions.addOption(cmdLinePropsOption);
        }

        public Properties getConfigProps() {
            return this._configProps;
        }

        public Level getDefaultLogLevel() {
            return this._defaultLogLevel;
        }

        public void setDefaultLogLevel(Level defaultLogLevel) {
            this._defaultLogLevel = defaultLogLevel;
        }
    }
}

