/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.netty;

import com.linkedin.databus2.core.container.monitoring.mbean.ContainerStatisticsCollector;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;

public class InboundContainerStatisticsCollectingHandler
extends SimpleChannelHandler {
    public static final String MODULE = InboundContainerStatisticsCollectingHandler.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private static final int MAX_UNMERGED_EVENTS_NUM = 100;
    private final ContainerStatisticsCollector _statsCollector;
    private ContainerStatisticsCollector _connStatsCollector;
    private int _unmergedEventsNum;

    public InboundContainerStatisticsCollectingHandler(ContainerStatisticsCollector statsCollector) {
        this._statsCollector = statsCollector;
        this._connStatsCollector = null;
    }

    private void mergeConnStats() {
        this._statsCollector.merge(this._connStatsCollector);
        this._connStatsCollector.reset();
        this._unmergedEventsNum = 0;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (null != this._statsCollector) {
            InetSocketAddress inetAddress;
            Object value = e.getValue();
            String client = null;
            client = value instanceof InetSocketAddress ? ((inetAddress = (InetSocketAddress)value).getAddress().isLoopbackAddress() ? "localhost" : inetAddress.getAddress().getHostAddress()) : e.getValue().toString();
            this._connStatsCollector = this._statsCollector.createForClientConnection(client);
            this._connStatsCollector.registerInboundConnectionOpen();
            this._unmergedEventsNum = 1;
        }
        super.channelConnected(ctx, e);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (null != this._statsCollector && null == e.getValue()) {
            if (null == this._connStatsCollector) {
                this._statsCollector.registerInboundConnectionClose();
            } else {
                this._connStatsCollector.registerInboundConnectionClose();
                this.mergeConnStats();
            }
        }
        super.channelDisconnected(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (null != this._statsCollector && e.getMessage() instanceof ChannelBuffer) {
            ChannelBuffer bufferMessage = (ChannelBuffer)e.getMessage();
            if (null == this._connStatsCollector) {
                this._statsCollector.addInboundResponseSize(bufferMessage.readableBytes());
            } else {
                this._connStatsCollector.addInboundResponseSize(bufferMessage.readableBytes());
                if (this._unmergedEventsNum >= 100) {
                    this.mergeConnStats();
                } else {
                    ++this._unmergedEventsNum;
                }
            }
        }
        super.messageReceived(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (null != this._statsCollector) {
            if (null == this._connStatsCollector) {
                this._statsCollector.registerInboundConnectionError(e.getCause());
            } else {
                this._connStatsCollector.registerInboundConnectionError(e.getCause());
                if (this._unmergedEventsNum >= 100) {
                    this.mergeConnStats();
                } else {
                    ++this._unmergedEventsNum;
                }
            }
        }
        super.exceptionCaught(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (null != this._connStatsCollector) {
            this.mergeConnStats();
            this._connStatsCollector.unregisterMBeans();
            this._connStatsCollector = null;
        }
        super.channelClosed(ctx, e);
    }
}

