/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.netty;

import com.linkedin.databus2.core.container.ExtendedReadTimeoutHandler;
import com.linkedin.databus2.core.container.ExtendedWriteTimeoutHandler;
import com.linkedin.databus2.core.container.HttpRequestLoggingHandler;
import com.linkedin.databus2.core.container.netty.ConnectionChannelRegistrationHandler;
import com.linkedin.databus2.core.container.netty.DatabusRequestExecutionHandler;
import com.linkedin.databus2.core.container.netty.HttpRequestHandler;
import com.linkedin.databus2.core.container.netty.OutboundContainerStatisticsCollectingHandler;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.logging.LoggingHandler;
import org.jboss.netty.logging.InternalLogLevel;

public class HttpServerPipelineFactory
implements ChannelPipelineFactory {
    private final ServerContainer _serverContainer;

    public HttpServerPipelineFactory(ServerContainer serverContainer) {
        this._serverContainer = serverContainer;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("auto group register ", (ChannelHandler)new ConnectionChannelRegistrationHandler(this._serverContainer.getHttpChannelGroup()));
        if (Logger.getRootLogger().isTraceEnabled()) {
            pipeline.addLast("netty server traffic", (ChannelHandler)new LoggingHandler("netty server traffic", InternalLogLevel.DEBUG, true));
        }
        pipeline.addLast("outbound statistics collector", (ChannelHandler)new OutboundContainerStatisticsCollectingHandler(this._serverContainer.getContainerStatsCollector()));
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("http logger", (ChannelHandler)new HttpRequestLoggingHandler());
        ExtendedReadTimeoutHandler readTimeoutHandler = new ExtendedReadTimeoutHandler("server container " + this._serverContainer.getContainerStaticConfig().getId(), this._serverContainer.getNetworkTimeoutTimer(), this._serverContainer.getContainerStaticConfig().getReadTimeoutMs(), true);
        HttpRequestHandler reqHandler = new HttpRequestHandler(this._serverContainer, readTimeoutHandler);
        pipeline.addLast("handler", (ChannelHandler)reqHandler);
        if (this._serverContainer.getContainerStaticConfig().getEnableHttpCompression()) {
            pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor());
        }
        pipeline.addLast("executionHandler", (ChannelHandler)this._serverContainer.getNettyExecHandler());
        DatabusRequestExecutionHandler dbusRequestHandler = new DatabusRequestExecutionHandler(this._serverContainer);
        pipeline.addLast("databusRequestRunner", (ChannelHandler)dbusRequestHandler);
        pipeline.addLast("server container write timeout handler", (ChannelHandler)new ExtendedWriteTimeoutHandler("server container " + this._serverContainer.getContainerStaticConfig().getId(), this._serverContainer.getNetworkTimeoutTimer(), this._serverContainer.getContainerStaticConfig().getWriteTimeoutMs(), true));
        return pipeline;
    }
}

