/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.netty;

import com.linkedin.databus2.core.container.ExtendedReadTimeoutHandler;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.UpstreamMessageEvent;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;

public class HttpRequestHandler
extends SimpleChannelUpstreamHandler {
    public static final String MODULE = HttpRequestHandler.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final ServerContainer _serverContainer;
    private final ExtendedReadTimeoutHandler _readTimeoutHandler;
    private HttpRequest request;
    private boolean readingChunks = false;
    private DatabusRequest dbusRequest;
    private ArrayList<ChannelBuffer> body = new ArrayList();

    public HttpRequestHandler(ServerContainer serverContainer, ExtendedReadTimeoutHandler readTimeoutHandler) {
        this._serverContainer = serverContainer;
        this._readTimeoutHandler = readTimeoutHandler;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        try {
            if (!this.readingChunks) {
                this.request = (HttpRequest)e.getMessage();
                ctx.sendUpstream((ChannelEvent)e);
                QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.request.getUri());
                String queryPath = queryStringDecoder.getPath();
                int slashPos = queryPath.indexOf(47, 1);
                if (slashPos < 0) {
                    slashPos = queryPath.length();
                }
                String cmdName = queryPath.substring(1, slashPos);
                ServerContainer.RuntimeConfig config = (ServerContainer.RuntimeConfig)this._serverContainer.getContainerRuntimeConfigMgr().getReadOnlyConfig();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Got command: " + cmdName));
                }
                this.dbusRequest = new DatabusRequest(cmdName, this.request.getMethod(), e.getRemoteAddress(), config);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Starting processing command [" + this.dbusRequest.getId() + "] " + this.dbusRequest.getName()));
                }
                Properties requestProps = this.dbusRequest.getParams();
                if (slashPos < queryPath.length()) {
                    requestProps.put("reqpath", queryPath.substring(slashPos + 1));
                }
                for (Map.Entry h : this.request.getHeaders()) {
                    this.handleHttpHeader(h);
                }
                Map params = queryStringDecoder.getParameters();
                if (!params.isEmpty()) {
                    for (Map.Entry p : params.entrySet()) {
                        String key = (String)p.getKey();
                        List vals = (List)p.getValue();
                        if (vals.size() == 1) {
                            requestProps.put(key, vals.get(0));
                        } else {
                            requestProps.put(key, vals);
                        }
                        for (String val : vals) {
                            LOG.trace((Object)("PARAM: " + key + " = " + val));
                        }
                    }
                }
                if (this.request.isChunked()) {
                    if (null != this._readTimeoutHandler) {
                        this.readingChunks = true;
                        this._readTimeoutHandler.start(ctx.getPipeline().getContext((ChannelHandler)this._readTimeoutHandler));
                    }
                } else {
                    ChannelBuffer content = this.request.getContent();
                    this.handleRequestContentChunk(content);
                    this.writeResponse(ctx, e);
                }
            } else if (e.getMessage() instanceof HttpChunk) {
                HttpChunk chunk = (HttpChunk)e.getMessage();
                if (chunk.isLast()) {
                    this.readingChunks = false;
                    LOG.trace((Object)"END OF CONTENT");
                    HttpChunkTrailer trailer = (HttpChunkTrailer)chunk;
                    for (Map.Entry h : trailer.getHeaders()) {
                        this.handleHttpHeader(h);
                    }
                    this.writeResponse(ctx, e);
                } else {
                    ChannelBuffer content = chunk.getContent();
                    this.handleRequestContentChunk(content);
                }
            }
            ctx.sendUpstream((ChannelEvent)e);
        }
        catch (Exception ex) {
            LOG.error((Object)"HttpRequestHandler.messageReceived error", (Throwable)ex);
        }
    }

    private void writeResponse(ChannelHandlerContext ctx, MessageEvent e) {
        try {
            if (HttpMethod.POST != this.dbusRequest.getRequestType()) {
                this.dbusRequest.getParams().put("reqdata", this.body);
            }
            if (null != this._readTimeoutHandler && this._readTimeoutHandler.isStarted()) {
                this._readTimeoutHandler.stop();
            }
            ctx.sendUpstream((ChannelEvent)new UpstreamMessageEvent(e.getChannel(), (Object)this.dbusRequest, e.getRemoteAddress()));
        }
        catch (Exception ex) {
            LOG.error((Object)"HttpRequestHandler.writeResponse error", (Throwable)ex);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Throwable cause = e.getCause();
        if (cause instanceof OutOfMemoryError) {
            LOG.error((Object)"Running out of memory. Initiating a shutdown on the server container");
            this._serverContainer.shutdownAsynchronously();
        }
        boolean logError = true;
        if (cause instanceof ClosedChannelException) {
            logError = false;
        } else if (cause instanceof IOException) {
            boolean bl = logError = !cause.getMessage().contains("Connection reset by peer");
        }
        if (logError) {
            LOG.error((Object)("exception detected: " + cause.getMessage()), cause);
        }
        if (e.getChannel().isOpen()) {
            e.getChannel().close();
        }
    }

    private void handleRequestContentChunk(ChannelBuffer chunk) {
        if (chunk.readable()) {
            this.body.add(chunk);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("CHUNK: " + chunk.readableBytes()));
            }
        }
    }

    private void handleHttpHeader(Map.Entry<String, String> h) {
        Properties requestProps = this.dbusRequest.getParams();
        String headerKey = h.getKey().toLowerCase();
        LOG.trace((Object)("HEADER: " + h.getKey() + " = " + h.getValue()));
        if (headerKey.startsWith("x-dbus-")) {
            String headerParamName = headerKey.substring("x-dbus-".length());
            requestProps.put(headerParamName, h.getValue());
        }
    }
}

