/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.netty;

import com.linkedin.databus.core.DbusConstants;
import com.linkedin.databus.core.data_model.PhysicalPartition;
import com.linkedin.databus.core.util.DbusHttpUtils;
import com.linkedin.databus2.core.container.monitoring.mbean.ContainerStatisticsCollector;
import com.linkedin.databus2.core.container.netty.ChunkedBodyWritableByteChannel;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.RequestProcessorRegistry;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

public class DatabusRequestExecutionHandler
extends SimpleChannelUpstreamHandler {
    public static final String MODULE = DatabusRequestExecutionHandler.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final RequestProcessorRegistry _processorRegistry;
    private final ServerContainer _serverContainer;
    private DatabusRequest _dbusRequest;
    private HttpRequest _httpRequest;

    public DatabusRequestExecutionHandler(ServerContainer serverContainer) {
        this._serverContainer = serverContainer;
        this._processorRegistry = this._serverContainer.getProcessorRegistry();
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelClosed(ctx, e);
        ctx.setAttachment(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        block22: {
            if (e.getMessage() instanceof HttpRequest) {
                this._httpRequest = (HttpRequest)e.getMessage();
                ctx.sendUpstream((ChannelEvent)e);
            }
            if (e.getMessage() instanceof DatabusRequest) {
                this._dbusRequest = (DatabusRequest)e.getMessage();
                if (ctx.getAttachment() != null && ctx.getAttachment() instanceof PhysicalPartition) {
                    this._dbusRequest.setCursorPartition((PhysicalPartition)ctx.getAttachment());
                }
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Creating response for command [" + this._dbusRequest.getId() + "] " + this._dbusRequest.getName()));
                    }
                    boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)this._httpRequest);
                    HttpResponse response = this.generateEmptyResponse();
                    if (LOG.isDebugEnabled()) {
                        response.addHeader("x-dbus-req-id", (Object)Long.toString(this._dbusRequest.getId()));
                    }
                    ChunkedBodyWritableByteChannel responseChannel = null;
                    try {
                        responseChannel = new ChunkedBodyWritableByteChannel(e.getChannel(), response);
                        this._dbusRequest.setResponseContent(responseChannel);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("About to run command [" + this._dbusRequest.getId() + "] " + this._dbusRequest.getName()));
                        }
                        Future<DatabusRequest> responseFuture = this._processorRegistry.run(this._dbusRequest);
                        ServerContainer.RuntimeConfig config = this._dbusRequest.getConfig();
                        int timeoutMs = config.getRequestProcessingBudgetMs();
                        boolean done = responseFuture.isDone();
                        while (!done) {
                            try {
                                responseFuture.get(timeoutMs, TimeUnit.MILLISECONDS);
                                done = true;
                                ctx.setAttachment((Object)this._dbusRequest.getCursorPartition());
                            }
                            catch (InterruptedException ie) {
                                done = responseFuture.isDone();
                            }
                            catch (Exception ex) {
                                done = true;
                                this._dbusRequest.setError(ex);
                                ctx.setAttachment(null);
                            }
                        }
                    }
                    finally {
                        ContainerStatisticsCollector statsCollector;
                        if (null != responseChannel) {
                            if (LOG.isDebugEnabled()) {
                                long curTimeMs = System.currentTimeMillis();
                                responseChannel.addMetadata("x-dbus-req-latency", Long.toString(curTimeMs - this._dbusRequest.getCreateTimestampMs()));
                            }
                            responseChannel.close();
                        }
                        if (null != this._dbusRequest.getResponseThrowable() && null != (statsCollector = this._serverContainer.getContainerStatsCollector())) {
                            statsCollector.registerContainerError(this._dbusRequest.getResponseThrowable());
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Done runing command [" + this._dbusRequest.getId() + "] " + this._dbusRequest.getName()));
                    }
                    if (!keepAlive || null == responseChannel) {
                        e.getChannel().close();
                    }
                    break block22;
                }
                catch (RuntimeException ex) {
                    LOG.error((Object)"HttpRequestHandler.writeResponse error", (Throwable)ex);
                    ContainerStatisticsCollector statsCollector = this._serverContainer.getContainerStatsCollector();
                    if (null != statsCollector) {
                        statsCollector.registerContainerError(ex);
                    }
                    break block22;
                }
            }
            ctx.sendUpstream((ChannelEvent)e);
        }
    }

    private HttpResponse generateEmptyResponse() {
        CookieDecoder cookieDecoder;
        Set cookies;
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setHeader("Access-Control-Allow-Origin", (Object)"*");
        this.setTrackingInfo((HttpResponse)response);
        String cookieString = this._httpRequest.getHeader("Cookie");
        if (cookieString != null && !(cookies = (cookieDecoder = new CookieDecoder()).decode(cookieString)).isEmpty()) {
            CookieEncoder cookieEncoder = new CookieEncoder(true);
            for (Cookie cookie : cookies) {
                cookieEncoder.addCookie(cookie);
            }
            response.addHeader("Set-Cookie", (Object)cookieEncoder.encode());
        }
        return response;
    }

    private void setTrackingInfo(HttpResponse response) {
        String hostname = DbusConstants.getMachineName();
        if (null == hostname || "UNKNOWN".equals(hostname)) {
            hostname = DbusHttpUtils.getLocalHostName();
        }
        response.setHeader("x-dbus-server-host", (Object)hostname);
        String serviceId = DbusConstants.getServiceIdentifier();
        if (!"UNKNOWN".equals(serviceId)) {
            response.setHeader("x-dbus-server-service", (Object)DbusConstants.getServiceIdentifier());
        }
    }
}

