/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.netty;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.jboss.netty.handler.timeout.WriteTimeoutException;

public class ConnectionChannelRegistrationHandler
extends SimpleChannelHandler {
    public final String MODULE = ConnectionChannelRegistrationHandler.class.getName();
    public final Logger LOG = Logger.getLogger((String)this.MODULE);
    private final ChannelGroup _channelGroup;

    public ConnectionChannelRegistrationHandler(ChannelGroup channelGroup) {
        this._channelGroup = channelGroup;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelOpen(ctx, e);
        if (null != this._channelGroup) {
            this._channelGroup.add((Object)ctx.getChannel());
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("channel registered: " + ctx.getChannel().getRemoteAddress()));
            }
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("channel closed: " + ctx.getChannel().getRemoteAddress()));
        }
        this._channelGroup.remove((Object)ctx.getChannel());
        super.channelClosed(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Throwable err = e.getCause();
        if (err instanceof OutOfMemoryError) {
            this._channelGroup.close();
        }
        boolean logFull = true;
        if (err instanceof IOException) {
            if (err instanceof ClosedChannelException) {
                logFull = false;
            } else if (null == err.getMessage()) {
                logFull = true;
            } else if (err.getMessage().contains("Connection reset")) {
                logFull = false;
            }
        } else if (err instanceof WriteTimeoutException) {
            logFull = false;
        } else if (err instanceof ReadTimeoutException) {
            logFull = false;
        }
        if (logFull) {
            String message = err.getMessage();
            if (null == message) {
                message = err.getClass().getSimpleName();
            }
            this.LOG.error((Object)("Unhandled network exception for peer " + ctx.getChannel().getRemoteAddress() + ": " + message), err);
        } else if (this.LOG.isDebugEnabled()) {
            String message = err.getMessage();
            if (null == message) {
                message = err.getClass().getSimpleName();
            }
            this.LOG.error((Object)("Unhandled network exception for peer " + ctx.getChannel().getRemoteAddress() + "): " + message));
        }
        if (ctx.getChannel().isOpen()) {
            ctx.getChannel().close();
        }
    }

    public void disconnectRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("channel close requested:" + e.getChannel().getRemoteAddress()));
        }
        super.disconnectRequested(ctx, e);
    }

    public void closeRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("channel disconnect requested:" + e.getChannel().getRemoteAddress()));
        }
        super.closeRequested(ctx, e);
    }
}

